/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.UserFeedback;
import ai.h2o.automl.UserFeedbackEvent;
import ai.h2o.automl.collectors.MetaCollector;
import ai.h2o.automl.colmeta.ColMeta;
import ai.h2o.automl.utils.AutoMLUtils;
import hex.tree.DHistogram;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Rapids;
import water.rapids.Val;
import water.rapids.ast.prims.mungers.AstNaOmit;
import water.util.ArrayUtils;
import water.util.Log;

public class FrameMetadata
extends Iced {
    final String _datasetName;
    public final Frame _fr;
    public int[] _catFeats;
    public int[] _numFeats;
    public int[] _intCols;
    public int[] _dblCols;
    public int[] _binaryCols;
    public int[] _intNotBinaryCols;
    public int _response;
    private boolean _isClassification;
    private String[] _ignoredCols;
    private String[] _includeCols;
    private long _naCnt = -1L;
    private int _numFeat = -1;
    private int _catFeat = -1;
    private long _nclass = -1L;
    private double[][] _dummies = null;
    public ColMeta[] _cols;
    public Vec[] _trainTestWeight;
    private long _featsWithNa = -1L;
    private long _rowsWithNa = -1L;
    private double _minSkewness = -1.0;
    private double _maxSkewness = -1.0;
    private double _meanSkewness = -1.0;
    private double _stdSkewness = -1.0;
    private double _medianSkewness = -1.0;
    private double _minKurtosis = -1.0;
    private double _maxKurtosis = -1.0;
    private double _meanKurtosis = -1.0;
    private double _stdKurtosis = -1.0;
    private double _medianKurtosis = -1.0;
    private double _minCardinality = -1.0;
    private double _maxCardinality = -1.0;
    private double _meanCardinality = -1.0;
    private double _stdCardinality = -1.0;
    private double _medianCardinality = -1.0;
    private UserFeedback _userFeedback;
    private AstNaOmit astNaOmit;
    public static final double SQLNAN = -99999.0;
    public static final String[] METAVALUES = new String[]{"DatasetName", "NRow", "NCol", "LogNRow", "LogNCol", "NACount", "NAFraction", "NumberNumericFeat", "NumberCatFeat", "RatioNumericToCatFeat", "RatioCatToNumericFeat", "DatasetRatio", "LogDatasetRatio", "InverseDatasetRatio", "LogInverseDatasetRatio", "Classification", "DummyStratMSE", "DummyStratLogLoss", "DummyMostFreqMSE", "DummyMostFreqLogLoss", "DummyRandomMSE", "DummyRandomLogLoss", "DummyMedianMSE", "DummyMeanMSE", "NClass", "FeatWithNAs", "RowsWithNAs", "MinSkewness", "MaxSkewness", "MeanSkewness", "StdSkewness", "MedianSkewness", "MinKurtosis", "MaxKurtosis", "MeanKurtosis", "StdKurtosis", "MedianKurtosis", "MinCardinality", "MaxCardinality", "MeanCardinality", "StdCardinality", "MedianCardinality"};

    public void delete() {
        for (Vec v : this._trainTestWeight) {
            if (null == v) continue;
            v.remove();
        }
    }

    public static HashMap<String, Object> makeEmptyFrameMeta() {
        LinkedHashMap<String, Object> hm = new LinkedHashMap<String, Object>();
        for (String key : METAVALUES) {
            hm.put(key, null);
        }
        return hm;
    }

    public void fillSimpleMeta(HashMap<String, Object> fm) {
        fm.put("DatasetName", this._datasetName);
        fm.put("NRow", this._fr.numRows());
        fm.put("NCol", this._fr.numCols());
        fm.put("LogNRow", Math.log((Double)fm.get("NRow")));
        fm.put("LogNCol", Math.log((Double)fm.get("NCol")));
        fm.put("NACount", this._fr.naCount());
        fm.put("NAFraction", this._fr.naFraction());
        fm.put("NumberNumericFeat", this.numberOfNumericFeatures());
        fm.put("NumberCatFeat", this.numberOfCategoricalFeatures());
        fm.put("RatioNumericToCatFeat", Double.isInfinite((Double)fm.get("NumberCatFeat")) ? -99999.0 : (Double)fm.get("NumberNumericFeat") / (Double)fm.get("NumberCatFeat"));
        fm.put("RatioCatToNumericFeat", Double.isInfinite((Double)fm.get("NumberNumericFeat")) ? -99999.0 : (Double)fm.get("NumberCatFeat") / (Double)fm.get("NumberNumericFeat"));
        fm.put("DatasetRatio", (double)this._fr.numCols() / (double)this._fr.numRows());
        fm.put("LogDatasetRatio", Math.log((Double)fm.get("DatasetRatio")));
        fm.put("InverseDatasetRatio", (double)this._fr.numRows() / (double)this._fr.numCols());
        fm.put("LogInverseDatasetRatio", Math.log((Double)fm.get("InverseDatasetRatio")));
        fm.put("Classification", this._isClassification ? 1 : 0);
        fm.put("FeatWithNAs", this.na_FeatureCount());
        fm.put("RowsWithNAs", this.rowsWithNa());
        fm.put("NClass", this.nClass());
        double[] skew = this.skewness();
        fm.put("MinSkewness", skew[0]);
        fm.put("MaxSkewness", skew[1]);
        fm.put("MeanSkewness", skew[2]);
        fm.put("StdSkewness", skew[3]);
        fm.put("MedianSkewness", skew[4]);
        double[] kurt = this.kurtosis();
        fm.put("MinKurtosis", kurt[0]);
        fm.put("MaxKurtosis", kurt[1]);
        fm.put("MeanKurtosis", kurt[2]);
        fm.put("StdKurtosis", kurt[3]);
        fm.put("MedianKurtosis", kurt[4]);
        double[] sym = this.cardinality();
        fm.put("MinCardinality", sym[0]);
        fm.put("MaxCardinality", sym[1]);
        fm.put("MeanCardinality", sym[2]);
        fm.put("StdCardinality", sym[3]);
        fm.put("MedianCardinality", sym[4]);
    }

    public int[] diffCols(int[] filterThese) {
        HashSet<Integer> filter = new HashSet<Integer>();
        for (int i : filterThese) {
            filter.add(i);
        }
        ArrayList<Integer> res = new ArrayList<Integer>();
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._cols[i]._ignored || this._cols[i]._response || filter.contains(i)) continue;
            res.add(i);
        }
        return AutoMLUtils.intListToA(res);
    }

    public long na_FeatureCount() {
        if (this._featsWithNa != -1L) {
            return this._featsWithNa;
        }
        long cnt = 0L;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._cols[i]._ignored || this._cols[i]._response || this._cols[i]._percentNA == 0.0) continue;
            ++cnt;
        }
        this._featsWithNa = cnt;
        return this._featsWithNa;
    }

    public long rowsWithNa() {
        if (this._rowsWithNa != -1L) {
            return this._rowsWithNa;
        }
        String x = String.format("(na.omit %s)", this._fr._key);
        Val res = Rapids.exec((String)x);
        Frame f = res.getFrame();
        long cnt = this._fr.numRows() - f.numRows();
        f.delete();
        this._rowsWithNa = cnt;
        return this._rowsWithNa;
    }

    public long nClass() {
        if (this._nclass != -1L) {
            return this._nclass;
        }
        if (this._isClassification) {
            long cnt = 0L;
            this._nclass = cnt = (long)this._fr.vec(this._response).domain().length;
            return this._nclass;
        }
        this._nclass = 0L;
        return 0L;
    }

    public double[] skewness() {
        double[] ar = new double[]{this._minSkewness, this._maxSkewness, this._meanSkewness, this._stdSkewness, this._medianSkewness};
        if (this._minSkewness != -1.0 && this._maxSkewness != -1.0 && this._meanSkewness != -1.0 && this._stdSkewness != -1.0 && this._medianSkewness != -1.0) {
            return ar;
        }
        if (this.isAnyNumeric()) {
            int ar_size = this.numberOfNumericFeatures();
            double[] darry = new double[ar_size];
            int ind = 0;
            for (int i = 0; i < this._cols.length; ++i) {
                if (this._cols[i]._ignored || this._cols[i]._response || !this._cols[i]._isNumeric) continue;
                darry[ind] = this._cols[i]._skew;
                ++ind;
            }
            Vec vd1 = FrameMetadata.dvec(darry);
            Vec[] vdd = new Vec[]{vd1};
            Key key = Key.make((String)"keyD");
            String[] names = new String[]{"vd1"};
            Frame dr = new Frame(key, names, vdd);
            DKV.put((Keyed)dr);
            ar[0] = this.rapidMin(dr);
            ar[1] = this.rapidMax(dr);
            ar[2] = this.rapidMean(dr);
            ar[3] = this.rapidSd(dr);
            ar[4] = this.rapidMedian(dr);
            this._minSkewness = ar[0];
            this._maxSkewness = ar[1];
            this._meanSkewness = ar[2];
            this._stdSkewness = ar[3];
            this._medianSkewness = ar[4];
            dr.remove();
        } else {
            ar[0] = Double.NaN;
            ar[1] = Double.NaN;
            ar[2] = Double.NaN;
            ar[3] = Double.NaN;
            ar[4] = Double.NaN;
            this._minSkewness = Double.NaN;
            this._maxSkewness = Double.NaN;
            this._meanSkewness = Double.NaN;
            this._stdSkewness = Double.NaN;
            this._medianSkewness = Double.NaN;
        }
        return ar;
    }

    public double[] kurtosis() {
        double[] ar = new double[]{this._minKurtosis, this._maxKurtosis, this._meanKurtosis, this._stdKurtosis, this._medianKurtosis};
        if (this._minKurtosis != -1.0 && this._maxKurtosis != -1.0 && this._meanKurtosis != -1.0 && this._stdKurtosis != -1.0 && this._medianKurtosis != -1.0) {
            return ar;
        }
        if (this.isAnyNumeric()) {
            int ar_size = this.numberOfNumericFeatures();
            double[] darry = new double[ar_size];
            int ind = 0;
            for (int i = 0; i < this._cols.length; ++i) {
                if (this._cols[i]._ignored || this._cols[i]._response || !this._cols[i]._isNumeric) continue;
                darry[ind] = this._cols[i]._kurtosis;
                ++ind;
            }
            Vec vd1 = FrameMetadata.dvec(darry);
            Vec[] vdd = new Vec[]{vd1};
            Key key = Key.make((String)"keyD");
            String[] names = new String[]{"vd1"};
            Frame dr = new Frame(key, names, vdd);
            DKV.put((Keyed)dr);
            ar[0] = this.rapidMin(dr);
            ar[1] = this.rapidMax(dr);
            ar[2] = this.rapidMean(dr);
            ar[3] = this.rapidSd(dr);
            ar[4] = this.rapidMedian(dr);
            this._minKurtosis = ar[0];
            this._maxKurtosis = ar[1];
            this._meanKurtosis = ar[2];
            this._stdKurtosis = ar[3];
            this._medianKurtosis = ar[4];
            dr.remove();
        } else {
            ar[0] = Double.NaN;
            ar[1] = Double.NaN;
            ar[2] = Double.NaN;
            ar[3] = Double.NaN;
            ar[4] = Double.NaN;
            this._minKurtosis = Double.NaN;
            this._maxKurtosis = Double.NaN;
            this._meanKurtosis = Double.NaN;
            this._stdKurtosis = Double.NaN;
            this._medianKurtosis = Double.NaN;
        }
        return ar;
    }

    public double[] cardinality() {
        double[] ar = new double[]{this._minCardinality, this._maxCardinality, this._meanCardinality, this._stdCardinality, this._medianCardinality};
        if (this._minCardinality != -1.0 && this._maxCardinality != -1.0 && this._meanCardinality != -1.0 && this._stdCardinality != -1.0 && this._medianCardinality != -1.0) {
            return ar;
        }
        if (this.isAnyCategorical()) {
            int ar_size = this.numberOfCategoricalFeatures();
            double[] darry = new double[ar_size];
            int ind = 0;
            for (int i = 0; i < this._cols.length; ++i) {
                if (this._cols[i]._ignored || this._cols[i]._response || !this._cols[i]._isCategorical) continue;
                darry[ind] = this._cols[i]._cardinality;
                ++ind;
            }
            Vec vd1 = FrameMetadata.dvec(darry);
            Vec[] vdd = new Vec[]{vd1};
            Key key = Key.make((String)"keyD");
            String[] names = new String[]{"vd1"};
            Frame dr = new Frame(key, names, vdd);
            DKV.put((Keyed)dr);
            ar[0] = this.rapidMin(dr);
            ar[1] = this.rapidMax(dr);
            ar[2] = this.rapidMean(dr);
            ar[3] = this.rapidSd(dr);
            ar[4] = this.rapidMedian(dr);
            this._minCardinality = ar[0];
            this._maxCardinality = ar[1];
            this._meanCardinality = ar[2];
            this._stdCardinality = ar[3];
            this._medianCardinality = ar[4];
            dr.remove();
        } else {
            ar[0] = Double.NaN;
            ar[1] = Double.NaN;
            ar[2] = Double.NaN;
            ar[3] = Double.NaN;
            ar[4] = Double.NaN;
            this._minCardinality = Double.NaN;
            this._maxCardinality = Double.NaN;
            this._meanCardinality = Double.NaN;
            this._stdCardinality = Double.NaN;
            this._medianCardinality = Double.NaN;
        }
        return ar;
    }

    public static Vec dvec(double ... rows) {
        Key k = Vec.VectorGroup.VG_LEN1.addVec();
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec(k, 3);
        NewChunk chunk = new NewChunk((Vec)avec, 0);
        for (double r : rows) {
            chunk.addNum(r);
        }
        chunk.close(0, fs);
        Vec vec = avec.layout_and_close(fs);
        fs.blockForPending();
        return vec;
    }

    public boolean isAnyNumeric() {
        boolean cnt = false;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._cols[i]._ignored || this._cols[i]._response || !this._cols[i]._isNumeric) continue;
            cnt = true;
            break;
        }
        return cnt;
    }

    public boolean isAnyCategorical() {
        boolean cnt = false;
        for (int i = 0; i < this._cols.length; ++i) {
            if (this._cols[i]._ignored || this._cols[i]._response || !this._cols[i]._isCategorical) continue;
            cnt = true;
            break;
        }
        return cnt;
    }

    public double rapidMin(Frame dr) {
        Val val = Rapids.exec((String)("(min " + dr._key + ")"));
        double d = val.getNum();
        return d;
    }

    public double rapidMax(Frame dr) {
        Val val = Rapids.exec((String)("(max " + dr._key + ")"));
        double d = val.getNum();
        return d;
    }

    public double rapidMean(Frame dr, boolean ignore_na) {
        Val val = Rapids.exec((String)("(mean " + dr._key + " " + ignore_na + " false)"));
        double[] darray = val.getRow();
        double d = darray[0];
        return d;
    }

    public double rapidMean(Frame dr) {
        return this.rapidMean(dr, true);
    }

    public double rapidSd(Frame dr) {
        Val val = Rapids.exec((String)("(sd " + dr._key + " true)"));
        double[] darray = val.getNums();
        double d = darray[0];
        return d;
    }

    public double rapidMedian(Frame dr) {
        Val val = Rapids.exec((String)("(median " + dr._key + " true)"));
        double[] darray = val.getNums();
        double d = darray[0];
        return d;
    }

    public int numberOfNumericFeatures() {
        if (this._numFeat != -1) {
            return this._numFeat;
        }
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        ArrayList<Integer> intCols = new ArrayList<Integer>();
        ArrayList<Integer> dblCols = new ArrayList<Integer>();
        ArrayList<Integer> binCols = new ArrayList<Integer>();
        ArrayList<Integer> intNotBinCols = new ArrayList<Integer>();
        int cnt = 0;
        int idx = 0;
        for (Vec v : this._fr.vecs()) {
            boolean ignored = this._cols[idx]._ignored;
            boolean response = this._cols[idx]._response;
            if (v.isNumeric() && !ignored && !response) {
                ++cnt;
                idxs.add(idx);
                if (v.isInt()) {
                    intCols.add(idx);
                }
                if (v.isBinary()) {
                    binCols.add(idx);
                }
                if (v.isInt() && !v.isBinary()) {
                    intNotBinCols.add(idx);
                }
                if (v.isNumeric() && !v.isInt()) {
                    dblCols.add(idx);
                }
            }
            ++idx;
        }
        this._numFeats = AutoMLUtils.intListToA(idxs);
        this._intCols = AutoMLUtils.intListToA(intCols);
        this._dblCols = AutoMLUtils.intListToA(dblCols);
        this._binaryCols = AutoMLUtils.intListToA(binCols);
        this._intNotBinaryCols = AutoMLUtils.intListToA(intNotBinCols);
        this._numFeat = cnt;
        return this._numFeat;
    }

    public int numberOfCategoricalFeatures() {
        if (this._catFeat != -1) {
            return this._catFeat;
        }
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        int cnt = 0;
        int idx = 0;
        for (Vec v : this._fr.vecs()) {
            boolean ignored = this._cols[idx]._ignored;
            boolean response = this._cols[idx]._response;
            if (v.isCategorical() && !ignored && !response) {
                ++cnt;
                idxs.add(idx);
            }
            ++idx;
        }
        this._catFeats = AutoMLUtils.intListToA(idxs);
        this._catFeat = cnt;
        return this._catFeat;
    }

    public FrameMetadata(UserFeedback userFeedback, Frame fr, int response, String datasetName) {
        this._datasetName = datasetName;
        this._fr = fr;
        this._response = response;
        this._cols = new ColMeta[this._fr.numCols()];
        this._userFeedback = userFeedback;
    }

    public FrameMetadata(UserFeedback userFeedback, Frame fr, int response, String datasetName, boolean isClassification) {
        this(userFeedback, fr, response, datasetName);
        this._isClassification = isClassification;
    }

    public FrameMetadata(UserFeedback userFeedback, Frame fr, int response, int[] predictors, String datasetName, boolean isClassification) {
        this(userFeedback, fr, response, FrameMetadata.intAtoStringA(predictors, fr.names()), datasetName, isClassification);
    }

    public FrameMetadata(UserFeedback userFeedback, Frame fr, int response, String[] predictors, String datasetName, boolean isClassification) {
        this(userFeedback, fr, response, datasetName, isClassification);
        this._includeCols = predictors;
        if (null == this._includeCols) {
            for (int i = 0; i < this._fr.numCols(); ++i) {
                this._cols[i] = new ColMeta(this._fr.vec(i), this._fr.name(i), i, i == this._response);
            }
        } else {
            HashSet preds = new HashSet();
            Collections.addAll(preds, this._includeCols);
            for (int i = 0; i < this._fr.numCols(); ++i) {
                this._cols[i] = new ColMeta(this._fr.vec(i), this._fr.name(i), i, i == this._response, !preds.contains(this._fr.name(i)));
            }
        }
    }

    public boolean isClassification() {
        return this._isClassification;
    }

    public String[] ignoredCols() {
        if (this._ignoredCols == null) {
            ArrayList<Integer> cols = new ArrayList<Integer>();
            for (ColMeta c : this._cols) {
                if (!c._ignored) continue;
                cols.add(c._idx);
            }
            this._ignoredCols = new String[cols.size()];
            for (int i = 0; i < cols.size(); ++i) {
                this._ignoredCols[i] = this._fr.name(((Integer)cols.get(i)).intValue());
            }
        }
        return this._ignoredCols;
    }

    public String[] includedCols() {
        if (this._includeCols == null) {
            if (null == this.ignoredCols()) {
                this._includeCols = this._fr.names();
                return this._includeCols;
            }
            this._includeCols = ArrayUtils.difference((String[])this._fr.names(), (String[])this.ignoredCols());
        }
        return this._includeCols;
    }

    public ColMeta response() {
        if (-1 == this._response) {
            for (int i = 0; i < this._cols.length; ++i) {
                if (!this._cols[i]._response) continue;
                this._response = i;
                break;
            }
        }
        return this._cols[this._response];
    }

    public boolean stratify() {
        return this.response()._stratify;
    }

    public Vec[] weights() {
        if (null != this._trainTestWeight) {
            return this._trainTestWeight;
        }
        this._trainTestWeight = this.stratify() ? AutoMLUtils.makeStratifiedWeights(this.response()._v, 0.8, this.response()._weightMult) : AutoMLUtils.makeWeights(this.response()._v, 0.8, this.response()._weightMult);
        return this._trainTestWeight;
    }

    public FrameMetadata computeFrameMetaPass1() {
        H2O.H2OCountedCompleter[] tasks = new MetaPass1[this._fr.numCols()];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = new MetaPass1(i, this);
        }
        this._isClassification = tasks[this._response]._isClassification;
        MetaCollector.ParallelTasks metaCollector = new MetaCollector.ParallelTasks(tasks);
        long start = System.currentTimeMillis();
        ((MetaCollector.ParallelTasks)H2O.submitTask((H2O.H2OCountedCompleter)metaCollector)).join();
        this._userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, "Frame metadata analyzer pass 1 completed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds");
        double sumTimeToMRTaskPerCol = 0.0;
        ArrayList<Integer> dropCols = new ArrayList<Integer>();
        for (H2O.H2OCountedCompleter cmt : tasks) {
            if (((MetaPass1)cmt)._colMeta._ignored) {
                dropCols.add(((MetaPass1)cmt)._colMeta._idx);
            } else {
                this._cols[((MetaPass1)cmt)._colMeta._idx] = ((MetaPass1)cmt)._colMeta;
            }
            sumTimeToMRTaskPerCol += (double)((MetaPass1)cmt)._elapsed;
        }
        this._userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, "Average time to analyze each column: " + String.format("%.5f", sumTimeToMRTaskPerCol / (double)tasks.length / 1000.0) + " seconds");
        if (dropCols.size() > 0) {
            this.dropIgnoredCols(AutoMLUtils.intListToA(dropCols));
        }
        return this;
    }

    private void dropIgnoredCols(int[] dropCols) {
        Vec[] vecsToRemove;
        this._userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, "AutoML dropping " + dropCols.length + " ignored columns");
        for (Vec v : vecsToRemove = this._fr.remove(dropCols)) {
            v.remove();
        }
        ColMeta[] cm = new ColMeta[this._fr.numCols()];
        int idx = 0;
        for (int i = 0; i < this._fr.numCols(); ++i) {
            while (null == this._cols[idx]) {
                ++idx;
            }
            cm[i] = this._cols[idx++];
        }
        this._cols = cm;
        this.flushCachedItems();
    }

    private void flushCachedItems() {
        this._catFeats = null;
        this._numFeats = null;
        this._intCols = null;
        this._dblCols = null;
        this._binaryCols = null;
        this._intNotBinaryCols = null;
        this._response = -1;
        this._naCnt = -1L;
        this._numFeat = -1;
        this._catFeat = -1;
        this._nclass = -1L;
        this._ignoredCols = null;
        this._includeCols = null;
        this._featsWithNa = -1L;
        this._rowsWithNa = -1L;
        this._minKurtosis = -1.0;
        this._minSkewness = -1.0;
        this._minCardinality = -1.0;
        this._maxKurtosis = -1.0;
        this._maxSkewness = -1.0;
        this._maxCardinality = -1.0;
        this._meanKurtosis = -1.0;
        this._meanSkewness = -1.0;
        this._meanCardinality = -1.0;
        this._stdKurtosis = -1.0;
        this._stdSkewness = -1.0;
        this._stdCardinality = -1.0;
        this._medianKurtosis = -1.0;
        this._medianSkewness = -1.0;
        this._medianCardinality = -1.0;
    }

    public static String[] intAtoStringA(int[] select, String[] names) {
        String[] preds = new String[select.length];
        int i = 0;
        for (int p : select) {
            preds[i++] = names[p];
        }
        return preds;
    }

    private static class MetaPass1
    extends H2O.H2OCountedCompleter<MetaPass1> {
        private final boolean _response;
        private boolean _isClassification;
        private double _mean;
        private final ColMeta _colMeta;
        private long _elapsed;

        static double log2(double numerator) {
            return Math.log(numerator) / Math.log(2.0) + 1.0E-10;
        }

        public MetaPass1(int idx, FrameMetadata fm) {
            Vec v = fm._fr.vec(idx);
            this._response = fm._response == idx;
            String colname = fm._fr.name(idx);
            this._colMeta = new ColMeta(v, colname, idx, this._response);
            if (this._response) {
                this._isClassification = this._colMeta.isClassification();
            }
            this._mean = v.mean();
            this._colMeta._cardinality = v.isCategorical() ? v.cardinality() : 0;
            int nbins = (int)Math.ceil(1.0 + MetaPass1.log2(v.length()));
            char xbins = (char)((long)v.max() - (long)v.min());
            if (!this._colMeta._ignored && !this._colMeta._v.isBad() && xbins > '\u0000') {
                this._colMeta._histo = MetaCollector.DynamicHisto.makeDHistogram(colname, nbins, nbins, (byte)(v.isCategorical() ? 2 : (v.isInt() ? 1 : 0)), v.min(), v.max());
            }
            Key key = Key.make((String)"keyW");
            String[] names = new String[]{"num1"};
            Vec[] vecs = new Vec[]{v};
            Frame vec_tofr = new Frame(key, names, vecs);
            DKV.put((Keyed)vec_tofr);
            String x = String.format("(skewness %s %s )", vec_tofr._key, true);
            Val res1 = Rapids.exec((String)x);
            double[] darray1 = res1.getNums();
            this._colMeta._skew = darray1[0];
            String y = String.format("(kurtosis %s %s )", vec_tofr._key, true);
            Val res2 = Rapids.exec((String)y);
            double[] darray2 = res2.getNums();
            this._colMeta._kurtosis = darray2[0];
            DKV.remove((Key)vec_tofr._key);
        }

        public ColMeta meta() {
            return this._colMeta;
        }

        public long elapsed() {
            return this._elapsed;
        }

        public void compute2() {
            long start = System.currentTimeMillis();
            char xbins = (char)((long)this._colMeta._v.max() - (long)this._colMeta._v.min());
            if (!this._colMeta._ignored && !this._colMeta._v.isBad() && xbins > '\u0000') {
                HistTask t = (HistTask)new HistTask(this._colMeta._histo, this._mean).doAll(new Vec[]{this._colMeta._v});
                this._elapsed = System.currentTimeMillis() - start;
                this._colMeta._thirdMoment = t._thirdMoment / (double)(this._colMeta._v.length() - this._colMeta._v.naCnt() - 1L);
                this._colMeta._fourthMoment = t._fourthMoment / (double)(this._colMeta._v.length() - this._colMeta._v.naCnt() - 1L);
                this._colMeta._MRTaskMillis = this._elapsed;
                Log.info((Object[])new Object[]{"completed MetaPass1 for col number: " + this._colMeta._idx});
            }
            this.tryComplete();
        }

        private static class HistTask
        extends MRTask<HistTask> {
            private DHistogram _h;
            private double _thirdMoment;
            private double _fourthMoment;
            private double _mean;

            HistTask(DHistogram h, double mean) {
                this._h = h;
                this._mean = mean;
            }

            public void setupLocal() {
                this._h.init();
            }

            public void map(Chunk C) {
                double min = this._h.find_min();
                double max = this._h.find_maxIn();
                double[] bins = new double[this._h._nbin];
                for (int r = 0; r < C._len; ++r) {
                    double colData = C.atd(r);
                    if (Double.isNaN(colData)) continue;
                    if (colData < min) {
                        min = colData;
                    }
                    if (colData > max) {
                        max = colData;
                    }
                    int n = this._h.bin(colData);
                    bins[n] = bins[n] + 1.0;
                    double delta = colData - this._mean;
                    double threeDelta = delta * delta * delta;
                    this._thirdMoment += threeDelta;
                    this._fourthMoment += threeDelta * delta;
                }
                this._h.setMin(min);
                this._h.setMaxIn(max);
                for (int b = 0; b < bins.length; ++b) {
                    if (bins[b] == 0.0) continue;
                    this._h.addWAtomic(b, bins[b]);
                }
            }

            public void reduce(HistTask t) {
                if (this._h == t._h) {
                    return;
                }
                if (this._h == null) {
                    this._h = t._h;
                } else if (t._h != null) {
                    this._h.add(t._h);
                }
                if (!Double.isNaN(t._thirdMoment)) {
                    this._thirdMoment = Double.isNaN(this._thirdMoment) ? t._thirdMoment : (this._thirdMoment += t._thirdMoment);
                }
                if (!Double.isNaN(t._fourthMoment)) {
                    this._fourthMoment = Double.isNaN(this._fourthMoment) ? t._fourthMoment : (this._fourthMoment += t._fourthMoment);
                }
            }
        }
    }
}

