/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoMLBuildSpec;
import ai.h2o.automl.FrameMetadata;
import ai.h2o.automl.H2OJob;
import ai.h2o.automl.Leaderboard;
import ai.h2o.automl.TimedH2ORunnable;
import ai.h2o.automl.UserFeedback;
import ai.h2o.automl.UserFeedbackEvent;
import ai.h2o.automl.utils.AutoMLUtils;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelParametersBuilderFactory;
import hex.StackedEnsembleModel;
import hex.deeplearning.DeepLearningModel;
import hex.glm.GLMModel;
import hex.grid.Grid;
import hex.grid.GridSearch;
import hex.grid.HyperSpaceSearchCriteria;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBMModel;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.api.schemas3.ImportFilesV3;
import water.api.schemas3.KeyV3;
import water.exceptions.H2OAbstractRuntimeException;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.util.ArrayUtils;
import water.util.IcedHashMapGeneric;
import water.util.Log;

public final class AutoML
extends Lockable<AutoML>
implements TimedH2ORunnable {
    private static final boolean verifyImmutability = true;
    private static final SimpleDateFormat fullTimestampFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S");
    private static final SimpleDateFormat timestampFormatForKeys = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private AutoMLBuildSpec buildSpec;
    private Frame origTrainingFrame;
    private boolean didValidationSplit = false;
    private boolean didLeaderboardSplit = false;
    private Frame trainingFrame;
    private Frame validationFrame;
    private Frame leaderboardFrame;
    private Vec responseColumn;
    private Vec foldColumn;
    private Vec weightsColumn;
    private FrameMetadata frameMetadata;
    private Key<Grid>[] gridKeys = new Key[0];
    private boolean isClassification;
    private Date startTime;
    private static Date lastStartTime;
    private long stopTimeMs;
    private Job job;
    private transient ArrayList<Job> jobs;
    private transient ArrayList<Frame> tempFrames;
    private AtomicInteger modelCount = new AtomicInteger();
    private Leaderboard leaderboard;
    private UserFeedback userFeedback;
    private Vec[] originalTrainingFrameVecs;
    private String[] originalTrainingFrameNames;
    private long[] originalTrainingFrameChecksums;
    private String[] skipAlgosList = new String[0];
    private int individualModelsTrained = 0;
    private NonBlockingHashMap<String, Integer> algoInstanceCounters = new NonBlockingHashMap();
    private NonBlockingHashMap<String, Integer> gridInstanceCounters = new NonBlockingHashMap();

    public AutoMLBuildSpec getBuildSpec() {
        return this.buildSpec;
    }

    public Frame getTrainingFrame() {
        return this.trainingFrame;
    }

    public Frame getValidationFrame() {
        return this.validationFrame;
    }

    public Frame getLeaderboardFrame() {
        return this.leaderboardFrame;
    }

    public Vec getResponseColumn() {
        return this.responseColumn;
    }

    public Vec getFoldColumn() {
        return this.foldColumn;
    }

    public Vec getWeightsColumn() {
        return this.weightsColumn;
    }

    public FrameMetadata getFrameMetadata() {
        return this.frameMetadata;
    }

    public AutoML() {
        super(null);
    }

    public AutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        super(key);
        this.startTime = startTime;
        this.userFeedback = new UserFeedback(this);
        this.buildSpec = buildSpec;
        this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "AutoML job created: " + fullTimestampFormat.format(this.startTime));
        this.handleDatafileParameters(buildSpec);
        if (null != buildSpec.input_spec.fold_column && 5 != buildSpec.build_control.nfolds) {
            throw new H2OIllegalArgumentException("Cannot specify fold_column and a non-default nfolds value at the same time.");
        }
        if (null != buildSpec.input_spec.fold_column) {
            this.userFeedback.warn(UserFeedbackEvent.Stage.Workflow, "Custom fold column, " + buildSpec.input_spec.fold_column + ", will be used. nfolds value will be ignored.");
        }
        this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "Build control seed: " + buildSpec.build_control.stopping_criteria.seed() + (buildSpec.build_control.stopping_criteria.seed() == -1L ? " (random)" : ""));
        if (this.buildSpec.build_control.stopping_criteria._stopping_tolerance == -1.0) {
            this.buildSpec.build_control.stopping_criteria.set_default_stopping_tolerance_for_frame(this.trainingFrame);
            this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "Setting stopping tolerance adaptively based on the training frame: " + this.buildSpec.build_control.stopping_criteria._stopping_tolerance);
        } else {
            this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "Stopping tolerance set by the user: " + this.buildSpec.build_control.stopping_criteria._stopping_tolerance);
            double default_tolerance = HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria.default_stopping_tolerance_for_frame((Frame)this.trainingFrame);
            if (this.buildSpec.build_control.stopping_criteria._stopping_tolerance < 0.7 * default_tolerance) {
                this.userFeedback.warn(UserFeedbackEvent.Stage.Workflow, "Stopping tolerance set by the user is < 70% of the recommended default of " + default_tolerance + ", so models may take a long time to converge or may not converge at all.");
            }
        }
        this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "Project: " + this.projectName());
        this.leaderboard = Leaderboard.getOrMakeLeaderboard(this.projectName(), this.userFeedback, this.leaderboardFrame);
        this.jobs = new ArrayList();
        this.tempFrames = new ArrayList();
    }

    private void optionallySplitDatasets() {
        if (this.buildSpec.build_control.nfolds > 1 || null != this.buildSpec.input_spec.fold_column) {
            if (null == this.validationFrame) {
                Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this.origTrainingFrame, (Key[])new Key[]{Key.make((String)("automl_training_" + this.origTrainingFrame._key)), Key.make((String)("automl_validation_" + this.origTrainingFrame._key))}, (double[])new double[]{0.8, 0.2}, (long)this.buildSpec.build_control.stopping_criteria.seed());
                this.trainingFrame = splits[0];
                this.validationFrame = splits[1];
                this.didValidationSplit = true;
                this.didLeaderboardSplit = false;
                this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Automatically split the training data into training and validation frames in the ratio 80/20");
            } else {
                this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Training and validation were both specified; no auto-splitting.");
            }
            if (null == this.leaderboardFrame) {
                this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Leaderboard frame not provided by the user; leaderboard will use cross-validation metrics instead.");
            }
        } else if (null == this.leaderboardFrame) {
            if (null == this.validationFrame) {
                Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this.origTrainingFrame, (Key[])new Key[]{Key.make((String)("automl_training_" + this.origTrainingFrame._key)), Key.make((String)("automl_validation_" + this.origTrainingFrame._key)), Key.make((String)("automl_leaderboard_" + this.origTrainingFrame._key))}, (double[])new double[]{0.8, 0.1, 0.1}, (long)this.buildSpec.build_control.stopping_criteria.seed());
                this.trainingFrame = splits[0];
                this.validationFrame = splits[1];
                this.leaderboardFrame = splits[2];
                this.didValidationSplit = true;
                this.didLeaderboardSplit = true;
                this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Automatically split the training data into training, validation and leaderboard frames in the ratio 80/10/10");
            } else {
                Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this.validationFrame, (Key[])new Key[]{Key.make((String)("automl_validation_" + this.origTrainingFrame._key)), Key.make((String)("automl_leaderboard_" + this.origTrainingFrame._key))}, (double[])new double[]{0.5, 0.5}, (long)this.buildSpec.build_control.stopping_criteria.seed());
                this.validationFrame = splits[0];
                this.leaderboardFrame = splits[1];
                this.didValidationSplit = true;
                this.didLeaderboardSplit = true;
                this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Automatically split the validation data into validation and leaderboard frames in the ratio 50/50");
            }
        } else if (null == this.validationFrame) {
            Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this.origTrainingFrame, (Key[])new Key[]{Key.make((String)("automl_training_" + this.origTrainingFrame._key)), Key.make((String)("automl_validation_" + this.origTrainingFrame._key))}, (double[])new double[]{0.8, 0.2}, (long)this.buildSpec.build_control.stopping_criteria.seed());
            this.trainingFrame = splits[0];
            this.validationFrame = splits[1];
            this.didValidationSplit = true;
            this.didLeaderboardSplit = false;
            this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Automatically split the training data into training and validation frames in the ratio 80/20");
        } else {
            this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "Training, validation and leaderboard datasets were all specified; not auto-splitting.");
        }
    }

    private void handleDatafileParameters(AutoMLBuildSpec buildSpec) {
        this.origTrainingFrame = (Frame)DKV.getGet(buildSpec.input_spec.training_frame);
        this.validationFrame = (Frame)DKV.getGet(buildSpec.input_spec.validation_frame);
        this.leaderboardFrame = (Frame)DKV.getGet(buildSpec.input_spec.leaderboard_frame);
        if (null == buildSpec.input_spec.training_frame && null != buildSpec.input_spec.training_path) {
            this.origTrainingFrame = AutoML.importParseFrame(buildSpec.input_spec.training_path, buildSpec.input_spec.parse_setup);
        }
        if (null == buildSpec.input_spec.validation_frame && null != buildSpec.input_spec.validation_path) {
            this.validationFrame = AutoML.importParseFrame(buildSpec.input_spec.validation_path, buildSpec.input_spec.parse_setup);
        }
        if (null == buildSpec.input_spec.leaderboard_frame && null != buildSpec.input_spec.leaderboard_path) {
            this.leaderboardFrame = AutoML.importParseFrame(buildSpec.input_spec.leaderboard_path, buildSpec.input_spec.parse_setup);
        }
        if (null == this.origTrainingFrame) {
            throw new H2OIllegalArgumentException("No training frame; user specified training_path: " + buildSpec.input_spec.training_path + " and training_frame: " + buildSpec.input_spec.training_frame);
        }
        if (this.origTrainingFrame.find(buildSpec.input_spec.response_column) == -1) {
            throw new H2OIllegalArgumentException("Response column '" + buildSpec.input_spec.response_column + "' is not in the training frame.");
        }
        if (buildSpec.input_spec.fold_column != null && this.origTrainingFrame.find(buildSpec.input_spec.fold_column) == -1) {
            throw new H2OIllegalArgumentException("Fold column '" + buildSpec.input_spec.fold_column + "' is not in the training frame.");
        }
        if (buildSpec.input_spec.weights_column != null && this.origTrainingFrame.find(buildSpec.input_spec.weights_column) == -1) {
            throw new H2OIllegalArgumentException("Weights column '" + buildSpec.input_spec.weights_column + "' is not in the training frame.");
        }
        this.optionallySplitDatasets();
        if (null == this.trainingFrame) {
            this.trainingFrame = new Frame(this.origTrainingFrame);
            DKV.put((Keyed)this.trainingFrame);
        }
        this.responseColumn = this.trainingFrame.vec(buildSpec.input_spec.response_column);
        this.foldColumn = this.trainingFrame.vec(buildSpec.input_spec.fold_column);
        this.weightsColumn = this.trainingFrame.vec(buildSpec.input_spec.weights_column);
        this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "training frame: " + this.trainingFrame.toString().replace("\n", " ") + " checksum: " + this.trainingFrame.checksum());
        this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "validation frame: " + this.validationFrame.toString().replace("\n", " ") + " checksum: " + this.validationFrame.checksum());
        if (null != this.leaderboardFrame) {
            this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "leaderboard frame: " + this.leaderboardFrame.toString().replace("\n", " ") + " checksum: " + this.leaderboardFrame.checksum());
        } else {
            this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "leaderboard frame: NULL");
        }
        this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "response column: " + buildSpec.input_spec.response_column);
        this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "fold column: " + this.foldColumn);
        this.userFeedback.info(UserFeedbackEvent.Stage.DataImport, "weights column: " + this.weightsColumn);
        this.originalTrainingFrameVecs = (Vec[])this.origTrainingFrame.vecs().clone();
        this.originalTrainingFrameNames = (String[])this.origTrainingFrame.names().clone();
        this.originalTrainingFrameChecksums = new long[this.originalTrainingFrameVecs.length];
        for (int i = 0; i < this.originalTrainingFrameVecs.length; ++i) {
            this.originalTrainingFrameChecksums[i] = this.originalTrainingFrameVecs[i].checksum();
        }
        DKV.put((Keyed)this);
    }

    public static AutoML makeAutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        AutoML autoML = new AutoML(key, startTime, buildSpec);
        if (null == autoML.trainingFrame) {
            throw new H2OIllegalArgumentException("No training data has been specified, either as a path or a key.");
        }
        return autoML;
    }

    private static Frame importParseFrame(ImportFilesV3.ImportFiles importFiles, ParseSetup userSetup) {
        ArrayList files = new ArrayList();
        ArrayList keys = new ArrayList();
        ArrayList fails = new ArrayList();
        ArrayList dels = new ArrayList();
        H2O.getPM().importFiles(importFiles.path, null, files, keys, fails, dels);
        importFiles.files = files.toArray(new String[0]);
        importFiles.destination_frames = keys.toArray(new String[0]);
        importFiles.fails = fails.toArray(new String[0]);
        importFiles.dels = dels.toArray(new String[0]);
        String datasetName = importFiles.path.split("\\.(?=[^\\.]+$)")[0];
        String separatorRegex = File.separator.equals("/") ? "/" : "\\";
        String[] pathPieces = datasetName.split(separatorRegex);
        datasetName = pathPieces[pathPieces.length - 1];
        Key[] realKeys = new Key[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            realKeys[i] = Key.make((String)((String)keys.get(i)));
        }
        ParseSetup guessedParseSetup = ParseSetup.guessSetup((Key[])realKeys, (boolean)false, (int)0);
        return ParseDataset.parse((Key)Key.make((String)datasetName), (Key[])realKeys, (boolean)true, (ParseSetup)guessedParseSetup);
    }

    @Override
    public void run() {
        this.stopTimeMs = System.currentTimeMillis() + Math.round(1000.0 * this.buildSpec.build_control.stopping_criteria.max_runtime_secs());
        try {
            this.learn();
        }
        catch (AutoMLDoneException autoMLDoneException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        for (Frame f : this.tempFrames) {
            f.delete();
        }
        this.tempFrames = null;
        if (null == this.jobs) {
            return;
        }
        for (Job j : this.jobs) {
            j.stop();
        }
        for (Job j : this.jobs) {
            j.get();
        }
        this.jobs = null;
    }

    public long getStopTimeMs() {
        return this.stopTimeMs;
    }

    @Override
    public long timeRemainingMs() {
        long remaining = this.getStopTimeMs() - System.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    public int remainingModels() {
        if (this.buildSpec.build_control.stopping_criteria.max_models() == 0) {
            return Integer.MAX_VALUE;
        }
        return this.buildSpec.build_control.stopping_criteria.max_models() - this.modelCount.get();
    }

    @Override
    public boolean keepRunning() {
        return this.timeRemainingMs() > 0L && this.remainingModels() > 0;
    }

    public void pollAndUpdateProgress(UserFeedbackEvent.Stage stage, String name, long workContribution, Job parentJob, Job subJob, JobType subJobType) {
        if (null == subJob) {
            parentJob.update(workContribution, "SKIPPED: " + name);
            return;
        }
        this.userFeedback.info(stage, name + " started");
        this.jobs.add(subJob);
        long lastWorkedSoFar = 0L;
        long cumulative = 0L;
        int gridLastCount = 0;
        while (subJob.isRunning()) {
            Grid grid;
            int gridCount;
            if (parentJob.stop_requested()) {
                Log.info((Object[])new Object[]{"Skipping " + name + " due to Job cancel"});
                subJob.stop();
            }
            long workedSoFar = Math.round(subJob.progress() * (float)workContribution);
            cumulative += workedSoFar;
            parentJob.update((long)Math.round(workedSoFar - lastWorkedSoFar), name);
            if (JobType.HyperparamSearch == subJobType && (gridCount = (grid = (Grid)subJob._result.get()).getModelCount()) > gridLastCount) {
                this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "Built: " + gridCount + " models for search: " + name);
                this.addModels(grid.getModelKeys());
                gridLastCount = gridCount;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lastWorkedSoFar = workedSoFar;
        }
        if (JobType.HyperparamSearch == subJobType) {
            if (subJob.isCrashed()) {
                this.userFeedback.info(stage, name + " failed: " + subJob.ex().toString());
            } else {
                Grid grid = (Grid)subJob._result.get();
                int gridCount = grid.getModelCount();
                if (gridCount > gridLastCount) {
                    this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "Built: " + gridCount + " models for search: " + name);
                    this.addModels(grid.getModelKeys());
                    gridLastCount = gridCount;
                }
                this.userFeedback.info(stage, name + " complete");
            }
        } else if (JobType.ModelBuild == subJobType) {
            if (subJob.isCrashed()) {
                this.userFeedback.info(stage, name + " failed: " + subJob.ex().toString());
            } else {
                this.userFeedback.info(stage, name + " complete");
                this.addModel((Model)subJob._result.get());
            }
        }
        parentJob.update(workContribution - lastWorkedSoFar);
        try {
            this.jobs.remove(subJob);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextInstanceCounter(String algoName, NonBlockingHashMap<String, Integer> instanceCounters) {
        NonBlockingHashMap<String, Integer> nonBlockingHashMap = instanceCounters;
        synchronized (nonBlockingHashMap) {
            int instanceNum = 0;
            if (instanceCounters.containsKey((Object)algoName)) {
                instanceNum = (Integer)instanceCounters.get((Object)algoName) + 1;
            }
            instanceCounters.put((Object)algoName, (Object)instanceNum);
            return instanceNum;
        }
    }

    private Key<Model> modelKey(String algoName) {
        return Key.make((String)(algoName + "_" + this.nextInstanceCounter(algoName, this.algoInstanceCounters) + "_AutoML_" + timestampFormatForKeys.format(this.startTime)));
    }

    public Job trainModel(Key<Model> key, String algoURLName, Model.Parameters parms) {
        String algoName = ModelBuilder.algoName((String)algoURLName);
        if (null == key) {
            key = this.modelKey(algoName);
        }
        Job job = new Job(key, ModelBuilder.javaName((String)algoURLName), algoName);
        ModelBuilder builder = ModelBuilder.make((String)algoURLName, (Job)job, key);
        Model.Parameters defaults = builder._parms;
        builder._parms = parms;
        this.setCommonModelBuilderParams(builder._parms);
        builder._parms._max_runtime_secs = builder._parms._max_runtime_secs == 0.0 ? (double)Math.round((double)this.timeRemainingMs() / 1000.0) : Math.min(builder._parms._max_runtime_secs, (double)Math.round((double)this.timeRemainingMs() / 1000.0));
        if (builder._parms._seed == defaults._seed && this.buildSpec.build_control.stopping_criteria.seed() != -1L) {
            builder._parms._seed = this.buildSpec.build_control.stopping_criteria.seed() + (long)this.individualModelsTrained++;
        }
        if (builder._parms._stopping_metric == defaults._stopping_metric) {
            builder._parms._stopping_metric = this.buildSpec.build_control.stopping_criteria.stopping_metric();
        }
        if (builder._parms._stopping_rounds == defaults._stopping_rounds) {
            builder._parms._stopping_rounds = this.buildSpec.build_control.stopping_criteria.stopping_rounds();
        }
        if (builder._parms._stopping_tolerance == defaults._stopping_tolerance) {
            builder._parms._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        }
        builder.init(false);
        return builder.trainModel();
    }

    private Key<Grid> gridKey(String algoName) {
        return Key.make((String)(algoName + "_grid_" + this.nextInstanceCounter(algoName, this.gridInstanceCounters) + "_AutoML_" + timestampFormatForKeys.format(this.startTime)));
    }

    private void addGridKey(Key<Grid> gridKey) {
        this.gridKeys = Arrays.copyOf(this.gridKeys, this.gridKeys.length + 1);
        this.gridKeys[this.gridKeys.length - 1] = gridKey;
    }

    public Job<Grid> hyperparameterSearch(String algoName, Model.Parameters baseParms, Map<String, Object[]> searchParms) {
        return this.hyperparameterSearch(null, algoName, baseParms, searchParms);
    }

    public Job<Grid> hyperparameterSearch(Key<Grid> gridKey, String algoName, Model.Parameters baseParms, Map<String, Object[]> searchParms) {
        Model.Parameters defaults;
        if (ArrayUtils.contains((String[])this.skipAlgosList, (String)algoName)) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: skipping algo " + algoName + " hyperparameter search");
            return null;
        }
        this.setCommonModelBuilderParams(baseParms);
        if (this.remainingModels() <= 0) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: hit the max_models limit; skipping " + algoName + " hyperparameter search");
            return null;
        }
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = (HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.buildSpec.build_control.stopping_criteria.clone();
        if (searchCriteria.max_runtime_secs() == 0.0) {
            searchCriteria.set_max_runtime_secs((double)this.timeRemainingMs() / 1000.0);
        } else {
            searchCriteria.set_max_runtime_secs(Math.min(searchCriteria.max_runtime_secs(), (double)this.timeRemainingMs() / 1000.0));
        }
        if (searchCriteria.max_runtime_secs() <= 0.001) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: out of time; skipping " + algoName + " hyperparameter search");
            return null;
        }
        if (searchCriteria.max_models() == 0) {
            searchCriteria.set_max_models(this.remainingModels());
        } else {
            searchCriteria.set_max_models(Math.min(searchCriteria.max_models(), this.remainingModels()));
        }
        this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: starting " + algoName + " hyperparameter search");
        try {
            defaults = (Model.Parameters)baseParms.getClass().newInstance();
        }
        catch (Exception e) {
            this.userFeedback.warn(UserFeedbackEvent.Stage.ModelTraining, "Internal error doing hyperparameter search");
            throw new H2OIllegalArgumentException("Hyperparameter search can't create a new instance of Model.Parameters subclass: " + baseParms.getClass());
        }
        if (baseParms._stopping_metric == defaults._stopping_metric) {
            baseParms._stopping_metric = this.buildSpec.build_control.stopping_criteria.stopping_metric();
        }
        if (baseParms._stopping_rounds == defaults._stopping_rounds) {
            baseParms._stopping_rounds = this.buildSpec.build_control.stopping_criteria.stopping_rounds();
        }
        if (baseParms._stopping_tolerance == defaults._stopping_tolerance) {
            baseParms._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        }
        if (null == gridKey) {
            gridKey = this.gridKey(algoName);
        }
        this.addGridKey(gridKey);
        Job gridJob = GridSearch.startGridSearch(gridKey, (Model.Parameters)baseParms, searchParms, (ModelParametersBuilderFactory)new GridSearch.SimpleParametersBuilderFactory(), (HyperSpaceSearchCriteria)searchCriteria);
        return gridJob;
    }

    private void setCommonModelBuilderParams(Model.Parameters params) {
        params._train = this.trainingFrame._key;
        if (null != this.validationFrame) {
            params._valid = this.validationFrame._key;
        }
        params._response_column = this.buildSpec.input_spec.response_column;
        params._ignored_columns = this.buildSpec.input_spec.ignored_columns;
        params._seed = this.buildSpec.build_control.stopping_criteria.seed();
        if (!(params instanceof StackedEnsembleModel.StackedEnsembleParameters)) {
            params._keep_cross_validation_predictions = true;
            params._fold_column = this.buildSpec.input_spec.fold_column;
            params._weights_column = this.buildSpec.input_spec.weights_column;
            if (this.buildSpec.input_spec.fold_column == null) {
                params._nfolds = this.buildSpec.build_control.nfolds;
                if (this.buildSpec.build_control.nfolds > 1) {
                    params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
                }
            }
        }
    }

    private boolean exceededSearchLimits(String whatWeAreSkipping) {
        if (ArrayUtils.contains((String[])this.skipAlgosList, (String)whatWeAreSkipping)) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: skipping algo " + whatWeAreSkipping + " build");
            return true;
        }
        if ((double)this.timeRemainingMs() <= 0.001) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: out of time; skipping " + whatWeAreSkipping);
            return true;
        }
        if (this.remainingModels() <= 0) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "AutoML: hit the max_models limit; skipping " + whatWeAreSkipping);
            return true;
        }
        return false;
    }

    Job<DRFModel> defaultRandomForest() {
        if (this.exceededSearchLimits("DRF")) {
            return null;
        }
        DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
        this.setCommonModelBuilderParams((Model.Parameters)drfParameters);
        drfParameters._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        Job randomForestJob = this.trainModel(null, "drf", (Model.Parameters)drfParameters);
        return randomForestJob;
    }

    Job<DRFModel> defaultExtremelyRandomTrees() {
        if (this.exceededSearchLimits("DRF (XRT)")) {
            return null;
        }
        DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
        this.setCommonModelBuilderParams((Model.Parameters)drfParameters);
        drfParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
        drfParameters._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        Job randomForestJob = this.trainModel(this.modelKey("XRT"), "drf", (Model.Parameters)drfParameters);
        return randomForestJob;
    }

    void defaultGBMs(Key<Grid> gridKey) {
        if (this.exceededSearchLimits("default GBMs")) {
            return;
        }
        GBMModel.GBMParameters gbmParameters = new GBMModel.GBMParameters();
        this.setCommonModelBuilderParams((Model.Parameters)gbmParameters);
        gbmParameters._score_tree_interval = 5;
        gbmParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.AUTO;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_ntrees", new Integer[]{10000});
        searchParams.put("_sample_rate", new Double[]{0.8});
        searchParams.put("_col_sample_rate", new Double[]{0.8});
        searchParams.put("_col_sample_rate_per_tree", new Double[]{0.8});
        Job<Grid> gbmJob = null;
        searchParams.put("_max_depth", new Integer[]{6});
        searchParams.put("_min_rows", new Integer[]{1});
        gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM 1", 10L, this.job(), gbmJob, JobType.HyperparamSearch);
        searchParams.put("_max_depth", new Integer[]{7});
        searchParams.put("_min_rows", new Integer[]{10});
        gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM 2", 10L, this.job(), gbmJob, JobType.HyperparamSearch);
        searchParams.put("_max_depth", new Integer[]{8});
        searchParams.put("_min_rows", new Integer[]{10});
        gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM 3", 10L, this.job(), gbmJob, JobType.HyperparamSearch);
        searchParams.put("_max_depth", new Integer[]{10});
        searchParams.put("_min_rows", new Integer[]{10});
        gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM 4", 10L, this.job(), gbmJob, JobType.HyperparamSearch);
        searchParams.put("_max_depth", new Integer[]{15});
        searchParams.put("_min_rows", new Integer[]{100});
        gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM 5", 10L, this.job(), gbmJob, JobType.HyperparamSearch);
    }

    Job<DeepLearningModel> defaultDeepLearning() {
        if (this.exceededSearchLimits("DeepLearning")) {
            return null;
        }
        DeepLearningModel.DeepLearningParameters deepLearningParameters = new DeepLearningModel.DeepLearningParameters();
        this.setCommonModelBuilderParams((Model.Parameters)deepLearningParameters);
        deepLearningParameters._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        deepLearningParameters._hidden = new int[]{10, 10, 10};
        Job deepLearningJob = this.trainModel(null, "deeplearning", (Model.Parameters)deepLearningParameters);
        return deepLearningJob;
    }

    public Job<Grid> defaultSearchGLM() {
        Key gridKey = Key.make((String)("GLM_grid_default_" + this._key.toString()));
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = this.buildSpec.build_control.stopping_criteria;
        GLMModel.GLMParameters glmParameters = new GLMModel.GLMParameters();
        this.setCommonModelBuilderParams((Model.Parameters)glmParameters);
        glmParameters._lambda_search = true;
        glmParameters._family = this.getResponseColumn().isBinary() && !this.getResponseColumn().isNumeric() ? GLMModel.GLMParameters.Family.binomial : (this.getResponseColumn().isCategorical() ? GLMModel.GLMParameters.Family.multinomial : GLMModel.GLMParameters.Family.gaussian);
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        glmParameters._alpha = new double[]{0.0, 0.2, 0.4, 0.6, 0.8, 1.0};
        searchParams.put("_missing_values_handling", new DeepLearningModel.DeepLearningParameters.MissingValuesHandling[]{DeepLearningModel.DeepLearningParameters.MissingValuesHandling.MeanImputation});
        Job<Grid> glmJob = this.hyperparameterSearch("GLM", (Model.Parameters)glmParameters, searchParams);
        return glmJob;
    }

    public Job<Grid> defaultSearchGBM(Key<Grid> gridKey) {
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = this.buildSpec.build_control.stopping_criteria;
        GBMModel.GBMParameters gbmParameters = new GBMModel.GBMParameters();
        this.setCommonModelBuilderParams((Model.Parameters)gbmParameters);
        gbmParameters._score_tree_interval = 5;
        gbmParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.AUTO;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_ntrees", new Integer[]{10000});
        searchParams.put("_max_depth", new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17});
        searchParams.put("_min_rows", new Integer[]{1, 5, 10, 15, 30, 100});
        searchParams.put("_learn_rate", new Double[]{0.001, 0.005, 0.008, 0.01, 0.05, 0.08, 0.1, 0.5, 0.8});
        searchParams.put("_sample_rate", new Double[]{0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        searchParams.put("_col_sample_rate", new Double[]{0.4, 0.7, 1.0});
        searchParams.put("_col_sample_rate_per_tree", new Double[]{0.4, 0.7, 1.0});
        searchParams.put("_min_split_improvement", new Double[]{1.0E-4, 1.0E-5});
        Job<Grid> gbmJob = this.hyperparameterSearch(gridKey, "GBM", (Model.Parameters)gbmParameters, searchParams);
        return gbmJob;
    }

    public Job<Grid> defaultSearchDL1(Key<Grid> gridKey) {
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = this.buildSpec.build_control.stopping_criteria;
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        this.setCommonModelBuilderParams((Model.Parameters)dlParameters);
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50}, {200}, {500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0}, {0.1}, {0.2}, {0.3}, {0.4}, {0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, "DL", (Model.Parameters)dlParameters, searchParams);
        return dlJob;
    }

    public Job<Grid> defaultSearchDL2(Key<Grid> gridKey) {
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = this.buildSpec.build_control.stopping_criteria;
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        this.setCommonModelBuilderParams((Model.Parameters)dlParameters);
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50}, {200, 200}, {500, 500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0}, {0.1, 0.1}, {0.2, 0.2}, {0.3, 0.3}, {0.4, 0.4}, {0.5, 0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, "DL", (Model.Parameters)dlParameters, searchParams);
        return dlJob;
    }

    public Job<Grid> defaultSearchDL3(Key<Grid> gridKey) {
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = this.buildSpec.build_control.stopping_criteria;
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        this.setCommonModelBuilderParams((Model.Parameters)dlParameters);
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50, 50}, {200, 200, 200}, {500, 500, 500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0, 0.0}, {0.1, 0.1, 0.1}, {0.2, 0.2, 0.2}, {0.3, 0.3, 0.3}, {0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, "DL", (Model.Parameters)dlParameters, searchParams);
        return dlJob;
    }

    Job<StackedEnsembleModel> stack(String modelName, Key<Model>[] ... modelKeyArrays) {
        ArrayList<Key<Model>> allModelKeys = new ArrayList<Key<Model>>();
        for (Key<Model>[] modelKeyArray : modelKeyArrays) {
            allModelKeys.addAll(Arrays.asList(modelKeyArray));
        }
        StackedEnsembleModel.StackedEnsembleParameters stackedEnsembleParameters = new StackedEnsembleModel.StackedEnsembleParameters();
        stackedEnsembleParameters._base_models = allModelKeys.toArray(new Key[0]);
        stackedEnsembleParameters._valid = this.getValidationFrame() == null ? null : this.getValidationFrame()._key;
        stackedEnsembleParameters._keep_levelone_frame = true;
        if (this.buildSpec.input_spec.fold_column != null) {
            stackedEnsembleParameters._metalearner_fold_column = this.buildSpec.input_spec.fold_column;
            stackedEnsembleParameters._metalearner_nfolds = 0;
        } else {
            stackedEnsembleParameters._metalearner_nfolds = this.buildSpec.build_control.nfolds;
        }
        Key<Model> modelKey = this.modelKey(modelName);
        Job ensembleJob = this.trainModel(modelKey, "stackedensemble", (Model.Parameters)stackedEnsembleParameters);
        return ensembleJob;
    }

    public void learn() {
        this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "AutoML build started: " + fullTimestampFormat.format(new Date()));
        if (this.buildSpec.build_models.exclude_algos != null) {
            for (algo algo2 : this.buildSpec.build_models.exclude_algos) {
                this.skipAlgosList = (String[])ArrayUtils.append((Object[])this.skipAlgosList, (Object[])new String[]{algo2.toString()});
            }
        }
        for (String string : this.skipAlgosList = ArrayUtils.append((String[])this.skipAlgosList, (String[])new String[0])) {
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "Disabling algo: " + string + " as requested by the user.");
        }
        if (ArrayUtils.contains((String[])this.skipAlgosList, (String)"DeepLearning")) {
            this.skipAlgosList = (String[])ArrayUtils.append((Object[])this.skipAlgosList, (Object[])new String[]{"DL"});
        }
        if (ArrayUtils.contains((String[])this.skipAlgosList, (String)"GBM")) {
            this.skipAlgosList = (String[])ArrayUtils.append((Object[])this.skipAlgosList, (Object[])new String[]{"default GBMs"});
        }
        if (ArrayUtils.contains((String[])this.skipAlgosList, (String)"DRF")) {
            this.skipAlgosList = (String[])ArrayUtils.append((Object[])this.skipAlgosList, (Object[])new String[]{"DRF (XRT)"});
        }
        this.frameMetadata = new FrameMetadata(this.userFeedback, this.trainingFrame, this.trainingFrame.find(this.buildSpec.input_spec.response_column), this.trainingFrame._key.toString()).computeFrameMetaPass1();
        HashMap<String, Object> hashMap = FrameMetadata.makeEmptyFrameMeta();
        this.frameMetadata.fillSimpleMeta(hashMap);
        this.giveDatasetFeedback(this.trainingFrame, this.userFeedback, hashMap);
        this.job.update(20L, "Computed dataset metadata");
        this.isClassification = this.frameMetadata.isClassification();
        Job<DRFModel> defaultRandomForestJob = this.defaultRandomForest();
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "Default Random Forest build", 50L, this.job(), defaultRandomForestJob, JobType.ModelBuild);
        Job<DRFModel> defaultExtremelyRandomTreesJob = this.defaultExtremelyRandomTrees();
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "Extremely Randomized Trees (XRT) Random Forest build", 50L, this.job(), defaultExtremelyRandomTreesJob, JobType.ModelBuild);
        Job<Grid> job = this.defaultSearchGLM();
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GLM hyperparameter search", 50L, this.job(), job, JobType.HyperparamSearch);
        Key<Grid> gbmGridKey = this.gridKey("GBM");
        this.defaultGBMs(gbmGridKey);
        Job<DeepLearningModel> defaultDeepLearningJob = this.defaultDeepLearning();
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "Default Deep Learning build", 20L, this.job(), defaultDeepLearningJob, JobType.ModelBuild);
        Job<Grid> gbmJob = this.defaultSearchGBM(gbmGridKey);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "GBM hyperparameter search", 80L, this.job(), gbmJob, JobType.HyperparamSearch);
        Key<Grid> dlGridKey = this.gridKey("DeepLearning");
        Job<Grid> dlJob1 = this.defaultSearchDL1(dlGridKey);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "DeepLearning hyperparameter search 1", 150L, this.job(), dlJob1, JobType.HyperparamSearch);
        Job<Grid> dlJob2 = this.defaultSearchDL2(dlGridKey);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "DeepLearning hyperparameter search 2", 200L, this.job(), dlJob2, JobType.HyperparamSearch);
        Job<Grid> dlJob3 = this.defaultSearchDL3(dlGridKey);
        this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "DeepLearning hyperparameter search 3", 300L, this.job(), dlJob3, JobType.HyperparamSearch);
        Model[] allModels = this.leaderboard().getModels();
        if (allModels.length == 0) {
            this.job.update(50L, "No models built; StackedEnsemble builds skipped");
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "No models were built, due to timeouts or the exclude_algos option. StackedEnsemble builds skipped.");
        } else if (allModels.length == 1) {
            this.job.update(50L, "One model built; StackedEnsemble builds skipped");
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "StackedEnsemble builds skipped since there is only one model built");
        } else if (ArrayUtils.contains((String[])this.skipAlgosList, (String)"StackedEnsemble")) {
            this.job.update(50L, "StackedEnsemble builds skipped");
            this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "StackedEnsemble builds skipped due to the exclude_algos option.");
        } else {
            Model m = allModels[0];
            if (this.buildSpec.build_control.nfolds == 0) {
                this.job.update(50L, "Cross-validation disabled by the user; StackedEnsemble build skipped");
                this.userFeedback.info(UserFeedbackEvent.Stage.ModelTraining, "Cross-validation disabled by the user; StackedEnsemble build skipped");
            } else {
                int nonEnsembleCount = 0;
                for (Model aModel : allModels) {
                    if (aModel instanceof StackedEnsembleModel) continue;
                    ++nonEnsembleCount;
                }
                Key[] notEnsembles = new Key[nonEnsembleCount];
                int notEnsembleIndex = 0;
                for (Model model : allModels) {
                    if (model instanceof StackedEnsembleModel) continue;
                    notEnsembles[notEnsembleIndex++] = model._key;
                }
                Job<StackedEnsembleModel> ensembleJob = this.stack("StackedEnsemble_AllModels", new Key[][]{notEnsembles});
                this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "StackedEnsemble build using all AutoML models", 50L, this.job(), ensembleJob, JobType.ModelBuild);
                ArrayList<Model> bestModelsOfEachType = new ArrayList<Model>();
                HashSet<String> typesOfGatheredModels = new HashSet<String>();
                for (Model aModel : allModels) {
                    String type = this.getModelType(aModel);
                    if (typesOfGatheredModels.contains(type)) continue;
                    typesOfGatheredModels.add(type);
                    bestModelsOfEachType.add(aModel);
                }
                Key[] keyArray = new Key[bestModelsOfEachType.size()];
                for (int i = 0; i < bestModelsOfEachType.size(); ++i) {
                    keyArray[i] = ((Model)bestModelsOfEachType.get((int)i))._key;
                }
                Job<StackedEnsembleModel> bestEnsembleJob = this.stack("StackedEnsemble_BestOfFamily", new Key[][]{keyArray});
                this.pollAndUpdateProgress(UserFeedbackEvent.Stage.ModelTraining, "StackedEnsemble build using top model from each algorithm type", 50L, this.job(), bestEnsembleJob, JobType.ModelBuild);
            }
        }
        this.userFeedback.info(UserFeedbackEvent.Stage.Workflow, "AutoML: build done; built " + this.modelCount + " models");
        Log.info((Object[])new Object[]{this.userFeedback.toString("User Feedback for AutoML Run " + this._key + ":")});
        for (UserFeedbackEvent event : this.userFeedback.feedbackEvents) {
            Log.info((Object[])new Object[]{event});
        }
        if (0 < this.leaderboard().getModelKeys().length) {
            Log.info((Object[])new Object[]{this.leaderboard().toTwoDimTable("Leaderboard for project " + this.projectName(), true).toString()});
        }
        this.possiblyVerifyImmutability();
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoML startAutoML(AutoMLBuildSpec buildSpec) {
        Date startTime = new Date();
        Class<AutoML> clazz = AutoML.class;
        synchronized (AutoML.class) {
            if (lastStartTime != null) {
                while (lastStartTime.getYear() == startTime.getYear() && lastStartTime.getMonth() == startTime.getMonth() && lastStartTime.getDate() == startTime.getDate() && lastStartTime.getHours() == startTime.getHours() && lastStartTime.getMinutes() == startTime.getMinutes() && lastStartTime.getSeconds() == startTime.getSeconds()) {
                    startTime = new Date();
                }
            }
            lastStartTime = startTime;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String keyString = "AutoML_" + timestampFormatForKeys.format(startTime);
            AutoML aml = AutoML.makeAutoML((Key<AutoML>)Key.make((String)keyString), startTime, buildSpec);
            DKV.put((Keyed)aml);
            AutoML.startAutoML(aml);
            return aml;
        }
    }

    public static void startAutoML(AutoML aml) {
        if (aml.job == null || !aml.job.isRunning()) {
            Job job;
            aml.job = job = new H2OJob(aml, aml._key, aml.timeRemainingMs()).start();
            job._work = 1000L;
            DKV.put((Keyed)aml);
            job.update(30L, "Data import and parse complete");
        }
    }

    public void get() {
        if (this.job != null) {
            this.job.get();
        }
    }

    public void delete() {
        AutoMLUtils.cleanup_adapt(this.trainingFrame, this.origTrainingFrame);
        this.leaderboard.delete();
        this.userFeedback.delete();
        this.remove();
    }

    public void deleteWithChildren() {
        this.leaderboard.deleteWithChildren();
        this.delete();
        for (Key<Grid> gridKey : this.gridKeys) {
            gridKey.remove();
        }
        if (this.buildSpec.input_spec.training_frame == null) {
            this.origTrainingFrame.delete();
        }
        if (this.buildSpec.input_spec.validation_frame == null && this.buildSpec.input_spec.validation_path != null) {
            this.validationFrame.delete();
        }
    }

    public Job job() {
        if (null == this.job) {
            return null;
        }
        return (Job)DKV.getGet((Key)this.job._key);
    }

    public Leaderboard leaderboard() {
        return this.leaderboard == null ? null : (Leaderboard)this.leaderboard._key.get();
    }

    public Model leader() {
        return this.leaderboard() == null ? null : this.leaderboard().getLeader();
    }

    public UserFeedback userFeedback() {
        return this.userFeedback == null ? null : (UserFeedback)this.userFeedback._key.get();
    }

    public String projectName() {
        return this.buildSpec == null ? null : this.buildSpec.project();
    }

    public void addModels(Key<Model>[] newModels) {
        int before = this.leaderboard().getModelCount();
        this.leaderboard().addModels(newModels);
        int after = this.leaderboard().getModelCount();
        this.modelCount.addAndGet(after - before);
    }

    public void addModel(Key<Model> newModel) {
        int before = this.leaderboard().getModelCount();
        this.leaderboard().addModel(newModel);
        int after = this.leaderboard().getModelCount();
        this.modelCount.addAndGet(after - before);
    }

    public void addModel(Model newModel) {
        int before = this.leaderboard().getModelCount();
        this.leaderboard().addModel(newModel);
        int after = this.leaderboard().getModelCount();
        this.modelCount.addAndGet(after - before);
    }

    public Class<AutoMLKeyV3> makeSchema() {
        return AutoMLKeyV3.class;
    }

    public boolean possiblyVerifyImmutability() {
        boolean warning = false;
        this.userFeedback.debug(UserFeedbackEvent.Stage.Workflow, "Verifying training frame immutability. . .");
        Vec[] vecsRightNow = this.origTrainingFrame.vecs();
        String[] namesRightNow = this.origTrainingFrame.names();
        if (this.originalTrainingFrameVecs.length != vecsRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this.originalTrainingFrameVecs.length + " to: " + vecsRightNow.length});
            warning = true;
        }
        if (this.originalTrainingFrameNames.length != namesRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this.originalTrainingFrameNames.length + " to: " + namesRightNow.length});
            warning = true;
        }
        for (int i = 0; i < this.originalTrainingFrameVecs.length; ++i) {
            if (!this.originalTrainingFrameVecs[i].equals((Object)vecsRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed keys.  Was: " + this.originalTrainingFrameVecs[i] + " , now: " + vecsRightNow[i]});
                warning = true;
            }
            if (!this.originalTrainingFrameNames[i].equals(namesRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed names.  Was: " + this.originalTrainingFrameNames[i] + " , now: " + namesRightNow[i]});
                warning = true;
            }
            if (this.originalTrainingFrameChecksums[i] == vecsRightNow[i].checksum()) continue;
            Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed checksum.  Was: " + this.originalTrainingFrameChecksums[i] + " , now: " + vecsRightNow[i].checksum()});
            warning = true;
        }
        if (warning) {
            this.userFeedback.warn(UserFeedbackEvent.Stage.Workflow, "Training frame was mutated!  This indicates a bug in the AutoML software.");
        } else {
            this.userFeedback.debug(UserFeedbackEvent.Stage.Workflow, "Training frame was not mutated (as expected).");
        }
        return warning;
    }

    private void giveDatasetFeedback(Frame frame, UserFeedback userFeedback, HashMap<String, Object> frameMeta) {
        userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, "Metadata for Frame: " + frame._key.toString());
        for (Map.Entry<String, Object> entry : frameMeta.entrySet()) {
            if (entry.getKey().startsWith("Dummy")) continue;
            Object val = entry.getValue();
            if (val instanceof Double || val instanceof Float) {
                userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, entry.getKey() + ": " + String.format("%.6f", val));
                continue;
            }
            userFeedback.info(UserFeedbackEvent.Stage.FeatureAnalysis, entry.getKey() + ": " + entry.getValue());
        }
    }

    private String getModelType(Model m) {
        return m._key.toString().startsWith("XRT_") ? "XRT" : m._parms.algoName();
    }

    private class AutoMLDoneException
    extends H2OAbstractRuntimeException {
        public AutoMLDoneException() {
            this("done", "done");
        }

        public AutoMLDoneException(String msg, String dev_msg) {
            super(msg, dev_msg, new IcedHashMapGeneric.IcedHashMapStringObject());
        }
    }

    public static class AutoMLKeyV3
    extends KeyV3<Iced, AutoMLKeyV3, AutoML> {
        public AutoMLKeyV3() {
        }

        public AutoMLKeyV3(Key<AutoML> key) {
            super(key);
        }
    }

    private static enum JobType {
        Unknown,
        ModelBuild,
        HyperparamSearch;

    }

    public static enum algo {
        GLM,
        DRF,
        GBM,
        DeepLearning,
        StackedEnsemble;

    }
}

