/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import java.text.SimpleDateFormat;
import java.util.Date;
import water.Iced;
import water.util.TwoDimTable;

public class UserFeedbackEvent
extends Iced {
    public final int longestLevel = UserFeedbackEvent.longestLevel();
    public final int longestStage = UserFeedbackEvent.longestStage();
    private long timestamp = System.currentTimeMillis();
    private transient AutoML autoML;
    private Level level;
    private Stage stage;
    private String message;
    protected static final String[] colHeaders = new String[]{"timestamp", "level", "stage", "message"};
    protected static final String[] colTypes = new String[]{"string", "string", "string", "string"};
    protected static final String[] colFormats = new String[]{"%s", "%s", "%s", "%s"};
    private static final SimpleDateFormat timestampFormat = new SimpleDateFormat("HH:mm:ss.S");

    public long getTimestamp() {
        return this.timestamp;
    }

    public AutoML getAutoML() {
        return this.autoML;
    }

    public Level getLevel() {
        return this.level;
    }

    public Stage getStage() {
        return this.stage;
    }

    public String getMessage() {
        return this.message;
    }

    public UserFeedbackEvent(AutoML autoML, Level level, Stage stage, String message) {
        this.autoML = autoML;
        this.level = level;
        this.stage = stage;
        this.message = message;
    }

    private static int longestStage() {
        int longest = -1;
        for (Stage stage : Stage.values()) {
            longest = Math.max(longest, stage.name().length());
        }
        return longest;
    }

    private static int longestLevel() {
        int longest = -1;
        for (Level level : Level.values()) {
            longest = Math.max(longest, level.name().length());
        }
        return longest;
    }

    public static final TwoDimTable makeTwoDimTable(String tableHeader, int length) {
        String[] rowHeaders = new String[length];
        for (int i = 0; i < length; ++i) {
            rowHeaders[i] = "" + i;
        }
        return new TwoDimTable(tableHeader, "Actions taken and discoveries made by AutoML", rowHeaders, colHeaders, colTypes, colFormats, "#");
    }

    public void addTwoDimTableRow(TwoDimTable table, int row) {
        int col = 0;
        table.set(row, col++, (Object)timestampFormat.format(new Date(this.timestamp)));
        table.set(row, col++, (Object)this.level);
        table.set(row, col++, (Object)this.stage);
        table.set(row, col++, (Object)this.message);
    }

    public String toString() {
        return String.format("%-12s %-" + this.longestLevel + "s %-" + this.longestStage + "s %s", new Object[]{timestampFormat.format(new Date(this.timestamp)), this.level, this.stage, this.message});
    }

    public static enum Stage {
        Workflow,
        DataImport,
        FeatureAnalysis,
        FeatureReduction,
        FeatureCreation,
        ModelTraining;

    }

    public static enum Level {
        Debug,
        Info,
        Warn;

    }
}

