/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.AutoMLBuildSpec;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import water.api.Handler;
import water.api.Route;
import water.api.Schema;
import water.api.schemas3.JobV3;
import water.automl.api.schemas3.AutoMLBuildSpecV99;

public class AutoMLBuilderHandler
extends Handler {
    Map<String, Object> postBody;

    public Schema handle(int version, Route route, Properties parms, String post_body) throws Exception {
        this.postBody = (Map)new Gson().fromJson(post_body, HashMap.class);
        return super.handle(version, route, parms, post_body);
    }

    public AutoMLBuildSpecV99 build(int version, AutoMLBuildSpecV99 buildSpecSchema) {
        Map stopping_criteria;
        Map build_control;
        AutoMLBuildSpec buildSpec = (AutoMLBuildSpec)buildSpecSchema.createAndFillImpl();
        if (buildSpec.input_spec.training_frame != null && buildSpec.input_spec.training_path != null) {
            throw new IllegalArgumentException("Both training_frame and training_files were specified; you must choose one or the other!");
        }
        if (buildSpec.input_spec.validation_frame != null && buildSpec.input_spec.validation_path != null) {
            throw new IllegalArgumentException("Both validation_frame and validation_files were specified; you must choose one or the other!");
        }
        if (this.postBody.containsKey("build_control") && (build_control = (Map)this.postBody.get("build_control")).containsKey("stopping_criteria") && !(stopping_criteria = (Map)build_control.get("stopping_criteria")).containsKey("stopping_tolerance")) {
            buildSpec.build_control.stopping_criteria._stopping_tolerance = -1.0;
        }
        AutoML aml = AutoML.startAutoML(buildSpec);
        buildSpecSchema.job = new JobV3().fillFromImpl(aml.job());
        return buildSpecSchema;
    }
}

