/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoMLBuildSpec;
import ai.h2o.automl.EventLog;
import ai.h2o.automl.EventLogEntry;
import ai.h2o.automl.H2OJob;
import ai.h2o.automl.Leaderboard;
import ai.h2o.automl.TimedH2ORunnable;
import hex.Model;
import hex.ModelBuilder;
import hex.ModelParametersBuilderFactory;
import hex.ScoreKeeper;
import hex.deeplearning.DeepLearningModel;
import hex.ensemble.StackedEnsembleModel;
import hex.genmodel.utils.DistributionFamily;
import hex.glm.GLMModel;
import hex.grid.Grid;
import hex.grid.GridSearch;
import hex.grid.HyperSpaceSearchCriteria;
import hex.splitframe.ShuffleSplitFrame;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRFModel;
import hex.tree.gbm.GBMModel;
import hex.tree.xgboost.XGBoostModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.automl.api.schemas3.AutoMLV99;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;
import water.util.Countdown;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.fp.Predicate;

public final class AutoML
extends Lockable<AutoML>
implements TimedH2ORunnable {
    private static final boolean verifyImmutability = true;
    private static final SimpleDateFormat timestampFormatForKeys = new SimpleDateFormat("yyyyMMdd_HHmmss");
    private AutoMLBuildSpec buildSpec;
    private Frame origTrainingFrame;
    private Frame trainingFrame;
    private Frame validationFrame;
    private Frame blendingFrame;
    private Frame leaderboardFrame;
    private Vec responseColumn;
    private Vec foldColumn;
    private Vec weightsColumn;
    private Key<Grid>[] gridKeys = new Key[0];
    private Date startTime;
    private static Date lastStartTime;
    private Countdown runCountdown;
    private Job job;
    private transient List<Job> jobs;
    private AtomicInteger modelCount = new AtomicInteger();
    private Leaderboard leaderboard;
    private EventLog eventLog;
    private Vec[] originalTrainingFrameVecs;
    private String[] originalTrainingFrameNames;
    private long[] originalTrainingFrameChecksums;
    private WorkAllocations workAllocations;
    private int individualModelsTrained = 0;
    private NonBlockingHashMap<String, Integer> algoInstanceCounters = new NonBlockingHashMap();
    private NonBlockingHashMap<String, Integer> gridInstanceCounters = new NonBlockingHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoML startAutoML(AutoMLBuildSpec buildSpec) {
        Date startTime = new Date();
        Class<AutoML> clazz = AutoML.class;
        synchronized (AutoML.class) {
            if (lastStartTime != null) {
                while (lastStartTime.getYear() == startTime.getYear() && lastStartTime.getMonth() == startTime.getMonth() && lastStartTime.getDate() == startTime.getDate() && lastStartTime.getHours() == startTime.getHours() && lastStartTime.getMinutes() == startTime.getMinutes() && lastStartTime.getSeconds() == startTime.getSeconds()) {
                    startTime = new Date();
                }
            }
            lastStartTime = startTime;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            String keyString = buildSpec.build_control.project_name;
            AutoML aml = AutoML.makeAutoML((Key<AutoML>)Key.make((String)keyString), startTime, buildSpec);
            DKV.put((Keyed)aml);
            AutoML.startAutoML(aml);
            return aml;
        }
    }

    public static void startAutoML(AutoML aml) {
        if (aml.job == null || !aml.job.isRunning()) {
            H2OJob j = new H2OJob(aml, aml._key, aml.runCountdown.remainingTime());
            aml.job = j._job;
            j.start(aml.workAllocations.remainingWork());
            DKV.put((Keyed)aml);
        }
    }

    public static AutoML makeAutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        AutoML autoML = new AutoML(key, startTime, buildSpec);
        if (null == autoML.trainingFrame) {
            throw new H2OIllegalArgumentException("No training data has been specified, either as a path or a key.");
        }
        return autoML;
    }

    public Class<AutoMLV99.AutoMLKeyV3> makeSchema() {
        return AutoMLV99.AutoMLKeyV3.class;
    }

    public AutoMLBuildSpec getBuildSpec() {
        return this.buildSpec;
    }

    public Frame getTrainingFrame() {
        return this.trainingFrame;
    }

    public Frame getValidationFrame() {
        return this.validationFrame;
    }

    public Frame getBlendingFrame() {
        return this.blendingFrame;
    }

    public Frame getLeaderboardFrame() {
        return this.leaderboardFrame;
    }

    public Vec getResponseColumn() {
        return this.responseColumn;
    }

    public Vec getFoldColumn() {
        return this.foldColumn;
    }

    public Vec getWeightsColumn() {
        return this.weightsColumn;
    }

    public AutoML() {
        super(null);
    }

    public AutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        super(key);
        this.startTime = startTime;
        this.buildSpec = buildSpec;
        this.jobs = new ArrayList<Job>();
        this.runCountdown = Countdown.fromSeconds((double)buildSpec.build_control.stopping_criteria.max_runtime_secs());
        try {
            this.eventLog = EventLog.make((Key<AutoML>)this._key);
            this.eventLog().info(EventLogEntry.Stage.Workflow, "Project: " + this.projectName());
            this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML job created: " + EventLogEntry.dateTimeFormat.format(this.startTime)).setNamedValue("creation_epoch", this.startTime, EventLogEntry.epochFormat);
            this.workAllocations = this.planWork();
            if (null != buildSpec.input_spec.fold_column) {
                this.eventLog().warn(EventLogEntry.Stage.Workflow, "Custom fold column, " + buildSpec.input_spec.fold_column + ", will be used. nfolds value will be ignored.");
                buildSpec.build_control.nfolds = 0;
            }
            this.eventLog().info(EventLogEntry.Stage.Workflow, "Build control seed: " + buildSpec.build_control.stopping_criteria.seed() + (buildSpec.build_control.stopping_criteria.seed() == -1L ? " (random)" : ""));
            this.handleDatafileParameters(buildSpec);
            if (this.buildSpec.build_control.stopping_criteria.stopping_tolerance() == -1.0) {
                this.buildSpec.build_control.stopping_criteria.set_default_stopping_tolerance_for_frame(this.trainingFrame);
                this.eventLog().info(EventLogEntry.Stage.Workflow, "Setting stopping tolerance adaptively based on the training frame: " + this.buildSpec.build_control.stopping_criteria.stopping_tolerance());
            } else {
                this.eventLog().info(EventLogEntry.Stage.Workflow, "Stopping tolerance set by the user: " + this.buildSpec.build_control.stopping_criteria.stopping_tolerance());
                double default_tolerance = AutoMLBuildSpec.AutoMLStoppingCriteria.default_stopping_tolerance_for_frame(this.trainingFrame);
                if (this.buildSpec.build_control.stopping_criteria.stopping_tolerance() < 0.7 * default_tolerance) {
                    this.eventLog().warn(EventLogEntry.Stage.Workflow, "Stopping tolerance set by the user is < 70% of the recommended default of " + default_tolerance + ", so models may take a long time to converge or may not converge at all.");
                }
            }
            String sort_metric = buildSpec.input_spec.sort_metric == null ? null : buildSpec.input_spec.sort_metric.toLowerCase();
            this.leaderboard = Leaderboard.getOrMake(this.projectName(), this.eventLog, this.leaderboardFrame, sort_metric);
        }
        catch (Exception e) {
            this.delete();
            throw e;
        }
    }

    WorkAllocations planWork() {
        if (this.buildSpec.build_models.exclude_algos != null && this.buildSpec.build_models.include_algos != null) {
            throw new H2OIllegalArgumentException("Parameters `exclude_algos` and `include_algos` are mutually exclusive: please use only one of them if necessary.");
        }
        HashSet<Algo> skippedAlgos = new HashSet<Algo>();
        if (this.buildSpec.build_models.exclude_algos != null) {
            skippedAlgos.addAll(Arrays.asList(this.buildSpec.build_models.exclude_algos));
        } else if (this.buildSpec.build_models.include_algos != null) {
            skippedAlgos.addAll(Arrays.asList(Algo.values()));
            skippedAlgos.removeAll(Arrays.asList(this.buildSpec.build_models.include_algos));
        }
        for (Algo algo : Algo.values()) {
            if (skippedAlgos.contains((Object)algo) || algo.enabled()) continue;
            this.eventLog.warn(EventLogEntry.Stage.ModelTraining, "AutoML: " + algo.name() + " is not available; skipping it.");
            skippedAlgos.add(algo);
        }
        WorkAllocations workAllocations = new WorkAllocations();
        workAllocations.allocate(Algo.DeepLearning, 1, JobType.ModelBuild, 10).allocate(Algo.DeepLearning, 3, JobType.HyperparamSearch, 20).allocate(Algo.DRF, 2, JobType.ModelBuild, 10).allocate(Algo.GBM, 5, JobType.ModelBuild, 10).allocate(Algo.GBM, 1, JobType.HyperparamSearch, 60).allocate(Algo.GLM, 1, JobType.HyperparamSearch, 20).allocate(Algo.XGBoost, 3, JobType.ModelBuild, 10).allocate(Algo.XGBoost, 1, JobType.HyperparamSearch, 100).allocate(Algo.StackedEnsemble, 2, JobType.ModelBuild, 15).end();
        for (Algo skippedAlgo : skippedAlgos) {
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "Disabling Algo: " + (Object)((Object)skippedAlgo) + " as requested by the user.");
            workAllocations.remove(skippedAlgo);
        }
        return workAllocations;
    }

    @Override
    public void run() {
        this.runCountdown.start();
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build started: " + EventLogEntry.dateTimeFormat.format(this.runCountdown.start_time())).setNamedValue("start_epoch", this.runCountdown.start_time(), EventLogEntry.epochFormat);
        this.learn();
        this.stop();
    }

    @Override
    public void stop() {
        if (null == this.jobs) {
            return;
        }
        for (Job j : this.jobs) {
            j.stop();
        }
        for (Job j : this.jobs) {
            j.get();
        }
        this.jobs = null;
        this.runCountdown.stop();
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build stopped: " + EventLogEntry.dateTimeFormat.format(this.runCountdown.stop_time())).setNamedValue("stop_epoch", this.runCountdown.stop_time(), EventLogEntry.epochFormat);
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build done: built " + this.modelCount + " models");
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML duration: " + PrettyPrint.msecs((long)this.runCountdown.duration(), (boolean)true)).setNamedValue("duration_secs", Math.round((double)this.runCountdown.duration() / 1000.0));
        Log.info((Object[])new Object[]{this.eventLog().toString("Event Log for AutoML Run " + this._key + ":")});
        for (EventLogEntry event : this.eventLog()._events) {
            Log.info((Object[])new Object[]{event});
        }
        if (0 < this.leaderboard().getModelKeys().length) {
            Log.info((Object[])new Object[]{this.leaderboard().toTwoDimTable("Leaderboard for project " + this.projectName(), true).toString()});
        }
        this.possiblyVerifyImmutability();
        if (!this.buildSpec.build_control.keep_cross_validation_predictions) {
            this.cleanUpModelsCVPreds();
        }
    }

    private void learn() {
        this.defaultXGBoosts(false);
        this.defaultSearchGLM(null);
        this.defaultRandomForest();
        this.defaultGBMs();
        this.defaultDeepLearning();
        this.defaultExtremelyRandomTrees();
        this.defaultSearchXGBoost(null, false);
        this.defaultSearchGBM(null);
        this.defaultSearchDL();
        this.defaultStackedEnsembles();
    }

    public void get() {
        if (this.job != null) {
            this.job.get();
        }
    }

    public Job job() {
        if (null == this.job) {
            return null;
        }
        return (Job)DKV.getGet((Key)this.job._key);
    }

    public Model leader() {
        return this.leaderboard() == null ? null : this.leaderboard.getLeader();
    }

    public Leaderboard leaderboard() {
        return this.leaderboard == null ? null : (this.leaderboard = (Leaderboard)this.leaderboard._key.get());
    }

    public EventLog eventLog() {
        return this.eventLog == null ? null : (this.eventLog = (EventLog)this.eventLog._key.get());
    }

    public String projectName() {
        return this.buildSpec == null ? null : this.buildSpec.project();
    }

    @Override
    public long timeRemainingMs() {
        return this.runCountdown.remainingTime();
    }

    public int remainingModels() {
        if (this.buildSpec.build_control.stopping_criteria.max_models() == 0) {
            return Integer.MAX_VALUE;
        }
        return this.buildSpec.build_control.stopping_criteria.max_models() - this.modelCount.get();
    }

    @Override
    public boolean keepRunning() {
        return !this.runCountdown.timedOut() && this.remainingModels() > 0;
    }

    private boolean isCVEnabled() {
        return this.buildSpec.build_control.nfolds != 0 || this.buildSpec.input_spec.fold_column != null;
    }

    private void optionallySplitTrainingDataset() {
        if (!this.isCVEnabled()) {
            double[] splitRatios = null;
            if (null == this.validationFrame && null == this.leaderboardFrame) {
                splitRatios = new double[]{0.8, 0.1, 0.1};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and none of validation frame and leaderboard frame were provided, automatically split the training data into training, validation and leaderboard frames in the ratio 80/10/10");
            } else if (null == this.validationFrame) {
                splitRatios = new double[]{0.9, 0.1, 0.0};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and no validation frame was provided, automatically split the training data into training and validation frames in the ratio 90/10");
            } else if (null == this.leaderboardFrame) {
                splitRatios = new double[]{0.9, 0.0, 0.1};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and no leaderboard frame was provided, automatically split the training data into training and leaderboard frames in the ratio 90/10");
            }
            if (splitRatios != null) {
                Key[] keys = new Key[]{Key.make((String)("automl_training_" + this.origTrainingFrame._key)), Key.make((String)("automl_validation_" + this.origTrainingFrame._key)), Key.make((String)("automl_leaderboard_" + this.origTrainingFrame._key))};
                Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this.origTrainingFrame, (Key[])keys, (double[])splitRatios, (long)this.buildSpec.build_control.stopping_criteria.seed());
                this.trainingFrame = splits[0];
                if (this.validationFrame == null && splits[1].numRows() > 0L) {
                    this.validationFrame = splits[1];
                } else {
                    splits[1].delete();
                }
                if (this.leaderboardFrame == null && splits[2].numRows() > 0L) {
                    this.leaderboardFrame = splits[2];
                } else {
                    splits[2].delete();
                }
            }
        }
    }

    private void handleDatafileParameters(AutoMLBuildSpec buildSpec) {
        this.origTrainingFrame = (Frame)DKV.getGet(buildSpec.input_spec.training_frame);
        this.validationFrame = (Frame)DKV.getGet(buildSpec.input_spec.validation_frame);
        this.blendingFrame = (Frame)DKV.getGet(buildSpec.input_spec.blending_frame);
        this.leaderboardFrame = (Frame)DKV.getGet(buildSpec.input_spec.leaderboard_frame);
        LinkedHashMap compatible_frames = new LinkedHashMap(){
            {
                this.put("training", AutoML.this.origTrainingFrame);
                this.put("validation", AutoML.this.validationFrame);
                this.put("blending", AutoML.this.blendingFrame);
                this.put("leaderboard", AutoML.this.leaderboardFrame);
            }
        };
        for (Map.Entry entry : compatible_frames.entrySet()) {
            Frame frame = (Frame)entry.getValue();
            if (frame == null || frame.find(buildSpec.input_spec.response_column) != -1) continue;
            throw new H2OIllegalArgumentException("Response column '" + buildSpec.input_spec.response_column + "' is not in the " + (String)entry.getKey() + " frame.");
        }
        if (buildSpec.input_spec.fold_column != null && this.origTrainingFrame.find(buildSpec.input_spec.fold_column) == -1) {
            throw new H2OIllegalArgumentException("Fold column '" + buildSpec.input_spec.fold_column + "' is not in the training frame.");
        }
        if (buildSpec.input_spec.weights_column != null && this.origTrainingFrame.find(buildSpec.input_spec.weights_column) == -1) {
            throw new H2OIllegalArgumentException("Weights column '" + buildSpec.input_spec.weights_column + "' is not in the training frame.");
        }
        this.optionallySplitTrainingDataset();
        if (null == this.trainingFrame) {
            this.trainingFrame = new Frame(this.origTrainingFrame);
            this.trainingFrame._key = Key.make((String)("automl_training_" + this.origTrainingFrame._key));
            DKV.put((Keyed)this.trainingFrame);
        }
        this.responseColumn = this.trainingFrame.vec(buildSpec.input_spec.response_column);
        this.foldColumn = this.trainingFrame.vec(buildSpec.input_spec.fold_column);
        this.weightsColumn = this.trainingFrame.vec(buildSpec.input_spec.weights_column);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "training frame: " + this.trainingFrame.toString().replace("\n", " ") + " checksum: " + this.trainingFrame.checksum());
        if (null != this.validationFrame) {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "validation frame: " + this.validationFrame.toString().replace("\n", " ") + " checksum: " + this.validationFrame.checksum());
        } else {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "validation frame: NULL");
        }
        if (null != this.leaderboardFrame) {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "leaderboard frame: " + this.leaderboardFrame.toString().replace("\n", " ") + " checksum: " + this.leaderboardFrame.checksum());
        } else {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "leaderboard frame: NULL");
        }
        this.eventLog().info(EventLogEntry.Stage.DataImport, "response column: " + buildSpec.input_spec.response_column);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "fold column: " + this.foldColumn);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "weights column: " + this.weightsColumn);
        this.originalTrainingFrameVecs = (Vec[])this.origTrainingFrame.vecs().clone();
        this.originalTrainingFrameNames = (String[])this.origTrainingFrame.names().clone();
        this.originalTrainingFrameChecksums = new long[this.originalTrainingFrameVecs.length];
        for (int i = 0; i < this.originalTrainingFrameVecs.length; ++i) {
            this.originalTrainingFrameChecksums[i] = this.originalTrainingFrameVecs[i].checksum();
        }
        DKV.put((Keyed)this);
    }

    private void pollAndUpdateProgress(EventLogEntry.Stage stage, String name, WorkAllocations.Work work, Job parentJob, Job subJob) {
        this.pollAndUpdateProgress(stage, name, work, parentJob, subJob, false);
    }

    private void pollAndUpdateProgress(EventLogEntry.Stage stage, String name, WorkAllocations.Work work, Job parentJob, Job subJob, boolean ignoreTimeout) {
        if (null == subJob) {
            if (null != parentJob) {
                parentJob.update((long)work.consume(), "SKIPPED: " + name);
                Log.info((Object[])new Object[]{"AutoML skipping " + name});
            }
            return;
        }
        this.eventLog().debug(stage, name + " started");
        this.jobs.add(subJob);
        long lastWorkedSoFar = 0L;
        long lastTotalGridModelsBuilt = 0L;
        while (subJob.isRunning()) {
            Grid grid;
            int totalGridModelsBuilt;
            if (null != parentJob) {
                if (parentJob.stop_requested()) {
                    this.eventLog().debug(stage, "AutoML job cancelled; skipping " + name);
                    subJob.stop();
                }
                if (!ignoreTimeout && this.runCountdown.timedOut()) {
                    this.eventLog().debug(stage, "AutoML: out of time; skipping " + name);
                    subJob.stop();
                }
            }
            long workedSoFar = Math.round(subJob.progress() * (float)work.share);
            if (null != parentJob) {
                parentJob.update((long)Math.round(workedSoFar - lastWorkedSoFar), name);
            }
            if (JobType.HyperparamSearch == work.type && (long)(totalGridModelsBuilt = (grid = (Grid)subJob._result.get()).getModelCount()) > lastTotalGridModelsBuilt) {
                this.eventLog().debug(stage, "Built: " + totalGridModelsBuilt + " models for search: " + name);
                this.addModels(grid.getModelKeys());
                lastTotalGridModelsBuilt = totalGridModelsBuilt;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lastWorkedSoFar = workedSoFar;
        }
        if (JobType.HyperparamSearch == work.type) {
            if (subJob.isCrashed()) {
                this.eventLog().warn(stage, name + " failed: " + subJob.ex().toString());
            } else if (subJob.get() == null) {
                this.eventLog().info(stage, name + " cancelled");
            } else {
                Grid grid = (Grid)subJob.get();
                int totalGridModelsBuilt = grid.getModelCount();
                if ((long)totalGridModelsBuilt > lastTotalGridModelsBuilt) {
                    this.eventLog().debug(stage, "Built: " + totalGridModelsBuilt + " models for search: " + name);
                    this.addModels(grid.getModelKeys());
                }
                this.eventLog().debug(stage, name + " complete");
            }
        } else if (JobType.ModelBuild == work.type) {
            if (subJob.isCrashed()) {
                this.eventLog().warn(stage, name + " failed: " + subJob.ex().toString());
            } else if (subJob.get() == null) {
                this.eventLog().info(stage, name + " cancelled");
            } else {
                this.eventLog().debug(stage, name + " complete");
                this.addModel((Model)subJob.get());
            }
        }
        if (null != parentJob) {
            parentJob.update((long)work.share - lastWorkedSoFar);
        }
        work.consume();
        this.jobs.remove(subJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextInstanceCounter(String algoName, NonBlockingHashMap<String, Integer> instanceCounters) {
        NonBlockingHashMap<String, Integer> nonBlockingHashMap = instanceCounters;
        synchronized (nonBlockingHashMap) {
            int instanceNum = 1;
            if (instanceCounters.containsKey((Object)algoName)) {
                instanceNum = (Integer)instanceCounters.get((Object)algoName) + 1;
            }
            instanceCounters.put((Object)algoName, (Object)instanceNum);
            return instanceNum;
        }
    }

    private Key<Model> modelKey(String algoName) {
        return this.modelKey(algoName, true);
    }

    private Key<Model> modelKey(String algoName, boolean with_counter) {
        String counterStr = with_counter ? "_" + this.nextInstanceCounter(algoName, this.algoInstanceCounters) : "";
        return Key.make((String)(algoName + counterStr + "_AutoML_" + timestampFormatForKeys.format(this.startTime)));
    }

    Job<Model> trainModel(Key<Model> key, WorkAllocations.Work work, Model.Parameters parms) {
        return this.trainModel(key, work, parms, false);
    }

    Job<Model> trainModel(Key<Model> key, WorkAllocations.Work work, Model.Parameters parms, boolean ignoreLimits) {
        if (this.exceededSearchLimits(work, key == null ? null : key.toString(), ignoreLimits)) {
            return null;
        }
        Algo algo = work.algo;
        String algoName = ModelBuilder.algoName((String)algo.urlName());
        if (null == key) {
            key = this.modelKey(algoName);
        }
        Job job = new Job(key, ModelBuilder.javaName((String)algo.urlName()), algoName);
        ModelBuilder builder = ModelBuilder.make((String)algo.urlName(), (Job)job, key);
        Model.Parameters defaults = builder._parms;
        builder._parms = parms;
        this.setCommonModelBuilderParams(builder._parms);
        this.setStoppingCriteria(builder._parms, defaults, true);
        builder._parms._max_runtime_secs = ignoreLimits ? 0.0 : (builder._parms._max_runtime_secs == 0.0 ? (double)this.timeRemainingMs() / 1000.0 : Math.min(builder._parms._max_runtime_secs, (double)this.timeRemainingMs() / 1000.0));
        builder.init(false);
        Log.debug((Object[])new Object[]{"Training model: " + algoName + ", time remaining (ms): " + this.timeRemainingMs()});
        try {
            return builder.trainModelOnH2ONode();
        }
        catch (H2OIllegalArgumentException exception) {
            this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Skipping training of model " + key + " due to exception: " + (Object)((Object)exception));
            return null;
        }
    }

    private Key<Grid> gridKey(String algoName) {
        return Key.make((String)(algoName + "_grid_" + this.nextInstanceCounter(algoName, this.gridInstanceCounters) + "_AutoML_" + timestampFormatForKeys.format(this.startTime)));
    }

    private void addGridKey(Key<Grid> gridKey) {
        this.gridKeys = Arrays.copyOf(this.gridKeys, this.gridKeys.length + 1);
        this.gridKeys[this.gridKeys.length - 1] = gridKey;
    }

    Job<Grid> hyperparameterSearch(Key<Grid> gridKey, WorkAllocations.Work work, Model.Parameters baseParms, Map<String, Object[]> searchParms) {
        Model.Parameters defaults;
        if (this.exceededSearchLimits(work)) {
            return null;
        }
        Algo algo = work.algo;
        try {
            defaults = (Model.Parameters)baseParms.getClass().newInstance();
        }
        catch (Exception e) {
            this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Internal error doing hyperparameter search");
            throw new H2OIllegalArgumentException("Hyperparameter search can't create a new instance of Model.Parameters subclass: " + baseParms.getClass());
        }
        this.setCommonModelBuilderParams(baseParms);
        this.setStoppingCriteria(baseParms, defaults, false);
        HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria searchCriteria = (HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.buildSpec.build_control.stopping_criteria.getSearchCriteria().clone();
        double maxAssignedTime = (double)((float)this.timeRemainingMs() * this.workAllocations.remainingWorkRatio(work)) / 1000.0;
        int maxAssignedModels = (int)Math.ceil((float)this.remainingModels() * this.workAllocations.remainingWorkRatio(work, new Predicate<WorkAllocations.Work>(){

            public Boolean apply(WorkAllocations.Work work) {
                return work.algo != Algo.StackedEnsemble;
            }
        }));
        if (searchCriteria.max_runtime_secs() == 0.0) {
            searchCriteria.set_max_runtime_secs(maxAssignedTime);
        } else {
            searchCriteria.set_max_runtime_secs(Math.min(searchCriteria.max_runtime_secs(), maxAssignedTime));
        }
        if (searchCriteria.max_models() == 0) {
            searchCriteria.set_max_models(maxAssignedModels);
        } else {
            searchCriteria.set_max_models(Math.min(searchCriteria.max_models(), maxAssignedModels));
        }
        this.eventLog().info(EventLogEntry.Stage.ModelTraining, "AutoML: starting " + (Object)((Object)algo) + " hyperparameter search");
        if (null == gridKey) {
            gridKey = this.gridKey(algo.name());
        }
        this.addGridKey(gridKey);
        Log.debug((Object[])new Object[]{"Hyperparameter search: " + algo.name() + ", time remaining (ms): " + this.timeRemainingMs()});
        return GridSearch.startGridSearch(gridKey, (Model.Parameters)baseParms, searchParms, (ModelParametersBuilderFactory)new GridSearch.SimpleParametersBuilderFactory(), (HyperSpaceSearchCriteria)searchCriteria);
    }

    Job<StackedEnsembleModel> stack(String modelName, Key<Model>[] modelKeyArrays, boolean use_cache) {
        WorkAllocations.Work work = this.workAllocations.getAllocation(Algo.StackedEnsemble, JobType.ModelBuild);
        if (work == null) {
            return null;
        }
        StackedEnsembleModel.StackedEnsembleParameters stackedEnsembleParameters = new StackedEnsembleModel.StackedEnsembleParameters();
        stackedEnsembleParameters._base_models = modelKeyArrays;
        stackedEnsembleParameters._valid = this.getValidationFrame() == null ? null : this.getValidationFrame()._key;
        stackedEnsembleParameters._blending = this.getBlendingFrame() == null ? null : this.getBlendingFrame()._key;
        stackedEnsembleParameters._keep_levelone_frame = true;
        stackedEnsembleParameters._keep_base_model_predictions = use_cache;
        stackedEnsembleParameters._metalearner_fold_column = this.buildSpec.input_spec.fold_column;
        stackedEnsembleParameters._metalearner_nfolds = this.buildSpec.build_control.nfolds;
        stackedEnsembleParameters.initMetalearnerParams();
        stackedEnsembleParameters._metalearner_parameters._keep_cross_validation_models = this.buildSpec.build_control.keep_cross_validation_models;
        stackedEnsembleParameters._metalearner_parameters._keep_cross_validation_predictions = this.buildSpec.build_control.keep_cross_validation_predictions;
        Key<Model> modelKey = this.modelKey(modelName, false);
        return this.trainModel(modelKey, work, (Model.Parameters)stackedEnsembleParameters, true);
    }

    private void setCommonModelBuilderParams(Model.Parameters params) {
        params._train = this.trainingFrame._key;
        if (null != this.validationFrame) {
            params._valid = this.validationFrame._key;
        }
        params._response_column = this.buildSpec.input_spec.response_column;
        params._ignored_columns = this.buildSpec.input_spec.ignored_columns;
        if (!(params instanceof StackedEnsembleModel.StackedEnsembleParameters)) {
            params._keep_cross_validation_predictions = this.getBlendingFrame() == null ? true : this.buildSpec.build_control.keep_cross_validation_predictions;
            params._fold_column = this.buildSpec.input_spec.fold_column;
            params._weights_column = this.buildSpec.input_spec.weights_column;
            if (this.buildSpec.input_spec.fold_column == null) {
                params._nfolds = this.buildSpec.build_control.nfolds;
                if (this.buildSpec.build_control.nfolds > 1) {
                    params._fold_assignment = Model.Parameters.FoldAssignmentScheme.Modulo;
                }
            }
            if (this.buildSpec.build_control.balance_classes) {
                params._balance_classes = this.buildSpec.build_control.balance_classes;
                params._class_sampling_factors = this.buildSpec.build_control.class_sampling_factors;
                params._max_after_balance_size = this.buildSpec.build_control.max_after_balance_size;
            }
        }
        params._keep_cross_validation_models = this.buildSpec.build_control.keep_cross_validation_models;
        params._keep_cross_validation_fold_assignment = this.buildSpec.build_control.nfolds != 0 && this.buildSpec.build_control.keep_cross_validation_fold_assignment;
        params._export_checkpoints_dir = this.buildSpec.build_control.export_checkpoints_dir;
    }

    private void setStoppingCriteria(Model.Parameters parms, Model.Parameters defaults, boolean isIndividualModel) {
        parms._max_runtime_secs = this.buildSpec.build_control.stopping_criteria.max_runtime_secs_per_model();
        if (isIndividualModel && parms._seed == defaults._seed && this.buildSpec.build_control.stopping_criteria.seed() != -1L) {
            parms._seed = this.buildSpec.build_control.stopping_criteria.seed() + (long)this.individualModelsTrained++;
        }
        if (parms._stopping_metric == defaults._stopping_metric) {
            parms._stopping_metric = this.buildSpec.build_control.stopping_criteria.stopping_metric();
        }
        if (parms._stopping_metric == ScoreKeeper.StoppingMetric.AUTO) {
            String sort_metric = this.getSortMetric();
            ScoreKeeper.StoppingMetric stoppingMetric = sort_metric == null ? ScoreKeeper.StoppingMetric.AUTO : (parms._stopping_metric = sort_metric.equals("auc") ? ScoreKeeper.StoppingMetric.logloss : AutoML.metricValueOf(sort_metric));
        }
        if (parms._stopping_rounds == defaults._stopping_rounds) {
            parms._stopping_rounds = this.buildSpec.build_control.stopping_criteria.stopping_rounds();
        }
        if (parms._stopping_tolerance == defaults._stopping_tolerance) {
            parms._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        }
    }

    private boolean exceededSearchLimits(WorkAllocations.Work work) {
        return this.exceededSearchLimits(work, null, false);
    }

    private boolean exceededSearchLimits(WorkAllocations.Work work, String algo_desc, boolean ignoreLimits) {
        String fullName;
        String string = fullName = algo_desc == null ? work.algo.toString() : (Object)((Object)work.algo) + " (" + algo_desc + ")";
        if (this.job.stop_requested()) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: job cancelled; skipping " + fullName + " in " + (Object)((Object)work.type));
            return true;
        }
        if (!ignoreLimits && this.runCountdown.timedOut()) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: out of time; skipping " + fullName + " in " + (Object)((Object)work.type));
            return true;
        }
        if (!ignoreLimits && this.remainingModels() <= 0) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: hit the max_models limit; skipping " + fullName + " in " + (Object)((Object)work.type));
            return true;
        }
        return false;
    }

    void defaultXGBoosts(boolean emulateLightGBM) {
        Algo algo = Algo.XGBoost;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.ModelBuild);
        if (work == null) {
            return;
        }
        XGBoostModel.XGBoostParameters commonXGBoostParameters = new XGBoostModel.XGBoostParameters();
        if (emulateLightGBM) {
            commonXGBoostParameters._tree_method = XGBoostModel.XGBoostParameters.TreeMethod.hist;
            commonXGBoostParameters._grow_policy = XGBoostModel.XGBoostParameters.GrowPolicy.lossguide;
        }
        commonXGBoostParameters._distribution = this.getResponseColumn().isBinary() && !this.getResponseColumn().isNumeric() ? DistributionFamily.bernoulli : (this.getResponseColumn().isCategorical() ? DistributionFamily.multinomial : DistributionFamily.AUTO);
        commonXGBoostParameters._score_tree_interval = 5;
        commonXGBoostParameters._stopping_rounds = 5;
        commonXGBoostParameters._ntrees = 10000;
        commonXGBoostParameters._learn_rate = 0.05;
        XGBoostModel.XGBoostParameters xgBoostParameters = (XGBoostModel.XGBoostParameters)commonXGBoostParameters.clone();
        xgBoostParameters._max_depth = 10;
        xgBoostParameters._min_rows = 5.0;
        xgBoostParameters._sample_rate = 0.6;
        xgBoostParameters._col_sample_rate = 0.8;
        xgBoostParameters._col_sample_rate_per_tree = 0.8;
        if (emulateLightGBM) {
            xgBoostParameters._max_leaves = 1 << xgBoostParameters._max_depth;
            xgBoostParameters._max_depth *= 2;
            xgBoostParameters._min_sum_hessian_in_leaf = (float)xgBoostParameters._min_rows;
        }
        Key<Model> key = this.modelKey(algo.name());
        Job<Model> xgBoostJob = this.trainModel(key, work, (Model.Parameters)xgBoostParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, key.toString(), work, this.job(), xgBoostJob);
        xgBoostParameters = (XGBoostModel.XGBoostParameters)commonXGBoostParameters.clone();
        xgBoostParameters._max_depth = 20;
        xgBoostParameters._min_rows = 10.0;
        xgBoostParameters._sample_rate = 0.6;
        xgBoostParameters._col_sample_rate = 0.8;
        xgBoostParameters._col_sample_rate_per_tree = 0.8;
        if (emulateLightGBM) {
            xgBoostParameters._max_leaves = 1 << xgBoostParameters._max_depth;
            xgBoostParameters._max_depth *= 2;
            xgBoostParameters._min_sum_hessian_in_leaf = (float)xgBoostParameters._min_rows;
        }
        key = this.modelKey(algo.name());
        xgBoostJob = this.trainModel(key, work, (Model.Parameters)xgBoostParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, key.toString(), work, this.job(), xgBoostJob);
        xgBoostParameters = (XGBoostModel.XGBoostParameters)commonXGBoostParameters.clone();
        xgBoostParameters._max_depth = 5;
        xgBoostParameters._min_rows = 3.0;
        xgBoostParameters._sample_rate = 0.8;
        xgBoostParameters._col_sample_rate = 0.8;
        xgBoostParameters._col_sample_rate_per_tree = 0.8;
        if (emulateLightGBM) {
            xgBoostParameters._max_leaves = 1 << xgBoostParameters._max_depth;
            xgBoostParameters._max_depth *= 2;
            xgBoostParameters._min_sum_hessian_in_leaf = (float)xgBoostParameters._min_rows;
        }
        key = this.modelKey(algo.name());
        xgBoostJob = this.trainModel(key, work, (Model.Parameters)xgBoostParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, key.toString(), work, this.job(), xgBoostJob);
    }

    void defaultSearchXGBoost(Key<Grid> gridKey, boolean emulateLightGBM) {
        Algo algo = Algo.XGBoost;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        XGBoostModel.XGBoostParameters xgBoostParameters = new XGBoostModel.XGBoostParameters();
        if (emulateLightGBM) {
            xgBoostParameters._tree_method = XGBoostModel.XGBoostParameters.TreeMethod.hist;
            xgBoostParameters._grow_policy = XGBoostModel.XGBoostParameters.GrowPolicy.lossguide;
        }
        xgBoostParameters._distribution = this.getResponseColumn().isBinary() && !this.getResponseColumn().isNumeric() ? DistributionFamily.bernoulli : (this.getResponseColumn().isCategorical() ? DistributionFamily.multinomial : DistributionFamily.AUTO);
        xgBoostParameters._score_tree_interval = 5;
        xgBoostParameters._stopping_rounds = 5;
        xgBoostParameters._ntrees = 10000;
        xgBoostParameters._learn_rate = 0.05;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        if (emulateLightGBM) {
            searchParams.put("_max_leaves", new Integer[]{32, 1024, 32768, 0x100000});
            searchParams.put("_max_depth", new Integer[]{10, 20, 50});
            searchParams.put("_min_sum_hessian_in_leaf", new Double[]{0.01, 0.1, 1.0, 3.0, 5.0, 10.0, 15.0, 20.0});
        } else {
            searchParams.put("_max_depth", new Integer[]{5, 10, 15, 20});
            searchParams.put("_min_rows", new Double[]{0.01, 0.1, 1.0, 3.0, 5.0, 10.0, 15.0, 20.0});
        }
        searchParams.put("_sample_rate", new Double[]{0.6, 0.8, 1.0});
        searchParams.put("_col_sample_rate", new Double[]{0.6, 0.8, 1.0});
        searchParams.put("_col_sample_rate_per_tree", new Double[]{0.7, 0.8, 0.9, 1.0});
        searchParams.put("_booster", new XGBoostModel.XGBoostParameters.Booster[]{XGBoostModel.XGBoostParameters.Booster.gbtree, XGBoostModel.XGBoostParameters.Booster.gbtree, XGBoostModel.XGBoostParameters.Booster.dart});
        searchParams.put("_reg_lambda", new Float[]{Float.valueOf(0.001f), Float.valueOf(0.01f), Float.valueOf(0.1f), Float.valueOf(1.0f), Float.valueOf(10.0f), Float.valueOf(100.0f)});
        searchParams.put("_reg_alpha", new Float[]{Float.valueOf(0.001f), Float.valueOf(0.01f), Float.valueOf(0.1f), Float.valueOf(0.5f), Float.valueOf(1.0f)});
        Job<Grid> xgBoostSearchJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)xgBoostParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, algo.name() + " hyperparameter search", work, this.job(), xgBoostSearchJob);
    }

    void defaultRandomForest() {
        Algo algo = Algo.DRF;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.ModelBuild);
        if (work == null) {
            return;
        }
        DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
        drfParameters._score_tree_interval = 5;
        Job<Model> randomForestJob = this.trainModel(null, work, (Model.Parameters)drfParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "Default Random Forest build", work, this.job(), randomForestJob);
    }

    void defaultExtremelyRandomTrees() {
        Algo algo = Algo.DRF;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.ModelBuild);
        if (work == null) {
            return;
        }
        DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
        drfParameters._score_tree_interval = 5;
        Job<Model> randomForestJob = this.trainModel(this.modelKey("XRT"), work, (Model.Parameters)drfParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "Extremely Randomized Trees (XRT) Random Forest build", work, this.job(), randomForestJob);
    }

    void defaultGBMs() {
        Algo algo = Algo.GBM;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.ModelBuild);
        if (work == null) {
            return;
        }
        GBMModel.GBMParameters commonGBMParameters = new GBMModel.GBMParameters();
        commonGBMParameters._score_tree_interval = 5;
        commonGBMParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.AUTO;
        commonGBMParameters._ntrees = 1000;
        commonGBMParameters._sample_rate = 0.8;
        commonGBMParameters._col_sample_rate = 0.8;
        commonGBMParameters._col_sample_rate_per_tree = 0.8;
        GBMModel.GBMParameters gbmParameters = (GBMModel.GBMParameters)commonGBMParameters.clone();
        gbmParameters._max_depth = 6;
        gbmParameters._min_rows = 1.0;
        Job<Model> gbmJob = this.trainModel(null, work, (Model.Parameters)gbmParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM 1", work, this.job(), gbmJob);
        gbmParameters = (GBMModel.GBMParameters)commonGBMParameters.clone();
        gbmParameters._max_depth = 7;
        gbmParameters._min_rows = 10.0;
        gbmJob = this.trainModel(null, work, (Model.Parameters)gbmParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM 2", work, this.job(), gbmJob);
        gbmParameters = (GBMModel.GBMParameters)commonGBMParameters.clone();
        gbmParameters._max_depth = 8;
        gbmParameters._min_rows = 10.0;
        gbmJob = this.trainModel(null, work, (Model.Parameters)gbmParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM 3", work, this.job(), gbmJob);
        gbmParameters = (GBMModel.GBMParameters)commonGBMParameters.clone();
        gbmParameters._max_depth = 10;
        gbmParameters._min_rows = 10.0;
        gbmJob = this.trainModel(null, work, (Model.Parameters)gbmParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM 4", work, this.job(), gbmJob);
        gbmParameters = (GBMModel.GBMParameters)commonGBMParameters.clone();
        gbmParameters._max_depth = 15;
        gbmParameters._min_rows = 100.0;
        gbmJob = this.trainModel(null, work, (Model.Parameters)gbmParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM 5", work, this.job(), gbmJob);
    }

    void defaultDeepLearning() {
        Algo algo = Algo.DeepLearning;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.ModelBuild);
        if (work == null) {
            return;
        }
        DeepLearningModel.DeepLearningParameters deepLearningParameters = new DeepLearningModel.DeepLearningParameters();
        deepLearningParameters._stopping_tolerance = this.buildSpec.build_control.stopping_criteria.stopping_tolerance();
        deepLearningParameters._hidden = new int[]{10, 10, 10};
        Job<Model> deepLearningJob = this.trainModel(null, work, (Model.Parameters)deepLearningParameters);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "Default Deep Learning build", work, this.job(), deepLearningJob);
    }

    void defaultSearchGLM(Key<Grid> gridKey) {
        Algo algo = Algo.GLM;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        GLMModel.GLMParameters glmParameters = new GLMModel.GLMParameters();
        glmParameters._lambda_search = true;
        glmParameters._family = this.getResponseColumn().isBinary() && !this.getResponseColumn().isNumeric() ? GLMModel.GLMParameters.Family.binomial : (this.getResponseColumn().isCategorical() ? GLMModel.GLMParameters.Family.multinomial : GLMModel.GLMParameters.Family.gaussian);
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        glmParameters._alpha = new double[]{0.0, 0.2, 0.4, 0.6, 0.8, 1.0};
        searchParams.put("_missing_values_handling", new GLMModel.GLMParameters.MissingValuesHandling[]{GLMModel.GLMParameters.MissingValuesHandling.MeanImputation});
        Job<Grid> glmJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)glmParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GLM hyperparameter search", work, this.job(), glmJob);
    }

    void defaultSearchGBM(Key<Grid> gridKey) {
        Algo algo = Algo.GBM;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        GBMModel.GBMParameters gbmParameters = new GBMModel.GBMParameters();
        gbmParameters._score_tree_interval = 5;
        gbmParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.AUTO;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_ntrees", new Integer[]{10000});
        searchParams.put("_max_depth", new Integer[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17});
        searchParams.put("_min_rows", new Integer[]{1, 5, 10, 15, 30, 100});
        searchParams.put("_learn_rate", new Double[]{0.001, 0.005, 0.008, 0.01, 0.05, 0.08, 0.1, 0.5, 0.8});
        searchParams.put("_sample_rate", new Double[]{0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        searchParams.put("_col_sample_rate", new Double[]{0.4, 0.7, 1.0});
        searchParams.put("_col_sample_rate_per_tree", new Double[]{0.4, 0.7, 1.0});
        searchParams.put("_min_split_improvement", new Double[]{1.0E-4, 1.0E-5});
        Job<Grid> gbmJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)gbmParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "GBM hyperparameter search", work, this.job(), gbmJob);
    }

    void defaultSearchDL() {
        Key<Grid> dlGridKey = this.gridKey(Algo.DeepLearning.name());
        this.defaultSearchDL1(dlGridKey);
        this.defaultSearchDL2(dlGridKey);
        this.defaultSearchDL3(dlGridKey);
    }

    void defaultSearchDL1(Key<Grid> gridKey) {
        Algo algo = Algo.DeepLearning;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50}, {200}, {500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0}, {0.1}, {0.2}, {0.3}, {0.4}, {0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)dlParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "DeepLearning hyperparameter search 1", work, this.job(), dlJob);
    }

    void defaultSearchDL2(Key<Grid> gridKey) {
        Algo algo = Algo.DeepLearning;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50}, {200, 200}, {500, 500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0}, {0.1, 0.1}, {0.2, 0.2}, {0.3, 0.3}, {0.4, 0.4}, {0.5, 0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)dlParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "DeepLearning hyperparameter search 2", work, this.job(), dlJob);
    }

    void defaultSearchDL3(Key<Grid> gridKey) {
        Algo algo = Algo.DeepLearning;
        WorkAllocations.Work work = this.workAllocations.getAllocation(algo, JobType.HyperparamSearch);
        if (work == null) {
            return;
        }
        DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
        dlParameters._epochs = 10000.0;
        dlParameters._adaptive_rate = true;
        dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
        HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
        searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
        searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
        searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
        searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50, 50}, {200, 200, 200}, {500, 500, 500}});
        searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0, 0.0}, {0.1, 0.1, 0.1}, {0.2, 0.2, 0.2}, {0.3, 0.3, 0.3}, {0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}});
        Job<Grid> dlJob = this.hyperparameterSearch(gridKey, work, (Model.Parameters)dlParameters, searchParams);
        this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "DeepLearning hyperparameter search 3", work, this.job(), dlJob);
    }

    void defaultStackedEnsembles() {
        Model[] allModels = this.leaderboard().getModels();
        WorkAllocations.Work seWork = this.workAllocations.getAllocation(Algo.StackedEnsemble, JobType.ModelBuild);
        if (seWork == null) {
            this.job.update(0L, "StackedEnsemble builds skipped");
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "StackedEnsemble builds skipped due to the exclude_algos option.");
        } else if (allModels.length == 0) {
            this.job.update((long)seWork.consumeAll(), "No models built; StackedEnsemble builds skipped");
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "No models were built, due to timeouts or the exclude_algos option. StackedEnsemble builds skipped.");
        } else if (allModels.length == 1) {
            this.job.update((long)seWork.consumeAll(), "One model built; StackedEnsemble builds skipped");
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "StackedEnsemble builds skipped since there is only one model built");
        } else if (!this.isCVEnabled() && this.getBlendingFrame() == null) {
            this.job.update((long)seWork.consumeAll(), "Cross-validation disabled by the user and no blending frame provided; StackedEnsemble build skipped");
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "Cross-validation disabled by the user and no blending frame provided; StackedEnsemble build skipped");
        } else {
            int nonEnsembleCount = 0;
            for (Model aModel : allModels) {
                if (aModel instanceof StackedEnsembleModel) continue;
                ++nonEnsembleCount;
            }
            Key[] notEnsembles = new Key[nonEnsembleCount];
            int notEnsembleIndex = 0;
            for (Model aModel : allModels) {
                if (aModel instanceof StackedEnsembleModel) continue;
                notEnsembles[notEnsembleIndex++] = aModel._key;
            }
            ArrayList<Model> bestModelsOfEachType = new ArrayList<Model>();
            HashSet<String> typesOfGatheredModels = new HashSet<String>();
            for (Model aModel : allModels) {
                String type = this.getModelType(aModel);
                if (aModel instanceof StackedEnsembleModel || typesOfGatheredModels.contains(type)) continue;
                typesOfGatheredModels.add(type);
                bestModelsOfEachType.add(aModel);
            }
            Key[] bestModelKeys = new Key[bestModelsOfEachType.size()];
            for (int i = 0; i < bestModelsOfEachType.size(); ++i) {
                bestModelKeys[i] = ((Model)bestModelsOfEachType.get((int)i))._key;
            }
            Job<StackedEnsembleModel> bestEnsembleJob = this.stack("StackedEnsemble_BestOfFamily", bestModelKeys, true);
            this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "StackedEnsemble build using top model from each algorithm type", seWork, this.job(), bestEnsembleJob, true);
            Job<StackedEnsembleModel> ensembleJob = this.stack("StackedEnsemble_AllModels", notEnsembles, false);
            this.pollAndUpdateProgress(EventLogEntry.Stage.ModelTraining, "StackedEnsemble build using all AutoML models", seWork, this.job(), ensembleJob, true);
        }
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Key jobKey = this.job == null ? null : this.job._key;
        Log.debug((Object[])new Object[]{"Cleaning up AutoML " + jobKey});
        if (this.buildSpec.input_spec.training_frame == null && this.origTrainingFrame != null) {
            this.origTrainingFrame.delete(jobKey, fs, true);
        }
        if (this.buildSpec.input_spec.validation_frame == null && this.validationFrame != null) {
            this.validationFrame.delete(jobKey, fs, true);
        }
        if (this.buildSpec.input_spec.leaderboard_frame == null && this.leaderboardFrame != null) {
            this.leaderboardFrame.delete(jobKey, fs, true);
        }
        if (this.trainingFrame != null && this.origTrainingFrame != null) {
            Frame.deleteTempFrameAndItsNonSharedVecs((Frame)this.trainingFrame, (Frame)this.origTrainingFrame);
        }
        if (this.leaderboard() != null) {
            this.leaderboard().remove(fs, cascade);
        }
        if (this.eventLog() != null) {
            this.eventLog().remove(fs, cascade);
        }
        if (this.gridKeys != null) {
            for (Key<Grid> gridKey : this.gridKeys) {
                Keyed.remove(gridKey, (Futures)fs, (boolean)true);
            }
        }
        return super.remove_impl(fs, cascade);
    }

    private void addModels(Key<Model>[] newModels) {
        int before = this.leaderboard().getModelCount();
        this.leaderboard().addModels(newModels);
        int after = this.leaderboard().getModelCount();
        this.modelCount.addAndGet(after - before);
    }

    private void addModel(Model newModel) {
        int before = this.leaderboard().getModelCount();
        this.leaderboard().addModel(newModel);
        int after = this.leaderboard().getModelCount();
        this.modelCount.addAndGet(after - before);
    }

    private String getSortMetric() {
        Leaderboard leaderboard = this.leaderboard();
        return leaderboard == null ? null : leaderboard.sort_metric;
    }

    private static ScoreKeeper.StoppingMetric metricValueOf(String name) {
        String[] attempts;
        if (name == null) {
            return ScoreKeeper.StoppingMetric.AUTO;
        }
        switch (name) {
            case "mean_residual_deviance": {
                return ScoreKeeper.StoppingMetric.deviance;
            }
        }
        for (String attempt : attempts = new String[]{name, name.toUpperCase(), name.toLowerCase()}) {
            try {
                return ScoreKeeper.StoppingMetric.valueOf((String)attempt);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return ScoreKeeper.StoppingMetric.AUTO;
    }

    private boolean possiblyVerifyImmutability() {
        boolean warning = false;
        this.eventLog().debug(EventLogEntry.Stage.Workflow, "Verifying training frame immutability. . .");
        Vec[] vecsRightNow = this.origTrainingFrame.vecs();
        String[] namesRightNow = this.origTrainingFrame.names();
        if (this.originalTrainingFrameVecs.length != vecsRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this.originalTrainingFrameVecs.length + " to: " + vecsRightNow.length});
            warning = true;
        }
        if (this.originalTrainingFrameNames.length != namesRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this.originalTrainingFrameNames.length + " to: " + namesRightNow.length});
            warning = true;
        }
        for (int i = 0; i < this.originalTrainingFrameVecs.length; ++i) {
            if (!this.originalTrainingFrameVecs[i].equals((Object)vecsRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed keys.  Was: " + this.originalTrainingFrameVecs[i] + " , now: " + vecsRightNow[i]});
                warning = true;
            }
            if (!this.originalTrainingFrameNames[i].equals(namesRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed names.  Was: " + this.originalTrainingFrameNames[i] + " , now: " + namesRightNow[i]});
                warning = true;
            }
            if (this.originalTrainingFrameChecksums[i] == vecsRightNow[i].checksum()) continue;
            Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed checksum.  Was: " + this.originalTrainingFrameChecksums[i] + " , now: " + vecsRightNow[i].checksum()});
            warning = true;
        }
        if (warning) {
            this.eventLog().warn(EventLogEntry.Stage.Workflow, "Training frame was mutated!  This indicates a bug in the AutoML software.");
        } else {
            this.eventLog().debug(EventLogEntry.Stage.Workflow, "Training frame was not mutated (as expected).");
        }
        return warning;
    }

    private String getModelType(Model m) {
        return m._key.toString().startsWith("XRT_") ? "XRT" : m._parms.algoName();
    }

    private void cleanUpModelsCVPreds() {
        Log.info((Object[])new Object[]{"Cleaning up all CV Predictions for AutoML"});
        for (Model model : this.leaderboard().getModels()) {
            model.deleteCrossValidationPreds();
        }
    }

    static enum JobType {
        Unknown,
        ModelBuild,
        HyperparamSearch;

    }

    static class WorkAllocations
    extends Iced<WorkAllocations> {
        private boolean canAllocate = true;
        private Work[] allocations = new Work[0];

        WorkAllocations() {
        }

        WorkAllocations allocate(Algo algo, int count, JobType type, int workShare) {
            if (!this.canAllocate) {
                throw new IllegalStateException("Can't allocate new work.");
            }
            this.allocations = (Work[])ArrayUtils.append((Object[])this.allocations, (Object[])new Work[]{new Work(algo, count, type, workShare)});
            return this;
        }

        void end() {
            this.canAllocate = false;
        }

        void remove(Algo algo) {
            ArrayList<Work> filtered = new ArrayList<Work>(this.allocations.length);
            for (Work alloc : this.allocations) {
                if (algo.equals((Object)alloc.algo)) continue;
                filtered.add(alloc);
            }
            this.allocations = filtered.toArray(new Work[0]);
        }

        Work getAllocation(Algo algo, JobType workType) {
            for (Work alloc : this.allocations) {
                if (alloc.algo != algo || alloc.type != workType) continue;
                return alloc;
            }
            return null;
        }

        private int sum(Work[] workItems) {
            int tot = 0;
            for (Work item : workItems) {
                tot += item.count * item.share;
            }
            return tot;
        }

        int remainingWork() {
            return this.sum(this.allocations);
        }

        int remainingWork(Predicate<Work> predicate) {
            List selected = predicate.filter(Arrays.asList(this.allocations));
            return this.sum(selected.toArray(new Work[0]));
        }

        float remainingWorkRatio(Work work) {
            return (float)work.share / (float)this.remainingWork();
        }

        float remainingWorkRatio(Work work, Predicate<Work> predicate) {
            return (float)work.share / (float)this.remainingWork(predicate);
        }

        private static class Work
        extends Iced<Work> {
            private Algo algo;
            private int count;
            private JobType type;
            private int share;

            Work(Algo algo, int count, JobType type, int share) {
                this.algo = algo;
                this.count = count;
                this.type = type;
                this.share = share;
            }

            int consume() {
                return this.consume(1);
            }

            int consume(int amount) {
                int c = Math.min(this.count, amount);
                this.count -= c;
                return c * this.share;
            }

            int consumeAll() {
                return this.consume(Integer.MAX_VALUE);
            }
        }
    }
}

