/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.Algo;
import hex.ScoreKeeper;
import hex.grid.HyperSpaceSearchCriteria;
import water.Iced;
import water.Key;
import water.api.schemas3.JobV3;
import water.fvec.Frame;

public class AutoMLBuildSpec
extends Iced {
    public AutoMLBuildControl build_control;
    public AutoMLInput input_spec = new AutoMLInput();
    public AutoMLBuildModels build_models;
    public JobV3 job;
    private transient String project_cached = null;

    public AutoMLBuildSpec() {
        this.build_control = new AutoMLBuildControl();
        this.build_models = new AutoMLBuildModels();
    }

    public String project() {
        if (null != this.project_cached) {
            return this.project_cached;
        }
        if (null != this.build_control.project_name) {
            this.project_cached = this.build_control.project_name;
            return this.project_cached;
        }
        this.project_cached = "automl_" + this.project_cached;
        return this.project_cached;
    }

    public static final class AutoMLBuildModels
    extends Iced {
        public Algo[] exclude_algos;
        public Algo[] include_algos;
    }

    public static final class AutoMLInput
    extends Iced {
        public Key<Frame> training_frame;
        public Key<Frame> validation_frame;
        public Key<Frame> blending_frame;
        public Key<Frame> leaderboard_frame;
        public String response_column;
        public String fold_column;
        public String weights_column;
        public String[] ignored_columns;
        public String sort_metric;
    }

    public static final class AutoMLStoppingCriteria
    extends Iced {
        public static final int AUTO_STOPPING_TOLERANCE = -1;
        private HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria _searchCriteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
        private double _max_runtime_secs_per_model = 0.0;

        public double max_runtime_secs_per_model() {
            return this._max_runtime_secs_per_model;
        }

        public void set_max_runtime_secs_per_model(double max_runtime_secs_per_model) {
            this._max_runtime_secs_per_model = max_runtime_secs_per_model;
        }

        public long seed() {
            return this._searchCriteria.seed();
        }

        public int max_models() {
            return this._searchCriteria.max_models();
        }

        public double max_runtime_secs() {
            return this._searchCriteria.max_runtime_secs();
        }

        public int stopping_rounds() {
            return this._searchCriteria.stopping_rounds();
        }

        public ScoreKeeper.StoppingMetric stopping_metric() {
            return this._searchCriteria.stopping_metric();
        }

        public double stopping_tolerance() {
            return this._searchCriteria.stopping_tolerance();
        }

        public void set_seed(long seed) {
            this._searchCriteria.set_seed(seed);
        }

        public void set_max_models(int max_models) {
            this._searchCriteria.set_max_models(max_models);
        }

        public void set_max_runtime_secs(double max_runtime_secs) {
            this._searchCriteria.set_max_runtime_secs(max_runtime_secs);
        }

        public void set_stopping_rounds(int stopping_rounds) {
            this._searchCriteria.set_stopping_rounds(stopping_rounds);
        }

        public void set_stopping_metric(ScoreKeeper.StoppingMetric stopping_metric) {
            this._searchCriteria.set_stopping_metric(stopping_metric);
        }

        public void set_stopping_tolerance(double stopping_tolerance) {
            this._searchCriteria.set_stopping_tolerance(stopping_tolerance);
        }

        public void set_default_stopping_tolerance_for_frame(Frame frame) {
            this._searchCriteria.set_default_stopping_tolerance_for_frame(frame);
        }

        public static double default_stopping_tolerance_for_frame(Frame frame) {
            return HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria.default_stopping_tolerance_for_frame((Frame)frame);
        }

        public HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria getSearchCriteria() {
            return this._searchCriteria;
        }
    }

    public static final class AutoMLBuildControl
    extends Iced {
        public String project_name = null;
        public AutoMLStoppingCriteria stopping_criteria = new AutoMLStoppingCriteria();
        public boolean balance_classes = false;
        public float[] class_sampling_factors;
        public float max_after_balance_size = 5.0f;
        public int nfolds = 5;
        public boolean keep_cross_validation_predictions = false;
        public boolean keep_cross_validation_models = false;
        public boolean keep_cross_validation_fold_assignment = false;
        public String export_checkpoints_dir = null;

        public AutoMLBuildControl() {
            this.stopping_criteria.set_max_models(0);
            this.stopping_criteria.set_max_runtime_secs(3600.0);
            this.stopping_criteria.set_max_runtime_secs_per_model(0.0);
            this.stopping_criteria.set_stopping_rounds(3);
            this.stopping_criteria.set_stopping_tolerance(0.001);
            this.stopping_criteria.set_stopping_metric(ScoreKeeper.StoppingMetric.AUTO);
        }
    }
}

