/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.EventLog;
import ai.h2o.automl.EventLogEntry;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.TAtomic;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.TwoDimTable;

public class Leaderboard
extends Keyed<Leaderboard> {
    private final String project_name;
    private Key<Model>[] models = new Key[0];
    private IcedHashMap<Key<ModelMetrics>, ModelMetrics> leaderboard_set_metrics = new IcedHashMap();
    public double[] sort_metrics = new double[0];
    public double[] mean_residual_deviance = new double[0];
    public double[] rmse = new double[0];
    public double[] mse = new double[0];
    public double[] mae = new double[0];
    public double[] rmsle = new double[0];
    public double[] logloss = new double[0];
    public double[] auc = new double[0];
    public double[] mean_per_class_error = new double[0];
    String sort_metric;
    private String[] other_metrics;
    private boolean sort_decreasing;
    private boolean have_set_sort_metric = false;
    private EventLog eventLog;
    private Frame leaderboardFrame;
    private long leaderboardFrameChecksum;
    private static final String[] colTypesMultinomial = new String[]{"string", "double", "double", "double", "double"};
    private static final String[] colFormatsMultinomial = new String[]{"%s", "%.6f", "%.6f", "%.6f", "%.6f"};
    private static final String[] colTypesBinomial = new String[]{"string", "double", "double", "double", "double", "double"};
    private static final String[] colFormatsBinomial = new String[]{"%s", "%.6f", "%.6f", "%.6f", "%.6f", "%.6f"};
    private static final String[] colTypesRegression = new String[]{"string", "double", "double", "double", "double", "double"};
    private static final String[] colFormatsRegression = new String[]{"%s", "%.6f", "%.6f", "%.6f", "%.6f", "%.6f"};

    public Leaderboard(String project_name, EventLog eventLog, Frame leaderboardFrame, String sort_metric) {
        this._key = Key.make((String)Leaderboard.idForProject(project_name));
        this.project_name = project_name;
        this.eventLog = eventLog;
        this.leaderboardFrame = leaderboardFrame;
        this.leaderboardFrameChecksum = leaderboardFrame == null ? 0L : leaderboardFrame.checksum();
        this.sort_metric = sort_metric == null ? null : sort_metric.toLowerCase();
    }

    static Leaderboard getOrMake(String project_name, EventLog eventLog, Frame leaderboardFrame, String sort_metric) {
        Leaderboard leaderboard = (Leaderboard)DKV.getGet((Key)Key.make((String)Leaderboard.idForProject(project_name)));
        if (null != leaderboard) {
            leaderboard.eventLog = eventLog;
            leaderboard.leaderboardFrame = leaderboardFrame;
            if (sort_metric != null) {
                leaderboard.sort_metric = sort_metric.toLowerCase();
                leaderboard.sort_decreasing = leaderboard.sort_metric.equals("auc");
            }
            leaderboard.leaderboardFrameChecksum = leaderboardFrame == null ? 0L : leaderboardFrame.checksum();
        } else {
            leaderboard = new Leaderboard(project_name, eventLog, leaderboardFrame, sort_metric);
        }
        DKV.put((Keyed)leaderboard);
        return leaderboard;
    }

    public static String idForProject(String project_name) {
        return "AutoML_Leaderboard_" + project_name;
    }

    public String getProject() {
        return this.project_name;
    }

    private EventLog eventLog() {
        return this.eventLog == null ? null : (EventLog)this.eventLog._key.get();
    }

    private void setMetricAndDirection(String metric, String[] otherMetrics, boolean sortDecreasing) {
        this.sort_metric = metric;
        this.other_metrics = otherMetrics;
        this.sort_decreasing = sortDecreasing;
        this.have_set_sort_metric = true;
        DKV.put((Keyed)this);
    }

    private void setDefaultMetricAndDirection(Model m) {
        String[] metrics;
        if (m._output.isBinomialClassifier()) {
            metrics = new String[]{"logloss", "mean_per_class_error", "rmse", "mse"};
            if (this.sort_metric == null) {
                this.sort_metric = "auc";
            }
        } else if (m._output.isMultinomialClassifier()) {
            metrics = new String[]{"logloss", "rmse", "mse"};
            if (this.sort_metric == null) {
                this.sort_metric = "mean_per_class_error";
            }
        } else {
            metrics = new String[]{"rmse", "mse", "mae", "rmsle"};
            if (this.sort_metric == null) {
                this.sort_metric = "mean_residual_deviance";
            }
        }
        boolean sortDecreasing = this.sort_metric.equals("auc");
        this.setMetricAndDirection(this.sort_metric, metrics, sortDecreasing);
    }

    final void addModels(final Key<Model>[] newModels) {
        if (null == this._key) {
            throw new H2OIllegalArgumentException("Can't add models to a Leaderboard which isn't in the DKV.");
        }
        if (null == newModels || newModels.length == 0) {
            return;
        }
        if (!this.have_set_sort_metric) {
            this.setDefaultMetricAndDirection((Model)newModels[0].get());
        }
        final Key[] newLeader = new Key[1];
        final double[] newLeaderSortMetric = new double[1];
        new TAtomic<Leaderboard>(){

            public final Leaderboard atomic(Leaderboard updating) {
                if (updating == null) {
                    Log.err((Object[])new Object[]{"trying to update null leaderboard!"});
                    throw new H2OIllegalArgumentException("Trying to update a null leaderboard.");
                }
                Key[] oldModels = updating.models;
                Key oldLeader = oldModels == null || 0 == oldModels.length ? null : oldModels[0];
                HashSet<Key> uniques = new HashSet<Key>(oldModels.length + newModels.length);
                uniques.addAll(Arrays.asList(oldModels));
                uniques.addAll(Arrays.asList(newModels));
                Leaderboard.access$002(updating, uniques.toArray(new Key[0]));
                updating.leaderboard_set_metrics = new IcedHashMap();
                Model model = null;
                for (Key aKey : updating.models) {
                    model = (Model)aKey.get();
                    if (null == model) {
                        Leaderboard.this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Model in the leaderboard has unexpectedly been deleted from H2O: " + aKey);
                        continue;
                    }
                    ModelMetrics mm = null;
                    if (Leaderboard.this.leaderboardFrame == null) {
                        mm = ModelMetrics.defaultModelMetrics((Model)model);
                    } else {
                        mm = ModelMetrics.getFromDKV((Model)model, (Frame)Leaderboard.this.leaderboardFrame);
                        if (mm == null) {
                            model.score(Leaderboard.this.leaderboardFrame).delete();
                            mm = ModelMetrics.getFromDKV((Model)model, (Frame)Leaderboard.this.leaderboardFrame);
                        }
                    }
                    if (mm == null) continue;
                    updating.leaderboard_set_metrics.put((Object)mm._key, (Object)mm);
                }
                try {
                    List modelsSorted = null;
                    modelsSorted = Leaderboard.this.leaderboardFrame == null ? ModelMetrics.sortModelsByMetric((String)Leaderboard.this.sort_metric, (boolean)Leaderboard.this.sort_decreasing, Arrays.asList(updating.models)) : ModelMetrics.sortModelsByMetric((Frame)Leaderboard.this.leaderboardFrame, (String)Leaderboard.this.sort_metric, (boolean)Leaderboard.this.sort_decreasing, Arrays.asList(updating.models));
                    Leaderboard.access$002(updating, modelsSorted.toArray(new Key[0]));
                }
                catch (H2OIllegalArgumentException e) {
                    Log.warn((Object[])new Object[]{"ModelMetrics.sortModelsByMetric failed: " + (Object)((Object)e)});
                    throw e;
                }
                Model[] updating_models = new Model[updating.models.length];
                Leaderboard.modelsForModelKeys(updating.models, updating_models);
                updating.sort_metrics = Leaderboard.getMetrics(updating.sort_metric, (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                if (model._output.isBinomialClassifier()) {
                    updating.auc = Leaderboard.getMetrics("auc", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.logloss = Leaderboard.getMetrics("logloss", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.mean_per_class_error = Leaderboard.getMetrics("mean_per_class_error", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.rmse = Leaderboard.getMetrics("rmse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.mse = Leaderboard.getMetrics("mse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                } else if (model._output.isMultinomialClassifier()) {
                    updating.mean_per_class_error = Leaderboard.getMetrics("mean_per_class_error", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.logloss = Leaderboard.getMetrics("logloss", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.rmse = Leaderboard.getMetrics("rmse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.mse = Leaderboard.getMetrics("mse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                } else {
                    updating.mean_residual_deviance = Leaderboard.getMetrics("mean_residual_deviance", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.rmse = Leaderboard.getMetrics("rmse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.mse = Leaderboard.getMetrics("mse", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.mae = Leaderboard.getMetrics("mae", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                    updating.rmsle = Leaderboard.getMetrics("rmsle", (IcedHashMap<Key<ModelMetrics>, ModelMetrics>)updating.leaderboard_set_metrics, Leaderboard.this.leaderboardFrame, updating_models);
                }
                if (oldLeader == null || !oldLeader.equals((Object)updating.models[0])) {
                    newLeader[0] = updating.models[0];
                    newLeaderSortMetric[0] = updating.sort_metrics[0];
                }
                return updating;
            }
        }.invoke(this._key);
        Leaderboard updated = (Leaderboard)DKV.getGet((Key)this._key);
        this.models = updated.models;
        this.leaderboard_set_metrics = updated.leaderboard_set_metrics;
        this.sort_metrics = updated.sort_metrics;
        if (updated.getLeader()._output.isBinomialClassifier()) {
            this.auc = updated.auc;
            this.logloss = updated.logloss;
            this.mean_per_class_error = updated.mean_per_class_error;
            this.rmse = updated.rmse;
            this.mse = updated.mse;
        } else if (updated.getLeader()._output.isMultinomialClassifier()) {
            this.mean_per_class_error = updated.mean_per_class_error;
            this.logloss = updated.logloss;
            this.rmse = updated.rmse;
            this.mse = updated.mse;
        } else {
            this.mean_residual_deviance = updated.mean_residual_deviance;
            this.rmse = updated.rmse;
            this.mse = updated.mse;
            this.mae = updated.mae;
            this.rmsle = updated.rmsle;
        }
        if (null != newLeader[0]) {
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "New leader: " + newLeader[0] + ", " + this.sort_metric + ": " + newLeaderSortMetric[0]);
        }
    }

    void addModel(Key<Model> key) {
        if (null == key) {
            return;
        }
        Key[] keys = new Key[]{key};
        this.addModels(keys);
    }

    void addModel(Model model) {
        if (null == model) {
            return;
        }
        Key[] keys = new Key[]{model._key};
        this.addModels(keys);
    }

    private static Model[] modelsForModelKeys(Key<Model>[] modelKeys, Model[] models) {
        assert (models.length >= modelKeys.length);
        int i = 0;
        for (Key<Model> modelKey : modelKeys) {
            models[i++] = (Model)DKV.getGet(modelKey);
        }
        return models;
    }

    Key<Model>[] getModelKeys() {
        Leaderboard uptodate = (Leaderboard)DKV.getGet((Key)this._key);
        return uptodate == null ? new Key[]{} : uptodate.models;
    }

    private Key<Model>[] modelKeys(String metric, boolean sortDecreasing) {
        Key<Model>[] models = this.getModelKeys();
        List newModelsSorted = ModelMetrics.sortModelsByMetric((String)metric, (boolean)sortDecreasing, Arrays.asList(models));
        return newModelsSorted.toArray(new Key[0]);
    }

    Model[] getModels() {
        Key<Model>[] modelKeys = this.getModelKeys();
        if (modelKeys == null || 0 == modelKeys.length) {
            return new Model[0];
        }
        Model[] models = new Model[modelKeys.length];
        return Leaderboard.modelsForModelKeys(modelKeys, models);
    }

    Model[] getModels(String metric, boolean sortDecreasing) {
        Key<Model>[] modelKeys = this.modelKeys(metric, sortDecreasing);
        if (modelKeys == null || 0 == modelKeys.length) {
            return new Model[0];
        }
        Model[] models = new Model[modelKeys.length];
        return Leaderboard.modelsForModelKeys(modelKeys, models);
    }

    Model getLeader() {
        Key<Model>[] modelKeys = this.getModelKeys();
        if (modelKeys == null || 0 == modelKeys.length) {
            return null;
        }
        return (Model)modelKeys[0].get();
    }

    int getModelCount() {
        return this.getModelKeys().length;
    }

    private static double[] getMetrics(String metric, IcedHashMap<Key<ModelMetrics>, ModelMetrics> leaderboard_set_metrics, Frame leaderboardFrame, Model[] models) {
        double[] other_metrics = new double[models.length];
        int i = 0;
        for (Model m : models) {
            if (leaderboardFrame != null) {
                other_metrics[i++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)((ModelMetrics)leaderboard_set_metrics.get((Object)ModelMetrics.buildKey((Model)m, (Frame)leaderboardFrame))), (String)metric);
                continue;
            }
            Key model_key = m._key;
            long model_checksum = m.checksum();
            ModelMetrics mm = ModelMetrics.defaultModelMetrics((Model)m);
            other_metrics[i++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)((ModelMetrics)leaderboard_set_metrics.get((Object)ModelMetrics.buildKey((Key)model_key, (long)model_checksum, (Key)mm.frame()._key, (long)mm.frame().checksum()))), (String)metric);
        }
        return other_metrics;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Log.debug((Object[])new Object[]{"Cleaning up leaderboard from models " + Arrays.toString(this.models)});
        if (cascade) {
            for (Key<Model> m : this.models) {
                Keyed.remove((Key)m, (Futures)fs, (boolean)true);
            }
        }
        for (Key k : this.leaderboard_set_metrics.keySet()) {
            Keyed.remove((Key)k, (Futures)fs, (boolean)true);
        }
        return super.remove_impl(fs, cascade);
    }

    private static double[] defaultMetricForModel(Model m) {
        return Leaderboard.defaultMetricForModel(m, ModelMetrics.defaultModelMetrics((Model)m));
    }

    private static double[] defaultMetricForModel(Model m, ModelMetrics mm) {
        if (m._output.isBinomialClassifier()) {
            return new double[]{((ModelMetricsBinomial)mm).auc(), ((ModelMetricsBinomial)mm).logloss(), ((ModelMetricsBinomial)mm).mean_per_class_error(), mm.rmse(), mm.mse()};
        }
        if (m._output.isMultinomialClassifier()) {
            return new double[]{((ModelMetricsMultinomial)mm).mean_per_class_error(), ((ModelMetricsMultinomial)mm).logloss(), mm.rmse(), mm.mse()};
        }
        if (m._output.isSupervised()) {
            return new double[]{((ModelMetricsRegression)mm).mean_residual_deviance(), mm.rmse(), mm.mse(), ((ModelMetricsRegression)mm).mae(), ((ModelMetricsRegression)mm).rmsle()};
        }
        Log.warn((Object[])new Object[]{"Failed to find metric for model: " + m});
        return new double[]{Double.NaN};
    }

    private static String[] defaultMetricNameForModel(Model m) {
        if (m._output.isBinomialClassifier()) {
            return new String[]{"auc", "logloss", "mean_per_class_error", "rmse", "mse"};
        }
        if (m._output.isMultinomialClassifier()) {
            return new String[]{"mean per-class error", "logloss", "rmse", "mse"};
        }
        if (m._output.isSupervised()) {
            return new String[]{"mean_residual_deviance", "rmse", "mse", "mae", "rmsle"};
        }
        return new String[]{"unknown"};
    }

    String rankTsv() {
        String lineSeparator = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Error").append(lineSeparator);
        Model[] models = this.getModels();
        for (int i = models.length - 1; i >= 0; --i) {
            Model m = models[i];
            sb.append(Arrays.toString(Leaderboard.defaultMetricForModel(m)));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private static String[] colHeaders(String metric, String[] other_metric) {
        String[] headers = ArrayUtils.append((String[])new String[]{"model_id", metric}, (String[])other_metric);
        return headers;
    }

    private static final TwoDimTable makeTwoDimTable(String tableHeader, String sort_metric, String[] other_metrics, Model[] models) {
        assert (sort_metric != null || models.length == 0) : "sort_metrics needs to be always not-null for non-empty array!";
        String[] rowHeaders = new String[models.length];
        for (int i = 0; i < models.length; ++i) {
            rowHeaders[i] = "" + i;
        }
        if (models.length == 0) {
            return new TwoDimTable(tableHeader, "no models in this leaderboard", rowHeaders, Leaderboard.colHeaders("auc", other_metrics), colTypesBinomial, colFormatsBinomial, "-");
        }
        if (models[0]._output.isBinomialClassifier()) {
            return new TwoDimTable(tableHeader, "models sorted in order of " + sort_metric + ", best first", rowHeaders, Leaderboard.colHeaders("auc", other_metrics), colTypesBinomial, colFormatsBinomial, "#");
        }
        if (models[0]._output.isMultinomialClassifier()) {
            return new TwoDimTable(tableHeader, "models sorted in order of " + sort_metric + ", best first", rowHeaders, Leaderboard.colHeaders("mean_per_class_error", other_metrics), colTypesMultinomial, colFormatsMultinomial, "#");
        }
        return new TwoDimTable(tableHeader, "models sorted in order of " + sort_metric + ", best first", rowHeaders, Leaderboard.colHeaders("mean_residual_deviance", other_metrics), colTypesRegression, colFormatsRegression, "#");
    }

    private void addTwoDimTableRowMultinomial(TwoDimTable table, int row, String[] modelIDs, double[] mean_per_class_error, double[] logloss, double[] rmse, double[] mse) {
        int col = 0;
        table.set(row, col++, (Object)modelIDs[row]);
        table.set(row, col++, (Object)mean_per_class_error[row]);
        table.set(row, col++, (Object)logloss[row]);
        table.set(row, col++, (Object)rmse[row]);
        table.set(row, col++, (Object)mse[row]);
    }

    private void addTwoDimTableRowBinomial(TwoDimTable table, int row, String[] modelIDs, double[] auc, double[] logloss, double[] mean_per_class_error, double[] rmse, double[] mse) {
        int col = 0;
        table.set(row, col++, (Object)modelIDs[row]);
        table.set(row, col++, (Object)auc[row]);
        table.set(row, col++, (Object)logloss[row]);
        table.set(row, col++, (Object)mean_per_class_error[row]);
        table.set(row, col++, (Object)rmse[row]);
        table.set(row, col++, (Object)mse[row]);
    }

    private void addTwoDimTableRowRegression(TwoDimTable table, int row, String[] modelIDs, double[] mean_residual_deviance, double[] rmse, double[] mse, double[] mae, double[] rmsle) {
        int col = 0;
        table.set(row, col++, (Object)modelIDs[row]);
        table.set(row, col++, (Object)mean_residual_deviance[row]);
        table.set(row, col++, (Object)rmse[row]);
        table.set(row, col++, (Object)mse[row]);
        table.set(row, col++, (Object)mae[row]);
        table.set(row, col++, (Object)rmsle[row]);
    }

    public TwoDimTable toTwoDimTable() {
        return this.toTwoDimTable("Leaderboard for AutoML: " + this.project_name, false);
    }

    TwoDimTable toTwoDimTable(String tableHeader, boolean leftJustifyModelIds) {
        int i;
        Model[] models = this.getModels();
        String[] modelIDsFormatted = new String[models.length];
        this.other_metrics = models.length == 0 ? new String[]{"logloss", "mean_per_class_error", "rmse", "mse"} : (models[0]._output.isBinomialClassifier() ? new String[]{"logloss", "mean_per_class_error", "rmse", "mse"} : (models[0]._output.isMultinomialClassifier() ? new String[]{"logloss", "rmse", "mse"} : new String[]{"rmse", "mse", "mae", "rmsle"}));
        TwoDimTable table = Leaderboard.makeTwoDimTable(tableHeader, this.sort_metric, this.other_metrics, models);
        int maxModelIdLen = -1;
        for (Model m : models) {
            maxModelIdLen = Math.max(maxModelIdLen, m._key.toString().length());
        }
        for (i = 0; i < models.length; ++i) {
            modelIDsFormatted[i] = leftJustifyModelIds ? (models[i]._key.toString() + "                                                                                         ").substring(0, maxModelIdLen) : models[i]._key.toString();
        }
        for (i = 0; i < models.length; ++i) {
            if (models[i]._output.isMultinomialClassifier()) {
                this.addTwoDimTableRowMultinomial(table, i, modelIDsFormatted, this.mean_per_class_error, this.logloss, this.rmse, this.mse);
                continue;
            }
            if (models[i]._output.isBinomialClassifier()) {
                this.addTwoDimTableRowBinomial(table, i, modelIDsFormatted, this.auc, this.logloss, this.mean_per_class_error, this.rmse, this.mse);
                continue;
            }
            this.addTwoDimTableRowRegression(table, i, modelIDsFormatted, this.mean_residual_deviance, this.rmse, this.mse, this.mae, this.rmsle);
        }
        return table;
    }

    private static String toString(String project_name, Model[] models, String fieldSeparator, String lineSeparator, boolean includeTitle, boolean includeHeader) {
        StringBuilder sb = new StringBuilder();
        if (includeTitle) {
            sb.append("Leaderboard for project_name \"").append(project_name).append("\": ");
            if (models.length == 0) {
                sb.append("<empty>");
                return sb.toString();
            }
            sb.append(lineSeparator);
        }
        boolean printedHeader = false;
        for (Model m : models) {
            if (includeHeader && !printedHeader) {
                sb.append("model_id");
                sb.append(fieldSeparator);
                sb.append(Leaderboard.defaultMetricNameForModel(m));
                sb.append(lineSeparator);
                printedHeader = true;
            }
            sb.append(m._key.toString());
            sb.append(fieldSeparator);
            sb.append(Leaderboard.defaultMetricForModel(m));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private String toString(String fieldSeparator, String lineSeparator) {
        return Leaderboard.toString(this.project_name, this.getModels(), fieldSeparator, lineSeparator, true, true);
    }

    public String toString() {
        return this.toString(" ; ", " | ");
    }

    static /* synthetic */ Key[] access$002(Leaderboard x0, Key[] x1) {
        x0.models = x1;
        return x1;
    }
}

