/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.AutoML;
import water.DKV;
import water.Iced;
import water.Key;
import water.Value;
import water.api.Handler;
import water.automl.api.schemas3.AutoMLV99;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;

public class AutoMLHandler
extends Handler {
    public AutoMLV99 fetch(int version, AutoMLV99 autoMLV99) {
        AutoML autoML = (AutoML)DKV.getGet((String)autoMLV99.automl_id.name);
        return autoMLV99.fillFromImpl(autoML);
    }

    public static AutoML getFromDKV(String param_name, String key_str) {
        return AutoMLHandler.getFromDKV(param_name, Key.make((String)key_str));
    }

    public static AutoML getFromDKV(String param_name, Key key) {
        if (key == null) {
            throw new H2OIllegalArgumentException(param_name, "AutoML.getFromDKV()", null);
        }
        Value v = DKV.get((Key)key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Iced ice = v.get();
        if (!(ice instanceof AutoML)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, (Object)key.toString(), AutoML.class, ice.getClass());
        }
        return (AutoML)ice;
    }
}

