/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api.schemas3;

import ai.h2o.automl.EventLogEntry;
import java.util.Objects;
import water.Iced;
import water.api.API;
import water.api.EnumValuesProvider;
import water.api.Schema;

public class EventLogEntryV99
extends Schema<EventLogEntry, EventLogEntryV99> {
    @API(help="Timestamp for this event, in milliseconds since Jan 1, 1970", direction=API.Direction.OUTPUT)
    public long timestamp;
    @API(help="Importance of this log event", valuesProvider=LevelProvider.class, direction=API.Direction.OUTPUT)
    public EventLogEntry.Level level;
    @API(help="Stage of the AutoML process for this log event", valuesProvider=StageProvider.class, direction=API.Direction.OUTPUT)
    public EventLogEntry.Stage stage;
    @API(help="Message for this event", direction=API.Direction.OUTPUT)
    public String message;
    @API(help="String identifier associated to this entry", direction=API.Direction.OUTPUT)
    public String name;
    @API(help="Value associated to this entry", direction=API.Direction.OUTPUT)
    public String value;

    public EventLogEntryV99 fillFromImpl(EventLogEntry impl) {
        super.fillFromImpl((Iced)impl, new String[]{"value", "valueFormatter"});
        this.value = impl.getValueFormatter() == null ? Objects.toString(impl.getValue(), "") : impl.getValueFormatter().format(impl.getValue());
        return this;
    }

    public static final class StageProvider
    extends EnumValuesProvider<EventLogEntry.Stage> {
        public StageProvider() {
            super(EventLogEntry.Stage.class);
        }
    }

    public static final class LevelProvider
    extends EnumValuesProvider<EventLogEntry.Level> {
        public LevelProvider() {
            super(EventLogEntry.Level.class);
        }
    }
}

