/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.WorkAllocations;
import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.Leaderboard;
import hex.Model;
import hex.grid.Grid;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import water.Iced;
import water.Job;
import water.Key;
import water.util.Countdown;
import water.util.Log;

class ModelingStepsExecutor
extends Iced<ModelingStepsExecutor> {
    private static final int pollingIntervalInMillis = 1000;
    final Key<EventLog> _eventLogKey;
    final Key<Leaderboard> _leaderboardKey;
    final Countdown _runCountdown;
    private transient List<Job> _jobs;
    private final AtomicInteger _modelCount = new AtomicInteger();

    ModelingStepsExecutor(Leaderboard leaderboard, EventLog eventLog, Countdown runCountdown) {
        this._leaderboardKey = leaderboard._key;
        this._eventLogKey = eventLog._key;
        this._runCountdown = runCountdown;
    }

    int modelCount() {
        return this._modelCount.get();
    }

    void start() {
        this._jobs = new ArrayList<Job>();
        this._modelCount.set(0);
        this._runCountdown.start();
    }

    void stop() {
        this._runCountdown.stop();
        if (null == this._jobs) {
            return;
        }
        for (Job j : this._jobs) {
            j.stop();
        }
        for (Job j : this._jobs) {
            j.get();
        }
        this._jobs = null;
    }

    boolean submit(ModelingStep step, Job parentJob) {
        if (step.canRun()) {
            Job job = step.startJob();
            if (job == null) {
                this.skip(step._description, step.getAllocatedWork(), parentJob);
            } else {
                this.monitor(job, step.getAllocatedWork(), parentJob, step._ignoreConstraints);
                return true;
            }
        }
        return false;
    }

    private void skip(String name, WorkAllocations.Work work, Job parentJob) {
        if (null != parentJob) {
            parentJob.update((long)work.consume(), "SKIPPED: " + name);
            Log.info((Object[])new Object[]{"AutoML; skipping " + name});
        }
    }

    private void monitor(Job job, WorkAllocations.Work work, Job parentJob, boolean ignoreTimeout) {
        EventLog eventLog = this.eventLog();
        String jobDescription = job._result == null ? job._description : job._result.toString() + " [" + job._description + "]";
        eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " started");
        this._jobs.add(job);
        long lastWorkedSoFar = 0L;
        long lastTotalGridModelsBuilt = 0L;
        while (job.isRunning()) {
            Grid grid;
            int totalGridModelsBuilt;
            if (null != parentJob) {
                if (parentJob.stop_requested()) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML job cancelled; skipping " + jobDescription);
                    job.stop();
                }
                if (!ignoreTimeout && this._runCountdown.timedOut()) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML: out of time; skipping " + jobDescription);
                    job.stop();
                }
            }
            long workedSoFar = Math.round(job.progress() * (float)work._weight);
            if (null != parentJob) {
                parentJob.update((long)Math.round(workedSoFar - lastWorkedSoFar), jobDescription);
            }
            if (WorkAllocations.JobType.HyperparamSearch == work._type && (long)(totalGridModelsBuilt = (grid = (Grid)job._result.get()).getModelCount()) > lastTotalGridModelsBuilt) {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalGridModelsBuilt + " models for search: " + jobDescription);
                this.addModels(grid);
                lastTotalGridModelsBuilt = totalGridModelsBuilt;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lastWorkedSoFar = workedSoFar;
        }
        if (WorkAllocations.JobType.HyperparamSearch == work._type) {
            if (job.isCrashed()) {
                eventLog.warn(EventLogEntry.Stage.ModelTraining, jobDescription + " failed: " + job.ex().toString());
            } else if (job.get() == null) {
                eventLog.info(EventLogEntry.Stage.ModelTraining, jobDescription + " cancelled");
            } else {
                Grid grid = (Grid)job.get();
                int totalGridModelsBuilt = grid.getModelCount();
                if ((long)totalGridModelsBuilt > lastTotalGridModelsBuilt) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalGridModelsBuilt + " models for search: " + jobDescription);
                    this.addModels(grid);
                }
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
            }
        } else if (WorkAllocations.JobType.ModelBuild == work._type) {
            if (job.isCrashed()) {
                eventLog.warn(EventLogEntry.Stage.ModelTraining, jobDescription + " failed: " + job.ex().toString());
            } else if (job.get() == null) {
                eventLog.info(EventLogEntry.Stage.ModelTraining, jobDescription + " cancelled");
            } else {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
                this.addModel((Model)job.get());
            }
        }
        if (null != parentJob) {
            parentJob.update((long)work._weight - lastWorkedSoFar);
        }
        work.consume();
        this._jobs.remove(job);
    }

    private void addModels(Grid grid) {
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModels(grid.getModelKeys());
        int after = leaderboard.getModelCount();
        this._modelCount.addAndGet(after - before);
    }

    private void addModel(Model newModel) {
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModel(newModel._key);
        int after = leaderboard.getModelCount();
        this._modelCount.addAndGet(after - before);
    }

    private EventLog eventLog() {
        return (EventLog)this._eventLogKey.get();
    }

    private Leaderboard leaderboard() {
        return (Leaderboard)this._leaderboardKey.get();
    }
}

