/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import ai.h2o.automl.StepDefinition;
import ai.h2o.automl.events.EventLogEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import water.Iced;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;

public class ModelingStepsRegistry
extends Iced<ModelingStepsRegistry> {
    static final NonBlockingHashMap<String, ModelingStepsProvider> stepsByName = new NonBlockingHashMap();

    public ModelingStep[] getOrderedSteps(StepDefinition[] modelingPlan, AutoML aml) {
        aml.eventLog().info(EventLogEntry.Stage.Workflow, "Loading execution steps: " + Arrays.toString((Object[])modelingPlan));
        ArrayList<ModelingStep> orderedSteps = new ArrayList<ModelingStep>();
        for (StepDefinition def : modelingPlan) {
            ModelingStep[] toAdd;
            ModelingStepsProvider provider = (ModelingStepsProvider)stepsByName.get((Object)def._name);
            if (provider == null) {
                throw new IllegalArgumentException("Missing provider for training steps '" + def._name + "'");
            }
            Object steps = provider.newInstance(aml);
            if (def._alias != null) {
                toAdd = ((ModelingSteps)((Object)steps)).getSteps(def._alias);
            } else if (def._steps != null) {
                toAdd = ((ModelingSteps)((Object)steps)).getSteps(def._steps);
                if (toAdd.length < def._steps.length) {
                    List toAddIds = Stream.of(toAdd).map(s -> s._id).collect(Collectors.toList());
                    Stream.of(def._steps).filter(s -> !toAddIds.contains(s._id)).forEach(s -> aml.eventLog().warn(EventLogEntry.Stage.Workflow, "Step '" + s._id + "' not defined in provider '" + def._name + "': skipping it."));
                }
            } else {
                toAdd = ((ModelingSteps)((Object)steps)).getSteps(StepDefinition.Alias.all);
            }
            if (toAdd == null) continue;
            for (ModelingStep ts : toAdd) {
                ts._fromDef = def;
            }
            orderedSteps.addAll(Arrays.asList(toAdd));
        }
        return orderedSteps.toArray(new ModelingStep[0]);
    }

    public StepDefinition[] createDefinitionPlanFromSteps(ModelingStep[] steps) {
        ArrayList<StepDefinition> definitions = new ArrayList<StepDefinition>();
        for (ModelingStep step : steps) {
            StepDefinition.Step stepDesc = new StepDefinition.Step(step._id, step._weight);
            if (definitions.size() > 0) {
                StepDefinition lastDef = (StepDefinition)((Object)definitions.get(definitions.size() - 1));
                if (lastDef._name.equals(step._fromDef._name)) {
                    lastDef._steps = (StepDefinition.Step[])ArrayUtils.append((Object[])lastDef._steps, (Object[])new StepDefinition.Step[]{stepDesc});
                    continue;
                }
            }
            definitions.add(new StepDefinition(step._fromDef._name, new StepDefinition.Step[]{stepDesc}));
        }
        return definitions.toArray(new StepDefinition[0]);
    }

    static {
        ServiceLoader<ModelingStepsProvider> trainingStepsProviders = ServiceLoader.load(ModelingStepsProvider.class);
        for (ModelingStepsProvider provider : trainingStepsProviders) {
            stepsByName.put((Object)provider.getName(), (Object)provider);
        }
    }
}

