/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.Algo;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import water.Iced;
import water.util.ArrayUtils;

public class WorkAllocations
extends Iced<WorkAllocations> {
    private boolean frozen;
    private Work[] allocations = new Work[0];

    WorkAllocations allocate(Work work) {
        if (this.frozen) {
            throw new IllegalStateException("Can not allocate new work.");
        }
        this.allocations = (Work[])ArrayUtils.append((Object[])this.allocations, (Object[])new Work[]{work});
        return this;
    }

    WorkAllocations freeze() {
        this.frozen = true;
        return this;
    }

    void remove(Algo algo) {
        if (this.frozen) {
            throw new IllegalStateException("Can not modify allocations.");
        }
        ArrayList<Work> filtered = new ArrayList<Work>(this.allocations.length);
        for (Work alloc : this.allocations) {
            if (algo.equals((Object)alloc._algo)) continue;
            filtered.add(alloc);
        }
        this.allocations = filtered.toArray(new Work[0]);
    }

    public Work getAllocation(String id, Algo algo) {
        for (Work alloc : this.allocations) {
            if (alloc._algo != algo || !alloc._id.equals(id)) continue;
            return alloc;
        }
        return null;
    }

    public Work[] getAllocations(Predicate<Work> predicate) {
        return (Work[])Stream.of(this.allocations).filter(predicate).toArray(Work[]::new);
    }

    private int sum(Work[] workItems) {
        int tot = 0;
        for (Work item : workItems) {
            tot += item._weight;
        }
        return tot;
    }

    int remainingWork() {
        return this.sum(this.allocations);
    }

    int remainingWork(Predicate<Work> predicate) {
        return this.sum(this.getAllocations(predicate));
    }

    float remainingWorkRatio(Work work) {
        return (float)work._weight / (float)this.remainingWork();
    }

    float remainingWorkRatio(Work work, Predicate<Work> predicate) {
        return (float)work._weight / (float)this.remainingWork(predicate);
    }

    public static class Work
    extends Iced<Work> {
        String _id;
        Algo _algo;
        JobType _type;
        int _weight;

        Work(String id, Algo algo, JobType type, int weight) {
            this._algo = algo;
            this._type = type;
            this._id = id;
            this._weight = weight;
        }

        public int consume() {
            int consumed = this._weight;
            this._weight = 0;
            return consumed;
        }
    }

    public static enum JobType {
        Unknown,
        ModelBuild,
        HyperparamSearch;

    }
}

