/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.events;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.events.EventLogEntry;
import java.io.Serializable;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.util.Log;
import water.util.TwoDimTable;

public class EventLog
extends Keyed<EventLog> {
    public final Key<AutoML> _automl_id;
    public EventLogEntry[] _events;

    public EventLog(Key<AutoML> automlKey) {
        this._automl_id = automlKey;
        this._key = Key.make((String)EventLog.idForRun(automlKey));
        this._events = new EventLogEntry[0];
    }

    public static EventLog getOrMake(Key<AutoML> runKey) {
        EventLog eventLog = (EventLog)DKV.getGet((Key)Key.make((String)EventLog.idForRun(runKey)));
        if (null == eventLog) {
            eventLog = new EventLog(runKey);
        }
        DKV.put((Keyed)eventLog);
        return eventLog;
    }

    private static String idForRun(Key<AutoML> runKey) {
        if (null == runKey) {
            return "AutoML_Events_dummy";
        }
        return "AutoML_Events_" + runKey.toString();
    }

    public <V extends Serializable> EventLogEntry<V> debug(EventLogEntry.Stage stage, String message) {
        Log.debug((Object[])new Object[]{(Object)((Object)stage) + ": " + message});
        return this.addEvent(EventLogEntry.Level.Debug, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> info(EventLogEntry.Stage stage, String message) {
        Log.info((Object[])new Object[]{(Object)((Object)stage) + ": " + message});
        return this.addEvent(EventLogEntry.Level.Info, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> warn(EventLogEntry.Stage stage, String message) {
        Log.warn((Object[])new Object[]{(Object)((Object)stage) + ": " + message});
        return this.addEvent(EventLogEntry.Level.Warn, stage, message);
    }

    public <V extends Serializable> EventLogEntry<V> addEvent(EventLogEntry.Level level, EventLogEntry.Stage stage, String message) {
        EventLogEntry entry = new EventLogEntry(this._automl_id, level, stage, message);
        this.addEvent(entry);
        return entry;
    }

    public void addEvent(EventLogEntry event) {
        EventLogEntry[] oldEvents = this._events;
        EventLogEntry[] newEvents = new EventLogEntry[this._events.length + 1];
        System.arraycopy(oldEvents, 0, newEvents, 0, oldEvents.length);
        newEvents[oldEvents.length] = event;
        this._events = newEvents;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        this._events = new EventLogEntry[0];
        return super.remove_impl(fs, cascade);
    }

    public TwoDimTable toTwoDimTable() {
        String name = this._automl_id == null ? "(new)" : this._automl_id.toString();
        return this.toTwoDimTable("Event Log for AutoML:" + name);
    }

    public TwoDimTable toTwoDimTable(String tableHeader) {
        EventLogEntry[] events = (EventLogEntry[])this._events.clone();
        TwoDimTable table = EventLogEntry.makeTwoDimTable(tableHeader, events.length);
        for (int i = 0; i < events.length; ++i) {
            events[i].addTwoDimTableRow(table, i);
        }
        return table;
    }

    public String toString(String tableHeader) {
        return this.toTwoDimTable(tableHeader).toString();
    }

    public String toString() {
        return this.toTwoDimTable().toString();
    }
}

