/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import hex.Model;
import hex.deeplearning.DeepLearningModel;
import hex.grid.Grid;
import java.util.HashMap;
import java.util.Map;
import water.Job;

public class DeepLearningStepsProvider
implements ModelingStepsProvider<DeepLearningSteps> {
    @Override
    public String getName() {
        return Algo.DeepLearning.name();
    }

    @Override
    public DeepLearningSteps newInstance(AutoML aml) {
        return new DeepLearningSteps(aml);
    }

    public static class DeepLearningSteps
    extends ModelingSteps {
        private ModelingStep[] defaults = new DeepLearningModelStep[]{new DeepLearningModelStep("def_1", 10, this.aml()){

            @Override
            protected Job<DeepLearningModel> startJob() {
                DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
                dlParameters._hidden = new int[]{10, 10, 10};
                return this.trainModel((Model.Parameters)dlParameters);
            }
        }};
        private ModelingStep[] grids = new DeepLearningGridStep[]{new DeepLearningGridStep("grid_1", 20, this.aml()){

            @Override
            protected Job<Grid> startJob() {
                DeepLearningModel.DeepLearningParameters dlParameters = this.prepareModelParameters();
                Map<String, Object[]> searchParams = this.prepareSearchParams();
                searchParams.put("_hidden", (Object[])new Integer[][]{{50}, {200}, {500}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0}, {0.1}, {0.2}, {0.3}, {0.4}, {0.5}});
                return this.hyperparameterSearch((Model.Parameters)dlParameters, searchParams);
            }
        }, new DeepLearningGridStep("grid_2", 20, this.aml()){

            @Override
            protected Job<Grid> startJob() {
                DeepLearningModel.DeepLearningParameters dlParameters = this.prepareModelParameters();
                Map<String, Object[]> searchParams = this.prepareSearchParams();
                searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50}, {200, 200}, {500, 500}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0}, {0.1, 0.1}, {0.2, 0.2}, {0.3, 0.3}, {0.4, 0.4}, {0.5, 0.5}});
                return this.hyperparameterSearch((Model.Parameters)dlParameters, searchParams);
            }
        }, new DeepLearningGridStep("grid_3", 20, this.aml()){

            @Override
            protected Job<Grid> startJob() {
                DeepLearningModel.DeepLearningParameters dlParameters = this.prepareModelParameters();
                Map<String, Object[]> searchParams = this.prepareSearchParams();
                searchParams.put("_hidden", (Object[])new Integer[][]{{50, 50, 50}, {200, 200, 200}, {500, 500, 500}});
                searchParams.put("_hidden_dropout_ratios", (Object[])new Double[][]{{0.0, 0.0, 0.0}, {0.1, 0.1, 0.1}, {0.2, 0.2, 0.2}, {0.3, 0.3, 0.3}, {0.4, 0.4, 0.4}, {0.5, 0.5, 0.5}});
                return this.hyperparameterSearch((Model.Parameters)dlParameters, searchParams);
            }
        }};

        public DeepLearningSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        @Override
        protected ModelingStep[] getGrids() {
            return this.grids;
        }

        static abstract class DeepLearningGridStep
        extends ModelingStep.GridStep<DeepLearningModel> {
            DeepLearningGridStep(String id, int weight, AutoML autoML) {
                super(Algo.DeepLearning, id, weight, autoML);
            }

            DeepLearningModel.DeepLearningParameters prepareModelParameters() {
                DeepLearningModel.DeepLearningParameters dlParameters = new DeepLearningModel.DeepLearningParameters();
                dlParameters._epochs = 10000.0;
                dlParameters._adaptive_rate = true;
                dlParameters._activation = DeepLearningModel.DeepLearningParameters.Activation.RectifierWithDropout;
                return dlParameters;
            }

            Map<String, Object[]> prepareSearchParams() {
                HashMap<String, Object[]> searchParams = new HashMap<String, Object[]>();
                searchParams.put("_rho", new Double[]{0.9, 0.95, 0.99});
                searchParams.put("_epsilon", new Double[]{1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9});
                searchParams.put("_input_dropout_ratio", new Double[]{0.0, 0.05, 0.1, 0.15, 0.2});
                return searchParams;
            }
        }

        static abstract class DeepLearningModelStep
        extends ModelingStep.ModelStep<DeepLearningModel> {
            public DeepLearningModelStep(String id, int weight, AutoML autoML) {
                super(Algo.DeepLearning, id, weight, autoML);
            }
        }
    }
}

