/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import hex.Model;
import hex.glm.GLMModel;
import water.Job;

public class GLMStepsProvider
implements ModelingStepsProvider<GLMSteps> {
    @Override
    public String getName() {
        return Algo.GLM.name();
    }

    @Override
    public GLMSteps newInstance(AutoML aml) {
        return new GLMSteps(aml);
    }

    public static class GLMSteps
    extends ModelingSteps {
        private ModelingStep[] defaults = new GLMModelStep[]{new GLMModelStep("def_1", 10, this.aml()){

            @Override
            protected Job<GLMModel> startJob() {
                GLMModel.GLMParameters glmParameters = this.prepareModelParameters();
                glmParameters._alpha = new double[]{0.0, 0.2, 0.4, 0.6, 0.8, 1.0};
                glmParameters._missing_values_handling = GLMModel.GLMParameters.MissingValuesHandling.MeanImputation;
                return this.trainModel((Model.Parameters)glmParameters);
            }
        }};
        private ModelingStep[] grids = new ModelingStep[0];

        public GLMSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        @Override
        protected ModelingStep[] getGrids() {
            return this.grids;
        }

        static abstract class GLMModelStep
        extends ModelingStep.ModelStep<GLMModel> {
            GLMModelStep(String id, int weight, AutoML autoML) {
                super(Algo.GLM, id, weight, autoML);
            }

            GLMModel.GLMParameters prepareModelParameters() {
                GLMModel.GLMParameters glmParameters = new GLMModel.GLMParameters();
                glmParameters._lambda_search = true;
                glmParameters._family = this.aml().getResponseColumn().isBinary() && !this.aml().getResponseColumn().isNumeric() ? GLMModel.GLMParameters.Family.binomial : (this.aml().getResponseColumn().isCategorical() ? GLMModel.GLMParameters.Family.multinomial : GLMModel.GLMParameters.Family.gaussian);
                return glmParameters;
            }
        }
    }
}

