/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.WorkAllocations;
import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.Leaderboard;
import hex.Model;
import hex.ModelContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import water.Iced;
import water.Job;
import water.Key;
import water.util.ArrayUtils;
import water.util.Countdown;
import water.util.Log;

class ModelingStepsExecutor
extends Iced<ModelingStepsExecutor> {
    private static final int pollingIntervalInMillis = 1000;
    final Key<EventLog> _eventLogKey;
    final Key<Leaderboard> _leaderboardKey;
    final Countdown _runCountdown;
    private transient List<Job> _jobs;
    private final AtomicInteger _modelCount = new AtomicInteger();

    static void ensureStopRequestPropagated(Job job, Job parentJob) {
        if (job == null || parentJob == null) {
            return;
        }
        while (job.isRunning()) {
            if (parentJob.stop_requested()) {
                job.stop();
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    ModelingStepsExecutor(Leaderboard leaderboard, EventLog eventLog, Countdown runCountdown) {
        this._leaderboardKey = leaderboard._key;
        this._eventLogKey = eventLog._key;
        this._runCountdown = runCountdown;
    }

    int modelCount() {
        return this._modelCount.get();
    }

    void start() {
        this._jobs = new ArrayList<Job>();
        this._modelCount.set(0);
        this._runCountdown.start();
    }

    void stop() {
        this._runCountdown.stop();
        if (null == this._jobs) {
            return;
        }
        for (Job j : this._jobs) {
            j.stop();
        }
        for (Job j : this._jobs) {
            j.get();
        }
        this._jobs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean submit(ModelingStep step, Job parentJob) {
        block5: {
            if (step.canRun()) {
                Job job = step.startJob();
                try {
                    if (job == null) {
                        this.skip(step._description, step.getAllocatedWork(), parentJob);
                        break block5;
                    }
                    this.monitor(job, step.getAllocatedWork(), parentJob, ArrayUtils.contains((Object[])step._ignoredConstraints, (Object)((Object)AutoML.Constraint.TIMEOUT)));
                    boolean bl = true;
                    return bl;
                }
                finally {
                    step.onDone(job);
                }
            }
        }
        return false;
    }

    private void skip(String name, WorkAllocations.Work work, Job parentJob) {
        if (null != parentJob) {
            parentJob.update((long)work.consume(), "SKIPPED: " + name);
            Log.info((Object[])new Object[]{"AutoML; skipping " + name});
        }
    }

    void monitor(Job job, WorkAllocations.Work work, Job parentJob, boolean ignoreTimeout) {
        EventLog eventLog = this.eventLog();
        String jobDescription = job._result == null ? job._description : job._result.toString() + " [" + job._description + "]";
        eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " started");
        this._jobs.add(job);
        long lastWorkedSoFar = 0L;
        long lastTotalModelsBuilt = 0L;
        while (job.isRunning()) {
            if (null != parentJob) {
                if (parentJob.stop_requested()) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML job cancelled; skipping " + jobDescription);
                    job.stop();
                }
                if (!ignoreTimeout && this._runCountdown.timedOut()) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML: out of time; skipping " + jobDescription);
                    job.stop();
                }
            }
            long workedSoFar = Math.round(job.progress() * (float)work._weight);
            if (null != parentJob) {
                parentJob.update((long)Math.round(workedSoFar - lastWorkedSoFar), jobDescription);
            }
            if (WorkAllocations.JobType.HyperparamSearch == work._type || WorkAllocations.JobType.Selection == work._type) {
                int totalModelsBuilt;
                ModelContainer container = (ModelContainer)job._result.get();
                int n = totalModelsBuilt = container == null ? 0 : container.getModelCount();
                if ((long)totalModelsBuilt > lastTotalModelsBuilt) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalModelsBuilt + " models for " + (Object)((Object)work._type) + " : " + jobDescription);
                    this.addModels(container);
                    lastTotalModelsBuilt = totalModelsBuilt;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            lastWorkedSoFar = workedSoFar;
        }
        if (WorkAllocations.JobType.HyperparamSearch == work._type || WorkAllocations.JobType.Selection == work._type) {
            if (job.isCrashed()) {
                eventLog.warn(EventLogEntry.Stage.ModelTraining, jobDescription + " failed: " + job.ex().toString());
            } else if (job.get() == null) {
                eventLog.info(EventLogEntry.Stage.ModelTraining, jobDescription + " cancelled");
            } else {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
                ModelContainer container = (ModelContainer)job.get();
                int totalModelsBuilt = container.getModelCount();
                if ((long)totalModelsBuilt > lastTotalModelsBuilt) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalModelsBuilt + " models for " + (Object)((Object)work._type) + " : " + jobDescription);
                    this.addModels(container);
                }
            }
        } else if (WorkAllocations.JobType.ModelBuild == work._type) {
            if (job.isCrashed()) {
                eventLog.warn(EventLogEntry.Stage.ModelTraining, jobDescription + " failed: " + job.ex().toString());
            } else if (job.get() == null) {
                eventLog.info(EventLogEntry.Stage.ModelTraining, jobDescription + " cancelled");
            } else {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
                this.addModel((Model)job.get());
            }
        }
        if (null != parentJob) {
            parentJob.update((long)work._weight - lastWorkedSoFar);
        }
        work.consume();
        this._jobs.remove(job);
    }

    private void addModels(ModelContainer container) {
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModels(container.getModelKeys());
        int after = leaderboard.getModelCount();
        this._modelCount.addAndGet(after - before);
    }

    private void addModel(Model model) {
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModel(model._key);
        int after = leaderboard.getModelCount();
        this._modelCount.addAndGet(after - before);
    }

    private EventLog eventLog() {
        return (EventLog)this._eventLogKey.get();
    }

    private Leaderboard leaderboard() {
        return (Leaderboard)this._leaderboardKey.get();
    }
}

