/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import java.util.Arrays;
import java.util.Objects;
import water.Iced;

public class StepDefinition
extends Iced<StepDefinition> {
    String _name;
    Alias _alias;
    Step[] _steps;

    public StepDefinition() {
    }

    public StepDefinition(String name) {
        this(name, Alias.all);
    }

    public StepDefinition(String name, Alias alias) {
        this._name = name;
        this._alias = alias;
    }

    public StepDefinition(String name, String[] ids) {
        this._name = name;
        this._steps = new Step[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            this._steps[i] = new Step(ids[i]);
        }
    }

    public StepDefinition(String name, Step[] steps) {
        this._name = name;
        this._steps = steps;
    }

    public String toString() {
        return "{" + this._name + " : " + (this._steps == null ? this._alias : Arrays.toString((Object[])this._steps)) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        StepDefinition that = (StepDefinition)((Object)o);
        return this._name.equals(that._name) && this._alias == that._alias && Arrays.equals((Object[])this._steps, (Object[])that._steps);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this._name, this._alias});
        result = 31 * result + Arrays.hashCode((Object[])this._steps);
        return result;
    }

    public static class Step
    extends Iced<Step> {
        public static final int DEFAULT_WEIGHT = -1;
        String _id;
        int _weight = -1;

        public Step() {
        }

        public Step(String _id) {
            this._id = _id;
        }

        public Step(String id, int weight) {
            assert (weight > -1) : "weight should be >= 0";
            this._id = id;
            this._weight = weight;
        }

        public String toString() {
            return this._id + (this._weight > -1 ? " (" + this._weight + ")" : "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Step step = (Step)((Object)o);
            return this._id.equals(step._id) && this._weight == step._weight;
        }

        public int hashCode() {
            return Objects.hash(this._id, this._weight);
        }
    }

    public static enum Alias {
        all,
        defaults,
        grids,
        exploitation;

    }
}

