/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.collectors;

import hex.tree.DHistogram;
import hex.tree.SharedTreeModel;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import water.H2O;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.util.ArrayUtils;
import water.util.AtomicUtils;
import water.util.Log;

public class MetaCollector {

    public static final class DynamicHisto
    extends MRTask<DynamicHisto> {
        public DHistogram _h;
        public double[] _sums;
        public double[] _ssqs;

        public DynamicHisto(DHistogram h) {
            this._h = h;
        }

        DynamicHisto(String name, int nbins, int nbins_cats, byte isInt, double min, double max, boolean hasNAs) {
            if (!Double.isNaN(min) && !Double.isNaN(max)) {
                this._h = DynamicHisto.makeDHistogram(name, nbins, nbins_cats, isInt, min, max, hasNAs);
            } else {
                Log.info((Object[])new Object[]{"Ignoring all NaN column -> " + name});
            }
        }

        public static DHistogram makeDHistogram(String name, int nbins, int nbins_cats, byte isInt, double min, double max, boolean hasNAs) {
            double minIn = Math.max(min, -1.7976931348623157E308);
            double maxIn = Math.min(max, Double.MAX_VALUE);
            double maxEx = DHistogram.find_maxEx((double)maxIn, (int)(isInt == 1 ? 1 : 0));
            SharedTreeParameters parms = new SharedTreeParameters();
            parms._nbins = nbins;
            parms._nbins_cats = nbins_cats;
            return DHistogram.make((String)name, (int)nbins, (byte)isInt, (double)minIn, (double)maxEx, (boolean)hasNAs, (long)0L, (SharedTreeModel.SharedTreeParameters)parms, null, null);
        }

        public double binAt(int b) {
            return this._h.binAt(b);
        }

        public double mean(int b) {
            double n = this._h.w(b);
            return n > 0.0 ? this._sums[b] / n : this._h.binAt(b);
        }

        public double var(int b) {
            double n = this._h.w(b);
            if (n <= 1.0) {
                return 0.0;
            }
            return Math.max(0.0, (this._ssqs[b] - this._sums[b] * this._sums[b] / n) / (n - 1.0));
        }

        protected void init() {
            this._h.init();
            this._sums = MemoryManager.malloc8d((int)this._h._nbin);
            this._ssqs = MemoryManager.malloc8d((int)this._h._nbin);
        }

        public void setupLocal() {
            this.init();
        }

        public void map(Chunk c) {
            this.accum(c);
        }

        public void reduce(DynamicHisto ht) {
            this.merge(ht._h);
            if (this._sums != ht._sums) {
                ArrayUtils.add((double[])this._sums, (double[])ht._sums);
            }
            if (this._ssqs != ht._ssqs) {
                ArrayUtils.add((double[])this._ssqs, (double[])ht._ssqs);
            }
        }

        void accum(Chunk C) {
            double min = this._h.find_min();
            double max = this._h.find_maxIn();
            double[] bins = new double[this._h._nbin];
            double[] sums = new double[this._h._nbin];
            double[] ssqs = new double[this._h._nbin];
            for (int r = 0; r < C._len; ++r) {
                int b;
                double colData = C.atd(r);
                if (colData < min) {
                    min = colData;
                }
                if (colData > max) {
                    max = colData;
                }
                int n = b = this._h.bin(colData);
                bins[n] = bins[n] + 1.0;
                int n2 = b;
                sums[n2] = sums[n2] + colData;
                int n3 = b;
                ssqs[n3] = ssqs[n3] + colData * colData;
            }
            this._h.setMin(min);
            this._h.setMaxIn(max);
            for (int b = 0; b < bins.length; ++b) {
                if (bins[b] == 0.0) continue;
                this._h.addWAtomic(b, bins[b]);
                AtomicUtils.DoubleArray.add((double[])this._sums, (int)b, (double)sums[b]);
                AtomicUtils.DoubleArray.add((double[])this._ssqs, (int)b, (double)ssqs[b]);
            }
        }

        public void merge(DHistogram h) {
            if (this._h == h) {
                return;
            }
            if (this._h == null) {
                this._h = h;
            } else if (h != null) {
                this._h.add(h);
            }
        }

        private static class SharedTreeParameters
        extends SharedTreeModel.SharedTreeParameters {
            private SharedTreeParameters() {
            }

            public String algoName() {
                return "DUM";
            }

            public String fullName() {
                return "dummy";
            }

            public String javaName() {
                return "this.is.unused";
            }
        }
    }

    public static class ParallelTasks<T extends H2O.H2OCountedCompleter<T>>
    extends H2O.H2OCountedCompleter {
        private final AtomicInteger _ctr = new AtomicInteger(MAXP - 1);
        private static int MAXP = 100;
        private final T[] _tasks;

        public ParallelTasks(T[] tasks) {
            this._tasks = tasks;
        }

        public void compute2() {
            int nTasks = this._tasks.length;
            this.addToPendingCount(nTasks - 1);
            for (int i = 0; i < Math.min(MAXP, nTasks); ++i) {
                this.asyncVecTask(i);
            }
        }

        private void asyncVecTask(int task) {
            this._tasks[task].setCompleter((CountedCompleter)new Callback());
            this._tasks[task].fork();
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super((H2O.H2OCountedCompleter)ParallelTasks.this);
            }

            public void callback(H2O.H2OCountedCompleter cc) {
                int i = ParallelTasks.this._ctr.incrementAndGet();
                if (i < ParallelTasks.this._tasks.length) {
                    ParallelTasks.this.asyncVecTask(i);
                }
            }
        }
    }

    static enum COLLECT {
        skew{

            @Override
            void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + 1.0;
            }

            @Override
            void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        kurtosis{

            @Override
            void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1;
            }

            @Override
            void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            double postPass(double[] ds, long n) {
                return ds[0] / (double)n;
            }
        }
        ,
        uniqPerChk{

            @Override
            void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1;
            }

            @Override
            void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        timePerChunk{

            @Override
            void op(double[] d0s, double d1) {
                d0s[0] = d0s[0] + d1 * d1;
            }

            @Override
            void atomic_op(double[] d0s, double[] d1s) {
                d0s[0] = d0s[0] + d1s[0];
            }

            @Override
            double postPass(double[] ds, long n) {
                return ds[0];
            }
        }
        ,
        mode{

            @Override
            void op(double[] d0s, double d1) {
                int n = (int)d1;
                d0s[n] = d0s[n] + 1.0;
            }

            @Override
            void atomic_op(double[] d0s, double[] d1s) {
                ArrayUtils.add((double[])d0s, (double[])d1s);
            }

            @Override
            double postPass(double[] ds, long n) {
                return ArrayUtils.maxIndex((double[])ds);
            }

            @Override
            double[] initVal(int maxx) {
                return new double[maxx];
            }
        };


        abstract void op(double[] var1, double var2);

        abstract void atomic_op(double[] var1, double[] var2);

        abstract double postPass(double[] var1, long var2);

        double[] initVal(int maxx) {
            return new double[]{0.0};
        }
    }
}

