/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoMLBuildSpec;
import ai.h2o.automl.H2OJob;
import ai.h2o.automl.IAlgo;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingStepsExecutor;
import ai.h2o.automl.ModelingStepsRegistry;
import ai.h2o.automl.StepDefinition;
import ai.h2o.automl.TimedH2ORunnable;
import ai.h2o.automl.WorkAllocations;
import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.AlgoName;
import ai.h2o.automl.leaderboard.Leaderboard;
import ai.h2o.automl.leaderboard.LeaderboardCell;
import ai.h2o.automl.leaderboard.LeaderboardExtensionsProvider;
import ai.h2o.automl.leaderboard.ScoringTimePerRow;
import ai.h2o.automl.leaderboard.TrainingTime;
import ai.h2o.automl.preprocessing.PreprocessingStep;
import hex.Model;
import hex.ScoreKeeper;
import hex.splitframe.ShuffleSplitFrame;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.automl.api.schemas3.AutoMLV99;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.util.ArrayUtils;
import water.util.Countdown;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.StringUtils;

public final class AutoML
extends Lockable<AutoML>
implements TimedH2ORunnable {
    public static final Comparator<AutoML> byStartTime = Comparator.comparing(a -> a._startTime);
    public static final String keySeparator = "@@";
    private static final boolean verifyImmutability = true;
    private static final ThreadLocal<SimpleDateFormat> timestampFormatForKeys = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd_HHmmss"));
    private static StepDefinition[] defaultModelingPlan = new StepDefinition[]{new StepDefinition(Algo.XGBoost.name(), StepDefinition.Alias.defaults), new StepDefinition(Algo.GLM.name(), StepDefinition.Alias.defaults), new StepDefinition(Algo.DRF.name(), new String[]{"def_1"}), new StepDefinition(Algo.GBM.name(), StepDefinition.Alias.defaults), new StepDefinition(Algo.DeepLearning.name(), StepDefinition.Alias.defaults), new StepDefinition(Algo.DRF.name(), new String[]{"XRT"}), new StepDefinition(Algo.XGBoost.name(), StepDefinition.Alias.grids), new StepDefinition(Algo.GBM.name(), StepDefinition.Alias.grids), new StepDefinition(Algo.DeepLearning.name(), StepDefinition.Alias.grids), new StepDefinition(Algo.GBM.name(), new String[]{"lr_annealing"}), new StepDefinition(Algo.XGBoost.name(), new String[]{"lr_search"}), new StepDefinition(Algo.StackedEnsemble.name(), StepDefinition.Alias.defaults)};
    private static Date lastStartTime;
    private AutoMLBuildSpec _buildSpec;
    private Frame _origTrainingFrame;
    Frame _trainingFrame;
    Frame _validationFrame;
    Frame _blendingFrame;
    Frame _leaderboardFrame;
    Vec _responseColumn;
    Vec _foldColumn;
    Vec _weightsColumn;
    Date _startTime;
    Countdown _runCountdown;
    Job<AutoML> _job;
    WorkAllocations _workAllocations;
    StepDefinition[] _actualModelingSteps;
    AtomicLong _incrementalSeed = new AtomicLong();
    private NonBlockingHashMap<String, AtomicInteger> _instanceCounters = new NonBlockingHashMap();
    private ModelingStepsRegistry _modelingStepsRegistry;
    private ModelingStepsExecutor _modelingStepsExecutor;
    private Leaderboard _leaderboard;
    private EventLog _eventLog;
    private Vec[] _originalTrainingFrameVecs;
    private String[] _originalTrainingFrameNames;
    private long[] _originalTrainingFrameChecksums;
    private transient NonBlockingHashMap<Key, String> _trackedKeys = new NonBlockingHashMap();
    private transient ModelingStep[] _executionPlan;
    private transient PreprocessingStep[] _preprocessing;

    private static LeaderboardExtensionsProvider createLeaderboardExtensionProvider(AutoML automl) {
        final Key amlKey = automl._key;
        return new LeaderboardExtensionsProvider(){

            @Override
            public LeaderboardCell[] createExtensions(Model model) {
                AutoML aml = (AutoML)amlKey.get();
                return new LeaderboardCell[]{new TrainingTime(model), new ScoringTimePerRow(model, aml.getLeaderboardFrame(), aml.getTrainingFrame()), new AlgoName(model)};
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoML startAutoML(AutoMLBuildSpec buildSpec) {
        Date startTime = new Date();
        Class<AutoML> clazz = AutoML.class;
        synchronized (AutoML.class) {
            if (lastStartTime != null) {
                while ((double)Math.abs(lastStartTime.getTime() - startTime.getTime()) < 1000.0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    startTime = new Date();
                }
            }
            lastStartTime = startTime;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            AutoML aml = new AutoML(startTime, buildSpec);
            AutoML.startAutoML(aml);
            return aml;
        }
    }

    public static void startAutoML(AutoML aml) {
        if (aml._job == null || !aml._job.isRunning()) {
            H2OJob<AutoML> j = new H2OJob<AutoML>(aml, aml._key, aml._runCountdown.remainingTime());
            aml._job = j._job;
            aml.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML job created: " + EventLogEntry.dateTimeFormat.get().format(aml._startTime)).setNamedValue("creation_epoch", aml._startTime, EventLogEntry.epochFormat.get());
            j.start(aml._workAllocations.remainingWork());
            DKV.put((Keyed)aml);
        }
    }

    @Deprecated
    public static AutoML makeAutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        return new AutoML(key, startTime, buildSpec);
    }

    public Class<AutoMLV99.AutoMLKeyV3> makeSchema() {
        return AutoMLV99.AutoMLKeyV3.class;
    }

    public AutoMLBuildSpec getBuildSpec() {
        return this._buildSpec;
    }

    public Frame getTrainingFrame() {
        return this._trainingFrame;
    }

    public Frame getValidationFrame() {
        return this._validationFrame;
    }

    public Frame getBlendingFrame() {
        return this._blendingFrame;
    }

    public Frame getLeaderboardFrame() {
        return this._leaderboardFrame;
    }

    public Vec getResponseColumn() {
        return this._responseColumn;
    }

    public Vec getFoldColumn() {
        return this._foldColumn;
    }

    public Vec getWeightsColumn() {
        return this._weightsColumn;
    }

    public StepDefinition[] getActualModelingSteps() {
        return this._actualModelingSteps;
    }

    public AutoML() {
        super(null);
    }

    public AutoML(Date startTime, AutoMLBuildSpec buildSpec) {
        this(null, startTime, buildSpec);
    }

    public AutoML(Key<AutoML> key, Date startTime, AutoMLBuildSpec buildSpec) {
        super(key == null ? buildSpec.makeKey() : key);
        try {
            this._startTime = startTime;
            this._eventLog = EventLog.getOrMake(this._key);
            this.eventLog().info(EventLogEntry.Stage.Workflow, "Project: " + buildSpec.project());
            this.validateBuildSpec(buildSpec);
            this._buildSpec = buildSpec;
            this._runCountdown = Countdown.fromSeconds((double)this._buildSpec.build_control.stopping_criteria.max_runtime_secs());
            this._incrementalSeed.set(this._buildSpec.build_control.stopping_criteria.seed());
            this.prepareData();
            this.initLeaderboard();
            this.initPreprocessing();
            this.planWork();
            this._modelingStepsExecutor = new ModelingStepsExecutor(this._leaderboard, this._eventLog, this._runCountdown);
        }
        catch (Exception e) {
            this.delete();
            throw e;
        }
    }

    private void validateBuildSpec(AutoMLBuildSpec buildSpec) {
        this.validateInput(buildSpec.input_spec);
        this.validateModelValidation(buildSpec);
        this.validateModelBuilding(buildSpec.build_models);
        this.validateEarlyStopping(buildSpec.build_control.stopping_criteria, buildSpec.input_spec);
        this.validateReproducibility(buildSpec);
    }

    private void validateInput(final AutoMLBuildSpec.AutoMLInput input) {
        if (DKV.getGet(input.training_frame) == null) {
            throw new H2OIllegalArgumentException("No training data has been specified, either as a path or a key, or it is not available anymore.");
        }
        final Frame trainingFrame = (Frame)DKV.getGet(input.training_frame);
        final Frame validationFrame = (Frame)DKV.getGet(input.validation_frame);
        final Frame blendingFrame = (Frame)DKV.getGet(input.blending_frame);
        final Frame leaderboardFrame = (Frame)DKV.getGet(input.leaderboard_frame);
        LinkedHashMap<String, Frame> compatibleFrames = new LinkedHashMap<String, Frame>(){
            {
                this.put("training", trainingFrame);
                this.put("validation", validationFrame);
                this.put("blending", blendingFrame);
                this.put("leaderboard", leaderboardFrame);
            }
        };
        for (Map.Entry entry : compatibleFrames.entrySet()) {
            Frame frame = (Frame)entry.getValue();
            if (frame == null || frame.find(input.response_column) >= 0) continue;
            throw new H2OIllegalArgumentException("Response column '" + input.response_column + "' is not in the " + (String)entry.getKey() + " frame.");
        }
        if (input.fold_column != null && trainingFrame.find(input.fold_column) < 0) {
            throw new H2OIllegalArgumentException("Fold column '" + input.fold_column + "' is not in the training frame.");
        }
        if (input.weights_column != null && trainingFrame.find(input.weights_column) < 0) {
            throw new H2OIllegalArgumentException("Weights column '" + input.weights_column + "' is not in the training frame.");
        }
        if (input.ignored_columns != null) {
            ArrayList<String> ignoredColumns = new ArrayList<String>(Arrays.asList(input.ignored_columns));
            LinkedHashMap<String, String> doNotIgnore = new LinkedHashMap<String, String>(){
                {
                    this.put("response_column", input.response_column);
                    this.put("fold_column", input.fold_column);
                    this.put("weights_column", input.weights_column);
                }
            };
            for (Map.Entry entry : doNotIgnore.entrySet()) {
                if (entry.getValue() == null || !ignoredColumns.contains(entry.getValue())) continue;
                this.eventLog().info(EventLogEntry.Stage.Validation, "Removing " + (String)entry.getKey() + " '" + (String)entry.getValue() + "' from list of ignored columns.");
                ignoredColumns.remove(entry.getValue());
            }
            input.ignored_columns = ignoredColumns.toArray(new String[0]);
        }
    }

    private void validateModelValidation(AutoMLBuildSpec buildSpec) {
        if (buildSpec.input_spec.fold_column != null) {
            this.eventLog().warn(EventLogEntry.Stage.Validation, "Fold column " + buildSpec.input_spec.fold_column + " will be used for cross-validation. nfolds parameter will be ignored.");
            buildSpec.build_control.nfolds = 0;
        } else if (buildSpec.build_control.nfolds <= 1) {
            this.eventLog().info(EventLogEntry.Stage.Validation, "Cross-validation disabled by user: no fold column nor nfolds > 1.");
            buildSpec.build_control.nfolds = 0;
        }
        if ((buildSpec.build_control.nfolds > 0 || buildSpec.input_spec.fold_column != null) && DKV.getGet(buildSpec.input_spec.validation_frame) != null) {
            this.eventLog().warn(EventLogEntry.Stage.Validation, "User specified a validation frame with cross-validation still enabled. Please note that the models will still be validated using cross-validation only, the validation frame will be used to provide purely informative validation metrics on the trained models.");
        }
    }

    private void validateModelBuilding(AutoMLBuildSpec.AutoMLBuildModels modelBuilding) {
        if (modelBuilding.exclude_algos != null && modelBuilding.include_algos != null) {
            throw new H2OIllegalArgumentException("Parameters `exclude_algos` and `include_algos` are mutually exclusive: please use only one of them if necessary.");
        }
        if (modelBuilding.exploitation_ratio < 0.0 || modelBuilding.exploitation_ratio > 1.0) {
            throw new H2OIllegalArgumentException("`exploitation_ratio` must be between 0 and 1.");
        }
        if (modelBuilding.modeling_plan == null) {
            modelBuilding.modeling_plan = defaultModelingPlan;
        }
    }

    private void validateEarlyStopping(AutoMLBuildSpec.AutoMLStoppingCriteria stoppingCriteria, AutoMLBuildSpec.AutoMLInput input) {
        if (stoppingCriteria.max_models() <= 0 && stoppingCriteria.max_runtime_secs() <= 0.0) {
            stoppingCriteria.set_max_runtime_secs(3600.0);
            this.eventLog().info(EventLogEntry.Stage.Validation, "User didn't set any runtime constraints (max runtime or max models), using default 1h time limit");
        }
        Frame refFrame = (Frame)DKV.getGet(input.training_frame);
        if (stoppingCriteria.stopping_tolerance() == -1.0) {
            stoppingCriteria.set_default_stopping_tolerance_for_frame(refFrame);
            this.eventLog().info(EventLogEntry.Stage.Validation, "Setting stopping tolerance adaptively based on the training frame: " + stoppingCriteria.stopping_tolerance());
        } else {
            this.eventLog().info(EventLogEntry.Stage.Validation, "Stopping tolerance set by the user: " + stoppingCriteria.stopping_tolerance());
            double defaultTolerance = AutoMLBuildSpec.AutoMLStoppingCriteria.default_stopping_tolerance_for_frame(refFrame);
            if (stoppingCriteria.stopping_tolerance() < 0.7 * defaultTolerance) {
                this.eventLog().warn(EventLogEntry.Stage.Validation, "Stopping tolerance set by the user is < 70% of the recommended default of " + defaultTolerance + ", so models may take a long time to converge or may not converge at all.");
            }
        }
    }

    private void validateReproducibility(AutoMLBuildSpec buildSpec) {
        this.eventLog().info(EventLogEntry.Stage.Validation, "Build control seed: " + buildSpec.build_control.stopping_criteria.seed() + (buildSpec.build_control.stopping_criteria.seed() == -1L ? " (random)" : ""));
    }

    private void initLeaderboard() {
        String sortMetric = this._buildSpec.input_spec.sort_metric;
        String string = sortMetric = sortMetric == null || ScoreKeeper.StoppingMetric.AUTO.name().equalsIgnoreCase(sortMetric) ? null : sortMetric.toLowerCase();
        if ("deviance".equalsIgnoreCase(sortMetric)) {
            sortMetric = "mean_residual_deviance";
        }
        this._leaderboard = Leaderboard.getOrMake(this._key.toString(), this._eventLog, this._leaderboardFrame, sortMetric);
        this._leaderboard.setExtensionsProvider(AutoML.createLeaderboardExtensionProvider(this));
    }

    private void initPreprocessing() {
        this._preprocessing = this._buildSpec.build_models.preprocessing == null ? null : (PreprocessingStep[])Arrays.stream(this._buildSpec.build_models.preprocessing).map(def -> def.newPreprocessingStep(this)).toArray(PreprocessingStep[]::new);
    }

    PreprocessingStep[] getPreprocessing() {
        return this._preprocessing;
    }

    ModelingStep[] getExecutionPlan() {
        ModelingStep[] modelingStepArray;
        if (this._executionPlan == null) {
            this._executionPlan = this._modelingStepsRegistry.getOrderedSteps(this._buildSpec.build_models.modeling_plan, this);
            modelingStepArray = this._executionPlan;
        } else {
            modelingStepArray = this._executionPlan;
        }
        return modelingStepArray;
    }

    /*
     * WARNING - void declaration
     */
    void planWork() {
        void var4_6;
        HashSet<Algo> skippedAlgos = new HashSet<Algo>();
        if (this._buildSpec.build_models.exclude_algos != null) {
            skippedAlgos.addAll(Arrays.asList(this._buildSpec.build_models.exclude_algos));
        } else if (this._buildSpec.build_models.include_algos != null) {
            skippedAlgos.addAll(Arrays.asList(Algo.values()));
            skippedAlgos.removeAll(Arrays.asList(this._buildSpec.build_models.include_algos));
        }
        Algo[] algoArray = Algo.values();
        int n = algoArray.length;
        boolean bl = false;
        while (var4_6 < n) {
            Algo algo = algoArray[var4_6];
            if (!skippedAlgos.contains(algo) && !algo.enabled()) {
                boolean isMultinode = H2O.CLOUD.size() > 1;
                this._eventLog.warn(EventLogEntry.Stage.Workflow, isMultinode ? "AutoML: " + algo.name() + " is not available in multi-node cluster; skipping it. See http://docs.h2o.ai/h2o/latest-stable/h2o-docs/automl.html#experimental-features for details." : "AutoML: " + algo.name() + " is not available; skipping it.");
                skippedAlgos.add(algo);
            }
            ++var4_6;
        }
        this._modelingStepsRegistry = new ModelingStepsRegistry();
        WorkAllocations workAllocations = new WorkAllocations();
        for (ModelingStep step : this.getExecutionPlan()) {
            workAllocations.allocate(step.makeWork());
        }
        for (IAlgo iAlgo : skippedAlgos) {
            this.eventLog().info(EventLogEntry.Stage.Workflow, "Disabling Algo: " + iAlgo + " as requested by the user.");
            workAllocations.remove(iAlgo);
        }
        this.eventLog().debug(EventLogEntry.Stage.Workflow, "Defined work allocations: " + (Object)((Object)workAllocations));
        this.distributeExplorationVsExploitationWork(workAllocations);
        this.eventLog().debug(EventLogEntry.Stage.Workflow, "Actual work allocations: " + (Object)((Object)workAllocations));
        workAllocations.freeze();
        this._workAllocations = workAllocations;
    }

    private void distributeExplorationVsExploitationWork(WorkAllocations allocations) {
        int sumExploration = allocations.remainingWork(ModelingStep.isExplorationWork);
        int sumExploitation = allocations.remainingWork(ModelingStep.isExploitationWork);
        double explorationRatio = 1.0 - this._buildSpec.build_models.exploitation_ratio;
        int newTotal = (int)Math.round((double)sumExploration / explorationRatio);
        int newSumExploration = sumExploration;
        int newSumExploitation = newTotal - newSumExploration;
        for (WorkAllocations.Work work : allocations.getAllocations(ModelingStep.isExplorationWork)) {
            work._weight = (int)Math.round((double)work._weight * (double)newSumExploration / (double)sumExploration);
        }
        for (WorkAllocations.Work work : allocations.getAllocations(ModelingStep.isExploitationWork)) {
            work._weight = (int)Math.round((double)work._weight * (double)newSumExploitation / (double)sumExploitation);
        }
    }

    @Override
    public void run() {
        this._modelingStepsExecutor.start();
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build started: " + EventLogEntry.dateTimeFormat.get().format(this._runCountdown.start_time())).setNamedValue("start_epoch", this._runCountdown.start_time(), EventLogEntry.epochFormat.get());
        this.learn();
        this.stop();
    }

    @Override
    public void stop() {
        if (null == this._modelingStepsExecutor) {
            return;
        }
        this._modelingStepsExecutor.stop();
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build stopped: " + EventLogEntry.dateTimeFormat.get().format(this._runCountdown.stop_time())).setNamedValue("stop_epoch", this._runCountdown.stop_time(), EventLogEntry.epochFormat.get());
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML build done: built " + this._modelingStepsExecutor.modelCount() + " models");
        this.eventLog().info(EventLogEntry.Stage.Workflow, "AutoML duration: " + PrettyPrint.msecs((long)this._runCountdown.duration(), (boolean)true)).setNamedValue("duration_secs", Math.round((double)this._runCountdown.duration() / 1000.0));
        Log.info((Object[])new Object[]{this.eventLog().toString("Event Log for AutoML Run " + this._key + ":")});
        for (EventLogEntry event : this.eventLog()._events) {
            Log.info((Object[])new Object[]{event});
        }
        if (0 < this.leaderboard().getModelKeys().length) {
            Log.info((Object[])new Object[]{this.leaderboard().toLogString()});
        } else {
            long max_runtime_secs = (long)this._buildSpec.build_control.stopping_criteria.max_runtime_secs();
            this.eventLog().warn(EventLogEntry.Stage.Workflow, "Empty leaderboard.\nAutoML was not able to build any model within a max runtime constraint of " + max_runtime_secs + " seconds, you may want to increase this value before retrying.");
        }
        this.possiblyVerifyImmutability();
        if (!this._buildSpec.build_control.keep_cross_validation_predictions) {
            this.cleanUpModelsCVPreds();
        }
    }

    public void get() {
        if (this._job != null) {
            this._job.get();
        }
    }

    public Job<AutoML> job() {
        if (null == this._job) {
            return null;
        }
        return (Job)DKV.getGet((Key)this._job._key);
    }

    public Model leader() {
        return this.leaderboard() == null ? null : this._leaderboard.getLeader();
    }

    public Leaderboard leaderboard() {
        return this._leaderboard == null ? null : (this._leaderboard = (Leaderboard)this._leaderboard._key.get());
    }

    public EventLog eventLog() {
        return this._eventLog == null ? null : (this._eventLog = (EventLog)this._eventLog._key.get());
    }

    public String projectName() {
        return this._buildSpec == null ? null : this._buildSpec.project();
    }

    @Override
    public long timeRemainingMs() {
        return this._runCountdown.remainingTime();
    }

    public int remainingModels() {
        if (this._buildSpec.build_control.stopping_criteria.max_models() == 0) {
            return Integer.MAX_VALUE;
        }
        return this._buildSpec.build_control.stopping_criteria.max_models() - this._modelingStepsExecutor.modelCount();
    }

    @Override
    public boolean keepRunning() {
        return !this._runCountdown.timedOut() && this.remainingModels() > 0;
    }

    public boolean isCVEnabled() {
        return this._buildSpec.build_control.nfolds > 0 || this._buildSpec.input_spec.fold_column != null;
    }

    private void optionallySplitTrainingDataset() {
        if (!this.isCVEnabled()) {
            double[] splitRatios = null;
            if (null == this._validationFrame && null == this._leaderboardFrame) {
                splitRatios = new double[]{0.8, 0.1, 0.1};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and none of validation frame and leaderboard frame were provided, automatically split the training data into training, validation and leaderboard frames in the ratio 80/10/10");
            } else if (null == this._validationFrame) {
                splitRatios = new double[]{0.9, 0.1, 0.0};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and no validation frame was provided, automatically split the training data into training and validation frames in the ratio 90/10");
            } else if (null == this._leaderboardFrame) {
                splitRatios = new double[]{0.9, 0.0, 0.1};
                this.eventLog().info(EventLogEntry.Stage.DataImport, "Since cross-validation is disabled, and no leaderboard frame was provided, automatically split the training data into training and leaderboard frames in the ratio 90/10");
            }
            if (splitRatios != null) {
                Key[] keys = new Key[]{Key.make((String)("automl_training_" + this._origTrainingFrame._key)), Key.make((String)("automl_validation_" + this._origTrainingFrame._key)), Key.make((String)("automl_leaderboard_" + this._origTrainingFrame._key))};
                Frame[] splits = ShuffleSplitFrame.shuffleSplitFrame((Frame)this._origTrainingFrame, (Key[])keys, (double[])splitRatios, (long)this._buildSpec.build_control.stopping_criteria.seed());
                this._trainingFrame = splits[0];
                if (this._validationFrame == null && splits[1].numRows() > 0L) {
                    this._validationFrame = splits[1];
                } else {
                    splits[1].delete();
                }
                if (this._leaderboardFrame == null && splits[2].numRows() > 0L) {
                    this._leaderboardFrame = splits[2];
                } else {
                    splits[2].delete();
                }
            }
        }
    }

    private void prepareData() {
        AutoMLBuildSpec.AutoMLInput input = this._buildSpec.input_spec;
        this._origTrainingFrame = (Frame)DKV.getGet(input.training_frame);
        this._validationFrame = (Frame)DKV.getGet(input.validation_frame);
        this._blendingFrame = (Frame)DKV.getGet(input.blending_frame);
        this._leaderboardFrame = (Frame)DKV.getGet(input.leaderboard_frame);
        this.optionallySplitTrainingDataset();
        if (null == this._trainingFrame) {
            this._trainingFrame = new Frame(this._origTrainingFrame);
            this._trainingFrame._key = Key.make((String)("automl_training_" + this._origTrainingFrame._key));
            DKV.put((Keyed)this._trainingFrame);
        }
        this._responseColumn = this._trainingFrame.vec(input.response_column);
        this._foldColumn = this._trainingFrame.vec(input.fold_column);
        this._weightsColumn = this._trainingFrame.vec(input.weights_column);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "training frame: " + this._trainingFrame.toString().replace("\n", " ") + " checksum: " + this._trainingFrame.checksum());
        if (null != this._validationFrame) {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "validation frame: " + this._validationFrame.toString().replace("\n", " ") + " checksum: " + this._validationFrame.checksum());
        } else {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "validation frame: NULL");
        }
        if (null != this._leaderboardFrame) {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "leaderboard frame: " + this._leaderboardFrame.toString().replace("\n", " ") + " checksum: " + this._leaderboardFrame.checksum());
        } else {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "leaderboard frame: NULL");
        }
        if (null != this._blendingFrame) {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "blending frame: " + this._blendingFrame.toString().replace("\n", " ") + " checksum: " + this._blendingFrame.checksum());
        } else {
            this.eventLog().info(EventLogEntry.Stage.DataImport, "blending frame: NULL");
        }
        this.eventLog().info(EventLogEntry.Stage.DataImport, "response column: " + input.response_column);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "fold column: " + this._foldColumn);
        this.eventLog().info(EventLogEntry.Stage.DataImport, "weights column: " + this._weightsColumn);
        this._originalTrainingFrameVecs = (Vec[])this._origTrainingFrame.vecs().clone();
        this._originalTrainingFrameNames = (String[])this._origTrainingFrame.names().clone();
        this._originalTrainingFrameChecksums = new long[this._originalTrainingFrameVecs.length];
        for (int i = 0; i < this._originalTrainingFrameVecs.length; ++i) {
            this._originalTrainingFrameChecksums[i] = this._originalTrainingFrameVecs[i].checksum();
        }
    }

    private void learn() {
        ArrayList<ModelingStep> executed = new ArrayList<ModelingStep>();
        if (this._preprocessing != null) {
            for (PreprocessingStep preprocessingStep : this._preprocessing) {
                preprocessingStep.prepare();
            }
        }
        for (ModelingStep modelingStep : this.getExecutionPlan()) {
            if (this.exceededSearchLimits(modelingStep) || !this._modelingStepsExecutor.submit(modelingStep, this.job())) continue;
            executed.add(modelingStep);
        }
        if (this._preprocessing != null) {
            for (PreprocessingStep preprocessingStep : this._preprocessing) {
                preprocessingStep.dispose();
            }
        }
        this._actualModelingSteps = this._modelingStepsRegistry.createDefinitionPlanFromSteps(executed.toArray(new ModelingStep[0]));
        this.eventLog().info(EventLogEntry.Stage.Workflow, "Actual modeling steps: " + Arrays.toString((Object[])this._actualModelingSteps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextInstanceCounter(String algoName, String type) {
        String key = algoName + "_" + type;
        if (!this._instanceCounters.containsKey((Object)key)) {
            NonBlockingHashMap<String, AtomicInteger> nonBlockingHashMap = this._instanceCounters;
            synchronized (nonBlockingHashMap) {
                if (!this._instanceCounters.containsKey((Object)key)) {
                    this._instanceCounters.put((Object)key, (Object)new AtomicInteger(0));
                }
            }
        }
        return ((AtomicInteger)this._instanceCounters.get((Object)key)).incrementAndGet();
    }

    public Key makeKey(String algoName, String type, boolean with_counter) {
        String counterStr = with_counter ? "_" + this.nextInstanceCounter(algoName, type) : "";
        String prefix = StringUtils.isNullOrEmpty((String)type) ? algoName : algoName + "_" + type + "_";
        return Key.make((String)(prefix + counterStr + "_AutoML_" + timestampFormatForKeys.get().format(this._startTime)));
    }

    public void trackKey(Key key) {
        this._trackedKeys.put((Object)key, (Object)Arrays.toString(Thread.currentThread().getStackTrace()));
    }

    private boolean exceededSearchLimits(ModelingStep step) {
        if (this._job.stop_requested()) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: job cancelled; skipping " + step._description);
            return true;
        }
        if (!ArrayUtils.contains((Object[])step._ignoredConstraints, (Object)((Object)Constraint.TIMEOUT)) && this._runCountdown.timedOut()) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: out of time; skipping " + step._description);
            return true;
        }
        if (!ArrayUtils.contains((Object[])step._ignoredConstraints, (Object)((Object)Constraint.MODEL_COUNT)) && this.remainingModels() <= 0) {
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "AutoML: hit the max_models limit; skipping " + step._description);
            return true;
        }
        return false;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        Key jobKey = this._job == null ? null : this._job._key;
        Log.debug((Object[])new Object[]{"Cleaning up AutoML " + jobKey});
        if (this._buildSpec != null) {
            if (this._buildSpec.input_spec.training_frame == null && this._origTrainingFrame != null) {
                this._origTrainingFrame.delete(jobKey, fs, true);
            }
            if (this._buildSpec.input_spec.validation_frame == null && this._validationFrame != null) {
                this._validationFrame.delete(jobKey, fs, true);
            }
            if (this._buildSpec.input_spec.leaderboard_frame == null && this._leaderboardFrame != null) {
                this._leaderboardFrame.delete(jobKey, fs, true);
            }
        }
        if (this._trainingFrame != null && this._origTrainingFrame != null) {
            Frame.deleteTempFrameAndItsNonSharedVecs((Frame)this._trainingFrame, (Frame)this._origTrainingFrame);
        }
        if (this.leaderboard() != null) {
            this.leaderboard().remove(fs, cascade);
        }
        if (this.eventLog() != null) {
            this.eventLog().remove(fs, cascade);
        }
        if (cascade && this._preprocessing != null) {
            for (PreprocessingStep preprocessingStep : this._preprocessing) {
                preprocessingStep.remove();
            }
        }
        for (Key key : this._trackedKeys.keySet()) {
            Keyed.remove((Key)key, (Futures)fs, (boolean)true);
        }
        return super.remove_impl(fs, cascade);
    }

    private boolean possiblyVerifyImmutability() {
        boolean warning = false;
        this.eventLog().debug(EventLogEntry.Stage.Workflow, "Verifying training frame immutability. . .");
        Vec[] vecsRightNow = this._origTrainingFrame.vecs();
        String[] namesRightNow = this._origTrainingFrame.names();
        if (this._originalTrainingFrameVecs.length != vecsRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this._originalTrainingFrameVecs.length + " to: " + vecsRightNow.length});
            warning = true;
        }
        if (this._originalTrainingFrameNames.length != namesRightNow.length) {
            Log.warn((Object[])new Object[]{"Training frame vec count has changed from: " + this._originalTrainingFrameNames.length + " to: " + namesRightNow.length});
            warning = true;
        }
        for (int i = 0; i < this._originalTrainingFrameVecs.length; ++i) {
            if (!this._originalTrainingFrameVecs[i].equals((Object)vecsRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed keys.  Was: " + this._originalTrainingFrameVecs[i] + " , now: " + vecsRightNow[i]});
                warning = true;
            }
            if (!this._originalTrainingFrameNames[i].equals(namesRightNow[i])) {
                Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed names.  Was: " + this._originalTrainingFrameNames[i] + " , now: " + namesRightNow[i]});
                warning = true;
            }
            if (this._originalTrainingFrameChecksums[i] == vecsRightNow[i].checksum()) continue;
            Log.warn((Object[])new Object[]{"Training frame vec number " + i + " has changed checksum.  Was: " + this._originalTrainingFrameChecksums[i] + " , now: " + vecsRightNow[i].checksum()});
            warning = true;
        }
        if (warning) {
            this.eventLog().warn(EventLogEntry.Stage.Workflow, "Training frame was mutated!  This indicates a bug in the AutoML software.");
        } else {
            this.eventLog().debug(EventLogEntry.Stage.Workflow, "Training frame was not mutated (as expected).");
        }
        return warning;
    }

    private void cleanUpModelsCVPreds() {
        Log.info((Object[])new Object[]{"Cleaning up all CV Predictions for AutoML"});
        for (Model model : this.leaderboard().getModels()) {
            model.deleteCrossValidationPreds();
        }
    }

    public static enum Constraint {
        MODEL_COUNT,
        TIMEOUT;

    }
}

