/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.IAlgo;
import ai.h2o.automl.ModelingStepsRegistry;
import ai.h2o.automl.StepDefinition;
import ai.h2o.automl.preprocessing.PreprocessingStepDefinition;
import hex.Model;
import hex.ScoreKeeper;
import hex.grid.HyperSpaceSearchCriteria;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Stream;
import water.Iced;
import water.Key;
import water.exceptions.H2OIllegalValueException;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.PojoUtils;
import water.util.StringUtils;

public class AutoMLBuildSpec
extends Iced {
    private static final ThreadLocal<DateFormat> projectTimeStampFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd_HmmssSSS"));
    public final AutoMLBuildControl build_control = new AutoMLBuildControl();
    public final AutoMLInput input_spec = new AutoMLInput();
    public final AutoMLBuildModels build_models = new AutoMLBuildModels();

    public String project() {
        if (this.build_control.project_name == null) {
            this.build_control.project_name = "AutoML_" + projectTimeStampFormat.get().format(new Date());
        }
        return this.build_control.project_name;
    }

    public Key<AutoML> makeKey() {
        return Key.make((String)(this.project() + "@@" + StringUtils.sanitizeIdentifier((String)this.input_spec.response_column)));
    }

    public static final class AutoMLCustomParameters
    extends Iced {
        static final String ALGO_PARAMS_ALL_ENABLED = "sys.ai.h2o.automl.algo_parameters.all.enabled";
        private static final String[] ALLOWED_PARAMETERS = new String[]{"monotone_constraints"};
        private static final String ROOT_PARAM = "algo_parameters";
        private final IcedHashMap<String, String[]> _algoParameterNames = new IcedHashMap();
        private final IcedHashMap<String, Model.Parameters> _algoParameters = new IcedHashMap();

        public static Builder create() {
            return new Builder();
        }

        public boolean hasCustomParams(IAlgo algo) {
            return this._algoParameterNames.get((Object)algo.name()) != null;
        }

        public boolean hasCustomParam(IAlgo algo, String param) {
            return ArrayUtils.contains((Object[])((Object[])this._algoParameterNames.get((Object)algo.name())), (Object)param);
        }

        public void applyCustomParameters(IAlgo algo, Model.Parameters destParams) {
            if (this.hasCustomParams(algo)) {
                String[] paramNames = this.getCustomParameterNames(algo);
                String[] onlyParamNames = (String[])Stream.of(paramNames).map(p -> "_" + p).toArray(String[]::new);
                PojoUtils.copyProperties((Object)destParams, (Object)this.getCustomizedDefaults(algo), (PojoUtils.FieldNaming)PojoUtils.FieldNaming.CONSISTENT, null, (String[])onlyParamNames);
            }
        }

        String[] getCustomParameterNames(IAlgo algo) {
            return (String[])this._algoParameterNames.get((Object)algo.name());
        }

        Model.Parameters getCustomizedDefaults(IAlgo algo) {
            Model.Parameters defaults;
            if (!this._algoParameters.containsKey((Object)algo.name()) && (defaults = this.defaultParameters(algo)) != null) {
                this._algoParameters.put((Object)algo.name(), (Object)defaults);
            }
            return (Model.Parameters)this._algoParameters.get((Object)algo.name());
        }

        private Model.Parameters defaultParameters(IAlgo algo) {
            return algo.enabled() ? ModelingStepsRegistry.defaultParameters(algo.name()) : null;
        }

        private void addParameterName(IAlgo algo, String param) {
            if (!this._algoParameterNames.containsKey((Object)algo.name())) {
                this._algoParameterNames.put((Object)algo.name(), (Object)new String[]{param});
            } else {
                Object[] names = (String[])this._algoParameterNames.get((Object)algo.name());
                if (!ArrayUtils.contains((Object[])names, (Object)param)) {
                    this._algoParameterNames.put((Object)algo.name(), (Object)ArrayUtils.append((Object[])names, (Object[])new String[]{param}));
                }
            }
        }

        private <V> boolean addParameter(String param, V value) {
            boolean added = false;
            for (Algo algo : Algo.values()) {
                added |= this.addParameter(algo, param, value);
            }
            return added;
        }

        private <V> boolean addParameter(IAlgo algo, String param, V value) {
            Model.Parameters customParams = this.getCustomizedDefaults(algo);
            try {
                if (customParams != null && (this.setField(customParams, param, value, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES) || this.setField(customParams, param, value, PojoUtils.FieldNaming.CONSISTENT))) {
                    this.addParameterName(algo, param);
                    return true;
                }
                Log.debug((Object[])new Object[]{"Could not set custom param " + param + " for algo " + algo});
                return false;
            }
            catch (IllegalArgumentException iae) {
                throw new H2OIllegalValueException(param, ROOT_PARAM, value);
            }
        }

        private <D, V> boolean setField(D dest, String fieldName, V value, PojoUtils.FieldNaming naming) {
            try {
                PojoUtils.setField(dest, (String)fieldName, value, (PojoUtils.FieldNaming)naming);
                return true;
            }
            catch (IllegalArgumentException iae) {
                try {
                    PojoUtils.getFieldValue(dest, (String)fieldName, (PojoUtils.FieldNaming)naming);
                }
                catch (IllegalArgumentException ignored) {
                    return false;
                }
                throw iae;
            }
        }

        public static final class Builder {
            private final transient List<AutoMLCustomParameter> _anyAlgoParams = new ArrayList<AutoMLCustomParameter>();
            private final transient List<AutoMLCustomParameter> _specificAlgoParams = new ArrayList<AutoMLCustomParameter>();

            public <V> Builder add(String param, V value) {
                this.assertParameterAllowed(param);
                this._anyAlgoParams.add(new AutoMLCustomParameter(param, value));
                return this;
            }

            public <V> Builder add(IAlgo algo, String param, V value) {
                this.assertParameterAllowed(param);
                this._specificAlgoParams.add(new AutoMLCustomParameter(algo, param, value));
                return this;
            }

            public AutoMLCustomParameters build() {
                AutoMLCustomParameters instance = new AutoMLCustomParameters();
                for (AutoMLCustomParameter param : this._anyAlgoParams) {
                    if (instance.addParameter(param._name, param._value)) continue;
                    throw new H2OIllegalValueException(param._name, AutoMLCustomParameters.ROOT_PARAM, param._value);
                }
                for (AutoMLCustomParameter param : this._specificAlgoParams) {
                    if (instance.addParameter(param._algo, param._name, param._value)) continue;
                    throw new H2OIllegalValueException(param._name, AutoMLCustomParameters.ROOT_PARAM, param._value);
                }
                return instance;
            }

            private void assertParameterAllowed(String param) {
                if (!Boolean.parseBoolean(System.getProperty(AutoMLCustomParameters.ALGO_PARAMS_ALL_ENABLED, "false")) && !ArrayUtils.contains((Object[])ALLOWED_PARAMETERS, (Object)param)) {
                    throw new H2OIllegalValueException(AutoMLCustomParameters.ROOT_PARAM, (Object)param);
                }
            }
        }

        public static final class AutoMLCustomParameter<V>
        extends Iced {
            private IAlgo _algo;
            private String _name;
            private V _value;

            private AutoMLCustomParameter(String name, V value) {
                this._name = name;
                this._value = value;
            }

            private AutoMLCustomParameter(IAlgo algo, String name, V value) {
                this._algo = algo;
                this._name = name;
                this._value = value;
            }
        }
    }

    public static final class AutoMLBuildModels
    extends Iced {
        public Algo[] exclude_algos;
        public Algo[] include_algos;
        public StepDefinition[] modeling_plan;
        public double exploitation_ratio = 0.0;
        public AutoMLCustomParameters algo_parameters = new AutoMLCustomParameters();
        public PreprocessingStepDefinition[] preprocessing;
    }

    public static final class AutoMLInput
    extends Iced {
        public Key<Frame> training_frame;
        public Key<Frame> validation_frame;
        public Key<Frame> blending_frame;
        public Key<Frame> leaderboard_frame;
        public String response_column;
        public String fold_column;
        public String weights_column;
        public String[] ignored_columns;
        public String sort_metric = ScoreKeeper.StoppingMetric.AUTO.name();
    }

    public static final class AutoMLStoppingCriteria
    extends Iced {
        public static final int AUTO_STOPPING_TOLERANCE = -1;
        private final HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria _searchCriteria = new HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria();
        private double _max_runtime_secs_per_model = 0.0;

        public static double default_stopping_tolerance_for_frame(Frame frame) {
            return HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria.default_stopping_tolerance_for_frame((Frame)frame);
        }

        public AutoMLStoppingCriteria() {
            this.set_max_models(0);
            this.set_max_runtime_secs(0.0);
            this.set_max_runtime_secs_per_model(0.0);
            this.set_stopping_rounds(3);
            this.set_stopping_tolerance(-1.0);
            this.set_stopping_metric(ScoreKeeper.StoppingMetric.AUTO);
        }

        public double max_runtime_secs_per_model() {
            return this._max_runtime_secs_per_model;
        }

        public void set_max_runtime_secs_per_model(double max_runtime_secs_per_model) {
            this._max_runtime_secs_per_model = max_runtime_secs_per_model;
        }

        public long seed() {
            return this._searchCriteria.seed();
        }

        public int max_models() {
            return this._searchCriteria.max_models();
        }

        public double max_runtime_secs() {
            return this._searchCriteria.max_runtime_secs();
        }

        public int stopping_rounds() {
            return this._searchCriteria.stopping_rounds();
        }

        public ScoreKeeper.StoppingMetric stopping_metric() {
            return this._searchCriteria.stopping_metric();
        }

        public double stopping_tolerance() {
            return this._searchCriteria.stopping_tolerance();
        }

        public void set_seed(long seed) {
            this._searchCriteria.set_seed(seed);
        }

        public void set_max_models(int max_models) {
            this._searchCriteria.set_max_models(max_models);
        }

        public void set_max_runtime_secs(double max_runtime_secs) {
            this._searchCriteria.set_max_runtime_secs(max_runtime_secs);
        }

        public void set_stopping_rounds(int stopping_rounds) {
            this._searchCriteria.set_stopping_rounds(stopping_rounds);
        }

        public void set_stopping_metric(ScoreKeeper.StoppingMetric stopping_metric) {
            this._searchCriteria.set_stopping_metric(stopping_metric);
        }

        public void set_stopping_tolerance(double stopping_tolerance) {
            this._searchCriteria.set_stopping_tolerance(stopping_tolerance);
        }

        public void set_default_stopping_tolerance_for_frame(Frame frame) {
            this._searchCriteria.set_default_stopping_tolerance_for_frame(frame);
        }

        public HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria getSearchCriteria() {
            return this._searchCriteria;
        }
    }

    public static final class AutoMLBuildControl
    extends Iced {
        public final AutoMLStoppingCriteria stopping_criteria = new AutoMLStoppingCriteria();
        public String project_name = null;
        public boolean balance_classes = false;
        public float[] class_sampling_factors;
        public float max_after_balance_size = 5.0f;
        public int nfolds = 5;
        public boolean keep_cross_validation_predictions = false;
        public boolean keep_cross_validation_models = false;
        public boolean keep_cross_validation_fold_assignment = false;
        public String export_checkpoints_dir = null;
    }
}

