/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.StepDefinition;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import water.Iced;
import water.util.ArrayUtils;

public abstract class ModelingSteps
extends Iced<ModelingSteps> {
    private transient AutoML _aml;

    public ModelingSteps(AutoML autoML) {
        this._aml = autoML;
    }

    protected AutoML aml() {
        return this._aml;
    }

    Optional<ModelingStep> getStep(String id) {
        return Stream.of(this.getAllSteps()).filter(step -> step._id.equals(id)).findFirst();
    }

    ModelingStep[] getSteps(StepDefinition.Step[] steps) {
        ArrayList tSteps = new ArrayList();
        for (StepDefinition.Step step : steps) {
            this.getStep(step._id).ifPresent(tStep -> {
                if (step._weight != -1) {
                    tStep._weight = step._weight;
                }
                tSteps.add(tStep);
            });
        }
        return tSteps.toArray(new ModelingStep[0]);
    }

    ModelingStep[] getSteps(StepDefinition.Alias alias) {
        switch (alias) {
            case all: {
                return this.getAllSteps();
            }
            case defaults: {
                return this.getDefaultModels();
            }
            case grids: {
                return this.getGrids();
            }
            case exploitation: {
                return this.getExploitation();
            }
        }
        return new ModelingStep[0];
    }

    ModelingStep[] getAllSteps() {
        ModelingStep[] all = new ModelingStep[]{};
        all = (ModelingStep[])ArrayUtils.append((Object[])all, (Object[])this.getDefaultModels());
        all = (ModelingStep[])ArrayUtils.append((Object[])all, (Object[])this.getGrids());
        all = (ModelingStep[])ArrayUtils.append((Object[])all, (Object[])this.getExploitation());
        return all;
    }

    protected ModelingStep[] getDefaultModels() {
        return new ModelingStep[0];
    }

    protected ModelingStep[] getGrids() {
        return new ModelingStep[0];
    }

    protected ModelingStep[] getExploitation() {
        return new ModelingStep[0];
    }
}

