/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import hex.Model;
import hex.ModelContainer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.TypeMap;
import water.util.ArrayUtils;

public class Models<M extends Model>
extends Lockable<Models<M>>
implements ModelContainer<M> {
    private final int _type_id;
    private final Job _job;
    private Key<M>[] _modelKeys = new Key[0];

    public Models(Key<Models<M>> key, Class<M> clz) {
        this(key, clz, null);
    }

    public Models(Key<Models<M>> key, Class<M> clz, Job job) {
        super(key);
        this._type_id = clz != null && !Modifier.isAbstract(clz.getModifiers()) ? TypeMap.getIcedId((String)clz.getName()) : -1;
        this._job = job;
    }

    public Key<M>[] getModelKeys() {
        return (Key[])this._modelKeys.clone();
    }

    public M[] getModels() {
        Arrays.stream(this._modelKeys).forEach(DKV::prefetch);
        Class<Model> clz = this._type_id >= 0 ? TypeMap.theFreezable((int)this._type_id).getClass() : Model.class;
        return (Model[])Arrays.stream(this._modelKeys).map(k -> k == null ? null : (Model)k.get()).toArray(l -> (Model[])Array.newInstance(clz, l));
    }

    public int getModelCount() {
        return this._modelKeys.length;
    }

    public void addModel(Key<M> key) {
        this.addModels(new Key[]{key});
    }

    public void addModels(Key<M>[] keys) {
        this.write_lock(this._job);
        this._modelKeys = (Key[])ArrayUtils.append((Object[])this._modelKeys, (Object[])keys);
        this.update(this._job);
        this.unlock(this._job);
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (cascade) {
            for (Key<M> k : this._modelKeys) {
                Keyed.remove(k, (Futures)fs, (boolean)true);
            }
        }
        this._modelKeys = new Key[0];
        return super.remove_impl(fs, cascade);
    }
}

