/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.modeling;

import ai.h2o.automl.Algo;
import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelParametersProvider;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.ModelingSteps;
import ai.h2o.automl.ModelingStepsProvider;
import hex.Model;
import hex.tree.SharedTreeModel;
import hex.tree.drf.DRFModel;
import water.Job;
import water.Key;

public class DRFStepsProvider
implements ModelingStepsProvider<DRFSteps>,
ModelParametersProvider<DRFModel.DRFParameters> {
    @Override
    public String getName() {
        return Algo.DRF.name();
    }

    @Override
    public DRFSteps newInstance(AutoML aml) {
        return new DRFSteps(aml);
    }

    @Override
    public DRFModel.DRFParameters newDefaultParameters() {
        return new DRFModel.DRFParameters();
    }

    public static class DRFSteps
    extends ModelingSteps {
        private ModelingStep[] defaults = new DRFModelStep[]{new DRFModelStep("def_1", 10, this.aml()){

            @Override
            protected Job<DRFModel> startJob() {
                DRFModel.DRFParameters drfParameters = this.prepareModelParameters();
                return this.trainModel((Model.Parameters)drfParameters);
            }
        }, new DRFModelStep("XRT", 10, this.aml()){
            {
                super(id, weight, autoML);
                this._description = this._description + " (Extremely Randomized Trees)";
            }

            @Override
            protected Job<DRFModel> startJob() {
                DRFModel.DRFParameters drfParameters = this.prepareModelParameters();
                drfParameters._histogram_type = SharedTreeModel.SharedTreeParameters.HistogramType.Random;
                Key key = this.makeKey("XRT", true);
                return this.trainModel(key, (Model.Parameters)drfParameters);
            }
        }};
        private ModelingStep[] grids = new ModelingStep[0];

        public DRFSteps(AutoML autoML) {
            super(autoML);
        }

        @Override
        protected ModelingStep[] getDefaultModels() {
            return this.defaults;
        }

        @Override
        protected ModelingStep[] getGrids() {
            return this.grids;
        }

        static abstract class DRFModelStep
        extends ModelingStep.ModelStep<DRFModel> {
            DRFModelStep(String id, int weight, AutoML autoML) {
                super(Algo.DRF, id, weight, autoML);
            }

            DRFModel.DRFParameters prepareModelParameters() {
                DRFModel.DRFParameters drfParameters = new DRFModel.DRFParameters();
                drfParameters._score_tree_interval = 5;
                return drfParameters;
            }
        }
    }
}

