/*
 * Decompiled with CFR 0.152.
 */
package water.automl.api;

import ai.h2o.automl.leaderboard.Leaderboard;
import water.DKV;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.api.schemas3.TwoDimTableV3;
import water.automl.api.schemas3.LeaderboardV99;
import water.automl.api.schemas3.LeaderboardsV99;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;

public class LeaderboardsHandler
extends Handler {
    public LeaderboardsV99 list(int version, LeaderboardsV99 s) {
        Leaderboards m = (Leaderboards)s.createAndFillImpl();
        m.leaderboards = Leaderboards.fetchAll();
        return (LeaderboardsV99)s.fillFromImpl(m);
    }

    public LeaderboardV99 fetch(int version, LeaderboardsV99 input) {
        if (null == input.project_name) {
            throw new H2OKeyNotFoundArgumentException("Client must specify a project_name.");
        }
        Leaderboard leaderboard = LeaderboardsHandler.getFromDKV(Key.make((String)Leaderboard.idForProject(input.project_name)), "project_name");
        LeaderboardV99 lb = new LeaderboardV99().fillFromImpl(leaderboard);
        if (input.extensions != null) {
            lb.table = new TwoDimTableV3().fillFromImpl(leaderboard.toTwoDimTable(input.extensions));
        }
        return lb;
    }

    private static Leaderboard getFromDKV(Key key) {
        return LeaderboardsHandler.getFromDKV(key, "(none)");
    }

    private static Leaderboard getFromDKV(Key key, String argName) {
        Value v = DKV.get((Key)key);
        if (v == null) {
            throw new H2OKeyNotFoundArgumentException(key.toString());
        }
        Iced ice = v.get();
        if (!(ice instanceof Leaderboard)) {
            throw new H2OKeyWrongTypeArgumentException(argName, (Object)key.toString(), Leaderboard.class, ice.getClass());
        }
        return (Leaderboard)ice;
    }

    public static final class Leaderboards
    extends Iced {
        public Leaderboard[] leaderboards;

        public static Leaderboard[] fetchAll() {
            Key[] leaderboardKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                public boolean filter(KeySnapshot.KeyInfo k) {
                    return Value.isSubclassOf((int)k._type, Leaderboard.class);
                }
            }).keys();
            Leaderboard[] leaderboards = new Leaderboard[leaderboardKeys.length];
            for (int i = 0; i < leaderboardKeys.length; ++i) {
                Leaderboard leaderboard;
                leaderboards[i] = leaderboard = LeaderboardsHandler.getFromDKV(leaderboardKeys[i]);
            }
            return leaderboards;
        }
    }
}

