/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl;

import ai.h2o.automl.AutoML;
import ai.h2o.automl.ModelingStep;
import ai.h2o.automl.StepResultState;
import ai.h2o.automl.WorkAllocations;
import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.Leaderboard;
import hex.Model;
import hex.ModelContainer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import water.Iced;
import water.Job;
import water.Key;
import water.util.Countdown;
import water.util.Log;

class ModelingStepsExecutor
extends Iced<ModelingStepsExecutor> {
    static final int DEFAULT_POLLING_INTERVAL_IN_MILLIS = 1000;
    static final StepResultState.Resolution DEFAULT_STATE_RESOLUTION_STRATEGY = StepResultState.Resolution.optimistic;
    final Key<EventLog> _eventLogKey;
    final Key<Leaderboard> _leaderboardKey;
    final Countdown _runCountdown;
    private int _pollingIntervalInMillis;
    private StepResultState.Resolution _stateResolutionStrategy;
    private transient List<Job> _jobs;
    private final AtomicInteger _modelCount = new AtomicInteger();

    static void ensureStopRequestPropagated(Job job, Job parentJob, int pollingIntervalInMillis) {
        if (job == null || parentJob == null) {
            return;
        }
        while (job.isRunning()) {
            if (parentJob.stop_requested()) {
                job.stop();
            }
            try {
                Thread.sleep(pollingIntervalInMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    ModelingStepsExecutor(Leaderboard leaderboard, EventLog eventLog, Countdown runCountdown) {
        this._leaderboardKey = leaderboard._key;
        this._eventLogKey = eventLog._key;
        this._runCountdown = runCountdown;
    }

    void setPollingInterval(int millis) {
        assert (millis > 0);
        this._pollingIntervalInMillis = millis;
    }

    void setStateResolutionStrategy(StepResultState.Resolution strategy) {
        assert (strategy != null);
        this._stateResolutionStrategy = strategy;
    }

    int modelCount() {
        return this._modelCount.get();
    }

    void start() {
        this.start(1000, DEFAULT_STATE_RESOLUTION_STRATEGY);
    }

    void start(int pollingIntervalInMillis, StepResultState.Resolution strategy) {
        this.setPollingInterval(pollingIntervalInMillis);
        this.setStateResolutionStrategy(strategy);
        this._jobs = new ArrayList<Job>();
        this._modelCount.set(0);
        this._runCountdown.start();
    }

    void stop() {
        this._runCountdown.stop();
        if (this._jobs == null) {
            return;
        }
        for (Job j : this._jobs) {
            j.stop();
        }
        for (Job j : this._jobs) {
            j.get();
        }
        this._jobs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StepResultState submit(ModelingStep step, Job parentJob) {
        StepResultState resultState = new StepResultState(step._description);
        Iterator<ModelingStep> it = step.iterateSubSteps();
        while (it.hasNext()) {
            resultState.addState(this.submit(it.next(), parentJob));
        }
        if (step.canRun()) {
            Job job = null;
            try {
                job = step.run();
                if (job == null) {
                    resultState.addState(this.skip(step, parentJob));
                }
                resultState.addState(this.monitor(job, step, parentJob));
            }
            catch (Exception e) {
                resultState.addState(new StepResultState(step._description, e));
            }
            finally {
                step.onDone(job);
            }
        } else {
            resultState.addState(new StepResultState(step._description, StepResultState.ResultStatus.skipped));
            if (step.getAllocatedWork() != null) {
                step.getAllocatedWork().consume();
            }
        }
        resultState.resolveState(this._stateResolutionStrategy);
        return resultState;
    }

    private StepResultState skip(ModelingStep step, Job parentJob) {
        if (null != parentJob) {
            String desc = step._description;
            WorkAllocations.Work work = step.getAllocatedWork();
            parentJob.update((long)work.consume(), "SKIPPED: " + desc);
            Log.info((Object[])new Object[]{"AutoML; skipping " + desc});
        }
        return new StepResultState(step._description, StepResultState.ResultStatus.skipped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StepResultState monitor(Job job, ModelingStep step, Job parentJob) {
        EventLog eventLog = this.eventLog();
        String jobDescription = job._result == null ? job._description : job._result + " [" + job._description + "]";
        eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " started");
        this._jobs.add(job);
        boolean ignoreTimeout = step.ignores(AutoML.Constraint.TIMEOUT);
        WorkAllocations.Work work = step.getAllocatedWork();
        long lastWorkedSoFar = 0L;
        long lastTotalModelsBuilt = 0L;
        try {
            while (job.isRunning()) {
                if (parentJob != null) {
                    if (parentJob.stop_requested()) {
                        eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML job cancelled; skipping " + jobDescription);
                        job.stop();
                    }
                    if (!ignoreTimeout && this._runCountdown.timedOut()) {
                        eventLog.debug(EventLogEntry.Stage.ModelTraining, "AutoML: out of time; skipping " + jobDescription);
                        job.stop();
                    }
                }
                long workedSoFar = Math.round(job.progress() * (float)work._weight);
                if (parentJob != null) {
                    parentJob.update((long)Math.round(workedSoFar - lastWorkedSoFar), jobDescription);
                }
                if (WorkAllocations.JobType.HyperparamSearch == work._type || WorkAllocations.JobType.Selection == work._type) {
                    int totalModelsBuilt;
                    ModelContainer container = (ModelContainer)job._result.get();
                    int n = totalModelsBuilt = container == null ? 0 : container.getModelCount();
                    if ((long)totalModelsBuilt > lastTotalModelsBuilt) {
                        eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalModelsBuilt + " models for " + (Object)((Object)work._type) + " : " + jobDescription);
                        this.addModels(container, step);
                        lastTotalModelsBuilt = totalModelsBuilt;
                    }
                }
                try {
                    Thread.sleep(this._pollingIntervalInMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                lastWorkedSoFar = workedSoFar;
            }
            if (job.isCrashed()) {
                eventLog.error(EventLogEntry.Stage.ModelTraining, jobDescription + " failed: " + job.ex());
                StepResultState workedSoFar = new StepResultState(step._description, job.ex());
                return workedSoFar;
            }
            if (job.get() == null) {
                eventLog.info(EventLogEntry.Stage.ModelTraining, jobDescription + " cancelled");
                StepResultState workedSoFar = new StepResultState(step._description, StepResultState.ResultStatus.cancelled);
                return workedSoFar;
            }
            if (WorkAllocations.JobType.HyperparamSearch == work._type || WorkAllocations.JobType.Selection == work._type) {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
                ModelContainer container = (ModelContainer)job.get();
                int totalModelsBuilt = container.getModelCount();
                if ((long)totalModelsBuilt > lastTotalModelsBuilt) {
                    eventLog.debug(EventLogEntry.Stage.ModelTraining, "Built: " + totalModelsBuilt + " models for " + (Object)((Object)work._type) + " : " + jobDescription);
                    this.addModels(container, step);
                }
            } else if (WorkAllocations.JobType.ModelBuild == work._type) {
                eventLog.debug(EventLogEntry.Stage.ModelTraining, jobDescription + " complete");
                this.addModel((Model)job.get(), step);
            }
            StepResultState stepResultState = new StepResultState(step._description, StepResultState.ResultStatus.success);
            return stepResultState;
        }
        finally {
            if (parentJob != null) {
                parentJob.update((long)work._weight - lastWorkedSoFar);
            }
            work.consume();
            this._jobs.remove(job);
        }
    }

    private void addModels(ModelContainer container, ModelingStep step) {
        for (Key key : container.getModelKeys()) {
            step.register(key);
        }
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModels(container.getModelKeys());
        int after = leaderboard.getModelCount();
        this._modelCount.addAndGet(after - before);
    }

    private void addModel(Model model, ModelingStep step) {
        step.register(model._key);
        Leaderboard leaderboard = this.leaderboard();
        int before = leaderboard.getModelCount();
        leaderboard.addModel(model._key);
        int after = leaderboard.getModelCount();
        if (!step.ignores(AutoML.Constraint.MODEL_COUNT)) {
            this._modelCount.addAndGet(after - before);
        }
    }

    private EventLog eventLog() {
        return (EventLog)this._eventLogKey.get();
    }

    private Leaderboard leaderboard() {
        return (Leaderboard)this._leaderboardKey.get();
    }
}

