/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.leaderboard;

import ai.h2o.automl.events.EventLog;
import ai.h2o.automl.events.EventLogEntry;
import ai.h2o.automl.leaderboard.LeaderboardCell;
import ai.h2o.automl.leaderboard.LeaderboardColumn;
import ai.h2o.automl.leaderboard.LeaderboardExtensionsProvider;
import ai.h2o.automl.leaderboard.MetricScore;
import ai.h2o.automl.leaderboard.ModelId;
import ai.h2o.automl.leaderboard.ScoringTimePerRow;
import ai.h2o.automl.utils.DKVUtils;
import hex.Model;
import hex.ModelContainer;
import hex.ModelMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.Lockable;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.logging.Logger;
import water.logging.LoggerFactory;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.TwoDimTable;

public class Leaderboard
extends Lockable<Leaderboard>
implements ModelContainer<Model> {
    private static final Logger log = LoggerFactory.getLogger(Leaderboard.class);
    private final String _project_name;
    private Key<Model>[] _model_keys = new Key[0];
    private final IcedHashMap<Key<ModelMetrics>, ModelMetrics> _leaderboard_model_metrics = new IcedHashMap();
    private IcedHashMap<String, double[]> _metric_values = new IcedHashMap();
    private LeaderboardExtensionsProvider _extensionsProvider;
    private LeaderboardCell[] _extensions_cells = new LeaderboardCell[0];
    private String _sort_metric;
    private String[] _metrics;
    private final Key<EventLog> _eventlog_key;
    private final Key<Frame> _leaderboard_frame_key;
    private final long _leaderboard_frame_checksum;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static String idForProject(String project_name) {
        return "Leaderboard_" + project_name;
    }

    public static boolean isLossFunction(String metric) {
        return metric != null && !Arrays.asList("auc", "aucpr").contains(metric.toLowerCase());
    }

    public static Leaderboard getOrMake(String projectName, EventLog eventLog, Frame leaderboardFrame, String sortMetric) {
        Leaderboard leaderboard = (Leaderboard)DKV.getGet((Key)Key.make((String)Leaderboard.idForProject(projectName)));
        if (null != leaderboard) {
            if (!(leaderboardFrame == null || leaderboardFrame._key.equals(leaderboard._leaderboard_frame_key) && leaderboardFrame.checksum() == leaderboard._leaderboard_frame_checksum)) {
                throw new H2OIllegalArgumentException("Cannot use leaderboard " + projectName + " with a new leaderboard frame (existing leaderboard frame: " + leaderboard._leaderboard_frame_key + ").");
            }
            eventLog.warn(EventLogEntry.Stage.Workflow, "New models will be added to existing leaderboard " + projectName + " (leaderboard frame=" + leaderboard._leaderboard_frame_key + ") with already " + leaderboard.getModelKeys().length + " models.");
            if (sortMetric != null && !sortMetric.equals(leaderboard._sort_metric)) {
                leaderboard._sort_metric = sortMetric.toLowerCase();
                if (leaderboard.getLeader() != null) {
                    leaderboard.setDefaultMetrics(leaderboard.getLeader());
                }
            }
        } else {
            leaderboard = new Leaderboard(projectName, eventLog, leaderboardFrame, sortMetric);
        }
        DKV.put((Keyed)leaderboard);
        return leaderboard;
    }

    public Leaderboard(String projectName, EventLog eventLog, Frame leaderboardFrame, String sortMetric) {
        super(Key.make((String)Leaderboard.idForProject(projectName)));
        this._project_name = projectName;
        this._eventlog_key = eventLog._key;
        this._leaderboard_frame_key = leaderboardFrame == null ? null : leaderboardFrame._key;
        this._leaderboard_frame_checksum = leaderboardFrame == null ? 0L : leaderboardFrame.checksum();
        this._sort_metric = sortMetric == null ? null : sortMetric.toLowerCase();
    }

    public void setExtensionsProvider(LeaderboardExtensionsProvider provider) {
        this._extensionsProvider = provider;
    }

    public String getProject() {
        return this._project_name;
    }

    public String getSortMetric() {
        return this._sort_metric;
    }

    public String[] getMetrics() {
        String[] stringArray;
        if (this._metrics == null) {
            if (this._sort_metric == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._sort_metric;
            }
        } else {
            stringArray = this._metrics;
        }
        return stringArray;
    }

    public Frame leaderboardFrame() {
        return this._leaderboard_frame_key == null ? null : (Frame)this._leaderboard_frame_key.get();
    }

    public Key<Model>[] getModelKeys() {
        return this._model_keys;
    }

    public int getModelCount() {
        return this.getModelKeys() == null ? 0 : this.getModelKeys().length;
    }

    public Model[] getModels() {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.getModelKeys());
    }

    public Model[] getModelsSortedByMetric(String metric) {
        if (this.getModelCount() == 0) {
            return new Model[0];
        }
        return Leaderboard.getModelsFromKeys(this.sortModels(metric));
    }

    public Model getLeader() {
        if (this.getModelCount() == 0) {
            return null;
        }
        return (Model)this.getModelKeys()[0].get();
    }

    public int getModelRank(Key<Model> modelKey) {
        return ArrayUtils.find((Object[])this.getModelKeys(), modelKey) + 1;
    }

    public double[] getSortMetricValues() {
        return this._sort_metric == null ? null : (double[])this._metric_values.get((Object)this._sort_metric);
    }

    private EventLog eventLog() {
        return (EventLog)this._eventlog_key.get();
    }

    private void setDefaultMetrics(Model m) {
        int sortMetricIdx;
        this.write_lock();
        Object[] metrics = Leaderboard.defaultMetricsForModel(m);
        if (this._sort_metric == null) {
            String string = this._sort_metric = metrics.length > 0 ? metrics[0] : "mse";
        }
        if ((sortMetricIdx = ArrayUtils.find((Object[])metrics, (Object)this._sort_metric)) > 0) {
            metrics = (String[])ArrayUtils.remove((Object[])metrics, (int)sortMetricIdx);
            metrics = ArrayUtils.prepend((String[])metrics, (String)this._sort_metric);
        } else if (sortMetricIdx < 0) {
            metrics = ArrayUtils.append((String[])new String[]{this._sort_metric}, (String[])metrics);
        }
        this._metrics = metrics;
        this.update();
        this.unlock();
    }

    private ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey) {
        return this.getOrCreateModelMetrics(modelKey, this.getExtensionsAsMap());
    }

    private ModelMetrics getOrCreateModelMetrics(Key<Model> modelKey, Map<Key<Model>, LeaderboardCell[]> extensions) {
        ModelMetrics mm;
        Frame leaderboardFrame = this.leaderboardFrame();
        Model model = (Model)modelKey.get();
        if (leaderboardFrame == null) {
            mm = ModelMetrics.defaultModelMetrics((Model)model);
        } else {
            LeaderboardCell scoringTimePerRow;
            mm = ModelMetrics.getFromDKV((Model)model, (Frame)leaderboardFrame);
            if (mm == null && (scoringTimePerRow = this.getExtension(modelKey, ScoringTimePerRow.COLUMN.getName(), extensions)) != null && scoringTimePerRow.getValue() == null) {
                scoringTimePerRow.fetch();
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)leaderboardFrame);
            }
            if (mm == null) {
                model.score(leaderboardFrame).delete();
                mm = ModelMetrics.getFromDKV((Model)model, (Frame)leaderboardFrame);
            }
        }
        return mm;
    }

    public void addModels(Key<Model>[] modelKeys) {
        if (modelKeys == null || modelKeys.length == 0) {
            return;
        }
        if (null == this._key) {
            throw new H2OIllegalArgumentException("Can't add models to a Leaderboard which isn't in the DKV.");
        }
        Object[] oldModelKeys = this._model_keys;
        Key<Model> oldLeaderKey = oldModelKeys == null || 0 == oldModelKeys.length ? null : oldModelKeys[0];
        HashSet<Object> uniques = new HashSet<Object>(Arrays.asList(ArrayUtils.append((Object[])oldModelKeys, (Object[])modelKeys)));
        ArrayList<Object> allModelKeys = new ArrayList<Object>(uniques);
        HashSet<Object> newModelKeys = new HashSet<Object>(uniques);
        newModelKeys.removeAll(Arrays.asList(oldModelKeys));
        if (newModelKeys.isEmpty()) {
            return;
        }
        allModelKeys.forEach(DKV::prefetch);
        for (Key key : newModelKeys) {
            Model m = (Model)key.get();
            if (m == null) continue;
            this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "Adding model " + key + " to leaderboard " + this._key + ". Training time: model=" + Math.round(m._output._run_time / 1000L) + "s, total=" + Math.round(m._output._total_run_time / 1000L) + "s");
        }
        ArrayList<ModelMetrics> modelMetrics = new ArrayList<ModelMetrics>();
        HashMap<Key<Model>, LeaderboardCell[]> hashMap = new HashMap<Key<Model>, LeaderboardCell[]>();
        ArrayList<Key> badKeys = new ArrayList<Key>();
        for (Key key : allModelKeys) {
            Model model = (Model)key.get();
            if (model == null) {
                badKeys.add(key);
                this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Model `" + key + "` has unexpectedly been deleted from H2O: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            if (this._extensionsProvider != null) {
                hashMap.put((Key<Model>)key, this._extensionsProvider.createExtensions(model));
            }
            ModelMetrics mm = this.getOrCreateModelMetrics((Key<Model>)key, hashMap);
            assert (mm != null) : "Missing metrics for model " + key;
            if (mm == null) {
                badKeys.add(key);
                this.eventLog().warn(EventLogEntry.Stage.ModelTraining, "Metrics for model `" + key + "` are missing: ignoring the model and/or removing it from the leaderboard.");
                continue;
            }
            modelMetrics.add(mm);
        }
        if (this._metrics == null) {
            this.setDefaultMetrics((Model)modelKeys[0].get());
        }
        for (Key key : badKeys) {
            allModelKeys.remove(key);
            hashMap.remove(key);
        }
        this.atomicUpdate(() -> {
            this._leaderboard_model_metrics.clear();
            modelMetrics.forEach(this::addModelMetrics);
            this.updateModels(allModelKeys.toArray(new Key[0]));
            this._extensions_cells = new LeaderboardCell[0];
            extensions.forEach(this::addExtensions);
        }, null);
        if (oldLeaderKey == null || !oldLeaderKey.equals(this._model_keys[0])) {
            this.eventLog().info(EventLogEntry.Stage.ModelTraining, "New leader: " + this._model_keys[0] + ", " + this._sort_metric + ": " + ((double[])this._metric_values.get((Object)this._sort_metric))[0]);
        }
    }

    public void removeModels(Key<Model>[] modelKeys, boolean cascade) {
        if (modelKeys == null || modelKeys.length == 0 || Arrays.stream(modelKeys).noneMatch(k -> ArrayUtils.contains((Object[])this._model_keys, (Object)k))) {
            return;
        }
        Arrays.stream(modelKeys).filter(k -> ArrayUtils.contains((Object[])this._model_keys, (Object)k)).forEach(k -> this.eventLog().debug(EventLogEntry.Stage.ModelTraining, "Removing model " + k + " from leaderboard " + this._key));
        Key[] remainingKeys = (Key[])Arrays.stream(this._model_keys).filter(k -> !ArrayUtils.contains((Object[])modelKeys, (Object)k)).toArray(Key[]::new);
        this.atomicUpdate(() -> {
            this._model_keys = new Key[0];
            this.addModels(remainingKeys);
        }, null);
        if (cascade) {
            for (Key<Model> key : modelKeys) {
                Keyed.remove(key);
            }
        }
    }

    private void updateModels(Key<Model>[] modelKeys) {
        Key<Model>[] sortedModelKeys = this.sortModelKeys(modelKeys);
        Model[] sortedModels = Leaderboard.getModelsFromKeys(sortedModelKeys);
        IcedHashMap metricValues = new IcedHashMap();
        for (String metric : this._metrics) {
            metricValues.put((Object)metric, (Object)this.getMetrics(metric, sortedModels));
        }
        this._metric_values = metricValues;
        this._model_keys = sortedModelKeys;
    }

    private void atomicUpdate(Runnable update, Key<Job> jobKey) {
        DKVUtils.atomicUpdate(this, update, jobKey, this.lock);
    }

    public <M extends Model> void addModel(Key<M> key) {
        if (key == null) {
            return;
        }
        this.addModels(new Key[]{key});
    }

    public <M extends Model> void removeModel(Key<M> key, boolean cascade) {
        if (key == null) {
            return;
        }
        this.removeModels(new Key[]{key}, cascade);
    }

    private void addModelMetrics(ModelMetrics modelMetrics) {
        if (modelMetrics != null) {
            this._leaderboard_model_metrics.put((Object)modelMetrics._key, (Object)modelMetrics);
        }
    }

    private <M extends Model> void addExtensions(Key<M> key, LeaderboardCell ... extensions) {
        if (key == null) {
            return;
        }
        assert (ArrayUtils.contains((Object[])this._model_keys, key));
        Object[] toAdd = (LeaderboardCell[])Stream.of(extensions).filter(lc -> this.getExtension(key, lc.getColumn().getName()) == null).toArray(LeaderboardCell[]::new);
        this._extensions_cells = (LeaderboardCell[])ArrayUtils.append((Object[])this._extensions_cells, (Object[])toAdd);
    }

    /*
     * Exception decompiling
     */
    private Map<Key<Model>, LeaderboardCell[]> getExtensionsAsMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private <M extends Model> LeaderboardCell[] getExtensions(Key<M> key) {
        return (LeaderboardCell[])Stream.of(this._extensions_cells).filter(c -> c.getModelId().equals((Object)key)).toArray(LeaderboardCell[]::new);
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName) {
        return this.getExtension(key, extName, Collections.singletonMap(key, this.getExtensions(key)));
    }

    private <M extends Model> LeaderboardCell getExtension(Key<M> key, String extName, Map<Key<Model>, LeaderboardCell[]> extensions) {
        if (extensions != null && extensions.containsKey(key)) {
            return Stream.of((Object[])extensions.get(key)).filter(le -> le.getColumn().getName().equals(extName)).findFirst().orElse(null);
        }
        return null;
    }

    private static Model[] getModelsFromKeys(Key<Model>[] modelKeys) {
        Model[] models = new Model[modelKeys.length];
        int i = 0;
        for (Key<Model> modelKey : modelKeys) {
            models[i++] = (Model)DKV.getGet(modelKey);
        }
        return models;
    }

    private Key<Model>[] sortModels(String metric) {
        Key<Model>[] models = this.getModelKeys();
        boolean decreasing = !Leaderboard.isLossFunction(metric);
        List newModelsSorted = ModelMetrics.sortModelsByMetric((String)metric, (boolean)decreasing, Arrays.asList(models));
        return newModelsSorted.toArray(new Key[0]);
    }

    private Key<Model>[] sortModelKeys(Key<Model>[] modelKeys) {
        List sortedModelKeys;
        boolean sortDecreasing = !Leaderboard.isLossFunction(this._sort_metric);
        Frame leaderboardFrame = this.leaderboardFrame();
        try {
            sortedModelKeys = leaderboardFrame == null ? ModelMetrics.sortModelsByMetric((String)this._sort_metric, (boolean)sortDecreasing, Arrays.asList(modelKeys)) : ModelMetrics.sortModelsByMetric((Frame)leaderboardFrame, (String)this._sort_metric, (boolean)sortDecreasing, Arrays.asList(modelKeys));
        }
        catch (H2OIllegalArgumentException e) {
            log.warn("ModelMetrics.sortModelsByMetric failed: " + (Object)((Object)e));
            throw e;
        }
        return sortedModelKeys.toArray(new Key[0]);
    }

    private double[] getMetrics(String metric, Model[] models) {
        double[] metrics = new double[models.length];
        int i = 0;
        Frame leaderboardFrame = this.leaderboardFrame();
        for (Model m : models) {
            if (leaderboardFrame != null) {
                metrics[i++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)((ModelMetrics)this._leaderboard_model_metrics.get((Object)ModelMetrics.buildKey((Model)m, (Frame)leaderboardFrame))), (String)metric);
                continue;
            }
            Key model_key = m._key;
            long model_checksum = m.checksum();
            ModelMetrics mm = ModelMetrics.defaultModelMetrics((Model)m);
            metrics[i++] = ModelMetrics.getMetricFromModelMetric((ModelMetrics)((ModelMetrics)this._leaderboard_model_metrics.get((Object)ModelMetrics.buildKey((Key)model_key, (long)model_checksum, (Key)mm.frame()._key, (long)mm.frame().checksum()))), (String)metric);
        }
        return metrics;
    }

    protected Futures remove_impl(Futures fs, boolean cascade) {
        log.debug("Cleaning up leaderboard from models " + Arrays.toString(this._model_keys));
        if (cascade) {
            for (Key<Model> m : this._model_keys) {
                Keyed.remove((Key)m, (Futures)fs, (boolean)true);
            }
        }
        for (Key k : this._leaderboard_model_metrics.keySet()) {
            Keyed.remove((Key)k, (Futures)fs, (boolean)true);
        }
        return super.remove_impl(fs, cascade);
    }

    private static String[] defaultMetricsForModel(Model m) {
        if (m._output.isBinomialClassifier()) {
            return new String[]{"auc", "logloss", "aucpr", "mean_per_class_error", "rmse", "mse"};
        }
        if (m._output.isMultinomialClassifier()) {
            return new String[]{"mean_per_class_error", "logloss", "rmse", "mse"};
        }
        if (m._output.isSupervised()) {
            return new String[]{"mean_residual_deviance", "rmse", "mse", "mae", "rmsle"};
        }
        return new String[0];
    }

    private double[] getModelMetricValues(int rank) {
        assert (rank >= 0 && rank < this.getModelKeys().length) : "invalid rank";
        if (this._metrics == null) {
            return new double[0];
        }
        double[] values = new double[this._metrics.length];
        for (int i = 0; i < this._metrics.length; ++i) {
            values[i] = ((double[])this._metric_values.get((Object)this._metrics[i]))[rank];
        }
        return values;
    }

    String rankTsv() {
        String lineSeparator = "\n";
        StringBuilder sb = new StringBuilder();
        sb.append("Error").append(lineSeparator);
        for (int i = this.getModelKeys().length - 1; i >= 0; --i) {
            sb.append(Arrays.toString(this.getModelMetricValues(i)));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    private TwoDimTable makeTwoDimTable(String tableHeader, int nrows, LeaderboardColumn ... columns) {
        assert (columns.length > 0);
        assert (this._sort_metric != null || nrows == 0) : "sort_metrics needs to be always not-null for non-empty array!";
        String description = nrows > 0 ? "models sorted in order of " + this._sort_metric + ", best first" : "no models in this leaderboard";
        String[] rowHeaders = new String[nrows];
        for (int i = 0; i < nrows; ++i) {
            rowHeaders[i] = "" + i;
        }
        String[] colHeaders = (String[])Stream.of(columns).map(LeaderboardColumn::getName).toArray(String[]::new);
        String[] colTypes = (String[])Stream.of(columns).map(LeaderboardColumn::getType).toArray(String[]::new);
        String[] colFormats = (String[])Stream.of(columns).map(LeaderboardColumn::getFormat).toArray(String[]::new);
        String colHeaderForRowHeader = nrows > 0 ? "#" : "-";
        return new TwoDimTable(tableHeader, description, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeader);
    }

    private void addTwoDimTableRow(TwoDimTable table, int row, String modelID, String[] metrics, LeaderboardCell[] extensions) {
        int col = 0;
        table.set(row, col++, (Object)modelID);
        for (String metric : metrics) {
            double value = ((double[])this._metric_values.get((Object)metric))[row];
            table.set(row, col++, (Object)value);
        }
        for (LeaderboardCell extension : extensions) {
            if (extension != null) {
                Object value;
                Object v = value = extension.getValue() == null ? extension.fetch() : extension.getValue();
                if (!extension.isNA()) {
                    table.set(row, col, value);
                }
            }
            ++col;
        }
    }

    public TwoDimTable toTwoDimTable(String ... extensions) {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, false, extensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TwoDimTable toTwoDimTable(String tableHeader, boolean leftJustifyModelIds, String ... extensions) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        if (readLock.tryLock()) {
            try {
                Key[] modelKeys = (Key[])this._model_keys.clone();
                List<LeaderboardColumn> columns = this.getDefaultTableColumns();
                ArrayList extColumns = new ArrayList();
                if (this.getModelCount() > 0) {
                    Key<Model> leader = this.getModelKeys()[0];
                    LeaderboardCell[] extCells = extensions.length > 0 && "ALL".equalsIgnoreCase(extensions[0]) ? (LeaderboardCell[])Stream.of(this.getExtensions(leader)).filter(cell -> !cell.getColumn().isHidden()).toArray(LeaderboardCell[]::new) : (LeaderboardCell[])Stream.of(extensions).map(e -> this.getExtension((Key)leader, (String)e)).toArray(LeaderboardCell[]::new);
                    Stream.of(extCells).filter(Objects::nonNull).forEach(e -> extColumns.add(e.getColumn()));
                }
                columns.addAll(extColumns);
                TwoDimTable table = this.makeTwoDimTable(tableHeader, modelKeys.length, columns.toArray(new LeaderboardColumn[0]));
                int maxModelIdLen = Stream.of(modelKeys).mapToInt(k -> k.toString().length()).max().orElse(0);
                String[] modelIDsFormatted = new String[modelKeys.length];
                for (int i = 0; i < modelKeys.length; ++i) {
                    Key key = modelKeys[i];
                    modelIDsFormatted[i] = leftJustifyModelIds ? StringUtils.rightPad((String)key.toString(), (int)maxModelIdLen) : key.toString();
                    this.addTwoDimTableRow(table, i, modelIDsFormatted[i], this.getMetrics(), (LeaderboardCell[])extColumns.stream().map(ext -> this.getExtension(key, ext.getName())).toArray(LeaderboardCell[]::new));
                }
                TwoDimTable twoDimTable = table;
                return twoDimTable;
            }
            finally {
                readLock.unlock();
            }
        }
        return this.makeTwoDimTable(tableHeader, 0, this.getDefaultTableColumns().toArray(new LeaderboardColumn[0]));
    }

    private List<LeaderboardColumn> getDefaultTableColumns() {
        ArrayList<LeaderboardColumn> columns = new ArrayList<LeaderboardColumn>();
        columns.add(ModelId.COLUMN);
        for (String metric : this.getMetrics()) {
            columns.add(MetricScore.getColumn(metric));
        }
        return columns;
    }

    private String toString(String fieldSeparator, String lineSeparator, boolean includeTitle, boolean includeHeader) {
        StringBuilder sb = new StringBuilder();
        if (includeTitle) {
            sb.append("Leaderboard for project \"").append(this._project_name).append("\": ");
            if (this._model_keys.length == 0) {
                sb.append("<empty>");
                return sb.toString();
            }
            sb.append(lineSeparator);
        }
        boolean printedHeader = false;
        for (int i = 0; i < this._model_keys.length; ++i) {
            Key<Model> key = this._model_keys[i];
            if (includeHeader && !printedHeader) {
                sb.append("model_id");
                sb.append(fieldSeparator);
                Object[] metrics = this._metrics != null ? this._metrics : new String[]{};
                sb.append(Arrays.toString(metrics));
                sb.append(lineSeparator);
                printedHeader = true;
            }
            sb.append(key.toString());
            sb.append(fieldSeparator);
            double[] values = this._metrics != null ? this.getModelMetricValues(i) : new double[]{};
            sb.append(Arrays.toString(values));
            sb.append(lineSeparator);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(" ; ", " | ", true, true);
    }

    public String toLogString() {
        return this.toTwoDimTable("Leaderboard for project " + this._project_name, true, new String[0]).toString();
    }

    private static /* synthetic */ LeaderboardCell[] lambda$getExtensionsAsMap$11(LeaderboardCell[] lhs, LeaderboardCell[] rhs) {
        return (LeaderboardCell[])ArrayUtils.append((Object[])lhs, (Object[])rhs);
    }
}

