/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.automl.utils;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import water.Job;
import water.Key;
import water.Lockable;

public final class DKVUtils {
    private DKVUtils() {
    }

    public static <T extends Lockable<T>> void atomicUpdate(Lockable<T> target, Runnable update, Key<Job> jobKey) {
        target.write_lock(jobKey);
        try {
            update.run();
            target.update(jobKey);
        }
        finally {
            target.unlock(jobKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Lockable<T>> void atomicUpdate(Lockable<T> target, Runnable update, Key<Job> jobKey, ReadWriteLock lock) {
        Lock writeLock = lock.writeLock();
        if (lock instanceof ReentrantReadWriteLock && ((ReentrantReadWriteLock.WriteLock)writeLock).isHeldByCurrentThread()) {
            writeLock.lock();
            try {
                update.run();
            }
            finally {
                writeLock.unlock();
            }
        }
        writeLock.lock();
        try {
            DKVUtils.atomicUpdate(target, update, jobKey);
        }
        finally {
            writeLock.unlock();
        }
    }
}

