/*
 * Decompiled with CFR 0.152.
 */
package water.parser.avro;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;

public final class AvroUtil {
    public static boolean isSupportedSchema(Schema s) {
        Schema.Type typ = s.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ENUM: 
            case STRING: 
            case NULL: 
            case BYTES: {
                return true;
            }
            case UNION: {
                List unionSchemas = s.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.isSupportedSchema((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s2 = (Schema)unionSchemas.get(1);
                return s1.getType().equals((Object)Schema.Type.NULL) && AvroUtil.isSupportedSchema(s2) || s2.getType().equals((Object)Schema.Type.NULL) && AvroUtil.isSupportedSchema(s1);
            }
        }
        return false;
    }

    public static byte schemaToColumnType(Schema s) {
        Schema.Type typ = s.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return 3;
            }
            case ENUM: {
                return 4;
            }
            case STRING: {
                return 2;
            }
            case NULL: {
                return 0;
            }
            case BYTES: {
                return 2;
            }
            case UNION: {
                List unionSchemas = s.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.schemaToColumnType((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s2 = (Schema)unionSchemas.get(1);
                if (s1.getType().equals((Object)Schema.Type.NULL)) {
                    return AvroUtil.schemaToColumnType(s2);
                }
                if (!s2.getType().equals((Object)Schema.Type.NULL)) break;
                return AvroUtil.schemaToColumnType(s1);
            }
        }
        throw new IllegalArgumentException("Unsupported Avro schema type: " + s);
    }

    static String[] getDomain(Schema fieldSchema) {
        if (fieldSchema.getType() == Schema.Type.ENUM) {
            return fieldSchema.getEnumSymbols().toArray(new String[0]);
        }
        if (fieldSchema.getType() == Schema.Type.UNION) {
            List unionSchemas = fieldSchema.getTypes();
            if (unionSchemas.size() == 1) {
                return AvroUtil.getDomain((Schema)unionSchemas.get(0));
            }
            if (unionSchemas.size() == 2) {
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s2 = (Schema)unionSchemas.get(1);
                if (s1.getType() == Schema.Type.NULL) {
                    return AvroUtil.getDomain(s2);
                }
                if (s2.getType() == Schema.Type.NULL) {
                    return AvroUtil.getDomain(s1);
                }
            }
        }
        throw new IllegalArgumentException("Cannot get domain from field: " + fieldSchema);
    }

    public static Schema.Type toPrimitiveType(Schema s) {
        Schema.Type typ = s.getType();
        switch (typ) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case ENUM: 
            case STRING: 
            case NULL: 
            case BYTES: {
                return typ;
            }
            case UNION: {
                List unionSchemas = s.getTypes();
                if (unionSchemas.size() == 1) {
                    return AvroUtil.toPrimitiveType((Schema)unionSchemas.get(0));
                }
                if (unionSchemas.size() != 2) break;
                Schema s1 = (Schema)unionSchemas.get(0);
                Schema s2 = (Schema)unionSchemas.get(1);
                if (s1.getType().equals((Object)Schema.Type.NULL)) {
                    return AvroUtil.toPrimitiveType(s2);
                }
                if (!s2.getType().equals((Object)Schema.Type.NULL)) break;
                return AvroUtil.toPrimitiveType(s1);
            }
        }
        throw new IllegalArgumentException("Unsupported Avro schema type: " + s);
    }

    public static Schema.Field[] flatSchema(Schema s) {
        List fields = s.getFields();
        Schema.Field[] flatSchema = new Schema.Field[fields.size()];
        int cnt = 0;
        for (Schema.Field f : fields) {
            if (!AvroUtil.isSupportedSchema(f.schema())) continue;
            flatSchema[cnt] = f;
            ++cnt;
        }
        return cnt != flatSchema.length ? Arrays.copyOf(flatSchema, cnt) : flatSchema;
    }
}

