/*
 * Decompiled with CFR 0.152.
 */
package water.parser.avro;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.util.Utf8;
import water.Job;
import water.Key;
import water.parser.BufferedString;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.avro.AvroParserProvider;
import water.parser.avro.AvroUtil;
import water.util.ArrayUtils;
import water.util.Log;

public class AvroParser
extends Parser {
    private final byte[] header;

    AvroParser(ParseSetup setup, Key<Job> jobKey) {
        super(setup, jobKey);
        this.header = ((AvroParseSetup)setup).header;
    }

    protected final ParseWriter parseChunk(int cidx, ParseReader din, ParseWriter dout) {
        GenericDatumReader datumReader = new GenericDatumReader();
        H2OSeekableInputAdaptor sbai = new H2OSeekableInputAdaptor(cidx, din);
        DataFileReader dataFileReader = null;
        int cnt = 0;
        try {
            DataFileStream.Header fakeHeader = new DataFileReader((SeekableInput)new SeekableByteArrayInput(this.header), (DatumReader)datumReader).getHeader();
            dataFileReader = DataFileReader.openReader((SeekableInput)sbai, (DatumReader)datumReader, (DataFileStream.Header)fakeHeader, (boolean)true);
            Schema schema = dataFileReader.getSchema();
            GenericData.Record gr = new GenericData.Record(schema);
            Schema.Field[] flatSchema = AvroUtil.flatSchema(schema);
            long sync = dataFileReader.previousSync();
            if (sbai.chunkCnt == 0) {
                while (dataFileReader.hasNext() && dataFileReader.previousSync() == sync) {
                    gr = (GenericRecord)dataFileReader.next((Object)gr);
                    AvroParser.write2frame((GenericRecord)gr, this._setup.getColumnNames(), flatSchema, this._setup.getColumnTypes(), dout);
                    ++cnt;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read AVRO.", e);
        }
        Log.trace((Object[])new Object[]{String.format("Avro: ChunkIdx: %d read %d records, start at %d off, block count: %d, block size: %d", cidx, cnt, din.getChunkDataStart(cidx), dataFileReader.getBlockCount(), dataFileReader.getBlockSize())});
        return dout;
    }

    private static void write2frame(GenericRecord gr, String[] columnNames, Schema.Field[] inSchema, byte[] columnTypes, ParseWriter dout) {
        assert (inSchema.length == columnTypes.length) : "AVRO field flatenized schema has to match to parser setup";
        BufferedString bs = new BufferedString();
        block11: for (int cIdx = 0; cIdx < columnNames.length; ++cIdx) {
            int inputFieldIdx = inSchema[cIdx].pos();
            Schema.Type inputType = AvroUtil.toPrimitiveType(inSchema[cIdx].schema());
            byte targetType = columnTypes[cIdx];
            Object value = gr.get(inputFieldIdx);
            if (value == null) {
                dout.addInvalidCol(cIdx);
                continue;
            }
            switch (inputType) {
                case BOOLEAN: {
                    dout.addNumCol(cIdx, (Boolean)value != false ? 1.0 : 0.0);
                    continue block11;
                }
                case INT: {
                    dout.addNumCol(cIdx, (long)((Integer)value).intValue(), 0);
                    continue block11;
                }
                case LONG: {
                    dout.addNumCol(cIdx, ((Long)value).longValue(), 0);
                    continue block11;
                }
                case FLOAT: {
                    dout.addNumCol(cIdx, (double)((Float)value).floatValue());
                    continue block11;
                }
                case DOUBLE: {
                    dout.addNumCol(cIdx, ((Double)value).doubleValue());
                    continue block11;
                }
                case ENUM: {
                    GenericData.EnumSymbol es = (GenericData.EnumSymbol)value;
                    dout.addNumCol(cIdx, (double)es.getSchema().getEnumOrdinal(es.toString()));
                    continue block11;
                }
                case BYTES: {
                    dout.addStrCol(cIdx, bs.set(((ByteBuffer)value).array()));
                    continue block11;
                }
                case STRING: {
                    dout.addStrCol(cIdx, bs.set(((Utf8)value).getBytes()));
                    continue block11;
                }
                case NULL: {
                    dout.addInvalidCol(cIdx);
                }
            }
        }
    }

    public static ParseSetup guessSetup(byte[] bits) {
        try {
            return AvroParser.runOnPreview(bits, new AvroPreviewProcessor<ParseSetup>(){

                @Override
                public ParseSetup process(byte[] header, GenericRecord gr, long blockCount, long blockSize) {
                    return AvroParser.deriveParseSetup(header, gr, blockCount, blockSize);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Avro format was not recognized", e);
        }
    }

    static AvroInfo extractAvroInfo(byte[] bits, final ParseSetup requiredSetup) throws IOException {
        return AvroParser.runOnPreview(bits, new AvroPreviewProcessor<AvroInfo>(){

            @Override
            public AvroInfo process(byte[] header, GenericRecord gr, long blockCount, long blockSize) {
                Schema recordSchema = gr.getSchema();
                List fields = recordSchema.getFields();
                int supportedFieldCnt = 0;
                for (Schema.Field f : fields) {
                    if (!AvroUtil.isSupportedSchema(f.schema())) continue;
                    ++supportedFieldCnt;
                }
                assert (supportedFieldCnt == requiredSetup.getColumnNames().length) : "User-driven changes are not not supported in Avro format";
                String[][] domains = new String[supportedFieldCnt][];
                int i = 0;
                for (Schema.Field f : fields) {
                    Schema schema = f.schema();
                    if (!AvroUtil.isSupportedSchema(schema)) continue;
                    byte type = AvroUtil.schemaToColumnType(schema);
                    if (type == 4) {
                        domains[i] = AvroUtil.getDomain(schema);
                    }
                    ++i;
                }
                return new AvroInfo(header, blockCount, blockSize, domains);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <T> T runOnPreview(byte[] bits, AvroPreviewProcessor<T> processor) throws IOException {
        GenericDatumReader datumReader = new GenericDatumReader();
        SeekableByteArrayInput sbai = new SeekableByteArrayInput(bits);
        DataFileReader dataFileReader = null;
        dataFileReader = new DataFileReader((SeekableInput)sbai, (DatumReader)datumReader);
        int headerLen = (int)dataFileReader.previousSync();
        byte[] header = Arrays.copyOf(bits, headerLen);
        if (!dataFileReader.hasNext()) throw new RuntimeException("Empty Avro file - cannot run preview! ");
        GenericRecord gr = (GenericRecord)dataFileReader.next();
        T t = processor.process(header, gr, dataFileReader.getBlockCount(), dataFileReader.getBlockSize());
        return t;
        finally {
            try {
                if (dataFileReader != null) {
                    dataFileReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static ParseSetup deriveParseSetup(byte[] header, GenericRecord gr, long blockCount, long blockSize) {
        Schema recordSchema = gr.getSchema();
        List fields = recordSchema.getFields();
        int supportedFieldCnt = 0;
        for (Schema.Field f : fields) {
            if (!AvroUtil.isSupportedSchema(f.schema())) continue;
            ++supportedFieldCnt;
        }
        String[] names = new String[supportedFieldCnt];
        byte[] types = new byte[supportedFieldCnt];
        String[][] domains = new String[supportedFieldCnt][];
        String[] dataPreview = new String[supportedFieldCnt];
        int i = 0;
        for (Schema.Field f : fields) {
            Schema schema = f.schema();
            if (AvroUtil.isSupportedSchema(schema)) {
                names[i] = f.name();
                types[i] = AvroUtil.schemaToColumnType(schema);
                if (types[i] == 4) {
                    domains[i] = AvroUtil.getDomain(schema);
                }
                dataPreview[i] = gr.get(f.name()) != null ? gr.get(f.name()).toString() : "null";
                ++i;
                continue;
            }
            Log.warn((Object[])new Object[]{"Skipping field: " + f.name() + " because of unsupported type: " + schema.getType() + " schema: " + schema});
        }
        AvroParseSetup ps = new AvroParseSetup(supportedFieldCnt, names, types, domains, null, new String[][]{dataPreview}, header, blockSize);
        return ps;
    }

    private static interface AvroPreviewProcessor<R> {
        public R process(byte[] var1, GenericRecord var2, long var3, long var5);
    }

    static class AvroInfo {
        byte[] header;
        long firstBlockCount;
        long firstBlockSize;
        String[][] domains;

        public AvroInfo(byte[] header, long firstBlockCount, long firstBlockSize, String[][] domains) {
            this.header = header;
            this.firstBlockCount = firstBlockCount;
            this.firstBlockSize = firstBlockSize;
            this.domains = domains;
        }
    }

    public static class AvroParseSetup
    extends ParseSetup {
        final byte[] header;
        final long blockSize;

        public AvroParseSetup(int ncols, String[] columnNames, byte[] ctypes, String[][] domains, String[][] naStrings, String[][] data, byte[] header, long blockSize) {
            super(AvroParserProvider.AVRO_INFO, (byte)124, true, 1, ncols, columnNames, ctypes, domains, naStrings, data);
            this.header = header;
            this.blockSize = blockSize;
            this.setChunkSize((int)blockSize);
        }

        public AvroParseSetup(ParseSetup ps, byte[] header, long blockSize, String[][] domains) {
            super(ps);
            this.header = header;
            this.blockSize = blockSize;
            this.setDomains(domains);
            this.setChunkSize((int)blockSize);
        }

        protected Parser parser(Key jobKey) {
            return new AvroParser(this, (Key<Job>)jobKey);
        }
    }

    private static class H2OSeekableInputAdaptor
    implements SeekableInput {
        private final ParseReader din;
        private final int startCidx;
        protected int pos;
        protected int mark;
        private byte[] data;
        protected int chunkCnt;

        public H2OSeekableInputAdaptor(int cidx, ParseReader din) {
            this.din = din;
            this.startCidx = cidx;
            this.data = din.getChunkData(cidx);
            this.chunkCnt = 0;
            this.pos = this.mark = din.getChunkDataStart(cidx) > 0 ? din.getChunkDataStart(cidx) : 0;
        }

        public void seek(long p) throws IOException {
            this.reset();
            this.skip(p);
        }

        public long tell() throws IOException {
            return this.pos;
        }

        public long length() throws IOException {
            return -1L;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            this.needData(len);
            if (this.pos >= this.count()) {
                return -1;
            }
            int avail = this.count() - this.pos;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.data, this.pos, b, off, len);
            this.pos += len;
            return len;
        }

        public void close() throws IOException {
            this.data = null;
        }

        public void reset() {
            this.pos = 0;
        }

        public long skip(long n) {
            long remain = 0L;
            while ((remain = (long)(this.count() - this.pos)) < n && this.loadNextData()) {
            }
            if (n < remain) {
                remain = n < 0L ? 0L : n;
            }
            this.pos = (int)((long)this.pos + remain);
            return remain;
        }

        private int count() {
            return this.data.length;
        }

        private boolean needData(int len) {
            boolean loaded = false;
            while (this.count() - this.pos < len && (loaded = this.loadNextData())) {
            }
            return loaded;
        }

        private boolean loadNextData() {
            byte[] nextChunk = this.din.getChunkData(this.startCidx + this.chunkCnt + 1);
            if (nextChunk != null && nextChunk.length > 0) {
                this.data = ArrayUtils.append((byte[])this.data, (byte[])nextChunk);
                ++this.chunkCnt;
                Log.trace((Object[])new Object[]{String.format("Avro stream wrapper - loading another chunk: StartChunkIdx: %d, LoadedChunkCnt: %d", this.startCidx, this.chunkCnt)});
                return true;
            }
            return false;
        }
    }
}

