/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;


public class ModelMetricsMultinomialV3 extends ModelMetricsBaseV3 {

    /**
     * The R^2 for this scoring run.
     */
    public double r2;

    /**
     * The hit ratio table for this scoring run.
     */
    @SerializedName("hit_ratio_table")
    public TwoDimTableV3 hitRatioTable;

    /**
     * The ConfusionMatrix object for this scoring run.
     */
    public ConfusionMatrixV3 cm;

    /**
     * The logarithmic loss for this scoring run.
     */
    public double logloss;

    /**
     * The mean misclassification error per class.
     */
    @SerializedName("mean_per_class_error")
    public double meanPerClassError;


    /*------------------------------------------------------------------------------------------------------------------
    //                                                  INHERITED
    //------------------------------------------------------------------------------------------------------------------

    // The model used for this scoring run.
    public ModelKeyV3 model;

    // The checksum for the model used for this scoring run.
    public long modelChecksum;

    // The frame used for this scoring run.
    public FrameKeyV3 frame;

    // The checksum for the frame used for this scoring run.
    public long frameChecksum;

    // Optional description for this scoring run (to note out-of-bag, sampled data, etc.)
    public String description;

    // The category (e.g., Clustering) for the model used for this scoring run.
    public ModelCategory modelCategory;

    // The time in mS since the epoch for the start of this scoring run.
    public long scoringTime;

    // Predictions Frame.
    public FrameV3 predictions;

    // The Mean Squared Error of the prediction for this scoring run.
    public double mse;

    // The Root Mean Squared Error of the prediction for this scoring run.
    public double rmse;

    // Number of observations.
    public long nobs;

    */

    /**
     * Public constructor
     */
    public ModelMetricsMultinomialV3() {
        r2 = 0.0;
        logloss = 0.0;
        meanPerClassError = 0.0;
        modelChecksum = 0L;
        frameChecksum = 0L;
        description = "";
        scoringTime = 0L;
        mse = 0.0;
        rmse = 0.0;
        nobs = 0L;
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
