/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;

public interface Frames {

  /** 
   * Export a Frame to the given path with optional overwrite.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/Frames/{frame_id}/export")
  Call<FramesV3> export(
    @Path("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/Frames/{frame_id}/export")
  Call<FramesV3> export(@Path("frame_id") String frame_id);

  /** 
   * Return the summary metrics for a column, e.g. min, max, mean, sigma, percentiles, etc.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}/columns/{column}/summary")
  Call<FramesV3> columnSummary(
    @Path("frame_id") String frame_id,
    @Path("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}/columns/{column}/summary")
  Call<FramesV3> columnSummary(
    @Path("frame_id") String frame_id,
    @Path("column") String column
  );

  /** 
   * Return the domains for the specified categorical column ("null" if the column is not a categorical).
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}/columns/{column}/domain")
  Call<FramesV3> columnDomain(
    @Path("frame_id") String frame_id,
    @Path("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}/columns/{column}/domain")
  Call<FramesV3> columnDomain(
    @Path("frame_id") String frame_id,
    @Path("column") String column
  );

  /** 
   * Return the specified column from a Frame.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}/columns/{column}")
  Call<FramesV3> column(
    @Path("frame_id") String frame_id,
    @Path("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}/columns/{column}")
  Call<FramesV3> column(
    @Path("frame_id") String frame_id,
    @Path("column") String column
  );

  /** 
   * Return all the columns from a Frame.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}/columns")
  Call<FramesV3> columns(
    @Path("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}/columns")
  Call<FramesV3> columns(@Path("frame_id") String frame_id);

  /** 
   * Return a Frame, including the histograms, after forcing computation of rollups.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}/summary")
  Call<FramesV3> summary(
    @Path("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}/summary")
  Call<FramesV3> summary(@Path("frame_id") String frame_id);

  /** 
   * Return the specified Frame.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames/{frame_id}")
  Call<FramesV3> fetch(
    @Path("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames/{frame_id}")
  Call<FramesV3> fetch(@Path("frame_id") String frame_id);

  /** 
   * Return all Frames in the H2O distributed K/V store.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/Frames")
  Call<FramesV3> list(
    @Field("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/Frames")
  Call<FramesV3> list();

  /** 
   * Delete the specified Frame from the H2O distributed K/V store.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @DELETE("/3/Frames/{frame_id}")
  Call<FramesV3> delete(
    @Path("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @DELETE("/3/Frames/{frame_id}")
  Call<FramesV3> delete(@Path("frame_id") String frame_id);

  /** 
   * Delete all Frames from the H2O distributed K/V store.
   *   @param frame_id Name of Frame of interest
   *   @param column Name of column of interest
   *   @param row_offset Row offset to return
   *   @param row_count Number of rows to return
   *   @param column_offset Column offset to return
   *   @param column_count Number of columns to return
   *   @param find_compatible_models Find and return compatible models?
   *   @param path File output path
   *   @param force Overwrite existing file
   *   @param num_parts Number of part files to use (1=single file,-1=automatic)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @DELETE("/3/Frames")
  Call<FramesV3> deleteAll(
    @Field("frame_id") String frame_id,
    @Field("column") String column,
    @Field("row_offset") long row_offset,
    @Field("row_count") int row_count,
    @Field("column_offset") int column_offset,
    @Field("column_count") int column_count,
    @Field("find_compatible_models") boolean find_compatible_models,
    @Field("path") String path,
    @Field("force") boolean force,
    @Field("num_parts") int num_parts,
    @Field("_exclude_fields") String _exclude_fields
  );

  @DELETE("/3/Frames")
  Call<FramesV3> deleteAll();

}
