/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;

public interface PartialDependence {

  /** 
   * Create data for partial dependence plot(s) for the specified model and frame.
   *   @param model_id Model
   *   @param frame_id Frame
   *   @param cols Column(s)
   *   @param nbins Number of bins
   *   @param destination_key Key to store the destination
   */
  @FormUrlEncoded
  @POST("/3/PartialDependence/")
  Call<JobV3> makePartialDependence(
    @Field("model_id") String model_id,
    @Field("frame_id") String frame_id,
    @Field("cols") String[] cols,
    @Field("nbins") int nbins,
    @Field("destination_key") String destination_key
  );

  @FormUrlEncoded
  @POST("/3/PartialDependence/")
  Call<JobV3> makePartialDependence();

  /** 
   * Fetch partial dependence data.
   *   @param name Name (string representation) for this Key.
   *   @param type Name (string representation) for the type of Keyed this Key points to.
   *   @param URL URL for the resource that this Key points to, if one exists.
   */
  @GET("/3/PartialDependence/{name}")
  Call<PartialDependenceV3> fetchPartialDependence(
    @Path("name") String name,
    @Field("type") String type,
    @Field("URL") String URL
  );

  @GET("/3/PartialDependence/{name}")
  Call<PartialDependenceV3> fetchPartialDependence(@Path("name") String name);

}
