/*
 * Decompiled with CFR 0.152.
 */
package water.bindings.examples;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import water.bindings.pojos.ApiParseTypeValuesProvider;
import water.bindings.pojos.ColSpecifierV3;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.FramesV3;
import water.bindings.pojos.GBMParametersV3;
import water.bindings.pojos.GBMV3;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.JobV3;
import water.bindings.pojos.JobsV3;
import water.bindings.pojos.KeyV3;
import water.bindings.pojos.ModelMetricsListSchemaV3;
import water.bindings.pojos.ModelsV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;
import water.bindings.proxies.retrofit.CreateFrame;
import water.bindings.proxies.retrofit.Frames;
import water.bindings.proxies.retrofit.ImportFiles;
import water.bindings.proxies.retrofit.Jobs;
import water.bindings.proxies.retrofit.ModelBuilders;
import water.bindings.proxies.retrofit.Models;
import water.bindings.proxies.retrofit.Parse;
import water.bindings.proxies.retrofit.ParseSetup;
import water.bindings.proxies.retrofit.Predictions;

public class Example {
    public static JobV3 poll(Retrofit retrofit, String job_id) {
        Jobs jobsService = (Jobs)retrofit.create(Jobs.class);
        Response jobsResponse = null;
        int retries = 3;
        JobsV3 jobs = null;
        do {
            try {
                jobsResponse = jobsService.fetch(job_id).execute();
            }
            catch (IOException e) {
                System.err.println("Caught exception: " + e);
            }
            if (!jobsResponse.isSuccessful()) {
                if (retries-- > 0) continue;
                throw new RuntimeException("/3/Jobs/{job_id} failed 3 times.");
            }
            jobs = (JobsV3)jobsResponse.body();
            if (null == jobs.jobs || jobs.jobs.length != 1) {
                throw new RuntimeException("Failed to find Job: " + job_id);
            }
            if ("RUNNING".equals(jobs.jobs[0].status)) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ("RUNNING".equals(jobs.jobs[0].status));
        return jobs.jobs[0];
    }

    public static void gbm_example_flow() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(KeyV3.class, (Object)new KeySerializer());
        Gson gson = builder.create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("http://localhost:54321/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        ImportFiles importService = (ImportFiles)retrofit.create(ImportFiles.class);
        ParseSetup parseSetupService = (ParseSetup)retrofit.create(ParseSetup.class);
        Parse parseService = (Parse)retrofit.create(Parse.class);
        Frames framesService = (Frames)retrofit.create(Frames.class);
        Models modelsService = (Models)retrofit.create(Models.class);
        ModelBuilders modelBuildersService = (ModelBuilders)retrofit.create(ModelBuilders.class);
        Predictions predictionsService = (Predictions)retrofit.create(Predictions.class);
        JobV3 job = null;
        try {
            ImportFilesV3 importBody = (ImportFilesV3)importService.importFiles("http://s3.amazonaws.com/h2o-public-test-data/smalldata/flow_examples/arrhythmia.csv.gz", null).execute().body();
            System.out.println("import: " + importBody);
            ParseSetupV3 parseSetupBody = (ParseSetupV3)parseSetupService.guessSetup(importBody.destinationFrames, ApiParseTypeValuesProvider.GUESS, (byte)44, false, -1, null, null, null, null, 0, 0, 0, null).execute().body();
            System.out.println("parseSetupBody: " + parseSetupBody);
            ArrayList<String> source_frames = new ArrayList<String>();
            for (FrameKeyV3 frame : parseSetupBody.sourceFrames) {
                source_frames.add(frame.name);
            }
            ParseV3 parseBody = (ParseV3)parseService.parse("arrhythmia.hex", source_frames.toArray(new String[0]), parseSetupBody.parseType, parseSetupBody.separator, parseSetupBody.singleQuotes, parseSetupBody.checkHeader, parseSetupBody.numberColumns, parseSetupBody.columnNames, parseSetupBody.columnTypes, null, parseSetupBody.naStrings, parseSetupBody.chunkSize, true, true, null).execute().body();
            System.out.println("parseBody: " + parseBody);
            GBMParametersV3 gbmParms = new GBMParametersV3();
            FrameKeyV3 trainingFrame = new FrameKeyV3();
            trainingFrame.name = "arrhythmia.hex";
            gbmParms.trainingFrame = trainingFrame;
            ColSpecifierV3 responseColumn = new ColSpecifierV3();
            responseColumn.columnName = "C1";
            gbmParms.responseColumn = responseColumn;
            System.out.println("About to train GBM. . .");
            GBMV3 gbmBody = (GBMV3)ModelBuilders.Helper.trainGbm(modelBuildersService, gbmParms).execute().body();
            System.out.println("gbmBody: " + gbmBody);
            job = gbmBody.job;
            if (null == job || null == job.key) {
                throw new RuntimeException("train_gbm returned a bad Job: " + job);
            }
            job = Example.poll(retrofit, job.key.name);
            System.out.println("GBM build done.");
            KeyV3 modelKey = job.dest;
            ModelsV3 models = (ModelsV3)modelsService.fetch(modelKey.name).execute().body();
            System.out.println("models: " + models);
            System.out.println("new GBM model: " + models.models[0]);
            ModelMetricsListSchemaV3 predictions = (ModelMetricsListSchemaV3)predictionsService.predict(modelKey.name, trainingFrame.name, "predictions", null, false, false, -1, false, false, false, false, -1, false, null).execute().body();
            System.out.println("predictions: " + predictions);
        }
        catch (IOException e) {
            System.err.println("Caught exception: " + e);
        }
    }

    public static void simple_example() {
        Gson gson = new GsonBuilder().registerTypeAdapter(KeyV3.class, (Object)new KeySerializer()).create();
        Retrofit retrofit = new Retrofit.Builder().baseUrl("http://localhost:54321/").addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        CreateFrame createFrameService = (CreateFrame)retrofit.create(CreateFrame.class);
        Frames framesService = (Frames)retrofit.create(Frames.class);
        Models modelsService = (Models)retrofit.create(Models.class);
        try {
            Response all_frames_response = framesService.list().execute();
            Response all_models_response = modelsService.list().execute();
            if (all_frames_response.isSuccessful()) {
                FramesV3 all_frames = (FramesV3)all_frames_response.body();
                System.out.println("All Frames: ");
                System.out.println(all_frames);
            } else {
                System.err.println("framesService.list() failed");
            }
            if (all_models_response.isSuccessful()) {
                ModelsV3 all_models = (ModelsV3)all_models_response.body();
                System.out.println("All Models: ");
                System.out.println(all_models);
            } else {
                System.err.println("modelsService.list() failed");
            }
            Response create_frame_response = createFrameService.run(null, 1000L, 100, 42L, 42L, true, 0L, 100000L, 0.2, 100, 0.2, 32767L, 0.2, 0.5, 0.2, 0.0, 0.2, true, 2, true, null).execute();
            if (create_frame_response.isSuccessful()) {
                JobV3 job = (JobV3)create_frame_response.body();
                if (null == job || null == job.key) {
                    throw new RuntimeException("CreateFrame returned a bad Job: " + job);
                }
                job = Example.poll(retrofit, job.key.name);
                KeyV3 new_frame = job.dest;
                System.out.println("Created frame: " + new_frame);
                all_frames_response = framesService.list().execute();
                if (all_frames_response.isSuccessful()) {
                    FramesV3 all_frames = (FramesV3)all_frames_response.body();
                    System.out.println("All Frames (after createFrame): ");
                    System.out.println(all_frames);
                } else {
                    System.err.println("framesService.list() failed");
                }
                Response one_frame_response = framesService.fetch(new_frame.name).execute();
                if (one_frame_response.isSuccessful()) {
                    FramesV3 one_frames = (FramesV3)one_frame_response.body();
                    System.out.println("One Frame (after createFrame): ");
                    System.out.println(one_frames);
                } else {
                    System.err.println("framesService.fetch() failed");
                }
            } else {
                System.err.println("createFrameService.run() failed");
            }
        }
        catch (IOException e) {
            System.err.println("Caught exception: " + e);
        }
    }

    public static void main(String[] args) {
        Example.gbm_example_flow();
        Example.simple_example();
    }

    private static class KeySerializer
    implements JsonSerializer<KeyV3> {
        private KeySerializer() {
        }

        public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
            return new JsonPrimitive(key.name);
        }
    }
}

