/*
 * Decompiled with CFR 0.152.
 */
package water.bindings.examples.retrofit;

import java.io.IOException;
import java.util.UUID;
import water.bindings.H2oApi;
import water.bindings.pojos.ColSpecifierV3;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.GBMModelOutputV3;
import water.bindings.pojos.GBMModelV3;
import water.bindings.pojos.GBMParametersV3;
import water.bindings.pojos.GBMV3;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.JobV3;
import water.bindings.pojos.ModelKeyV3;
import water.bindings.pojos.ModelMetricsListSchemaV3;
import water.bindings.pojos.ModelsV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;
import water.bindings.pojos.RapidsSchemaV3;

public class GBM_Example {
    public static void gbmExampleFlow(String url) throws IOException {
        H2oApi h2o = url != null ? new H2oApi(url) : new H2oApi();
        JobV3 job = null;
        String sessionId = h2o.newSession().sessionKey;
        ImportFilesV3 importBody = h2o.importFiles("http://s3.amazonaws.com/h2o-public-test-data/smalldata/flow_examples/arrhythmia.csv.gz");
        System.out.println("import: " + importBody);
        ParseSetupV3 parseSetupBody = h2o.guessParseSetup((FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class));
        System.out.println("parseSetupBody: " + parseSetupBody);
        ParseV3 parseParms = new ParseV3();
        H2oApi.copyFields(parseParms, parseSetupBody);
        parseParms.destinationFrame = H2oApi.stringToFrameKey("arrhythmia.hex");
        parseParms.blocking = true;
        ParseV3 parseBody = h2o.parse(parseParms);
        System.out.println("parseBody: " + parseBody);
        String tmpVec = "tmp_" + UUID.randomUUID().toString();
        String splitExpr = "(,   (tmp= " + tmpVec + " (h2o.runif arrhythmia.hex 906317))" + "  (assign train " + "    (rows arrhythmia.hex (<= " + tmpVec + " 0.75)))" + "  (assign test " + "    (rows arrhythmia.hex (> " + tmpVec + " 0.75)))" + "  (rm " + tmpVec + "))";
        RapidsSchemaV3 rapidsParms = new RapidsSchemaV3();
        rapidsParms.sessionId = sessionId;
        rapidsParms.ast = splitExpr;
        h2o.rapidsExec(rapidsParms);
        GBMParametersV3 gbmParms = new GBMParametersV3();
        gbmParms.trainingFrame = H2oApi.stringToFrameKey("train");
        gbmParms.validationFrame = H2oApi.stringToFrameKey("test");
        ColSpecifierV3 responseColumn = new ColSpecifierV3();
        responseColumn.columnName = "C1";
        gbmParms.responseColumn = responseColumn;
        System.out.println("About to train GBM. . .");
        GBMV3 gbmBody = h2o.train_gbm(gbmParms);
        System.out.println("gbmBody: " + gbmBody);
        job = h2o.waitForJobCompletion(gbmBody.job.key);
        System.out.println("GBM build done.");
        ModelKeyV3 model_key = (ModelKeyV3)job.dest;
        ModelsV3 models = h2o.model(model_key);
        System.out.println("models: " + models);
        GBMModelV3 model = (GBMModelV3)models.models[0];
        System.out.println("new GBM model: " + model);
        assert (model.getClass() == GBMModelV3.class);
        assert (((GBMModelOutputV3)model.output).getClass() == GBMModelOutputV3.class);
        assert (((GBMParametersV3)model.parameters).getClass() == GBMParametersV3.class);
        ModelMetricsListSchemaV3 predict_params = new ModelMetricsListSchemaV3();
        predict_params.model = model_key;
        predict_params.frame = gbmParms.trainingFrame;
        predict_params.predictionsFrame = H2oApi.stringToFrameKey("predictions");
        ModelMetricsListSchemaV3 predictions = h2o.predict(predict_params);
        System.out.println("predictions: " + predictions);
        h2o.endSession();
    }

    public static void gbmExampleFlow() throws IOException {
        GBM_Example.gbmExampleFlow(null);
    }

    public static void main(String[] args) throws IOException {
        GBM_Example.gbmExampleFlow();
    }
}

