/*
 * Decompiled with CFR 0.152.
 */
package water.bindings.examples.retrofit;

import java.io.IOException;
import java.util.Arrays;
import water.bindings.H2oApi;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;

public class ImportPatternExample {
    public static void importPatternExample(String url) throws IOException {
        H2oApi h2o;
        H2oApi h2oApi = h2o = url != null ? new H2oApi(url) : new H2oApi();
        if (url != null) {
            h2o.setUrl(url);
        }
        Object job = null;
        String sessionId = h2o.newSession().sessionKey;
        String pattern = "prostate_0.*";
        ImportFilesV3 importBody = h2o.importFiles("../smalldata/junit/parse_folder", pattern);
        ParseSetupV3 parseSetupParams = new ParseSetupV3();
        parseSetupParams.sourceFrames = (FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class);
        parseSetupParams.checkHeader = 1;
        ParseSetupV3 parseSetupBody = h2o.guessParseSetup(parseSetupParams);
        ParseV3 parseParms = new ParseV3();
        H2oApi.copyFields(parseParms, parseSetupBody);
        parseParms.destinationFrame = H2oApi.stringToFrameKey("prostate");
        parseParms.blocking = true;
        ParseV3 parseBody = h2o.parse(parseParms);
        assert (importBody.files.length == 1);
        Object[] parsedFiles = new String[importBody.files.length];
        for (int i = 0; i < importBody.files.length; ++i) {
            parsedFiles[i] = importBody.files[i].substring(importBody.files[0].lastIndexOf("/") + 1);
        }
        String[] result = new String[]{"prostate_0.csv"};
        assert (parseBody.numberColumns == 9);
        assert (parseBody.rows == 10L);
        Object[] colNames = new String[]{"ID", "CAPSULE", "AGE", "RACE", "DPROS", "DCAPS", "PSA", "VOL", "GLEASON"};
        assert (Arrays.equals(parseBody.columnNames, colNames));
        pattern = "iris_.*_correct.*";
        importBody = h2o.importFiles("../smalldata/iris", pattern);
        parseSetupParams = new ParseSetupV3();
        parseSetupParams.sourceFrames = (FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class);
        parseSetupParams.checkHeader = 1;
        parseSetupBody = h2o.guessParseSetup(parseSetupParams);
        parseParms = new ParseV3();
        H2oApi.copyFields(parseParms, parseSetupBody);
        parseParms.destinationFrame = H2oApi.stringToFrameKey("iris");
        parseParms.blocking = true;
        parseBody = h2o.parse(parseParms);
        assert (importBody.files.length == 1);
        parsedFiles = new String[importBody.files.length];
        for (int i = 0; i < importBody.files.length; ++i) {
            parsedFiles[i] = importBody.files[i].substring(importBody.files[i].lastIndexOf("/") + 1);
        }
        Object[] result2 = new String[]{"iris_wheader_correct.csv"};
        assert (Arrays.equals(parsedFiles, result2));
        assert (parseBody.numberColumns == 5);
        assert (parseBody.rows == 150L);
        colNames = new String[]{"sepal_length", "sepal_width", "petal_length", "petal_width", "species"};
        assert (Arrays.equals(parseBody.columnNames, colNames));
        pattern = "50_.*";
        importBody = h2o.importFiles("../smalldata/gbm_test", pattern);
        parseSetupParams = new ParseSetupV3();
        parseSetupParams.sourceFrames = (FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class);
        parseSetupParams.checkHeader = 1;
        parseSetupBody = h2o.guessParseSetup(parseSetupParams);
        parseParms = new ParseV3();
        H2oApi.copyFields(parseParms, parseSetupBody);
        parseParms.destinationFrame = H2oApi.stringToFrameKey("50cat");
        parseParms.blocking = true;
        parseBody = h2o.parse(parseParms);
        assert (importBody.files.length == 2);
        parsedFiles = new String[importBody.files.length];
        for (int i = 0; i < importBody.files.length; ++i) {
            parsedFiles[i] = importBody.files[i].substring(importBody.files[i].lastIndexOf("/") + 1);
        }
        Object[] result3 = new String[]{"50_cattest_train.csv", "50_cattest_test.csv"};
        Arrays.sort(result3);
        Arrays.sort(parsedFiles);
        assert (Arrays.equals(parsedFiles, result3));
        assert (parseBody.numberColumns == 3);
        assert (parseBody.rows == 5000L);
        colNames = new String[]{"x1", "x2", "y"};
        assert (Arrays.equals(parseBody.columnNames, colNames));
        h2o.endSession();
    }

    public static void importPatternExample() throws IOException {
        ImportPatternExample.importPatternExample(null);
    }

    public static void main(String[] args) throws IOException {
        ImportPatternExample.importPatternExample();
    }
}

