/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;


public class RandomDiscreteValueSearchCriteriaV99 extends HyperSpaceSearchCriteriaV99 {

    /**
     * Seed for random number generator; set to a value other than -1 for reproducibility.
     */
    public long seed;

    /**
     * Maximum number of models to build (optional).
     */
    @SerializedName("max_models")
    public int maxModels;

    /**
     * Maximum time to spend building models (optional).
     */
    @SerializedName("max_runtime_secs")
    public double maxRuntimeSecs;

    /**
     * Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
     * stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)
     */
    @SerializedName("stopping_rounds")
    public int stoppingRounds;

    /**
     * Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)
     */
    @SerializedName("stopping_metric")
    public ScoreKeeperStoppingMetric stoppingMetric;

    /**
     * Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)
     */
    @SerializedName("stopping_tolerance")
    public double stoppingTolerance;


    /*------------------------------------------------------------------------------------------------------------------
    //                                                  INHERITED
    //------------------------------------------------------------------------------------------------------------------

    // Hyperparameter space search strategy.
    public GridHyperSpaceSearchCriteriaStrategy strategy;

    */

    /**
     * Public constructor
     */
    public RandomDiscreteValueSearchCriteriaV99() {
        seed = -1L;
        maxModels = 0;
        maxRuntimeSecs = 0.0;
        stoppingRounds = 0;
        stoppingMetric = ScoreKeeperStoppingMetric.AUTO;
        stoppingTolerance = 0.001;
        strategy = GridHyperSpaceSearchCriteriaStrategy.RandomDiscrete;
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
