/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;

public interface Leaderboards {

  /** 
   * Return all the AutoML leaderboards.
   *   @param project_name Name of project of interest
   *   @param extensions List of extension columns to add to leaderboard
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/99/Leaderboards")
  Call<LeaderboardsV99> list(
    @Query("project_name") String project_name,
    @Query("extensions") String[] extensions,
    @Query("_exclude_fields") String _exclude_fields
  );

  @GET("/99/Leaderboards")
  Call<LeaderboardsV99> list();

  /** 
   * Return the AutoML leaderboard for the given project.
   *   @param project_name Name of project of interest
   *   @param extensions List of extension columns to add to leaderboard
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/99/Leaderboards/{project_name}")
  Call<LeaderboardV99> fetch(
    @Path("project_name") String project_name,
    @Query("extensions") String[] extensions,
    @Query("_exclude_fields") String _exclude_fields
  );

  @GET("/99/Leaderboards/{project_name}")
  Call<LeaderboardV99> fetch(@Path("project_name") String project_name);

}
