/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;

public interface PartialDependence {

  /** 
   * Create data for partial dependence plot(s) for the specified model and frame.
   *   @param model_id Model
   *   @param frame_id Frame
   *   @param row_index Row Index
   *   @param cols Column(s)
   *   @param weight_column_index weight_column_index
   *   @param add_missing_na add_missing_na
   *   @param nbins Number of bins
   *   @param user_splits User define split points
   *   @param user_cols Column(s) of user defined splits
   *   @param num_user_splits Number of user defined splits per column
   *   @param col_pairs_2dpdp lists of column name pairs to plot 2D pdp for
   *   @param destination_key Key to store the destination
   *   @param targets Target classes for multinomial classification
   */
  @FormUrlEncoded
  @POST("/3/PartialDependence/")
  Call<JobV3> makePartialDependence(
    @Field("model_id") String model_id,
    @Field("frame_id") String frame_id,
    @Field("row_index") long row_index,
    @Field("cols") String[] cols,
    @Field("weight_column_index") int weight_column_index,
    @Field("add_missing_na") boolean add_missing_na,
    @Field("nbins") int nbins,
    @Field("user_splits") double[] user_splits,
    @Field("user_cols") String[] user_cols,
    @Field("num_user_splits") int[] num_user_splits,
    @Field("col_pairs_2dpdp") String[][] col_pairs_2dpdp,
    @Field("destination_key") String destination_key,
    @Field("targets") String[] targets
  );

  @FormUrlEncoded
  @POST("/3/PartialDependence/")
  Call<JobV3> makePartialDependence();

  /** 
   * Fetch partial dependence data.
   *   @param name Name (string representation) for this Key.
   *   @param type Name (string representation) for the type of Keyed this Key points to.
   *   @param URL URL for the resource that this Key points to, if one exists.
   */
  @GET("/3/PartialDependence/{name}")
  Call<PartialDependenceV3> fetchPartialDependence(
    @Path("name") String name,
    @Query("type") String type,
    @Query("URL") String URL
  );

  @GET("/3/PartialDependence/{name}")
  Call<PartialDependenceV3> fetchPartialDependence(@Path("name") String name);

}
