/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;


public class TreeV3 extends SchemaV3 {

    /**
     * Key of the model the desired tree belongs to
     */
    public ModelKeyV3 model;

    /**
     * Index of the tree in the model.
     */
    @SerializedName("tree_number")
    public int treeNumber;

    /**
     * Name of the class of the tree. Ignored for regression and binomial.
     */
    @SerializedName("tree_class")
    public String treeClass;

    /**
     * Whether to generate plain language rules.
     */
    @SerializedName("plain_language_rules")
    public TreeHandlerPlainLanguageRules plainLanguageRules;

    /**
     * Left child nodes in the tree
     */
    @SerializedName("left_children")
    public int[] leftChildren;

    /**
     * Right child nodes in the tree
     */
    @SerializedName("right_children")
    public int[] rightChildren;

    /**
     * Number of the root node
     */
    @SerializedName("root_node_id")
    public int rootNodeId;

    /**
     * Split thresholds (numeric and possibly categorical columns)
     */
    public float[] thresholds;

    /**
     * Names of the column of the split
     */
    public String[] features;

    /**
     * Which way NA Splits (LEFT, RIGHT, NA)
     */
    public String[] nas;

    /**
     * Description of the tree's nodes
     */
    public String[] descriptions;

    /**
     * Categorical levels on the edge from the parent node
     */
    public int[][] levels;

    /**
     * Prediction values on terminal nodes
     */
    public float[] predictions;

    /**
     * Plain language rules representation of a trained decision tree
     */
    @SerializedName("tree_decision_path")
    public String treeDecisionPath;

    /**
     * Plain language rules that were used in a particular prediction
     */
    @SerializedName("decision_paths")
    public String[] decisionPaths;

    /**
     * Public constructor
     */
    public TreeV3() {
        treeNumber = 0;
        treeClass = "";
        rootNodeId = 0;
        treeDecisionPath = "";
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
