/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;
import java.util.Map;


public class GridSearchSchema extends SchemaV3 {

    /**
     * Basic model builder parameters.
     */
    public ModelParametersSchemaV3 parameters;

    /**
     * Grid search parameters.
     */
    @SerializedName("hyper_parameters")
    public Map<Object,Object> hyperParameters;

    /**
     * Destination id for this grid; auto-generated if not specified.
     */
    @SerializedName("grid_id")
    public GridKeyV3 gridId;

    /**
     * Hyperparameter search criteria, including strategy and early stopping directives. If it is not given, exhaustive
     * Cartesian is used.
     */
    @SerializedName("search_criteria")
    public HyperSpaceSearchCriteriaV99 searchCriteria;

    /**
     * Level of parallelism during grid model building. 1 = sequential building (default). 0 for adaptive parallelism.
     * Any number > 1 sets the exact number of models built in parallel.
     */
    public int parallelism;

    /**
     * Path to a directory where grid will save everything necessary to resume training after cluster crash.
     */
    @SerializedName("recovery_dir")
    public String recoveryDir;

    /**
     * Key to use for the Job handling this GridSearch (internal use only).
     */
    @SerializedName("job_id")
    public JobKeyV3 jobId;

    /**
     * Number of all models generated by grid search.
     */
    @SerializedName("total_models")
    public int totalModels;

    /**
     * Job Key.
     */
    public JobV3 job;

    /**
     * Public constructor
     */
    public GridSearchSchema() {
        parallelism = 0;
        recoveryDir = "";
        totalModels = 0;
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
