/*
 * Decompiled with CFR 0.152.
 */
package water.bindings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import water.bindings.pojos.ANOVAGLMModelOutputV3;
import water.bindings.pojos.ANOVAGLMModelV3;
import water.bindings.pojos.ANOVAGLMParametersV3;
import water.bindings.pojos.ANOVAGLMV3;
import water.bindings.pojos.AboutV3;
import water.bindings.pojos.AdaBoostModelOutputV3;
import water.bindings.pojos.AdaBoostModelV3;
import water.bindings.pojos.AdaBoostParametersV3;
import water.bindings.pojos.AdaBoostV3;
import water.bindings.pojos.AggregatorModelOutputV99;
import water.bindings.pojos.AggregatorModelV99;
import water.bindings.pojos.AggregatorParametersV99;
import water.bindings.pojos.AggregatorV99;
import water.bindings.pojos.AssemblyV99;
import water.bindings.pojos.CapabilitiesV3;
import water.bindings.pojos.CloudLockV3;
import water.bindings.pojos.CloudV3;
import water.bindings.pojos.ColSpecifierV3;
import water.bindings.pojos.CoxPHModelOutputV3;
import water.bindings.pojos.CoxPHModelV3;
import water.bindings.pojos.CoxPHParametersV3;
import water.bindings.pojos.CoxPHV3;
import water.bindings.pojos.CreateFrameSimpleIV4;
import water.bindings.pojos.CreateFrameV3;
import water.bindings.pojos.DCTTransformerV3;
import water.bindings.pojos.DRFModelOutputV3;
import water.bindings.pojos.DRFModelV3;
import water.bindings.pojos.DRFParametersV3;
import water.bindings.pojos.DRFV3;
import water.bindings.pojos.DTModelOutputV3;
import water.bindings.pojos.DTModelV3;
import water.bindings.pojos.DTParametersV3;
import water.bindings.pojos.DTV3;
import water.bindings.pojos.DataInfoFrameV3;
import water.bindings.pojos.DecryptionSetupV3;
import water.bindings.pojos.DeepLearningModelOutputV3;
import water.bindings.pojos.DeepLearningModelV3;
import water.bindings.pojos.DeepLearningParametersV3;
import water.bindings.pojos.DeepLearningV3;
import water.bindings.pojos.DownloadDataV3;
import water.bindings.pojos.EndpointsListV4;
import water.bindings.pojos.ExtendedIsolationForestModelOutputV3;
import water.bindings.pojos.ExtendedIsolationForestModelV3;
import water.bindings.pojos.ExtendedIsolationForestParametersV3;
import water.bindings.pojos.ExtendedIsolationForestV3;
import water.bindings.pojos.FeatureInteractionV3;
import water.bindings.pojos.FindV3;
import water.bindings.pojos.FrameChunksV3;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.FrameLoadV3;
import water.bindings.pojos.FrameSaveV3;
import water.bindings.pojos.FrameV3;
import water.bindings.pojos.FramesListV3;
import water.bindings.pojos.FramesV3;
import water.bindings.pojos.FriedmanPopescusHV3;
import water.bindings.pojos.GAMModelOutputV3;
import water.bindings.pojos.GAMModelV3;
import water.bindings.pojos.GAMParametersV3;
import water.bindings.pojos.GAMV3;
import water.bindings.pojos.GBMModelOutputV3;
import water.bindings.pojos.GBMModelV3;
import water.bindings.pojos.GBMParametersV3;
import water.bindings.pojos.GBMV3;
import water.bindings.pojos.GLMModelOutputV3;
import water.bindings.pojos.GLMModelV3;
import water.bindings.pojos.GLMParametersV3;
import water.bindings.pojos.GLMRegularizationPathV3;
import water.bindings.pojos.GLMV3;
import water.bindings.pojos.GLRMModelOutputV3;
import water.bindings.pojos.GLRMModelV3;
import water.bindings.pojos.GLRMParametersV3;
import water.bindings.pojos.GLRMV3;
import water.bindings.pojos.GarbageCollectV3;
import water.bindings.pojos.GenericModelOutputV3;
import water.bindings.pojos.GenericModelV3;
import water.bindings.pojos.GenericParametersV3;
import water.bindings.pojos.GenericV3;
import water.bindings.pojos.GramV3;
import water.bindings.pojos.GridExportV3;
import water.bindings.pojos.GridKeyV3;
import water.bindings.pojos.GridSchemaV99;
import water.bindings.pojos.GridsV99;
import water.bindings.pojos.ImportFilesMultiV3;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.ImportHiveTableV3;
import water.bindings.pojos.ImportSQLTableV99;
import water.bindings.pojos.InfogramModelOutputV3;
import water.bindings.pojos.InfogramModelV3;
import water.bindings.pojos.InfogramParametersV3;
import water.bindings.pojos.InfogramV3;
import water.bindings.pojos.InitIDV3;
import water.bindings.pojos.InteractionV3;
import water.bindings.pojos.IsolationForestModelOutputV3;
import water.bindings.pojos.IsolationForestModelV3;
import water.bindings.pojos.IsolationForestParametersV3;
import water.bindings.pojos.IsolationForestV3;
import water.bindings.pojos.IsotonicRegressionModelOutputV3;
import water.bindings.pojos.IsotonicRegressionModelV3;
import water.bindings.pojos.IsotonicRegressionParametersV3;
import water.bindings.pojos.IsotonicRegressionV3;
import water.bindings.pojos.JStackV3;
import water.bindings.pojos.JobKeyV3;
import water.bindings.pojos.JobV3;
import water.bindings.pojos.JobV4;
import water.bindings.pojos.JobsV3;
import water.bindings.pojos.KMeansModelOutputV3;
import water.bindings.pojos.KMeansModelV3;
import water.bindings.pojos.KMeansParametersV3;
import water.bindings.pojos.KMeansV3;
import water.bindings.pojos.KeyV3;
import water.bindings.pojos.KillMinus3V3;
import water.bindings.pojos.LeaderboardV99;
import water.bindings.pojos.LeaderboardsV99;
import water.bindings.pojos.LogAndEchoV3;
import water.bindings.pojos.LogsV3;
import water.bindings.pojos.MakeGLMModelV3;
import water.bindings.pojos.MetadataV3;
import water.bindings.pojos.MissingInserterV3;
import water.bindings.pojos.ModelBuilderSchema;
import water.bindings.pojos.ModelBuildersV3;
import water.bindings.pojos.ModelExportV3;
import water.bindings.pojos.ModelIdV3;
import water.bindings.pojos.ModelImportV3;
import water.bindings.pojos.ModelKeyV3;
import water.bindings.pojos.ModelMetricsListSchemaV3;
import water.bindings.pojos.ModelMetricsMakerSchemaV3;
import water.bindings.pojos.ModelOutputSchemaV3;
import water.bindings.pojos.ModelParametersSchemaV3;
import water.bindings.pojos.ModelSchemaBaseV3;
import water.bindings.pojos.ModelSelectionModelOutputV3;
import water.bindings.pojos.ModelSelectionModelV3;
import water.bindings.pojos.ModelSelectionParametersV3;
import water.bindings.pojos.ModelSelectionV3;
import water.bindings.pojos.ModelsInfoV4;
import water.bindings.pojos.ModelsV3;
import water.bindings.pojos.NaiveBayesModelOutputV3;
import water.bindings.pojos.NaiveBayesModelV3;
import water.bindings.pojos.NaiveBayesParametersV3;
import water.bindings.pojos.NaiveBayesV3;
import water.bindings.pojos.NetworkTestV3;
import water.bindings.pojos.NodePersistentStorageV3;
import water.bindings.pojos.PCAModelOutputV3;
import water.bindings.pojos.PCAModelV3;
import water.bindings.pojos.PCAParametersV3;
import water.bindings.pojos.PCAV3;
import water.bindings.pojos.PSVMModelOutputV3;
import water.bindings.pojos.PSVMModelV3;
import water.bindings.pojos.PSVMParametersV3;
import water.bindings.pojos.PSVMV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;
import water.bindings.pojos.PartialDependenceV3;
import water.bindings.pojos.PersistS3CredentialsV3;
import water.bindings.pojos.PingV3;
import water.bindings.pojos.ProfilerV3;
import water.bindings.pojos.RapidsHelpV3;
import water.bindings.pojos.RapidsSchemaV3;
import water.bindings.pojos.RemoveAllV3;
import water.bindings.pojos.RemoveV3;
import water.bindings.pojos.ResumeV3;
import water.bindings.pojos.RuleFitModelOutputV3;
import water.bindings.pojos.RuleFitModelV3;
import water.bindings.pojos.RuleFitParametersV3;
import water.bindings.pojos.RuleFitV3;
import water.bindings.pojos.SVDModelOutputV99;
import water.bindings.pojos.SVDModelV99;
import water.bindings.pojos.SVDParametersV99;
import water.bindings.pojos.SVDV99;
import water.bindings.pojos.SaveToHiveTableV3;
import water.bindings.pojos.SessionIdV4;
import water.bindings.pojos.SessionPropertyV3;
import water.bindings.pojos.ShutdownV3;
import water.bindings.pojos.SignificantRulesV3;
import water.bindings.pojos.SplitFrameV3;
import water.bindings.pojos.StackedEnsembleModelOutputV99;
import water.bindings.pojos.StackedEnsembleModelV99;
import water.bindings.pojos.StackedEnsembleParametersV99;
import water.bindings.pojos.StackedEnsembleV99;
import water.bindings.pojos.SteamMetricsV3;
import water.bindings.pojos.StreamingSchema;
import water.bindings.pojos.TabulateV3;
import water.bindings.pojos.TargetEncoderModelOutputV3;
import water.bindings.pojos.TargetEncoderModelV3;
import water.bindings.pojos.TargetEncoderParametersV3;
import water.bindings.pojos.TargetEncoderTransformParametersV3;
import water.bindings.pojos.TargetEncoderV3;
import water.bindings.pojos.TimelineV3;
import water.bindings.pojos.TreeV3;
import water.bindings.pojos.TypeaheadV3;
import water.bindings.pojos.UnlockKeysV3;
import water.bindings.pojos.UpliftDRFModelOutputV3;
import water.bindings.pojos.UpliftDRFModelV3;
import water.bindings.pojos.UpliftDRFParametersV3;
import water.bindings.pojos.UpliftDRFV3;
import water.bindings.pojos.WaterMeterCpuTicksV3;
import water.bindings.pojos.WaterMeterIoV3;
import water.bindings.pojos.Word2VecModelAggregateMethod;
import water.bindings.pojos.Word2VecModelOutputV3;
import water.bindings.pojos.Word2VecModelV3;
import water.bindings.pojos.Word2VecParametersV3;
import water.bindings.pojos.Word2VecSynonymsV3;
import water.bindings.pojos.Word2VecTransformV3;
import water.bindings.pojos.Word2VecV3;
import water.bindings.pojos.XGBoostExecRespV3;
import water.bindings.pojos.XGBoostModelOutputV3;
import water.bindings.pojos.XGBoostModelV3;
import water.bindings.pojos.XGBoostParametersV3;
import water.bindings.pojos.XGBoostV3;
import water.bindings.proxies.retrofit.About;
import water.bindings.proxies.retrofit.Assembly;
import water.bindings.proxies.retrofit.Capabilities;
import water.bindings.proxies.retrofit.Cloud;
import water.bindings.proxies.retrofit.CloudLock;
import water.bindings.proxies.retrofit.ComputeGram;
import water.bindings.proxies.retrofit.CreateFrame;
import water.bindings.proxies.retrofit.DCTTransformer;
import water.bindings.proxies.retrofit.DKV;
import water.bindings.proxies.retrofit.DataInfoFrame;
import water.bindings.proxies.retrofit.DecryptionSetup;
import water.bindings.proxies.retrofit.DownloadDataset;
import water.bindings.proxies.retrofit.Endpoints;
import water.bindings.proxies.retrofit.FeatureInteraction;
import water.bindings.proxies.retrofit.Find;
import water.bindings.proxies.retrofit.FrameChunks;
import water.bindings.proxies.retrofit.Frames;
import water.bindings.proxies.retrofit.FriedmansPopescusH;
import water.bindings.proxies.retrofit.GarbageCollect;
import water.bindings.proxies.retrofit.GetGLMRegPath;
import water.bindings.proxies.retrofit.Grid;
import water.bindings.proxies.retrofit.Grids;
import water.bindings.proxies.retrofit.ImportFiles;
import water.bindings.proxies.retrofit.ImportFilesMulti;
import water.bindings.proxies.retrofit.ImportHiveTable;
import water.bindings.proxies.retrofit.ImportSQLTable;
import water.bindings.proxies.retrofit.InitID;
import water.bindings.proxies.retrofit.Interaction;
import water.bindings.proxies.retrofit.JStack;
import water.bindings.proxies.retrofit.Jobs;
import water.bindings.proxies.retrofit.KillMinus3;
import water.bindings.proxies.retrofit.Leaderboards;
import water.bindings.proxies.retrofit.LogAndEcho;
import water.bindings.proxies.retrofit.Logs;
import water.bindings.proxies.retrofit.MakeGLMModel;
import water.bindings.proxies.retrofit.Metadata;
import water.bindings.proxies.retrofit.MissingInserter;
import water.bindings.proxies.retrofit.ModelBuilders;
import water.bindings.proxies.retrofit.ModelMetrics;
import water.bindings.proxies.retrofit.Models;
import water.bindings.proxies.retrofit.Modelsinfo;
import water.bindings.proxies.retrofit.NetworkTest;
import water.bindings.proxies.retrofit.NodePersistentStorage;
import water.bindings.proxies.retrofit.Parse;
import water.bindings.proxies.retrofit.ParseSVMLight;
import water.bindings.proxies.retrofit.ParseSetup;
import water.bindings.proxies.retrofit.PartialDependence;
import water.bindings.proxies.retrofit.PersistS3;
import water.bindings.proxies.retrofit.Ping;
import water.bindings.proxies.retrofit.Predictions;
import water.bindings.proxies.retrofit.Profiler;
import water.bindings.proxies.retrofit.Rapids;
import water.bindings.proxies.retrofit.Recovery;
import water.bindings.proxies.retrofit.Sample;
import water.bindings.proxies.retrofit.SaveToHiveTable;
import water.bindings.proxies.retrofit.SessionProperties;
import water.bindings.proxies.retrofit.Sessions;
import water.bindings.proxies.retrofit.Shutdown;
import water.bindings.proxies.retrofit.SignificantRules;
import water.bindings.proxies.retrofit.SplitFrame;
import water.bindings.proxies.retrofit.SteamMetrics;
import water.bindings.proxies.retrofit.Tabulate;
import water.bindings.proxies.retrofit.TargetEncoderTransform;
import water.bindings.proxies.retrofit.Timeline;
import water.bindings.proxies.retrofit.Tree;
import water.bindings.proxies.retrofit.Typeahead;
import water.bindings.proxies.retrofit.UnlockKeys;
import water.bindings.proxies.retrofit.WaterMeterCpuTicks;
import water.bindings.proxies.retrofit.WaterMeterIo;
import water.bindings.proxies.retrofit.Word2VecSynonyms;
import water.bindings.proxies.retrofit.Word2VecTransform;
import water.bindings.proxies.retrofit.XGBoostExecutor;

public class H2oApi {
    public static String DEFAULT_URL = "http://localhost:54321/";
    private Retrofit retrofit;
    private String _url = DEFAULT_URL;
    private int timeout_s = 60;
    private int pollInterval_ms = 1000;

    public H2oApi() {
        this(DEFAULT_URL);
    }

    public H2oApi(String url) {
        this._url = url;
    }

    public H2oApi setUrl(String url) {
        this._url = url;
        this.retrofit = null;
        return this;
    }

    public H2oApi setTimeout(int t) {
        this.timeout_s = t;
        this.retrofit = null;
        return this;
    }

    public H2oApi setJobPollInterval(int millis) {
        this.pollInterval_ms = millis;
        return this;
    }

    public JobV3 waitForJobCompletion(JobKeyV3 jobKey) {
        return this.waitForJobCompletion(H2oApi.keyToString(jobKey));
    }

    public JobV3 waitForJobCompletion(String jobId) {
        Jobs jobService = this.getService(Jobs.class);
        Response jobsResponse = null;
        int retries = 3;
        JobsV3 jobs = null;
        do {
            try {
                Thread.sleep(this.pollInterval_ms);
                jobsResponse = jobService.fetch(jobId).execute();
            }
            catch (IOException e) {
                System.err.println("Caught exception: " + e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (jobsResponse == null || !jobsResponse.isSuccessful()) {
                if (retries-- > 0) continue;
                throw new RuntimeException("/3/Jobs/" + jobId + " failed 3 times.");
            }
            jobs = (JobsV3)jobsResponse.body();
            if (jobs.jobs != null && jobs.jobs.length == 1) continue;
            throw new RuntimeException("Failed to find Job: " + jobId);
        } while (jobs != null && jobs.jobs[0].status.equals("RUNNING"));
        return jobs == null ? null : jobs.jobs[0];
    }

    public XGBoostV3 train_xgboost() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (XGBoostV3)s.trainXgboost().execute().body();
    }

    public XGBoostV3 train_xgboost(XGBoostParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (XGBoostV3)s.trainXgboost(params.ntrees, params.maxDepth, params.minRows, params.minChildWeight, params.learnRate, params.eta, params.sampleRate, params.subsample, params.colSampleRate, params.colsampleBylevel, params.colSampleRatePerTree, params.colsampleBytree, params.colsampleBynode, params.monotoneConstraints, params.maxAbsLeafnodePred, params.maxDeltaStep, params.scoreTreeInterval, params.seed, params.minSplitImprovement, params.gamma, params.nthread, params.buildTreeOneNode, params.saveMatrixDirectory, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.maxBins, params.maxLeaves, params.treeMethod, params.growPolicy, params.booster, params.regLambda, params.regAlpha, params.quietMode, params.sampleType, params.normalizeType, params.rateDrop, params.oneDrop, params.skipDrop, params.dmatrixType, params.backend, params.gpuId, params.interactionConstraints, params.scalePosWeight, params.evalMetric, params.scoreEvalMetricOnly, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public XGBoostV3 validate_xgboost() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (XGBoostV3)s.validate_parametersXgboost().execute().body();
    }

    public XGBoostV3 validate_xgboost(XGBoostParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (XGBoostV3)s.validate_parametersXgboost(params.ntrees, params.maxDepth, params.minRows, params.minChildWeight, params.learnRate, params.eta, params.sampleRate, params.subsample, params.colSampleRate, params.colsampleBylevel, params.colSampleRatePerTree, params.colsampleBytree, params.colsampleBynode, params.monotoneConstraints, params.maxAbsLeafnodePred, params.maxDeltaStep, params.scoreTreeInterval, params.seed, params.minSplitImprovement, params.gamma, params.nthread, params.buildTreeOneNode, params.saveMatrixDirectory, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.maxBins, params.maxLeaves, params.treeMethod, params.growPolicy, params.booster, params.regLambda, params.regAlpha, params.quietMode, params.sampleType, params.normalizeType, params.rateDrop, params.oneDrop, params.skipDrop, params.dmatrixType, params.backend, params.gpuId, params.interactionConstraints, params.scalePosWeight, params.evalMetric, params.scoreEvalMetricOnly, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public XGBoostV3 grid_search_xgboost() throws IOException {
        Grid s = this.getService(Grid.class);
        return (XGBoostV3)s.trainXgboost().execute().body();
    }

    public XGBoostV3 grid_search_xgboost(XGBoostParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (XGBoostV3)s.trainXgboost(params.ntrees, params.maxDepth, params.minRows, params.minChildWeight, params.learnRate, params.eta, params.sampleRate, params.subsample, params.colSampleRate, params.colsampleBylevel, params.colSampleRatePerTree, params.colsampleBytree, params.colsampleBynode, params.monotoneConstraints, params.maxAbsLeafnodePred, params.maxDeltaStep, params.scoreTreeInterval, params.seed, params.minSplitImprovement, params.gamma, params.nthread, params.buildTreeOneNode, params.saveMatrixDirectory, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.maxBins, params.maxLeaves, params.treeMethod, params.growPolicy, params.booster, params.regLambda, params.regAlpha, params.quietMode, params.sampleType, params.normalizeType, params.rateDrop, params.oneDrop, params.skipDrop, params.dmatrixType, params.backend, params.gpuId, params.interactionConstraints, params.scalePosWeight, params.evalMetric, params.scoreEvalMetricOnly, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public XGBoostV3 grid_search_xgboost_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (XGBoostV3)s.resumeXgboost().execute().body();
    }

    public XGBoostV3 grid_search_xgboost_resume(XGBoostParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (XGBoostV3)s.resumeXgboost(params.ntrees, params.maxDepth, params.minRows, params.minChildWeight, params.learnRate, params.eta, params.sampleRate, params.subsample, params.colSampleRate, params.colsampleBylevel, params.colSampleRatePerTree, params.colsampleBytree, params.colsampleBynode, params.monotoneConstraints, params.maxAbsLeafnodePred, params.maxDeltaStep, params.scoreTreeInterval, params.seed, params.minSplitImprovement, params.gamma, params.nthread, params.buildTreeOneNode, params.saveMatrixDirectory, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.maxBins, params.maxLeaves, params.treeMethod, params.growPolicy, params.booster, params.regLambda, params.regAlpha, params.quietMode, params.sampleType, params.normalizeType, params.rateDrop, params.oneDrop, params.skipDrop, params.dmatrixType, params.backend, params.gpuId, params.interactionConstraints, params.scalePosWeight, params.evalMetric, params.scoreEvalMetricOnly, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_init() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.init().execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_init(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.init(H2oApi.keyToString(key), data).execute().body();
    }

    public StreamingSchema remote_xgb_setup() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (StreamingSchema)s.setup().execute().body();
    }

    public StreamingSchema remote_xgb_setup(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (StreamingSchema)s.setup(H2oApi.keyToString(key), data).execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_update() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.update().execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_update(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.update(H2oApi.keyToString(key), data).execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_metric() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.getEvalMetric().execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_metric(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.getEvalMetric(H2oApi.keyToString(key), data).execute().body();
    }

    public StreamingSchema remote_xgb_booster() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (StreamingSchema)s.getBooster().execute().body();
    }

    public StreamingSchema remote_xgb_booster(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (StreamingSchema)s.getBooster(H2oApi.keyToString(key), data).execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_cleanup() throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.cleanup().execute().body();
    }

    public XGBoostExecRespV3 remote_xgb_cleanup(KeyV3 key, String data) throws IOException {
        XGBoostExecutor s = this.getService(XGBoostExecutor.class);
        return (XGBoostExecRespV3)s.cleanup(H2oApi.keyToString(key), data).execute().body();
    }

    public StreamingSchema _assembly_fetch_mojo_pipeline(String assemblyId, String fileName) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (StreamingSchema)s.fetchMojoPipeline(assemblyId, fileName).execute().body();
    }

    public StreamingSchema _assembly_fetch_mojo_pipeline(AssemblyV99 params) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (StreamingSchema)s.fetchMojoPipeline(params.assemblyId, params.fileName, params.steps, H2oApi.keyToString(params.frame), params._excludeFields).execute().body();
    }

    public PersistS3CredentialsV3 set_s3_credentials(String secretKeyId, String secretAccessKey) throws IOException {
        PersistS3 s = this.getService(PersistS3.class);
        return (PersistS3CredentialsV3)s.setS3Credentials(secretKeyId, secretAccessKey).execute().body();
    }

    public PersistS3CredentialsV3 set_s3_credentials(String secretKeyId, String secretAccessKey, String sessionToken) throws IOException {
        PersistS3 s = this.getService(PersistS3.class);
        return (PersistS3CredentialsV3)s.setS3Credentials(secretKeyId, secretAccessKey, sessionToken).execute().body();
    }

    public PersistS3CredentialsV3 remove_s3_credentials(String secretKeyId, String secretAccessKey) throws IOException {
        PersistS3 s = this.getService(PersistS3.class);
        return (PersistS3CredentialsV3)s.removeS3Credentials(secretKeyId, secretAccessKey).execute().body();
    }

    public PersistS3CredentialsV3 remove_s3_credentials(String secretKeyId, String secretAccessKey, String sessionToken) throws IOException {
        PersistS3 s = this.getService(PersistS3.class);
        return (PersistS3CredentialsV3)s.removeS3Credentials(secretKeyId, secretAccessKey, sessionToken).execute().body();
    }

    public LeaderboardsV99 leaderboards() throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardsV99)s.list().execute().body();
    }

    public LeaderboardsV99 leaderboards(String projectName, String[] extensions) throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardsV99)s.list(projectName, extensions, "").execute().body();
    }

    public LeaderboardsV99 leaderboards(String projectName, String[] extensions, String _excludeFields) throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardsV99)s.list(projectName, extensions, _excludeFields).execute().body();
    }

    public LeaderboardV99 leaderboard(String projectName) throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardV99)s.fetch(projectName).execute().body();
    }

    public LeaderboardV99 leaderboard(String projectName, String[] extensions) throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardV99)s.fetch(projectName, extensions, "").execute().body();
    }

    public LeaderboardV99 leaderboard(String projectName, String[] extensions, String _excludeFields) throws IOException {
        Leaderboards s = this.getService(Leaderboards.class);
        return (LeaderboardV99)s.fetch(projectName, extensions, _excludeFields).execute().body();
    }

    public InfogramV3 train_infogram() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (InfogramV3)s.trainInfogram().execute().body();
    }

    public InfogramV3 train_infogram(InfogramParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (InfogramV3)s.trainInfogram(params.seed, params.standardize, H2oApi.keyToString(params.plugValues), params.maxIterations, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.algorithm, params.algorithmParams, params.protectedColumns, params.totalInformationThreshold, params.netInformationThreshold, params.relevanceIndexThreshold, params.safetyIndexThreshold, params.dataFraction, params.topNFeatures, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public InfogramV3 validate_infogram() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (InfogramV3)s.validate_parametersInfogram().execute().body();
    }

    public InfogramV3 validate_infogram(InfogramParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (InfogramV3)s.validate_parametersInfogram(params.seed, params.standardize, H2oApi.keyToString(params.plugValues), params.maxIterations, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.algorithm, params.algorithmParams, params.protectedColumns, params.totalInformationThreshold, params.netInformationThreshold, params.relevanceIndexThreshold, params.safetyIndexThreshold, params.dataFraction, params.topNFeatures, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public InfogramV3 grid_search_infogram() throws IOException {
        Grid s = this.getService(Grid.class);
        return (InfogramV3)s.trainInfogram().execute().body();
    }

    public InfogramV3 grid_search_infogram(InfogramParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (InfogramV3)s.trainInfogram(params.seed, params.standardize, H2oApi.keyToString(params.plugValues), params.maxIterations, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.algorithm, params.algorithmParams, params.protectedColumns, params.totalInformationThreshold, params.netInformationThreshold, params.relevanceIndexThreshold, params.safetyIndexThreshold, params.dataFraction, params.topNFeatures, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public InfogramV3 grid_search_infogram_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (InfogramV3)s.resumeInfogram().execute().body();
    }

    public InfogramV3 grid_search_infogram_resume(InfogramParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (InfogramV3)s.resumeInfogram(params.seed, params.standardize, H2oApi.keyToString(params.plugValues), params.maxIterations, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.algorithm, params.algorithmParams, params.protectedColumns, params.totalInformationThreshold, params.netInformationThreshold, params.relevanceIndexThreshold, params.safetyIndexThreshold, params.dataFraction, params.topNFeatures, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public TargetEncoderV3 train_targetencoder() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (TargetEncoderV3)s.trainTargetencoder().execute().body();
    }

    public TargetEncoderV3 train_targetencoder(TargetEncoderParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (TargetEncoderV3)s.trainTargetencoder(params.columnsToEncode, params.keepOriginalCategoricalColumns, params.blending, params.inflectionPoint, params.smoothing, params.dataLeakageHandling, params.noise, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public TargetEncoderV3 validate_targetencoder() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (TargetEncoderV3)s.validate_parametersTargetencoder().execute().body();
    }

    public TargetEncoderV3 validate_targetencoder(TargetEncoderParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (TargetEncoderV3)s.validate_parametersTargetencoder(params.columnsToEncode, params.keepOriginalCategoricalColumns, params.blending, params.inflectionPoint, params.smoothing, params.dataLeakageHandling, params.noise, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public TargetEncoderV3 grid_search_targetencoder() throws IOException {
        Grid s = this.getService(Grid.class);
        return (TargetEncoderV3)s.trainTargetencoder().execute().body();
    }

    public TargetEncoderV3 grid_search_targetencoder(TargetEncoderParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (TargetEncoderV3)s.trainTargetencoder(params.columnsToEncode, params.keepOriginalCategoricalColumns, params.blending, params.inflectionPoint, params.smoothing, params.dataLeakageHandling, params.noise, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public TargetEncoderV3 grid_search_targetencoder_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (TargetEncoderV3)s.resumeTargetencoder().execute().body();
    }

    public TargetEncoderV3 grid_search_targetencoder_resume(TargetEncoderParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (TargetEncoderV3)s.resumeTargetencoder(params.columnsToEncode, params.keepOriginalCategoricalColumns, params.blending, params.inflectionPoint, params.smoothing, params.dataLeakageHandling, params.noise, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public FrameKeyV3 target_encoder_transform() throws IOException {
        TargetEncoderTransform s = this.getService(TargetEncoderTransform.class);
        return (FrameKeyV3)s.transform().execute().body();
    }

    public FrameKeyV3 target_encoder_transform(TargetEncoderTransformParametersV3 params) throws IOException {
        TargetEncoderTransform s = this.getService(TargetEncoderTransform.class);
        return (FrameKeyV3)s.transform(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), params.asTraining, params.blending, params.inflectionPoint, params.smoothing, params.noise).execute().body();
    }

    public DeepLearningV3 train_deeplearning() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.trainDeeplearning().execute().body();
    }

    public DeepLearningV3 train_deeplearning(DeepLearningParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.trainDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DeepLearningV3 validate_deeplearning() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.validate_parametersDeeplearning().execute().body();
    }

    public DeepLearningV3 validate_deeplearning(DeepLearningParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.validate_parametersDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.trainDeeplearning().execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning(DeepLearningParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.trainDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.resumeDeeplearning().execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning_resume(DeepLearningParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.resumeDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLMV3 train_glm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.trainGlm().execute().body();
    }

    public GLMV3 train_glm(GLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.trainGlm(params.seed, params.family, params.randFamily, params.tweedieVariancePower, params.dispersionLearningRate, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, params.influence, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.dispersionParameterMethod, params.randLink, params.startval, params.randomColumns, params.calcLike, params.generateVariableInflationFactors, params.intercept, params.buildNullModel, params.fixDispersionParameter, params.initDispersionParameter, params.hglm, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.fixTweedieVariancePower, params.removeCollinearColumns, params.dispersionEpsilon, params.tweedieEpsilon, params.maxIterationsDispersion, params.generateScoringHistory, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLMV3 validate_glm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.validate_parametersGlm().execute().body();
    }

    public GLMV3 validate_glm(GLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.validate_parametersGlm(params.seed, params.family, params.randFamily, params.tweedieVariancePower, params.dispersionLearningRate, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, params.influence, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.dispersionParameterMethod, params.randLink, params.startval, params.randomColumns, params.calcLike, params.generateVariableInflationFactors, params.intercept, params.buildNullModel, params.fixDispersionParameter, params.initDispersionParameter, params.hglm, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.fixTweedieVariancePower, params.removeCollinearColumns, params.dispersionEpsilon, params.tweedieEpsilon, params.maxIterationsDispersion, params.generateScoringHistory, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLMV3 grid_search_glm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.trainGlm().execute().body();
    }

    public GLMV3 grid_search_glm(GLMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.trainGlm(params.seed, params.family, params.randFamily, params.tweedieVariancePower, params.dispersionLearningRate, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, params.influence, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.dispersionParameterMethod, params.randLink, params.startval, params.randomColumns, params.calcLike, params.generateVariableInflationFactors, params.intercept, params.buildNullModel, params.fixDispersionParameter, params.initDispersionParameter, params.hglm, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.fixTweedieVariancePower, params.removeCollinearColumns, params.dispersionEpsilon, params.tweedieEpsilon, params.maxIterationsDispersion, params.generateScoringHistory, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLMV3 grid_search_glm_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.resumeGlm().execute().body();
    }

    public GLMV3 grid_search_glm_resume(GLMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.resumeGlm(params.seed, params.family, params.randFamily, params.tweedieVariancePower, params.dispersionLearningRate, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, params.influence, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.dispersionParameterMethod, params.randLink, params.startval, params.randomColumns, params.calcLike, params.generateVariableInflationFactors, params.intercept, params.buildNullModel, params.fixDispersionParameter, params.initDispersionParameter, params.hglm, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.fixTweedieVariancePower, params.removeCollinearColumns, params.dispersionEpsilon, params.tweedieEpsilon, params.maxIterationsDispersion, params.generateScoringHistory, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLRMV3 train_glrm(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.trainGlrm(k).execute().body();
    }

    public GLRMV3 train_glrm(GLRMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.trainGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.representationName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLRMV3 validate_glrm(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.validate_parametersGlrm(k).execute().body();
    }

    public GLRMV3 validate_glrm(GLRMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.validate_parametersGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.representationName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLRMV3 grid_search_glrm(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.trainGlrm(k).execute().body();
    }

    public GLRMV3 grid_search_glrm(GLRMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.trainGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.representationName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLRMV3 grid_search_glrm_resume(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.resumeGlrm(k).execute().body();
    }

    public GLRMV3 grid_search_glrm_resume(GLRMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.resumeGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.representationName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public KMeansV3 train_kmeans() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.trainKmeans().execute().body();
    }

    public KMeansV3 train_kmeans(KMeansParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.trainKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.estimateK, params.clusterSizeConstraints, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public KMeansV3 validate_kmeans() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.validate_parametersKmeans().execute().body();
    }

    public KMeansV3 validate_kmeans(KMeansParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.validate_parametersKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.estimateK, params.clusterSizeConstraints, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public KMeansV3 grid_search_kmeans() throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.trainKmeans().execute().body();
    }

    public KMeansV3 grid_search_kmeans(KMeansParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.trainKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.estimateK, params.clusterSizeConstraints, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public KMeansV3 grid_search_kmeans_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.resumeKmeans().execute().body();
    }

    public KMeansV3 grid_search_kmeans_resume(KMeansParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.resumeKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.estimateK, params.clusterSizeConstraints, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public NaiveBayesV3 train_naivebayes() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.trainNaivebayes().execute().body();
    }

    public NaiveBayesV3 train_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.trainNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public NaiveBayesV3 validate_naivebayes() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.validate_parametersNaivebayes().execute().body();
    }

    public NaiveBayesV3 validate_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.validate_parametersNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes() throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.trainNaivebayes().execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.trainNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.resumeNaivebayes().execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes_resume(NaiveBayesParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.resumeNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PCAV3 train_pca(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.trainPca(k).execute().body();
    }

    public PCAV3 train_pca(PCAParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.trainPca(params.transform, params.pcaMethod, params.pcaImpl, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PCAV3 validate_pca(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.validate_parametersPca(k).execute().body();
    }

    public PCAV3 validate_pca(PCAParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.validate_parametersPca(params.transform, params.pcaMethod, params.pcaImpl, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PCAV3 grid_search_pca(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.trainPca(k).execute().body();
    }

    public PCAV3 grid_search_pca(PCAParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.trainPca(params.transform, params.pcaMethod, params.pcaImpl, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PCAV3 grid_search_pca_resume(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.resumePca(k).execute().body();
    }

    public PCAV3 grid_search_pca_resume(PCAParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.resumePca(params.transform, params.pcaMethod, params.pcaImpl, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public SVDV99 train_svd() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.trainSvd().execute().body();
    }

    public SVDV99 train_svd(SVDParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.trainSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public SVDV99 validate_svd() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.validate_parametersSvd().execute().body();
    }

    public SVDV99 validate_svd(SVDParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.validate_parametersSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public SVDV99 grid_search_svd() throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.trainSvd().execute().body();
    }

    public SVDV99 grid_search_svd(SVDParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.trainSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public SVDV99 grid_search_svd_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.resumeSvd().execute().body();
    }

    public SVDV99 grid_search_svd_resume(SVDParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.resumeSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DRFV3 train_drf() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.trainDrf().execute().body();
    }

    public DRFV3 train_drf(DRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.trainDrf(params.mtries, params.binomialDoubleTrees, params.sampleRate, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DRFV3 validate_drf() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.validate_parametersDrf().execute().body();
    }

    public DRFV3 validate_drf(DRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.validate_parametersDrf(params.mtries, params.binomialDoubleTrees, params.sampleRate, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DRFV3 grid_search_drf() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.trainDrf().execute().body();
    }

    public DRFV3 grid_search_drf(DRFParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.trainDrf(params.mtries, params.binomialDoubleTrees, params.sampleRate, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DRFV3 grid_search_drf_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.resumeDrf().execute().body();
    }

    public DRFV3 grid_search_drf_resume(DRFParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.resumeDrf(params.mtries, params.binomialDoubleTrees, params.sampleRate, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GBMV3 train_gbm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.trainGbm().execute().body();
    }

    public GBMV3 train_gbm(GBMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.trainGbm(params.learnRate, params.learnRateAnnealing, params.sampleRate, params.colSampleRate, params.monotoneConstraints, params.maxAbsLeafnodePred, params.predNoiseBandwidth, params.interactionConstraints, params.autoRebalance, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GBMV3 validate_gbm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.validate_parametersGbm().execute().body();
    }

    public GBMV3 validate_gbm(GBMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.validate_parametersGbm(params.learnRate, params.learnRateAnnealing, params.sampleRate, params.colSampleRate, params.monotoneConstraints, params.maxAbsLeafnodePred, params.predNoiseBandwidth, params.interactionConstraints, params.autoRebalance, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GBMV3 grid_search_gbm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.trainGbm().execute().body();
    }

    public GBMV3 grid_search_gbm(GBMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.trainGbm(params.learnRate, params.learnRateAnnealing, params.sampleRate, params.colSampleRate, params.monotoneConstraints, params.maxAbsLeafnodePred, params.predNoiseBandwidth, params.interactionConstraints, params.autoRebalance, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GBMV3 grid_search_gbm_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.resumeGbm().execute().body();
    }

    public GBMV3 grid_search_gbm_resume(GBMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.resumeGbm(params.learnRate, params.learnRateAnnealing, params.sampleRate, params.colSampleRate, params.monotoneConstraints, params.maxAbsLeafnodePred, params.predNoiseBandwidth, params.interactionConstraints, params.autoRebalance, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsolationForestV3 train_isolationforest() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsolationForestV3)s.trainIsolationforest().execute().body();
    }

    public IsolationForestV3 train_isolationforest(IsolationForestParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsolationForestV3)s.trainIsolationforest(params.sampleSize, params.sampleRate, params.mtries, params.contamination, H2oApi.colToString(params.validationResponseColumn), params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsolationForestV3 validate_isolationforest() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsolationForestV3)s.validate_parametersIsolationforest().execute().body();
    }

    public IsolationForestV3 validate_isolationforest(IsolationForestParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsolationForestV3)s.validate_parametersIsolationforest(params.sampleSize, params.sampleRate, params.mtries, params.contamination, H2oApi.colToString(params.validationResponseColumn), params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsolationForestV3 grid_search_isolationforest() throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsolationForestV3)s.trainIsolationforest().execute().body();
    }

    public IsolationForestV3 grid_search_isolationforest(IsolationForestParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsolationForestV3)s.trainIsolationforest(params.sampleSize, params.sampleRate, params.mtries, params.contamination, H2oApi.colToString(params.validationResponseColumn), params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsolationForestV3 grid_search_isolationforest_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsolationForestV3)s.resumeIsolationforest().execute().body();
    }

    public IsolationForestV3 grid_search_isolationforest_resume(IsolationForestParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsolationForestV3)s.resumeIsolationforest(params.sampleSize, params.sampleRate, params.mtries, params.contamination, H2oApi.colToString(params.validationResponseColumn), params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ExtendedIsolationForestV3 train_extendedisolationforest() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ExtendedIsolationForestV3)s.trainExtendedisolationforest().execute().body();
    }

    public ExtendedIsolationForestV3 train_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ExtendedIsolationForestV3)s.trainExtendedisolationforest(params.ntrees, params.sampleSize, params.extensionLevel, params.seed, params.scoreTreeInterval, params.disableTrainingMetrics, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ExtendedIsolationForestV3 validate_extendedisolationforest() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ExtendedIsolationForestV3)s.validate_parametersExtendedisolationforest().execute().body();
    }

    public ExtendedIsolationForestV3 validate_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ExtendedIsolationForestV3)s.validate_parametersExtendedisolationforest(params.ntrees, params.sampleSize, params.extensionLevel, params.seed, params.scoreTreeInterval, params.disableTrainingMetrics, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ExtendedIsolationForestV3 grid_search_extendedisolationforest() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ExtendedIsolationForestV3)s.trainExtendedisolationforest().execute().body();
    }

    public ExtendedIsolationForestV3 grid_search_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ExtendedIsolationForestV3)s.trainExtendedisolationforest(params.ntrees, params.sampleSize, params.extensionLevel, params.seed, params.scoreTreeInterval, params.disableTrainingMetrics, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ExtendedIsolationForestV3 grid_search_extendedisolationforest_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ExtendedIsolationForestV3)s.resumeExtendedisolationforest().execute().body();
    }

    public ExtendedIsolationForestV3 grid_search_extendedisolationforest_resume(ExtendedIsolationForestParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ExtendedIsolationForestV3)s.resumeExtendedisolationforest(params.ntrees, params.sampleSize, params.extensionLevel, params.seed, params.scoreTreeInterval, params.disableTrainingMetrics, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AggregatorV99 train_aggregator() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.trainAggregator().execute().body();
    }

    public AggregatorV99 train_aggregator(AggregatorParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.trainAggregator(params.transform, params.pcaMethod, params.k, params.maxIterations, params.targetNumExemplars, params.relTolNumExemplars, params.seed, params.useAllFactorLevels, params.saveMappingFrame, params.numIterationWithoutNewExemplar, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AggregatorV99 validate_aggregator() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.validate_parametersAggregator().execute().body();
    }

    public AggregatorV99 validate_aggregator(AggregatorParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.validate_parametersAggregator(params.transform, params.pcaMethod, params.k, params.maxIterations, params.targetNumExemplars, params.relTolNumExemplars, params.seed, params.useAllFactorLevels, params.saveMappingFrame, params.numIterationWithoutNewExemplar, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AggregatorV99 grid_search_aggregator() throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.trainAggregator().execute().body();
    }

    public AggregatorV99 grid_search_aggregator(AggregatorParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.trainAggregator(params.transform, params.pcaMethod, params.k, params.maxIterations, params.targetNumExemplars, params.relTolNumExemplars, params.seed, params.useAllFactorLevels, params.saveMappingFrame, params.numIterationWithoutNewExemplar, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AggregatorV99 grid_search_aggregator_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.resumeAggregator().execute().body();
    }

    public AggregatorV99 grid_search_aggregator_resume(AggregatorParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.resumeAggregator(params.transform, params.pcaMethod, params.k, params.maxIterations, params.targetNumExemplars, params.relTolNumExemplars, params.seed, params.useAllFactorLevels, params.saveMappingFrame, params.numIterationWithoutNewExemplar, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public Word2VecV3 train_word2vec() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (Word2VecV3)s.trainWord2vec().execute().body();
    }

    public Word2VecV3 train_word2vec(Word2VecParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (Word2VecV3)s.trainWord2vec(params.vecSize, params.windowSize, params.sentSampleRate, params.normModel, params.epochs, params.minWordFreq, params.initLearningRate, params.wordModel, H2oApi.keyToString(params.preTrained), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public Word2VecV3 validate_word2vec() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (Word2VecV3)s.validate_parametersWord2vec().execute().body();
    }

    public Word2VecV3 validate_word2vec(Word2VecParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (Word2VecV3)s.validate_parametersWord2vec(params.vecSize, params.windowSize, params.sentSampleRate, params.normModel, params.epochs, params.minWordFreq, params.initLearningRate, params.wordModel, H2oApi.keyToString(params.preTrained), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public Word2VecV3 grid_search_word2vec() throws IOException {
        Grid s = this.getService(Grid.class);
        return (Word2VecV3)s.trainWord2vec().execute().body();
    }

    public Word2VecV3 grid_search_word2vec(Word2VecParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (Word2VecV3)s.trainWord2vec(params.vecSize, params.windowSize, params.sentSampleRate, params.normModel, params.epochs, params.minWordFreq, params.initLearningRate, params.wordModel, H2oApi.keyToString(params.preTrained), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public Word2VecV3 grid_search_word2vec_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (Word2VecV3)s.resumeWord2vec().execute().body();
    }

    public Word2VecV3 grid_search_word2vec_resume(Word2VecParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (Word2VecV3)s.resumeWord2vec(params.vecSize, params.windowSize, params.sentSampleRate, params.normModel, params.epochs, params.minWordFreq, params.initLearningRate, params.wordModel, H2oApi.keyToString(params.preTrained), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public StackedEnsembleV99 train_stackedensemble(KeyV3[] baseModels) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (StackedEnsembleV99)s.trainStackedensemble(H2oApi.keyArrayToStringArray(baseModels)).execute().body();
    }

    public StackedEnsembleV99 train_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (StackedEnsembleV99)s.trainStackedensemble(H2oApi.keyArrayToStringArray(params.baseModels), params.metalearnerAlgorithm, params.metalearnerNfolds, params.metalearnerFoldAssignment, H2oApi.colToString(params.metalearnerFoldColumn), params.metalearnerTransform, params.keepLeveloneFrame, params.metalearnerParams, H2oApi.keyToString(params.blendingFrame), params.seed, params.scoreTrainingSamples, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public StackedEnsembleV99 validate_stackedensemble(KeyV3[] baseModels) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (StackedEnsembleV99)s.validate_parametersStackedensemble(H2oApi.keyArrayToStringArray(baseModels)).execute().body();
    }

    public StackedEnsembleV99 validate_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (StackedEnsembleV99)s.validate_parametersStackedensemble(H2oApi.keyArrayToStringArray(params.baseModels), params.metalearnerAlgorithm, params.metalearnerNfolds, params.metalearnerFoldAssignment, H2oApi.colToString(params.metalearnerFoldColumn), params.metalearnerTransform, params.keepLeveloneFrame, params.metalearnerParams, H2oApi.keyToString(params.blendingFrame), params.seed, params.scoreTrainingSamples, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public StackedEnsembleV99 grid_search_stackedensemble(KeyV3[] baseModels) throws IOException {
        Grid s = this.getService(Grid.class);
        return (StackedEnsembleV99)s.trainStackedensemble(H2oApi.keyArrayToStringArray(baseModels)).execute().body();
    }

    public StackedEnsembleV99 grid_search_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (StackedEnsembleV99)s.trainStackedensemble(H2oApi.keyArrayToStringArray(params.baseModels), params.metalearnerAlgorithm, params.metalearnerNfolds, params.metalearnerFoldAssignment, H2oApi.colToString(params.metalearnerFoldColumn), params.metalearnerTransform, params.keepLeveloneFrame, params.metalearnerParams, H2oApi.keyToString(params.blendingFrame), params.seed, params.scoreTrainingSamples, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public StackedEnsembleV99 grid_search_stackedensemble_resume(KeyV3[] baseModels) throws IOException {
        Grid s = this.getService(Grid.class);
        return (StackedEnsembleV99)s.resumeStackedensemble(H2oApi.keyArrayToStringArray(baseModels)).execute().body();
    }

    public StackedEnsembleV99 grid_search_stackedensemble_resume(StackedEnsembleParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (StackedEnsembleV99)s.resumeStackedensemble(H2oApi.keyArrayToStringArray(params.baseModels), params.metalearnerAlgorithm, params.metalearnerNfolds, params.metalearnerFoldAssignment, H2oApi.colToString(params.metalearnerFoldColumn), params.metalearnerTransform, params.keepLeveloneFrame, params.metalearnerParams, H2oApi.keyToString(params.blendingFrame), params.seed, params.scoreTrainingSamples, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public CoxPHV3 train_coxph() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (CoxPHV3)s.trainCoxph().execute().body();
    }

    public CoxPHV3 train_coxph(CoxPHParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (CoxPHV3)s.trainCoxph(H2oApi.colToString(params.startColumn), H2oApi.colToString(params.stopColumn), params.stratifyBy, params.ties, params.init, params.lreMin, params.maxIterations, params.interactionsOnly, params.interactions, params.interactionPairs, params.useAllFactorLevels, params.singleNodeMode, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public CoxPHV3 validate_coxph() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (CoxPHV3)s.validate_parametersCoxph().execute().body();
    }

    public CoxPHV3 validate_coxph(CoxPHParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (CoxPHV3)s.validate_parametersCoxph(H2oApi.colToString(params.startColumn), H2oApi.colToString(params.stopColumn), params.stratifyBy, params.ties, params.init, params.lreMin, params.maxIterations, params.interactionsOnly, params.interactions, params.interactionPairs, params.useAllFactorLevels, params.singleNodeMode, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public CoxPHV3 grid_search_coxph() throws IOException {
        Grid s = this.getService(Grid.class);
        return (CoxPHV3)s.trainCoxph().execute().body();
    }

    public CoxPHV3 grid_search_coxph(CoxPHParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (CoxPHV3)s.trainCoxph(H2oApi.colToString(params.startColumn), H2oApi.colToString(params.stopColumn), params.stratifyBy, params.ties, params.init, params.lreMin, params.maxIterations, params.interactionsOnly, params.interactions, params.interactionPairs, params.useAllFactorLevels, params.singleNodeMode, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public CoxPHV3 grid_search_coxph_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (CoxPHV3)s.resumeCoxph().execute().body();
    }

    public CoxPHV3 grid_search_coxph_resume(CoxPHParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (CoxPHV3)s.resumeCoxph(H2oApi.colToString(params.startColumn), H2oApi.colToString(params.stopColumn), params.stratifyBy, params.ties, params.init, params.lreMin, params.maxIterations, params.interactionsOnly, params.interactions, params.interactionPairs, params.useAllFactorLevels, params.singleNodeMode, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GenericV3 train_generic() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GenericV3)s.trainGeneric().execute().body();
    }

    public GenericV3 train_generic(GenericParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GenericV3)s.trainGeneric(params.path, H2oApi.keyToString(params.modelKey), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GenericV3 validate_generic() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GenericV3)s.validate_parametersGeneric().execute().body();
    }

    public GenericV3 validate_generic(GenericParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GenericV3)s.validate_parametersGeneric(params.path, H2oApi.keyToString(params.modelKey), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GenericV3 grid_search_generic() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GenericV3)s.trainGeneric().execute().body();
    }

    public GenericV3 grid_search_generic(GenericParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GenericV3)s.trainGeneric(params.path, H2oApi.keyToString(params.modelKey), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GenericV3 grid_search_generic_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GenericV3)s.resumeGeneric().execute().body();
    }

    public GenericV3 grid_search_generic_resume(GenericParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GenericV3)s.resumeGeneric(params.path, H2oApi.keyToString(params.modelKey), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GAMV3 train_gam(String[][] gamColumns) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GAMV3)s.trainGam(gamColumns).execute().body();
    }

    public GAMV3 train_gam(GAMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GAMV3)s.trainGam(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.startval, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.coldStart, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.storeKnotLocations, params.numKnots, params.splineOrders, params.splinesNonNegative, params.gamColumns, params.scale, params.bs, params.keepGamCols, params.standardizeTpGamCols, params.scaleTpPenaltyMat, params.knotIds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GAMV3 validate_gam(String[][] gamColumns) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GAMV3)s.validate_parametersGam(gamColumns).execute().body();
    }

    public GAMV3 validate_gam(GAMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GAMV3)s.validate_parametersGam(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.startval, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.coldStart, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.storeKnotLocations, params.numKnots, params.splineOrders, params.splinesNonNegative, params.gamColumns, params.scale, params.bs, params.keepGamCols, params.standardizeTpGamCols, params.scaleTpPenaltyMat, params.knotIds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GAMV3 grid_search_gam(String[][] gamColumns) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GAMV3)s.trainGam(gamColumns).execute().body();
    }

    public GAMV3 grid_search_gam(GAMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GAMV3)s.trainGam(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.startval, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.coldStart, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.storeKnotLocations, params.numKnots, params.splineOrders, params.splinesNonNegative, params.gamColumns, params.scale, params.bs, params.keepGamCols, params.standardizeTpGamCols, params.scaleTpPenaltyMat, params.knotIds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GAMV3 grid_search_gam_resume(String[][] gamColumns) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GAMV3)s.resumeGam(gamColumns).execute().body();
    }

    public GAMV3 grid_search_gam_resume(GAMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GAMV3)s.resumeGam(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.startval, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.coldStart, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.interactionPairs, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.storeKnotLocations, params.numKnots, params.splineOrders, params.splinesNonNegative, params.gamColumns, params.scale, params.bs, params.keepGamCols, params.standardizeTpGamCols, params.scaleTpPenaltyMat, params.knotIds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ANOVAGLMV3 train_anovaglm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ANOVAGLMV3)s.trainAnovaglm().execute().body();
    }

    public ANOVAGLMV3 train_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ANOVAGLMV3)s.trainAnovaglm(params.seed, params.standardize, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.alpha, params.lambda, params.lambdaSearch, params.solver, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.computePValues, params.maxIterations, params.link, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.highestInteractionTerm, params.type, params.earlyStopping, params.saveTransformedFramekeys, params.nparallelism, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ANOVAGLMV3 validate_anovaglm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ANOVAGLMV3)s.validate_parametersAnovaglm().execute().body();
    }

    public ANOVAGLMV3 validate_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ANOVAGLMV3)s.validate_parametersAnovaglm(params.seed, params.standardize, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.alpha, params.lambda, params.lambdaSearch, params.solver, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.computePValues, params.maxIterations, params.link, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.highestInteractionTerm, params.type, params.earlyStopping, params.saveTransformedFramekeys, params.nparallelism, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ANOVAGLMV3 grid_search_anovaglm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ANOVAGLMV3)s.trainAnovaglm().execute().body();
    }

    public ANOVAGLMV3 grid_search_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ANOVAGLMV3)s.trainAnovaglm(params.seed, params.standardize, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.alpha, params.lambda, params.lambdaSearch, params.solver, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.computePValues, params.maxIterations, params.link, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.highestInteractionTerm, params.type, params.earlyStopping, params.saveTransformedFramekeys, params.nparallelism, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ANOVAGLMV3 grid_search_anovaglm_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ANOVAGLMV3)s.resumeAnovaglm().execute().body();
    }

    public ANOVAGLMV3 grid_search_anovaglm_resume(ANOVAGLMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ANOVAGLMV3)s.resumeAnovaglm(params.seed, params.standardize, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.alpha, params.lambda, params.lambdaSearch, params.solver, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.computePValues, params.maxIterations, params.link, params.prior, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.highestInteractionTerm, params.type, params.earlyStopping, params.saveTransformedFramekeys, params.nparallelism, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PSVMV3 train_psvm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PSVMV3)s.trainPsvm().execute().body();
    }

    public PSVMV3 train_psvm(PSVMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PSVMV3)s.trainPsvm(params.hyperParam, params.kernelType, params.gamma, params.rankRatio, params.positiveWeight, params.negativeWeight, params.disableTrainingMetrics, params.svThreshold, params.maxIterations, params.factThreshold, params.feasibleThreshold, params.surrogateGapThreshold, params.muFactor, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PSVMV3 validate_psvm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PSVMV3)s.validate_parametersPsvm().execute().body();
    }

    public PSVMV3 validate_psvm(PSVMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PSVMV3)s.validate_parametersPsvm(params.hyperParam, params.kernelType, params.gamma, params.rankRatio, params.positiveWeight, params.negativeWeight, params.disableTrainingMetrics, params.svThreshold, params.maxIterations, params.factThreshold, params.feasibleThreshold, params.surrogateGapThreshold, params.muFactor, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PSVMV3 grid_search_psvm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (PSVMV3)s.trainPsvm().execute().body();
    }

    public PSVMV3 grid_search_psvm(PSVMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PSVMV3)s.trainPsvm(params.hyperParam, params.kernelType, params.gamma, params.rankRatio, params.positiveWeight, params.negativeWeight, params.disableTrainingMetrics, params.svThreshold, params.maxIterations, params.factThreshold, params.feasibleThreshold, params.surrogateGapThreshold, params.muFactor, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public PSVMV3 grid_search_psvm_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (PSVMV3)s.resumePsvm().execute().body();
    }

    public PSVMV3 grid_search_psvm_resume(PSVMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PSVMV3)s.resumePsvm(params.hyperParam, params.kernelType, params.gamma, params.rankRatio, params.positiveWeight, params.negativeWeight, params.disableTrainingMetrics, params.svThreshold, params.maxIterations, params.factThreshold, params.feasibleThreshold, params.surrogateGapThreshold, params.muFactor, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public RuleFitV3 train_rulefit() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (RuleFitV3)s.trainRulefit().execute().body();
    }

    public RuleFitV3 train_rulefit(RuleFitParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (RuleFitV3)s.trainRulefit(params.seed, params.algorithm, params.minRuleLength, params.maxRuleLength, params.maxNumRules, params.modelType, params.ruleGenerationNtrees, params.removeDuplicates, params.lambda, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public RuleFitV3 validate_rulefit() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (RuleFitV3)s.validate_parametersRulefit().execute().body();
    }

    public RuleFitV3 validate_rulefit(RuleFitParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (RuleFitV3)s.validate_parametersRulefit(params.seed, params.algorithm, params.minRuleLength, params.maxRuleLength, params.maxNumRules, params.modelType, params.ruleGenerationNtrees, params.removeDuplicates, params.lambda, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public RuleFitV3 grid_search_rulefit() throws IOException {
        Grid s = this.getService(Grid.class);
        return (RuleFitV3)s.trainRulefit().execute().body();
    }

    public RuleFitV3 grid_search_rulefit(RuleFitParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (RuleFitV3)s.trainRulefit(params.seed, params.algorithm, params.minRuleLength, params.maxRuleLength, params.maxNumRules, params.modelType, params.ruleGenerationNtrees, params.removeDuplicates, params.lambda, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public RuleFitV3 grid_search_rulefit_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (RuleFitV3)s.resumeRulefit().execute().body();
    }

    public RuleFitV3 grid_search_rulefit_resume(RuleFitParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (RuleFitV3)s.resumeRulefit(params.seed, params.algorithm, params.minRuleLength, params.maxRuleLength, params.maxNumRules, params.modelType, params.ruleGenerationNtrees, params.removeDuplicates, params.lambda, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public UpliftDRFV3 train_upliftdrf(String treatmentColumn) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (UpliftDRFV3)s.trainUpliftdrf(treatmentColumn).execute().body();
    }

    public UpliftDRFV3 train_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (UpliftDRFV3)s.trainUpliftdrf(params.mtries, params.sampleRate, params.treatmentColumn, params.upliftMetric, params.auucType, params.auucNbins, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public UpliftDRFV3 validate_upliftdrf(String treatmentColumn) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (UpliftDRFV3)s.validate_parametersUpliftdrf(treatmentColumn).execute().body();
    }

    public UpliftDRFV3 validate_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (UpliftDRFV3)s.validate_parametersUpliftdrf(params.mtries, params.sampleRate, params.treatmentColumn, params.upliftMetric, params.auucType, params.auucNbins, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public UpliftDRFV3 grid_search_upliftdrf(String treatmentColumn) throws IOException {
        Grid s = this.getService(Grid.class);
        return (UpliftDRFV3)s.trainUpliftdrf(treatmentColumn).execute().body();
    }

    public UpliftDRFV3 grid_search_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (UpliftDRFV3)s.trainUpliftdrf(params.mtries, params.sampleRate, params.treatmentColumn, params.upliftMetric, params.auucType, params.auucNbins, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public UpliftDRFV3 grid_search_upliftdrf_resume(String treatmentColumn) throws IOException {
        Grid s = this.getService(Grid.class);
        return (UpliftDRFV3)s.resumeUpliftdrf(treatmentColumn).execute().body();
    }

    public UpliftDRFV3 grid_search_upliftdrf_resume(UpliftDRFParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (UpliftDRFV3)s.resumeUpliftdrf(params.mtries, params.sampleRate, params.treatmentColumn, params.upliftMetric, params.auucType, params.auucNbins, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, params.calibrateModel, H2oApi.keyToString(params.calibrationFrame), params.calibrationMethod, params.checkConstantResponse, params.inTrainingCheckpointsDir, params.inTrainingCheckpointsTreeInterval, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ModelSelectionV3 train_modelselection() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelSelectionV3)s.trainModelselection().execute().body();
    }

    public ModelSelectionV3 train_modelselection(ModelSelectionParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelSelectionV3)s.trainModelselection(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.multinodeMode, params.buildGlmModel, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.startval, params.calcLike, params.mode, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.maxPredictorNumber, params.minPredictorNumber, params.nparallelism, params.pValuesThreshold, params.influence, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ModelSelectionV3 validate_modelselection() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelSelectionV3)s.validate_parametersModelselection().execute().body();
    }

    public ModelSelectionV3 validate_modelselection(ModelSelectionParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelSelectionV3)s.validate_parametersModelselection(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.multinodeMode, params.buildGlmModel, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.startval, params.calcLike, params.mode, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.maxPredictorNumber, params.minPredictorNumber, params.nparallelism, params.pValuesThreshold, params.influence, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ModelSelectionV3 grid_search_modelselection() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ModelSelectionV3)s.trainModelselection().execute().body();
    }

    public ModelSelectionV3 grid_search_modelselection(ModelSelectionParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ModelSelectionV3)s.trainModelselection(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.multinodeMode, params.buildGlmModel, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.startval, params.calcLike, params.mode, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.maxPredictorNumber, params.minPredictorNumber, params.nparallelism, params.pValuesThreshold, params.influence, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public ModelSelectionV3 grid_search_modelselection_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (ModelSelectionV3)s.resumeModelselection().execute().body();
    }

    public ModelSelectionV3 grid_search_modelselection_resume(ModelSelectionParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (ModelSelectionV3)s.resumeModelselection(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.theta, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.multinodeMode, params.buildGlmModel, params.earlyStopping, params.nlambdas, params.scoreIterationInterval, params.standardize, params.coldStart, params.missingValuesHandling, H2oApi.keyToString(params.plugValues), params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.startval, params.calcLike, params.mode, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.computePValues, params.removeCollinearColumns, params.maxPredictorNumber, params.minPredictorNumber, params.nparallelism, params.pValuesThreshold, params.influence, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsotonicRegressionV3 train_isotonicregression() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsotonicRegressionV3)s.trainIsotonicregression().execute().body();
    }

    public IsotonicRegressionV3 train_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsotonicRegressionV3)s.trainIsotonicregression(params.outOfBounds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsotonicRegressionV3 validate_isotonicregression() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsotonicRegressionV3)s.validate_parametersIsotonicregression().execute().body();
    }

    public IsotonicRegressionV3 validate_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (IsotonicRegressionV3)s.validate_parametersIsotonicregression(params.outOfBounds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsotonicRegressionV3 grid_search_isotonicregression() throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsotonicRegressionV3)s.trainIsotonicregression().execute().body();
    }

    public IsotonicRegressionV3 grid_search_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsotonicRegressionV3)s.trainIsotonicregression(params.outOfBounds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public IsotonicRegressionV3 grid_search_isotonicregression_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsotonicRegressionV3)s.resumeIsotonicregression().execute().body();
    }

    public IsotonicRegressionV3 grid_search_isotonicregression_resume(IsotonicRegressionParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (IsotonicRegressionV3)s.resumeIsotonicregression(params.outOfBounds, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DTV3 train_dt() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DTV3)s.trainDt().execute().body();
    }

    public DTV3 train_dt(DTParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DTV3)s.trainDt(params.seed, params.maxDepth, params.minRows, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DTV3 validate_dt() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DTV3)s.validate_parametersDt().execute().body();
    }

    public DTV3 validate_dt(DTParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DTV3)s.validate_parametersDt(params.seed, params.maxDepth, params.minRows, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DTV3 grid_search_dt() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DTV3)s.trainDt().execute().body();
    }

    public DTV3 grid_search_dt(DTParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DTV3)s.trainDt(params.seed, params.maxDepth, params.minRows, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public DTV3 grid_search_dt_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DTV3)s.resumeDt().execute().body();
    }

    public DTV3 grid_search_dt_resume(DTParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DTV3)s.resumeDt(params.seed, params.maxDepth, params.minRows, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AdaBoostV3 train_adaboost() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AdaBoostV3)s.trainAdaboost().execute().body();
    }

    public AdaBoostV3 train_adaboost(AdaBoostParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AdaBoostV3)s.trainAdaboost(params.nlearners, params.weakLearner, params.learnRate, params.weakLearnerParams, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AdaBoostV3 validate_adaboost() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AdaBoostV3)s.validate_parametersAdaboost().execute().body();
    }

    public AdaBoostV3 validate_adaboost(AdaBoostParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AdaBoostV3)s.validate_parametersAdaboost(params.nlearners, params.weakLearner, params.learnRate, params.weakLearnerParams, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AdaBoostV3 grid_search_adaboost() throws IOException {
        Grid s = this.getService(Grid.class);
        return (AdaBoostV3)s.trainAdaboost().execute().body();
    }

    public AdaBoostV3 grid_search_adaboost(AdaBoostParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (AdaBoostV3)s.trainAdaboost(params.nlearners, params.weakLearner, params.learnRate, params.weakLearnerParams, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public AdaBoostV3 grid_search_adaboost_resume() throws IOException {
        Grid s = this.getService(Grid.class);
        return (AdaBoostV3)s.resumeAdaboost().execute().body();
    }

    public AdaBoostV3 grid_search_adaboost_resume(AdaBoostParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (AdaBoostV3)s.resumeAdaboost(params.nlearners, params.weakLearner, params.learnRate, params.weakLearnerParams, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationModels, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, params.distribution, params.tweediePower, params.quantileAlpha, params.huberAlpha, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.categoricalEncoding, params.maxCategoricalLevels, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params.gainsliftBins, params.customMetricFunc, params.customDistributionFunc, params.exportCheckpointsDir, params.aucType).execute().body();
    }

    public GLMModelV3 make_glm_model(ModelKeyV3 model, String[] names, double[] beta) throws IOException {
        MakeGLMModel s = this.getService(MakeGLMModel.class);
        return (GLMModelV3)s.make_model(H2oApi.keyToString(model), names, beta).execute().body();
    }

    public GLMModelV3 make_glm_model(MakeGLMModelV3 params) throws IOException {
        MakeGLMModel s = this.getService(MakeGLMModel.class);
        return (GLMModelV3)s.make_model(H2oApi.keyToString(params.model), H2oApi.keyToString(params.dest), params.names, params.beta, params.threshold).execute().body();
    }

    public GLMRegularizationPathV3 glm_regularization_path(ModelKeyV3 model) throws IOException {
        GetGLMRegPath s = this.getService(GetGLMRegPath.class);
        return (GLMRegularizationPathV3)s.extractRegularizationPath(H2oApi.keyToString(model)).execute().body();
    }

    public GLMRegularizationPathV3 glm_regularization_path(GLMRegularizationPathV3 params) throws IOException {
        GetGLMRegPath s = this.getService(GetGLMRegPath.class);
        return (GLMRegularizationPathV3)s.extractRegularizationPath(H2oApi.keyToString(params.model), params.lambdas, params.alphas, params.explainedDevianceTrain, params.explainedDevianceValid, params.coefficients, params.coefficientsStd, params.coefficientNames, params.zValues, params.pValues, params.stdErrs).execute().body();
    }

    public GramV3 weighted_gram_matrix(FrameKeyV3 x) throws IOException {
        ComputeGram s = this.getService(ComputeGram.class);
        return (GramV3)s.computeGram(H2oApi.keyToString(x)).execute().body();
    }

    public GramV3 weighted_gram_matrix(GramV3 params) throws IOException {
        ComputeGram s = this.getService(ComputeGram.class);
        return (GramV3)s.computeGram(H2oApi.keyToString(params.x), H2oApi.colToString(params.w), params.useAllFactorLevels, params.standardize, params.skipMissing).execute().body();
    }

    public Word2VecSynonymsV3 word2vec_synonyms(ModelKeyV3 model, String word, int count) throws IOException {
        Word2VecSynonyms s = this.getService(Word2VecSynonyms.class);
        return (Word2VecSynonymsV3)s.findSynonyms(H2oApi.keyToString(model), word, count).execute().body();
    }

    public Word2VecSynonymsV3 word2vec_synonyms(Word2VecSynonymsV3 params) throws IOException {
        Word2VecSynonyms s = this.getService(Word2VecSynonyms.class);
        return (Word2VecSynonymsV3)s.findSynonyms(H2oApi.keyToString(params.model), params.word, params.count, params.synonyms, params.scores).execute().body();
    }

    public Word2VecTransformV3 word2vec_transform(ModelKeyV3 model, FrameKeyV3 wordsFrame) throws IOException {
        Word2VecTransform s = this.getService(Word2VecTransform.class);
        return (Word2VecTransformV3)s.transform(H2oApi.keyToString(model), H2oApi.keyToString(wordsFrame)).execute().body();
    }

    public Word2VecTransformV3 word2vec_transform(ModelKeyV3 model, FrameKeyV3 wordsFrame, Word2VecModelAggregateMethod aggregateMethod) throws IOException {
        Word2VecTransform s = this.getService(Word2VecTransform.class);
        return (Word2VecTransformV3)s.transform(H2oApi.keyToString(model), H2oApi.keyToString(wordsFrame), aggregateMethod).execute().body();
    }

    public DataInfoFrameV3 glm_datainfo_frame() throws IOException {
        DataInfoFrame s = this.getService(DataInfoFrame.class);
        return (DataInfoFrameV3)s.getDataInfoFrame().execute().body();
    }

    public DataInfoFrameV3 glm_datainfo_frame(DataInfoFrameV3 params) throws IOException {
        DataInfoFrame s = this.getService(DataInfoFrame.class);
        return (DataInfoFrameV3)s.getDataInfoFrame(H2oApi.keyToString(params.frame), params.interactions, params.useAll, params.standardize, params.interactionsOnly).execute().body();
    }

    public TreeV3 get_tree(ModelKeyV3 model, int treeNumber) throws IOException {
        Tree s = this.getService(Tree.class);
        return (TreeV3)s.getTree(H2oApi.keyToString(model), treeNumber).execute().body();
    }

    public TreeV3 get_tree(TreeV3 params) throws IOException {
        Tree s = this.getService(Tree.class);
        return (TreeV3)s.getTree(H2oApi.keyToString(params.model), params.treeNumber, params.treeClass, params.plainLanguageRules).execute().body();
    }

    public JobV3 createFrame() throws IOException {
        CreateFrame s = this.getService(CreateFrame.class);
        return (JobV3)s.run().execute().body();
    }

    public JobV3 createFrame(CreateFrameV3 params) throws IOException {
        CreateFrame s = this.getService(CreateFrame.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dest), params.rows, params.cols, params.seed, params.seedForColumnTypes, params.randomize, params.value, params.realRange, params.categoricalFraction, params.factors, params.integerFraction, params.integerRange, params.binaryFraction, params.binaryOnesFraction, params.timeFraction, params.stringFraction, params.missingFraction, params.hasResponse, params.responseFactors, params.positiveResponse, params._excludeFields).execute().body();
    }

    public SplitFrameV3 splitFrame() throws IOException {
        SplitFrame s = this.getService(SplitFrame.class);
        return (SplitFrameV3)s.run().execute().body();
    }

    public SplitFrameV3 splitFrame(SplitFrameV3 params) throws IOException {
        SplitFrame s = this.getService(SplitFrame.class);
        return (SplitFrameV3)s.run(H2oApi.keyToString(params.key), H2oApi.keyToString(params.dataset), params.ratios, H2oApi.keyArrayToStringArray(params.destinationFrames)).execute().body();
    }

    public JobV3 generateInteractions(int maxFactors) throws IOException {
        Interaction s = this.getService(Interaction.class);
        return (JobV3)s.run(maxFactors).execute().body();
    }

    public JobV3 generateInteractions(InteractionV3 params) throws IOException {
        Interaction s = this.getService(Interaction.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dest), H2oApi.keyToString(params.sourceFrame), params.factorColumns, params.pairwise, params.maxFactors, params.minOccurrence, params._excludeFields).execute().body();
    }

    public JobV3 _missingInserter_run(FrameKeyV3 dataset, double fraction) throws IOException {
        MissingInserter s = this.getService(MissingInserter.class);
        return (JobV3)s.run(H2oApi.keyToString(dataset), fraction).execute().body();
    }

    public JobV3 _missingInserter_run(MissingInserterV3 params) throws IOException {
        MissingInserter s = this.getService(MissingInserter.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dataset), params.fraction, params.seed, params._excludeFields).execute().body();
    }

    public JobV3 _dctTransformer_run(FrameKeyV3 dataset, int[] dimensions) throws IOException {
        DCTTransformer s = this.getService(DCTTransformer.class);
        return (JobV3)s.run(H2oApi.keyToString(dataset), dimensions).execute().body();
    }

    public JobV3 _dctTransformer_run(DCTTransformerV3 params) throws IOException {
        DCTTransformer s = this.getService(DCTTransformer.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dataset), H2oApi.keyToString(params.destinationFrame), params.dimensions, params.inverse, params._excludeFields).execute().body();
    }

    public TabulateV3 _tabulate_run(FrameKeyV3 dataset, ColSpecifierV3 predictor, ColSpecifierV3 response) throws IOException {
        Tabulate s = this.getService(Tabulate.class);
        return (TabulateV3)s.run(H2oApi.keyToString(dataset), H2oApi.colToString(predictor), H2oApi.colToString(response)).execute().body();
    }

    public TabulateV3 _tabulate_run(TabulateV3 params) throws IOException {
        Tabulate s = this.getService(Tabulate.class);
        return (TabulateV3)s.run(H2oApi.keyToString(params.dataset), H2oApi.colToString(params.predictor), H2oApi.colToString(params.response), H2oApi.colToString(params.weight), params.nbinsPredictor, params.nbinsResponse).execute().body();
    }

    public ImportFilesV3 importFiles(String path) throws IOException {
        ImportFiles s = this.getService(ImportFiles.class);
        return (ImportFilesV3)s.importFiles(path).execute().body();
    }

    public ImportFilesV3 importFiles(String path, String pattern) throws IOException {
        ImportFiles s = this.getService(ImportFiles.class);
        return (ImportFilesV3)s.importFiles(path, pattern, "").execute().body();
    }

    public ImportFilesV3 importFiles(String path, String pattern, String _excludeFields) throws IOException {
        ImportFiles s = this.getService(ImportFiles.class);
        return (ImportFilesV3)s.importFiles(path, pattern, _excludeFields).execute().body();
    }

    public ImportFilesMultiV3 importFilesMulti(String[] paths) throws IOException {
        ImportFilesMulti s = this.getService(ImportFilesMulti.class);
        return (ImportFilesMultiV3)s.importFilesMulti(paths).execute().body();
    }

    public ImportFilesMultiV3 importFilesMulti(String[] paths, String pattern) throws IOException {
        ImportFilesMulti s = this.getService(ImportFilesMulti.class);
        return (ImportFilesMultiV3)s.importFilesMulti(paths, pattern, "").execute().body();
    }

    public ImportFilesMultiV3 importFilesMulti(String[] paths, String pattern, String _excludeFields) throws IOException {
        ImportFilesMulti s = this.getService(ImportFilesMulti.class);
        return (ImportFilesMultiV3)s.importFilesMulti(paths, pattern, _excludeFields).execute().body();
    }

    public JobV3 importSqlTable(String connectionUrl, String username, String password) throws IOException {
        ImportSQLTable s = this.getService(ImportSQLTable.class);
        return (JobV3)s.importSQLTable(connectionUrl, username, password).execute().body();
    }

    public JobV3 importSqlTable(ImportSQLTableV99 params) throws IOException {
        ImportSQLTable s = this.getService(ImportSQLTable.class);
        return (JobV3)s.importSQLTable(params.connectionUrl, params.table, params.selectQuery, params.useTempTable, params.tempTableName, params.username, params.password, params.columns, params.fetchMode, params.numChunksHint, params._excludeFields).execute().body();
    }

    public JobV3 importHiveTable(String table) throws IOException {
        ImportHiveTable s = this.getService(ImportHiveTable.class);
        return (JobV3)s.importHiveTable(table).execute().body();
    }

    public JobV3 importHiveTable(ImportHiveTableV3 params) throws IOException {
        ImportHiveTable s = this.getService(ImportHiveTable.class);
        return (JobV3)s.importHiveTable(params.database, params.table, params.partitions, params.allowMultiFormat, params._excludeFields).execute().body();
    }

    public SaveToHiveTableV3 saveToHiveTable(FrameKeyV3 frameId, String jdbcUrl, String tableName) throws IOException {
        SaveToHiveTable s = this.getService(SaveToHiveTable.class);
        return (SaveToHiveTableV3)s.saveToHiveTable(H2oApi.keyToString(frameId), jdbcUrl, tableName).execute().body();
    }

    public SaveToHiveTableV3 saveToHiveTable(SaveToHiveTableV3 params) throws IOException {
        SaveToHiveTable s = this.getService(SaveToHiveTable.class);
        return (SaveToHiveTableV3)s.saveToHiveTable(H2oApi.keyToString(params.frameId), params.jdbcUrl, params.tableName, params.tablePath, params.format, params.tmpPath, params._excludeFields).execute().body();
    }

    public ParseSetupV3 guessParseSetup(FrameKeyV3[] sourceFrames) throws IOException {
        ParseSetup s = this.getService(ParseSetup.class);
        return (ParseSetupV3)s.guessSetup(H2oApi.keyArrayToStringArray(sourceFrames)).execute().body();
    }

    public ParseSetupV3 guessParseSetup(ParseSetupV3 params) throws IOException {
        ParseSetup s = this.getService(ParseSetup.class);
        return (ParseSetupV3)s.guessSetup(H2oApi.keyArrayToStringArray(params.sourceFrames), params.parseType, params.separator, params.singleQuotes, params.checkHeader, params.columnNames, params.skippedColumns, params.columnTypes, params.naStrings, params.columnNameFilter, params.columnOffset, params.columnCount, params.totalFilteredColumnCount, params.customNonDataLineMarkers, H2oApi.keyToString(params.decryptTool), params.partitionBy, params.escapechar, params.forceColTypes, params._excludeFields).execute().body();
    }

    public ParseV3 parse(ParseV3 params) throws IOException {
        Parse s = this.getService(Parse.class);
        return (ParseV3)s.parse(H2oApi.keyToString(params.destinationFrame), H2oApi.keyArrayToStringArray(params.sourceFrames), params.parseType, params.separator, params.singleQuotes, params.checkHeader, params.numberColumns, params.columnNames, params.columnTypes, params.skippedColumns, params.forceColTypes, params.domains, params.naStrings, params.chunkSize, params.deleteOnDone, params.blocking, H2oApi.keyToString(params.decryptTool), params.customNonDataLineMarkers, params.partitionBy, params.escapechar, params._excludeFields).execute().body();
    }

    public DecryptionSetupV3 setupDecryption() throws IOException {
        DecryptionSetup s = this.getService(DecryptionSetup.class);
        return (DecryptionSetupV3)s.setupDecryption().execute().body();
    }

    public DecryptionSetupV3 setupDecryption(DecryptionSetupV3 params) throws IOException {
        DecryptionSetup s = this.getService(DecryptionSetup.class);
        return (DecryptionSetupV3)s.setupDecryption(H2oApi.keyToString(params.decryptToolId), params.decryptImpl, H2oApi.keyToString(params.keystoreId), params.keystoreType, params.keyAlias, params.password, params.cipherSpec, params._excludeFields).execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3[] sourceFrames) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyArrayToStringArray(sourceFrames)).execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyToString(destinationFrame), H2oApi.keyArrayToStringArray(sourceFrames), "").execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames, String _excludeFields) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyToString(destinationFrame), H2oApi.keyArrayToStringArray(sourceFrames), _excludeFields).execute().body();
    }

    public PingV3 ping() throws IOException {
        Ping s = this.getService(Ping.class);
        return (PingV3)s.ping().execute().body();
    }

    public PingV3 ping(String _excludeFields) throws IOException {
        Ping s = this.getService(Ping.class);
        return (PingV3)s.ping(_excludeFields).execute().body();
    }

    public CloudV3 cloudStatus() throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status().execute().body();
    }

    public CloudV3 cloudStatus(boolean skipTicks) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status(skipTicks, "").execute().body();
    }

    public CloudV3 cloudStatus(boolean skipTicks, String _excludeFields) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status(skipTicks, _excludeFields).execute().body();
    }

    public CloudV3 cloudStatusMinimal() throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head().execute().body();
    }

    public CloudV3 cloudStatusMinimal(boolean skipTicks) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head(skipTicks, "").execute().body();
    }

    public CloudV3 cloudStatusMinimal(boolean skipTicks, String _excludeFields) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head(skipTicks, _excludeFields).execute().body();
    }

    public CloudLockV3 cloudLock() throws IOException {
        CloudLock s = this.getService(CloudLock.class);
        return (CloudLockV3)s.lock().execute().body();
    }

    public CloudLockV3 cloudLock(String reason) throws IOException {
        CloudLock s = this.getService(CloudLock.class);
        return (CloudLockV3)s.lock(reason, "").execute().body();
    }

    public CloudLockV3 cloudLock(String reason, String _excludeFields) throws IOException {
        CloudLock s = this.getService(CloudLock.class);
        return (CloudLockV3)s.lock(reason, _excludeFields).execute().body();
    }

    public JobsV3 jobs() throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list().execute().body();
    }

    public JobsV3 jobs(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list(H2oApi.keyToString(jobId), "").execute().body();
    }

    public JobsV3 jobs(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public TimelineV3 timeline() throws IOException {
        Timeline s = this.getService(Timeline.class);
        return (TimelineV3)s.fetch().execute().body();
    }

    public TimelineV3 timeline(String _excludeFields) throws IOException {
        Timeline s = this.getService(Timeline.class);
        return (TimelineV3)s.fetch(_excludeFields).execute().body();
    }

    public ProfilerV3 profiler(int depth) throws IOException {
        Profiler s = this.getService(Profiler.class);
        return (ProfilerV3)s.fetch(depth).execute().body();
    }

    public ProfilerV3 profiler(int depth, String _excludeFields) throws IOException {
        Profiler s = this.getService(Profiler.class);
        return (ProfilerV3)s.fetch(depth, _excludeFields).execute().body();
    }

    public JStackV3 stacktraces() throws IOException {
        JStack s = this.getService(JStack.class);
        return (JStackV3)s.fetch().execute().body();
    }

    public JStackV3 stacktraces(String _excludeFields) throws IOException {
        JStack s = this.getService(JStack.class);
        return (JStackV3)s.fetch(_excludeFields).execute().body();
    }

    public NetworkTestV3 testNetwork() throws IOException {
        NetworkTest s = this.getService(NetworkTest.class);
        return (NetworkTestV3)s.fetch().execute().body();
    }

    public NetworkTestV3 testNetwork(String _excludeFields) throws IOException {
        NetworkTest s = this.getService(NetworkTest.class);
        return (NetworkTestV3)s.fetch(_excludeFields).execute().body();
    }

    public UnlockKeysV3 unlockAllKeys() throws IOException {
        UnlockKeys s = this.getService(UnlockKeys.class);
        return (UnlockKeysV3)s.unlock().execute().body();
    }

    public UnlockKeysV3 unlockAllKeys(String _excludeFields) throws IOException {
        UnlockKeys s = this.getService(UnlockKeys.class);
        return (UnlockKeysV3)s.unlock(_excludeFields).execute().body();
    }

    public ShutdownV3 shutdownCluster() throws IOException {
        Shutdown s = this.getService(Shutdown.class);
        return (ShutdownV3)s.shutdown().execute().body();
    }

    public ShutdownV3 shutdownCluster(String _excludeFields) throws IOException {
        Shutdown s = this.getService(Shutdown.class);
        return (ShutdownV3)s.shutdown(_excludeFields).execute().body();
    }

    public AboutV3 about() throws IOException {
        About s = this.getService(About.class);
        return (AboutV3)s.get().execute().body();
    }

    public AboutV3 about(String _excludeFields) throws IOException {
        About s = this.getService(About.class);
        return (AboutV3)s.get(_excludeFields).execute().body();
    }

    public MetadataV3 endpoints() throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listRoutes().execute().body();
    }

    public MetadataV3 endpoints(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listRoutes(params.num, params.httpMethod, params.path, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 endpoint(String path) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchRoute(path).execute().body();
    }

    public MetadataV3 endpoint(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchRoute(params.path, params.num, params.httpMethod, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 schemaForClass(String classname) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadataByClass(classname).execute().body();
    }

    public MetadataV3 schemaForClass(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadataByClass(params.classname, params.num, params.httpMethod, params.path, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 schema(String schemaname) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadata(schemaname).execute().body();
    }

    public MetadataV3 schema(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadata(params.schemaname, params.num, params.httpMethod, params.path, params.classname, params._excludeFields).execute().body();
    }

    public MetadataV3 schemas() throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listSchemas().execute().body();
    }

    public MetadataV3 schemas(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listSchemas(params.num, params.httpMethod, params.path, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src).execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src, int limit) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src, limit, "").execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src, int limit, String _excludeFields) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src, limit, _excludeFields).execute().body();
    }

    public JobsV3 job(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.fetch(H2oApi.keyToString(jobId)).execute().body();
    }

    public JobsV3 job(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.fetch(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public JobsV3 cancelJob(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.cancel(H2oApi.keyToString(jobId)).execute().body();
    }

    public JobsV3 cancelJob(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.cancel(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public FindV3 findInFrame(FrameV3 key, long row) throws IOException {
        Find s = this.getService(Find.class);
        return (FindV3)s.find(key, row).execute().body();
    }

    public FindV3 findInFrame(FindV3 params) throws IOException {
        Find s = this.getService(Find.class);
        return (FindV3)s.find(params.key, params.column, params.row, params.match, params._excludeFields).execute().body();
    }

    public FramesV3 exportFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.export(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 exportFrame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.export(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FrameSaveV3 saveFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FrameSaveV3)s.save(H2oApi.keyToString(frameId)).execute().body();
    }

    public FrameSaveV3 saveFrame(FrameSaveV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FrameSaveV3)s.save(H2oApi.keyToString(params.frameId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public FrameLoadV3 loadFrame() throws IOException {
        Frames s = this.getService(Frames.class);
        return (FrameLoadV3)s.load().execute().body();
    }

    public FrameLoadV3 loadFrame(FrameLoadV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FrameLoadV3)s.load(H2oApi.keyToString(params.frameId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumnSummary(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnSummary(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumnSummary(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnSummary(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumnDomain(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnDomain(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumnDomain(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnDomain(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumn(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.column(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumn(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.column(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumns(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columns(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frameColumns(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columns(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 frameSummary(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.summary(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frameSummary(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.summary(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 lightFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetchLight(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 lightFrame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetchLight(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 frame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetch(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetch(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesListV3 frames() throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesListV3)s.list().execute().body();
    }

    public FramesListV3 frames(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesListV3)s.list(H2oApi.keyToString(frameId), "").execute().body();
    }

    public FramesListV3 frames(FrameKeyV3 frameId, String _excludeFields) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesListV3)s.list(H2oApi.keyToString(frameId), _excludeFields).execute().body();
    }

    public FramesV3 deleteFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.delete(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 deleteFrame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.delete(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FramesV3 deleteAllFrames() throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.deleteAll().execute().body();
    }

    public FramesV3 deleteAllFrames(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.deleteAll(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.fullColumnCount, params.columnCount, params.findCompatibleModels, params.path, params.force, params.numParts, params.parallel, params.format, params.compression, params.writeChecksum, params.separator, params.header, params.quoteHeader, params._excludeFields).execute().body();
    }

    public FrameChunksV3 frameChunks(FrameKeyV3 frameId) throws IOException {
        FrameChunks s = this.getService(FrameChunks.class);
        return (FrameChunksV3)s.fetch(H2oApi.keyToString(frameId)).execute().body();
    }

    public ModelsV3 model(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.fetch(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 model(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.fetch(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public ModelsV3 models() throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.list().execute().body();
    }

    public ModelsV3 models(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.list(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public ModelsV3 deleteModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.delete(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 deleteModel(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.delete(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public ModelsV3 deleteAllModels() throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.deleteAll().execute().body();
    }

    public ModelsV3 deleteAllModels(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.deleteAll(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public StreamingSchema modelPreview(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchPreview(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelPreview(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchPreview(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public StreamingSchema modelJavaCode(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchJavaCode(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelJavaCode(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchJavaCode(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public StreamingSchema modelMojo(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchMojo(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelMojo(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchMojo(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public StreamingSchema modelBinary(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchBinaryModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelBinary(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchBinaryModel(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public JobV3 makePDP() throws IOException {
        PartialDependence s = this.getService(PartialDependence.class);
        return (JobV3)s.makePartialDependence().execute().body();
    }

    public JobV3 makePDP(PartialDependenceV3 params) throws IOException {
        PartialDependence s = this.getService(PartialDependence.class);
        return (JobV3)s.makePartialDependence(H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.frameId), params.rowIndex, params.cols, params.weightColumnIndex, params.addMissingNa, params.nbins, params.userSplits, params.userCols, params.numUserSplits, params.colPairs2dpdp, H2oApi.keyToString(params.destinationKey), params.targets).execute().body();
    }

    public FeatureInteractionV3 makeFI(int maxInteractionDepth, int maxTreeDepth, int maxDeepening) throws IOException {
        FeatureInteraction s = this.getService(FeatureInteraction.class);
        return (FeatureInteractionV3)s.makeFeatureInteraction(maxInteractionDepth, maxTreeDepth, maxDeepening).execute().body();
    }

    public FeatureInteractionV3 makeFI(FeatureInteractionV3 params) throws IOException {
        FeatureInteraction s = this.getService(FeatureInteraction.class);
        return (FeatureInteractionV3)s.makeFeatureInteraction(H2oApi.keyToString(params.modelId), params.maxInteractionDepth, params.maxTreeDepth, params.maxDeepening, params._excludeFields).execute().body();
    }

    public FriedmanPopescusHV3 makeH(FrameV3 frame, String[] variables) throws IOException {
        FriedmansPopescusH s = this.getService(FriedmansPopescusH.class);
        return (FriedmanPopescusHV3)s.makeFriedmansPopescusH(frame, variables).execute().body();
    }

    public FriedmanPopescusHV3 makeH(FriedmanPopescusHV3 params) throws IOException {
        FriedmansPopescusH s = this.getService(FriedmansPopescusH.class);
        return (FriedmanPopescusHV3)s.makeFriedmansPopescusH(H2oApi.keyToString(params.modelId), params.frame, params.variables, params.h, params._excludeFields).execute().body();
    }

    public SignificantRulesV3 makeRules() throws IOException {
        SignificantRules s = this.getService(SignificantRules.class);
        return (SignificantRulesV3)s.makeSignificantRulesTable().execute().body();
    }

    public SignificantRulesV3 makeRules(ModelKeyV3 modelId) throws IOException {
        SignificantRules s = this.getService(SignificantRules.class);
        return (SignificantRulesV3)s.makeSignificantRulesTable(H2oApi.keyToString(modelId), "").execute().body();
    }

    public SignificantRulesV3 makeRules(ModelKeyV3 modelId, String _excludeFields) throws IOException {
        SignificantRules s = this.getService(SignificantRules.class);
        return (SignificantRulesV3)s.makeSignificantRulesTable(H2oApi.keyToString(modelId), _excludeFields).execute().body();
    }

    public PartialDependenceV3 fetchPDP(String name) throws IOException {
        PartialDependence s = this.getService(PartialDependence.class);
        return (PartialDependenceV3)s.fetchPartialDependence(name).execute().body();
    }

    public PartialDependenceV3 fetchPDP(String name, String type, String url) throws IOException {
        PartialDependence s = this.getService(PartialDependence.class);
        return (PartialDependenceV3)s.fetchPartialDependence(name, type, url).execute().body();
    }

    public ModelsV3 importModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.importModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 importModel(ModelImportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.importModel(H2oApi.keyToString(params.modelId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public ModelExportV3 exportModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelExportV3 exportModel(ModelExportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModel(H2oApi.keyToString(params.modelId), params.dir, params.force, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public ModelsV3 uploadModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.uploadModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 uploadModel(ModelImportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.uploadModel(H2oApi.keyToString(params.modelId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public ModelExportV3 exportMojo(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportMojo(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelExportV3 exportMojo(ModelExportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportMojo(H2oApi.keyToString(params.modelId), params.dir, params.force, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public ModelExportV3 exportModelDetails(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModelDetails(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelExportV3 exportModelDetails(ModelExportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModelDetails(H2oApi.keyToString(params.modelId), params.dir, params.force, params.exportCrossValidationPredictions, params._excludeFields).execute().body();
    }

    public GridSchemaV99 grid(GridKeyV3 gridId) throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridSchemaV99)s.fetch(H2oApi.keyToString(gridId)).execute().body();
    }

    public GridSchemaV99 grid(GridSchemaV99 params) throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridSchemaV99)s.fetch(H2oApi.keyToString(params.gridId), params.sortBy, params.decreasing, H2oApi.keyArrayToStringArray(params.modelIds)).execute().body();
    }

    public GridsV99 grids() throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridsV99)s.list().execute().body();
    }

    public ModelIdV3 newModelId(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelIdV3)s.calcModelId(algo).execute().body();
    }

    public ModelIdV3 newModelId(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelIdV3)s.calcModelId(algo, _excludeFields).execute().body();
    }

    public ModelBuildersV3 modelBuilder(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.fetch(algo).execute().body();
    }

    public ModelBuildersV3 modelBuilder(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.fetch(algo, _excludeFields).execute().body();
    }

    public ModelBuildersV3 modelBuilders() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list().execute().body();
    }

    public ModelBuildersV3 modelBuilders(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list(algo, "").execute().body();
    }

    public ModelBuildersV3 modelBuilders(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list(algo, _excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmFetch1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.fetch(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmFetch1(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.fetch(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), H2oApi.keyToString(params.deviancesFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.deepFeaturesHiddenLayerName, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.leafNodeAssignmentType, params.predictStagedProba, params.predictContributions, params.rowToTreeAssignment, params.predictContributionsOutputFormat, params.topN, params.bottomN, params.compareAbs, params.featureFrequencies, params.exemplarIndex, params.deviances, params.customMetricFunc, params.aucType, params.auucType, params.customAuucThresholds, params.auucNbins, H2oApi.keyToString(params.backgroundFrame), params.outputSpace, params.outputPerReference, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmDelete1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.delete(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmDelete1(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.delete(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), H2oApi.keyToString(params.deviancesFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.deepFeaturesHiddenLayerName, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.leafNodeAssignmentType, params.predictStagedProba, params.predictContributions, params.rowToTreeAssignment, params.predictContributionsOutputFormat, params.topN, params.bottomN, params.compareAbs, params.featureFrequencies, params.exemplarIndex, params.deviances, params.customMetricFunc, params.aucType, params.auucType, params.customAuucThresholds, params.auucNbins, H2oApi.keyToString(params.backgroundFrame), params.outputSpace, params.outputPerReference, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 score(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.score(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 score(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.score(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), H2oApi.keyToString(params.deviancesFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.deepFeaturesHiddenLayerName, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.leafNodeAssignmentType, params.predictStagedProba, params.predictContributions, params.rowToTreeAssignment, params.predictContributionsOutputFormat, params.topN, params.bottomN, params.compareAbs, params.featureFrequencies, params.exemplarIndex, params.deviances, params.customMetricFunc, params.aucType, params.auucType, params.customAuucThresholds, params.auucNbins, H2oApi.keyToString(params.backgroundFrame), params.outputSpace, params.outputPerReference, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 predict(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (ModelMetricsListSchemaV3)s.predict(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 predict(ModelMetricsListSchemaV3 params) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (ModelMetricsListSchemaV3)s.predict(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), H2oApi.keyToString(params.deviancesFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.deepFeaturesHiddenLayerName, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.leafNodeAssignmentType, params.predictStagedProba, params.predictContributions, params.rowToTreeAssignment, params.predictContributionsOutputFormat, params.topN, params.bottomN, params.compareAbs, params.featureFrequencies, params.exemplarIndex, params.deviances, params.customMetricFunc, params.aucType, params.auucType, params.customAuucThresholds, params.auucNbins, H2oApi.keyToString(params.backgroundFrame), params.outputSpace, params.outputPerReference, params._excludeFields).execute().body();
    }

    public JobV3 predict_async(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (JobV3)s.predictAsync(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public JobV3 predict_async(ModelMetricsListSchemaV3 params) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (JobV3)s.predictAsync(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), H2oApi.keyToString(params.deviancesFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.deepFeaturesHiddenLayerName, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.leafNodeAssignmentType, params.predictStagedProba, params.predictContributions, params.rowToTreeAssignment, params.predictContributionsOutputFormat, params.topN, params.bottomN, params.compareAbs, params.featureFrequencies, params.exemplarIndex, params.deviances, params.customMetricFunc, params.aucType, params.auucType, params.customAuucThresholds, params.auucNbins, H2oApi.keyToString(params.backgroundFrame), params.outputSpace, params.outputPerReference, params._excludeFields).execute().body();
    }

    public ModelMetricsMakerSchemaV3 makeMetrics(String predictionsFrame, String actualsFrame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsMakerSchemaV3)s.make(predictionsFrame, actualsFrame).execute().body();
    }

    public ModelMetricsMakerSchemaV3 makeMetrics(ModelMetricsMakerSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsMakerSchemaV3)s.make(params.predictionsFrame, params.actualsFrame, params.weightsFrame, params.treatmentFrame, params.domain, params.distribution, params.aucType, params.auucType, params.auucNbins, params.customAuucThresholds).execute().body();
    }

    public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx) throws IOException {
        WaterMeterCpuTicks s = this.getService(WaterMeterCpuTicks.class);
        return (WaterMeterCpuTicksV3)s.fetch(nodeidx).execute().body();
    }

    public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterCpuTicks s = this.getService(WaterMeterCpuTicks.class);
        return (WaterMeterCpuTicksV3)s.fetch(nodeidx, _excludeFields).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForNode(int nodeidx) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch(nodeidx).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForNode(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch(nodeidx, _excludeFields).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster() throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all().execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all(nodeidx, "").execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all(nodeidx, _excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsContains(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.exists(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsContains(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.exists(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsEnabled() throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.configured().execute().body();
    }

    public NodePersistentStorageV3 npsEnabled(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.configured(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsPut(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put_with_name(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsPut(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put_with_name(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsGet(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.get_as_string(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsGet(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.get_as_string(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsRemove(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.delete(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsRemove(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.delete(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsCreateCategory(String category) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put(category).execute().body();
    }

    public NodePersistentStorageV3 npsCreateCategory(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsKeys(String category) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.list(category).execute().body();
    }

    public NodePersistentStorageV3 npsKeys(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.list(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public LogsV3 logs(String nodeidx, String name) throws IOException {
        Logs s = this.getService(Logs.class);
        return (LogsV3)s.fetch(nodeidx, name).execute().body();
    }

    public LogsV3 logs(String nodeidx, String name, String _excludeFields) throws IOException {
        Logs s = this.getService(Logs.class);
        return (LogsV3)s.fetch(nodeidx, name, _excludeFields).execute().body();
    }

    public KillMinus3V3 logThreadDump() throws IOException {
        KillMinus3 s = this.getService(KillMinus3.class);
        return (KillMinus3V3)s.killm3().execute().body();
    }

    public KillMinus3V3 logThreadDump(String _excludeFields) throws IOException {
        KillMinus3 s = this.getService(KillMinus3.class);
        return (KillMinus3V3)s.killm3(_excludeFields).execute().body();
    }

    public RapidsSchemaV3 rapidsExec(String ast) throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsSchemaV3)s.rapidsExec(ast).execute().body();
    }

    public RapidsSchemaV3 rapidsExec(RapidsSchemaV3 params) throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsSchemaV3)s.rapidsExec(params.ast, params.sessionId, params.id, params._excludeFields).execute().body();
    }

    public AssemblyV99 _assembly_toJava(String assemblyId, String fileName) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.toJava(assemblyId, fileName).execute().body();
    }

    public AssemblyV99 _assembly_toJava(AssemblyV99 params) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.toJava(params.assemblyId, params.fileName, params.steps, H2oApi.keyToString(params.frame), params._excludeFields).execute().body();
    }

    public AssemblyV99 _assembly_fit() throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.fit().execute().body();
    }

    public AssemblyV99 _assembly_fit(AssemblyV99 params) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.fit(params.steps, H2oApi.keyToString(params.frame), params.fileName, params.assemblyId, params._excludeFields).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId)).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId), hexString, "").execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId), hexString, _excludeFields).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId)).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId), hexString, "").execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId), hexString, _excludeFields).execute().body();
    }

    public RemoveV3 deleteKey(KeyV3 key) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveV3)s.remove(H2oApi.keyToString(key)).execute().body();
    }

    public RemoveV3 deleteKey(KeyV3 key, boolean cascade) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveV3)s.remove(H2oApi.keyToString(key), cascade, "").execute().body();
    }

    public RemoveV3 deleteKey(KeyV3 key, boolean cascade, String _excludeFields) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveV3)s.remove(H2oApi.keyToString(key), cascade, _excludeFields).execute().body();
    }

    public RemoveAllV3 deleteAllKeys() throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveAllV3)s.removeAll().execute().body();
    }

    public RemoveAllV3 deleteAllKeys(KeyV3[] retainedKeys) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveAllV3)s.removeAll(H2oApi.keyArrayToStringArray(retainedKeys), "").execute().body();
    }

    public RemoveAllV3 deleteAllKeys(KeyV3[] retainedKeys, String _excludeFields) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveAllV3)s.removeAll(H2oApi.keyArrayToStringArray(retainedKeys), _excludeFields).execute().body();
    }

    public LogAndEchoV3 logAndEcho() throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo().execute().body();
    }

    public LogAndEchoV3 logAndEcho(String message) throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo(message, "").execute().body();
    }

    public LogAndEchoV3 logAndEcho(String message, String _excludeFields) throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo(message, _excludeFields).execute().body();
    }

    public InitIDV3 newSession() throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.startSession().execute().body();
    }

    public InitIDV3 newSession(String sessionKey) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.startSession(sessionKey, "").execute().body();
    }

    public InitIDV3 newSession(String sessionKey, String _excludeFields) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.startSession(sessionKey, _excludeFields).execute().body();
    }

    public InitIDV3 endSession() throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.endSession().execute().body();
    }

    public InitIDV3 endSession(String sessionKey) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.endSession(sessionKey, "").execute().body();
    }

    public InitIDV3 endSession(String sessionKey, String _excludeFields) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.endSession(sessionKey, _excludeFields).execute().body();
    }

    public SessionPropertyV3 setSessionProperty() throws IOException {
        SessionProperties s = this.getService(SessionProperties.class);
        return (SessionPropertyV3)s.setSessionProperty().execute().body();
    }

    public SessionPropertyV3 setSessionProperty(SessionPropertyV3 params) throws IOException {
        SessionProperties s = this.getService(SessionProperties.class);
        return (SessionPropertyV3)s.setSessionProperty(params.sessionKey, params.key, params.value, params._excludeFields).execute().body();
    }

    public SessionPropertyV3 getSessionProperty() throws IOException {
        SessionProperties s = this.getService(SessionProperties.class);
        return (SessionPropertyV3)s.getSessionProperty().execute().body();
    }

    public SessionPropertyV3 getSessionProperty(SessionPropertyV3 params) throws IOException {
        SessionProperties s = this.getService(SessionProperties.class);
        return (SessionPropertyV3)s.getSessionProperty(params.sessionKey, params.key, params.value, params._excludeFields).execute().body();
    }

    public GarbageCollectV3 garbageCollect() throws IOException {
        GarbageCollect s = this.getService(GarbageCollect.class);
        return (GarbageCollectV3)s.gc().execute().body();
    }

    public CloudV3 _sample_status() throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status().execute().body();
    }

    public CloudV3 _sample_status(boolean skipTicks) throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status(skipTicks, "").execute().body();
    }

    public CloudV3 _sample_status(boolean skipTicks, String _excludeFields) throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status(skipTicks, _excludeFields).execute().body();
    }

    public RapidsHelpV3 rapids_help() throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsHelpV3)s.genHelp().execute().body();
    }

    public SteamMetricsV3 steamMetrics() throws IOException {
        SteamMetrics s = this.getService(SteamMetrics.class);
        return (SteamMetricsV3)s.fetch().execute().body();
    }

    public SteamMetricsV3 steamMetrics(String _excludeFields) throws IOException {
        SteamMetrics s = this.getService(SteamMetrics.class);
        return (SteamMetricsV3)s.fetch(_excludeFields).execute().body();
    }

    public CapabilitiesV3 list_all_capabilities() throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listAll().execute().body();
    }

    public CapabilitiesV3 list_all_capabilities(String _excludeFields) throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listAll(_excludeFields).execute().body();
    }

    public CapabilitiesV3 list_core_capabilities() throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listCore().execute().body();
    }

    public CapabilitiesV3 list_core_capabilities(String _excludeFields) throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listCore(_excludeFields).execute().body();
    }

    public CapabilitiesV3 list_rest_capabilities() throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listRest().execute().body();
    }

    public CapabilitiesV3 list_rest_capabilities(String _excludeFields) throws IOException {
        Capabilities s = this.getService(Capabilities.class);
        return (CapabilitiesV3)s.listRest(_excludeFields).execute().body();
    }

    public GridKeyV3 import_grid(String gridPath) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GridKeyV3)s.importGrid(gridPath).execute().body();
    }

    public GridKeyV3 import_grid(String gridPath, boolean loadParamsReferences) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GridKeyV3)s.importGrid(gridPath, loadParamsReferences).execute().body();
    }

    public GridKeyV3 export_grid(String gridId, String gridDirectory) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GridKeyV3)s.exportGrid(gridId, gridDirectory).execute().body();
    }

    public GridKeyV3 export_grid(GridExportV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GridKeyV3)s.exportGrid(params.gridId, params.gridDirectory, params.saveParamsReferences, params.exportCrossValidationPredictions).execute().body();
    }

    public ResumeV3 recovery_resume() throws IOException {
        Recovery s = this.getService(Recovery.class);
        return (ResumeV3)s.resume().execute().body();
    }

    public ResumeV3 recovery_resume(String recoveryDir) throws IOException {
        Recovery s = this.getService(Recovery.class);
        return (ResumeV3)s.resume(recoveryDir).execute().body();
    }

    public EndpointsListV4 endpoints4() throws IOException {
        Endpoints s = this.getService(Endpoints.class);
        return (EndpointsListV4)s.listRoutes4().execute().body();
    }

    public EndpointsListV4 endpoints4(String __schema) throws IOException {
        Endpoints s = this.getService(Endpoints.class);
        return (EndpointsListV4)s.listRoutes4(__schema).execute().body();
    }

    public SessionIdV4 newSession4() throws IOException {
        Sessions s = this.getService(Sessions.class);
        return (SessionIdV4)s.newSession4().execute().body();
    }

    public SessionIdV4 newSession4(String _fields) throws IOException {
        Sessions s = this.getService(Sessions.class);
        return (SessionIdV4)s.newSession4(_fields).execute().body();
    }

    public InitIDV3 endSession4(String sessionKey) throws IOException {
        Sessions s = this.getService(Sessions.class);
        return (InitIDV3)s.endSession(sessionKey).execute().body();
    }

    public InitIDV3 endSession4(String sessionKey, String _excludeFields) throws IOException {
        Sessions s = this.getService(Sessions.class);
        return (InitIDV3)s.endSession(sessionKey, _excludeFields).execute().body();
    }

    public ModelsInfoV4 modelsInfo() throws IOException {
        Modelsinfo s = this.getService(Modelsinfo.class);
        return (ModelsInfoV4)s.modelsInfo().execute().body();
    }

    public ModelsInfoV4 modelsInfo(String __schema) throws IOException {
        Modelsinfo s = this.getService(Modelsinfo.class);
        return (ModelsInfoV4)s.modelsInfo(__schema).execute().body();
    }

    public JobV4 createSimpleFrame() throws IOException {
        Frames s = this.getService(Frames.class);
        return (JobV4)s.createSimpleFrame().execute().body();
    }

    public JobV4 createSimpleFrame(CreateFrameSimpleIV4 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (JobV4)s.createSimpleFrame(H2oApi.keyToString(params.dest), params.seed, params.nrows, params.ncolsReal, params.ncolsInt, params.ncolsEnum, params.ncolsBool, params.ncolsStr, params.ncolsTime, params.realLb, params.realUb, params.intLb, params.intUb, params.enumNlevels, params.boolP, params.timeLb, params.timeUb, params.strLength, params.missingFraction, params.responseType, params.responseLb, params.responseUb, params.responseP, params.responseNlevels, params._fields).execute().body();
    }

    public JobV4 getJob4(String jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobV4)s.getJob4(jobId).execute().body();
    }

    public JobV4 getJob4(String jobId, String _fields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobV4)s.getJob4(jobId, _fields).execute().body();
    }

    private void initializeRetrofit() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ModelV3TypeAdapter()).registerTypeAdapter(KeyV3.class, (Object)new KeySerializer()).registerTypeAdapter(ColSpecifierV3.class, (Object)new ColSerializer()).registerTypeAdapter(ModelBuilderSchema.class, (Object)new ModelDeserializer()).registerTypeAdapter(ModelSchemaBaseV3.class, (Object)new ModelSchemaDeserializer()).registerTypeAdapter(ModelOutputSchemaV3.class, (Object)new ModelOutputDeserializer()).registerTypeAdapter(ModelParametersSchemaV3.class, (Object)new ModelParametersDeserializer()).create();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)this.timeout_s, TimeUnit.SECONDS).writeTimeout((long)this.timeout_s, TimeUnit.SECONDS).readTimeout((long)this.timeout_s, TimeUnit.SECONDS).build();
        this.retrofit = new Retrofit.Builder().client(client).baseUrl(this._url).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
    }

    private Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.initializeRetrofit();
        }
        return this.retrofit;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.getRetrofit().create(clazz);
    }

    public static String[] keyArrayToStringArray(KeyV3[] keys) {
        if (keys == null) {
            return null;
        }
        String[] ids = new String[keys.length];
        int i = 0;
        for (KeyV3 key : keys) {
            ids[i++] = key.name;
        }
        return ids;
    }

    public static <T extends KeyV3> T[] stringArrayToKeyArray(String[] ids, Class<T> clz) {
        if (ids == null) {
            return null;
        }
        KeyV3[] keys = (KeyV3[])Array.newInstance(clz, ids.length);
        String keyType = clz.getSimpleName();
        if (keyType.endsWith("KeyV3")) {
            keyType = keyType.substring(0, keyType.length() - 5);
        }
        try {
            int i = 0;
            for (String id : ids) {
                keys[i] = (KeyV3)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
                keys[i].name = id;
                keys[i].type = keyType;
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keys;
    }

    public static String keyToString(KeyV3 key) {
        return key == null ? null : key.name;
    }

    public static FrameKeyV3 stringToFrameKey(String key) {
        if (key == null) {
            return null;
        }
        FrameKeyV3 k = new FrameKeyV3();
        k.name = key;
        return k;
    }

    private static String colToString(ColSpecifierV3 col) {
        return col == null ? null : col.columnName;
    }

    public static String stringToCol(String col) {
        if (col == null) {
            return null;
        }
        ColSpecifierV3 c = new ColSpecifierV3();
        c.columnName = col;
        return col;
    }

    public static void copyFields(Object to, Object from) {
        Field[] fromFields = from.getClass().getDeclaredFields();
        Field[] toFields = to.getClass().getDeclaredFields();
        for (Field fromField : fromFields) {
            try {
                Field toField = to.getClass().getDeclaredField(fromField.getName());
                fromField.setAccessible(true);
                toField.setAccessible(true);
                toField.set(to, fromField.get(from));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ModelV3TypeAdapter
    implements TypeAdapterFactory {
        private ModelV3TypeAdapter() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final Class rawType = type.getRawType();
            if (!ModelBuilderSchema.class.isAssignableFrom(rawType) && !ModelSchemaBaseV3.class.isAssignableFrom(rawType)) {
                return null;
            }
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    JsonObject jobj = new JsonParser().parse(in).getAsJsonObject();
                    if (jobj.has("parameters") && jobj.get("parameters").isJsonArray()) {
                        JsonArray jarr = jobj.get("parameters").getAsJsonArray();
                        JsonObject paramsNew = new JsonObject();
                        for (JsonElement item : jarr) {
                            JsonObject itemObj = item.getAsJsonObject();
                            paramsNew.add(itemObj.get("name").getAsString(), itemObj.get("actual_value"));
                        }
                        jobj.add("parameters", (JsonElement)paramsNew);
                    }
                    return new Gson().fromJson((JsonElement)jobj, rawType);
                }
            };
        }
    }

    private static class ModelParametersDeserializer
    implements JsonDeserializer<ModelParametersSchemaV3> {
        private ModelParametersDeserializer() {
        }

        public ModelParametersSchemaV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                switch (algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase()) {
                    case "xgboost": {
                        return (ModelParametersSchemaV3)context.deserialize(json, XGBoostParametersV3.class);
                    }
                    case "infogram": {
                        return (ModelParametersSchemaV3)context.deserialize(json, InfogramParametersV3.class);
                    }
                    case "targetencoder": {
                        return (ModelParametersSchemaV3)context.deserialize(json, TargetEncoderParametersV3.class);
                    }
                    case "deeplearning": {
                        return (ModelParametersSchemaV3)context.deserialize(json, DeepLearningParametersV3.class);
                    }
                    case "glm": {
                        return (ModelParametersSchemaV3)context.deserialize(json, GLMParametersV3.class);
                    }
                    case "glrm": {
                        return (ModelParametersSchemaV3)context.deserialize(json, GLRMParametersV3.class);
                    }
                    case "kmeans": {
                        return (ModelParametersSchemaV3)context.deserialize(json, KMeansParametersV3.class);
                    }
                    case "naivebayes": {
                        return (ModelParametersSchemaV3)context.deserialize(json, NaiveBayesParametersV3.class);
                    }
                    case "pca": {
                        return (ModelParametersSchemaV3)context.deserialize(json, PCAParametersV3.class);
                    }
                    case "svd": {
                        return (ModelParametersSchemaV3)context.deserialize(json, SVDParametersV99.class);
                    }
                    case "drf": {
                        return (ModelParametersSchemaV3)context.deserialize(json, DRFParametersV3.class);
                    }
                    case "gbm": {
                        return (ModelParametersSchemaV3)context.deserialize(json, GBMParametersV3.class);
                    }
                    case "isolationforest": {
                        return (ModelParametersSchemaV3)context.deserialize(json, IsolationForestParametersV3.class);
                    }
                    case "extendedisolationforest": {
                        return (ModelParametersSchemaV3)context.deserialize(json, ExtendedIsolationForestParametersV3.class);
                    }
                    case "aggregator": {
                        return (ModelParametersSchemaV3)context.deserialize(json, AggregatorParametersV99.class);
                    }
                    case "word2vec": {
                        return (ModelParametersSchemaV3)context.deserialize(json, Word2VecParametersV3.class);
                    }
                    case "stackedensemble": {
                        return (ModelParametersSchemaV3)context.deserialize(json, StackedEnsembleParametersV99.class);
                    }
                    case "coxph": {
                        return (ModelParametersSchemaV3)context.deserialize(json, CoxPHParametersV3.class);
                    }
                    case "generic": {
                        return (ModelParametersSchemaV3)context.deserialize(json, GenericParametersV3.class);
                    }
                    case "gam": {
                        return (ModelParametersSchemaV3)context.deserialize(json, GAMParametersV3.class);
                    }
                    case "anovaglm": {
                        return (ModelParametersSchemaV3)context.deserialize(json, ANOVAGLMParametersV3.class);
                    }
                    case "psvm": {
                        return (ModelParametersSchemaV3)context.deserialize(json, PSVMParametersV3.class);
                    }
                    case "rulefit": {
                        return (ModelParametersSchemaV3)context.deserialize(json, RuleFitParametersV3.class);
                    }
                    case "upliftdrf": {
                        return (ModelParametersSchemaV3)context.deserialize(json, UpliftDRFParametersV3.class);
                    }
                    case "modelselection": {
                        return (ModelParametersSchemaV3)context.deserialize(json, ModelSelectionParametersV3.class);
                    }
                    case "isotonicregression": {
                        return (ModelParametersSchemaV3)context.deserialize(json, IsotonicRegressionParametersV3.class);
                    }
                    case "dt": {
                        return (ModelParametersSchemaV3)context.deserialize(json, DTParametersV3.class);
                    }
                    case "adaboost": {
                        return (ModelParametersSchemaV3)context.deserialize(json, AdaBoostParametersV3.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelParametersSchemaV3 element " + json.toString());
        }
    }

    private static class ModelOutputDeserializer
    implements JsonDeserializer<ModelOutputSchemaV3> {
        private ModelOutputDeserializer() {
        }

        public ModelOutputSchemaV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                switch (algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase()) {
                    case "xgboost": {
                        return (ModelOutputSchemaV3)context.deserialize(json, XGBoostModelOutputV3.class);
                    }
                    case "infogram": {
                        return (ModelOutputSchemaV3)context.deserialize(json, InfogramModelOutputV3.class);
                    }
                    case "targetencoder": {
                        return (ModelOutputSchemaV3)context.deserialize(json, TargetEncoderModelOutputV3.class);
                    }
                    case "deeplearning": {
                        return (ModelOutputSchemaV3)context.deserialize(json, DeepLearningModelOutputV3.class);
                    }
                    case "glm": {
                        return (ModelOutputSchemaV3)context.deserialize(json, GLMModelOutputV3.class);
                    }
                    case "glrm": {
                        return (ModelOutputSchemaV3)context.deserialize(json, GLRMModelOutputV3.class);
                    }
                    case "kmeans": {
                        return (ModelOutputSchemaV3)context.deserialize(json, KMeansModelOutputV3.class);
                    }
                    case "naivebayes": {
                        return (ModelOutputSchemaV3)context.deserialize(json, NaiveBayesModelOutputV3.class);
                    }
                    case "pca": {
                        return (ModelOutputSchemaV3)context.deserialize(json, PCAModelOutputV3.class);
                    }
                    case "svd": {
                        return (ModelOutputSchemaV3)context.deserialize(json, SVDModelOutputV99.class);
                    }
                    case "drf": {
                        return (ModelOutputSchemaV3)context.deserialize(json, DRFModelOutputV3.class);
                    }
                    case "gbm": {
                        return (ModelOutputSchemaV3)context.deserialize(json, GBMModelOutputV3.class);
                    }
                    case "isolationforest": {
                        return (ModelOutputSchemaV3)context.deserialize(json, IsolationForestModelOutputV3.class);
                    }
                    case "extendedisolationforest": {
                        return (ModelOutputSchemaV3)context.deserialize(json, ExtendedIsolationForestModelOutputV3.class);
                    }
                    case "aggregator": {
                        return (ModelOutputSchemaV3)context.deserialize(json, AggregatorModelOutputV99.class);
                    }
                    case "word2vec": {
                        return (ModelOutputSchemaV3)context.deserialize(json, Word2VecModelOutputV3.class);
                    }
                    case "stackedensemble": {
                        return (ModelOutputSchemaV3)context.deserialize(json, StackedEnsembleModelOutputV99.class);
                    }
                    case "coxph": {
                        return (ModelOutputSchemaV3)context.deserialize(json, CoxPHModelOutputV3.class);
                    }
                    case "generic": {
                        return (ModelOutputSchemaV3)context.deserialize(json, GenericModelOutputV3.class);
                    }
                    case "gam": {
                        return (ModelOutputSchemaV3)context.deserialize(json, GAMModelOutputV3.class);
                    }
                    case "anovaglm": {
                        return (ModelOutputSchemaV3)context.deserialize(json, ANOVAGLMModelOutputV3.class);
                    }
                    case "psvm": {
                        return (ModelOutputSchemaV3)context.deserialize(json, PSVMModelOutputV3.class);
                    }
                    case "rulefit": {
                        return (ModelOutputSchemaV3)context.deserialize(json, RuleFitModelOutputV3.class);
                    }
                    case "upliftdrf": {
                        return (ModelOutputSchemaV3)context.deserialize(json, UpliftDRFModelOutputV3.class);
                    }
                    case "modelselection": {
                        return (ModelOutputSchemaV3)context.deserialize(json, ModelSelectionModelOutputV3.class);
                    }
                    case "isotonicregression": {
                        return (ModelOutputSchemaV3)context.deserialize(json, IsotonicRegressionModelOutputV3.class);
                    }
                    case "dt": {
                        return (ModelOutputSchemaV3)context.deserialize(json, DTModelOutputV3.class);
                    }
                    case "adaboost": {
                        return (ModelOutputSchemaV3)context.deserialize(json, AdaBoostModelOutputV3.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelOutputSchemaV3 element " + json.toString());
        }
    }

    private static class ModelSchemaDeserializer
    implements JsonDeserializer<ModelSchemaBaseV3> {
        private ModelSchemaDeserializer() {
        }

        public ModelSchemaBaseV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                switch (algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase()) {
                    case "xgboost": {
                        return (ModelSchemaBaseV3)context.deserialize(json, XGBoostModelV3.class);
                    }
                    case "infogram": {
                        return (ModelSchemaBaseV3)context.deserialize(json, InfogramModelV3.class);
                    }
                    case "targetencoder": {
                        return (ModelSchemaBaseV3)context.deserialize(json, TargetEncoderModelV3.class);
                    }
                    case "deeplearning": {
                        return (ModelSchemaBaseV3)context.deserialize(json, DeepLearningModelV3.class);
                    }
                    case "glm": {
                        return (ModelSchemaBaseV3)context.deserialize(json, GLMModelV3.class);
                    }
                    case "glrm": {
                        return (ModelSchemaBaseV3)context.deserialize(json, GLRMModelV3.class);
                    }
                    case "kmeans": {
                        return (ModelSchemaBaseV3)context.deserialize(json, KMeansModelV3.class);
                    }
                    case "naivebayes": {
                        return (ModelSchemaBaseV3)context.deserialize(json, NaiveBayesModelV3.class);
                    }
                    case "pca": {
                        return (ModelSchemaBaseV3)context.deserialize(json, PCAModelV3.class);
                    }
                    case "svd": {
                        return (ModelSchemaBaseV3)context.deserialize(json, SVDModelV99.class);
                    }
                    case "drf": {
                        return (ModelSchemaBaseV3)context.deserialize(json, DRFModelV3.class);
                    }
                    case "gbm": {
                        return (ModelSchemaBaseV3)context.deserialize(json, GBMModelV3.class);
                    }
                    case "isolationforest": {
                        return (ModelSchemaBaseV3)context.deserialize(json, IsolationForestModelV3.class);
                    }
                    case "extendedisolationforest": {
                        return (ModelSchemaBaseV3)context.deserialize(json, ExtendedIsolationForestModelV3.class);
                    }
                    case "aggregator": {
                        return (ModelSchemaBaseV3)context.deserialize(json, AggregatorModelV99.class);
                    }
                    case "word2vec": {
                        return (ModelSchemaBaseV3)context.deserialize(json, Word2VecModelV3.class);
                    }
                    case "stackedensemble": {
                        return (ModelSchemaBaseV3)context.deserialize(json, StackedEnsembleModelV99.class);
                    }
                    case "coxph": {
                        return (ModelSchemaBaseV3)context.deserialize(json, CoxPHModelV3.class);
                    }
                    case "generic": {
                        return (ModelSchemaBaseV3)context.deserialize(json, GenericModelV3.class);
                    }
                    case "gam": {
                        return (ModelSchemaBaseV3)context.deserialize(json, GAMModelV3.class);
                    }
                    case "anovaglm": {
                        return (ModelSchemaBaseV3)context.deserialize(json, ANOVAGLMModelV3.class);
                    }
                    case "psvm": {
                        return (ModelSchemaBaseV3)context.deserialize(json, PSVMModelV3.class);
                    }
                    case "rulefit": {
                        return (ModelSchemaBaseV3)context.deserialize(json, RuleFitModelV3.class);
                    }
                    case "upliftdrf": {
                        return (ModelSchemaBaseV3)context.deserialize(json, UpliftDRFModelV3.class);
                    }
                    case "modelselection": {
                        return (ModelSchemaBaseV3)context.deserialize(json, ModelSelectionModelV3.class);
                    }
                    case "isotonicregression": {
                        return (ModelSchemaBaseV3)context.deserialize(json, IsotonicRegressionModelV3.class);
                    }
                    case "dt": {
                        return (ModelSchemaBaseV3)context.deserialize(json, DTModelV3.class);
                    }
                    case "adaboost": {
                        return (ModelSchemaBaseV3)context.deserialize(json, AdaBoostModelV3.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelSchemaBaseV3 element " + json.toString());
        }
    }

    private static class ModelDeserializer
    implements JsonDeserializer<ModelBuilderSchema> {
        private ModelDeserializer() {
        }

        public ModelBuilderSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                switch (algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase()) {
                    case "xgboost": {
                        return (ModelBuilderSchema)context.deserialize(json, XGBoostV3.class);
                    }
                    case "infogram": {
                        return (ModelBuilderSchema)context.deserialize(json, InfogramV3.class);
                    }
                    case "targetencoder": {
                        return (ModelBuilderSchema)context.deserialize(json, TargetEncoderV3.class);
                    }
                    case "deeplearning": {
                        return (ModelBuilderSchema)context.deserialize(json, DeepLearningV3.class);
                    }
                    case "glm": {
                        return (ModelBuilderSchema)context.deserialize(json, GLMV3.class);
                    }
                    case "glrm": {
                        return (ModelBuilderSchema)context.deserialize(json, GLRMV3.class);
                    }
                    case "kmeans": {
                        return (ModelBuilderSchema)context.deserialize(json, KMeansV3.class);
                    }
                    case "naivebayes": {
                        return (ModelBuilderSchema)context.deserialize(json, NaiveBayesV3.class);
                    }
                    case "pca": {
                        return (ModelBuilderSchema)context.deserialize(json, PCAV3.class);
                    }
                    case "svd": {
                        return (ModelBuilderSchema)context.deserialize(json, SVDV99.class);
                    }
                    case "drf": {
                        return (ModelBuilderSchema)context.deserialize(json, DRFV3.class);
                    }
                    case "gbm": {
                        return (ModelBuilderSchema)context.deserialize(json, GBMV3.class);
                    }
                    case "isolationforest": {
                        return (ModelBuilderSchema)context.deserialize(json, IsolationForestV3.class);
                    }
                    case "extendedisolationforest": {
                        return (ModelBuilderSchema)context.deserialize(json, ExtendedIsolationForestV3.class);
                    }
                    case "aggregator": {
                        return (ModelBuilderSchema)context.deserialize(json, AggregatorV99.class);
                    }
                    case "word2vec": {
                        return (ModelBuilderSchema)context.deserialize(json, Word2VecV3.class);
                    }
                    case "stackedensemble": {
                        return (ModelBuilderSchema)context.deserialize(json, StackedEnsembleV99.class);
                    }
                    case "coxph": {
                        return (ModelBuilderSchema)context.deserialize(json, CoxPHV3.class);
                    }
                    case "generic": {
                        return (ModelBuilderSchema)context.deserialize(json, GenericV3.class);
                    }
                    case "gam": {
                        return (ModelBuilderSchema)context.deserialize(json, GAMV3.class);
                    }
                    case "anovaglm": {
                        return (ModelBuilderSchema)context.deserialize(json, ANOVAGLMV3.class);
                    }
                    case "psvm": {
                        return (ModelBuilderSchema)context.deserialize(json, PSVMV3.class);
                    }
                    case "rulefit": {
                        return (ModelBuilderSchema)context.deserialize(json, RuleFitV3.class);
                    }
                    case "upliftdrf": {
                        return (ModelBuilderSchema)context.deserialize(json, UpliftDRFV3.class);
                    }
                    case "modelselection": {
                        return (ModelBuilderSchema)context.deserialize(json, ModelSelectionV3.class);
                    }
                    case "isotonicregression": {
                        return (ModelBuilderSchema)context.deserialize(json, IsotonicRegressionV3.class);
                    }
                    case "dt": {
                        return (ModelBuilderSchema)context.deserialize(json, DTV3.class);
                    }
                    case "adaboost": {
                        return (ModelBuilderSchema)context.deserialize(json, AdaBoostV3.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelBuilderSchema element " + json.toString());
        }
    }

    private static class ColSerializer
    implements JsonSerializer<ColSpecifierV3> {
        private ColSerializer() {
        }

        public JsonElement serialize(ColSpecifierV3 col, Type typeOfCol, JsonSerializationContext context) {
            return new JsonPrimitive(col.columnName);
        }
    }

    private static class KeySerializer
    implements JsonSerializer<KeyV3>,
    JsonDeserializer<KeyV3> {
        private KeySerializer() {
        }

        public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
            return new JsonPrimitive(key.name);
        }

        public KeyV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String type;
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject jobj = json.getAsJsonObject();
            switch (type = jobj.get("type").getAsString()) {
                case "Key<Model>": {
                    return (KeyV3)context.deserialize((JsonElement)jobj, ModelKeyV3.class);
                }
                case "Key<Job>": {
                    return (KeyV3)context.deserialize((JsonElement)jobj, JobKeyV3.class);
                }
                case "Key<Grid>": {
                    return (KeyV3)context.deserialize((JsonElement)jobj, GridKeyV3.class);
                }
                case "Key<Frame>": {
                    return (KeyV3)context.deserialize((JsonElement)jobj, FrameKeyV3.class);
                }
            }
            throw new JsonParseException("Unable to deserialize key of type " + type);
        }
    }
}

