
/*
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings;

import water.bindings.pojos.*;
import water.bindings.proxies.retrofit.*;
import retrofit2.*;
import retrofit2.converter.gson.GsonConverterFactory;
import com.google.gson.*;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import okhttp3.OkHttpClient;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;


@SuppressWarnings("unused")
public class H2oApi {

  public static String DEFAULT_URL = "http://localhost:54321/";

  public H2oApi() {
    this(DEFAULT_URL);
  }
  public H2oApi(String url) {
    _url = url;
  }

  public H2oApi setUrl(String url) {
    _url = url;
    retrofit = null;
    return this;
  }

  public H2oApi setTimeout(int t) {
    timeout_s = t;
    retrofit = null;
    return this;
  }

  /**
   * Set time interval for job polling in {@link #waitForJobCompletion(JobKeyV3)}.
   *   @param millis time interval, in milliseconds
   */
  public H2oApi setJobPollInterval(int millis) {
    pollInterval_ms = millis;
    return this;
  }

  /**
   * Continuously poll server for the status of the given job, until it completes.
   *   @param jobKey job to query
   *   @return the finished job
   */
  public JobV3 waitForJobCompletion(JobKeyV3 jobKey) {
    return waitForJobCompletion(keyToString(jobKey));
  }
  public JobV3 waitForJobCompletion(String jobId) {
    Jobs jobService = getService(Jobs.class);
    Response<JobsV3> jobsResponse = null;
    int retries = 3;
    JobsV3 jobs = null;
    do {
      try {
        Thread.sleep(pollInterval_ms);
        jobsResponse = jobService.fetch(jobId).execute();
      } catch (IOException e) {
        System.err.println("Caught exception: " + e);
      } catch (InterruptedException e) { /* pass */ }
      if (jobsResponse == null || !jobsResponse.isSuccessful())
        if (retries-- > 0)
          continue;
        else
          throw new RuntimeException("/3/Jobs/" + jobId + " failed 3 times.");
      jobs = jobsResponse.body();
      if (jobs.jobs == null || jobs.jobs.length != 1)
        throw new RuntimeException("Failed to find Job: " + jobId);
    } while (jobs != null && jobs.jobs[0].status.equals("RUNNING"));
    return jobs == null? null : jobs.jobs[0];
  }


  /**
   * Train a XGBoost model.
   */
  public XGBoostV3 train_xgboost() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainXgboost().execute().body();
  }
  public XGBoostV3 train_xgboost(XGBoostParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainXgboost(
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.minChildWeight,
      params.learnRate,
      params.eta,
      params.sampleRate,
      params.subsample,
      params.colSampleRate,
      params.colsampleBylevel,
      params.colSampleRatePerTree,
      params.colsampleBytree,
      params.colsampleBynode,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.maxDeltaStep,
      params.scoreTreeInterval,
      params.seed,
      params.minSplitImprovement,
      params.gamma,
      params.nthread,
      params.buildTreeOneNode,
      params.saveMatrixDirectory,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.maxBins,
      params.maxLeaves,
      params.treeMethod,
      params.growPolicy,
      params.booster,
      params.regLambda,
      params.regAlpha,
      params.quietMode,
      params.sampleType,
      params.normalizeType,
      params.rateDrop,
      params.oneDrop,
      params.skipDrop,
      params.dmatrixType,
      params.backend,
      params.gpuId,
      params.interactionConstraints,
      params.scalePosWeight,
      params.evalMetric,
      params.scoreEvalMetricOnly,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of XGBoost model builder parameters.
   */
  public XGBoostV3 validate_xgboost() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersXgboost().execute().body();
  }
  public XGBoostV3 validate_xgboost(XGBoostParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersXgboost(
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.minChildWeight,
      params.learnRate,
      params.eta,
      params.sampleRate,
      params.subsample,
      params.colSampleRate,
      params.colsampleBylevel,
      params.colSampleRatePerTree,
      params.colsampleBytree,
      params.colsampleBynode,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.maxDeltaStep,
      params.scoreTreeInterval,
      params.seed,
      params.minSplitImprovement,
      params.gamma,
      params.nthread,
      params.buildTreeOneNode,
      params.saveMatrixDirectory,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.maxBins,
      params.maxLeaves,
      params.treeMethod,
      params.growPolicy,
      params.booster,
      params.regLambda,
      params.regAlpha,
      params.quietMode,
      params.sampleType,
      params.normalizeType,
      params.rateDrop,
      params.oneDrop,
      params.skipDrop,
      params.dmatrixType,
      params.backend,
      params.gpuId,
      params.interactionConstraints,
      params.scalePosWeight,
      params.evalMetric,
      params.scoreEvalMetricOnly,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for XGBoost model.
   */
  public XGBoostV3 grid_search_xgboost() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainXgboost().execute().body();
  }
  public XGBoostV3 grid_search_xgboost(XGBoostParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainXgboost(
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.minChildWeight,
      params.learnRate,
      params.eta,
      params.sampleRate,
      params.subsample,
      params.colSampleRate,
      params.colsampleBylevel,
      params.colSampleRatePerTree,
      params.colsampleBytree,
      params.colsampleBynode,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.maxDeltaStep,
      params.scoreTreeInterval,
      params.seed,
      params.minSplitImprovement,
      params.gamma,
      params.nthread,
      params.buildTreeOneNode,
      params.saveMatrixDirectory,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.maxBins,
      params.maxLeaves,
      params.treeMethod,
      params.growPolicy,
      params.booster,
      params.regLambda,
      params.regAlpha,
      params.quietMode,
      params.sampleType,
      params.normalizeType,
      params.rateDrop,
      params.oneDrop,
      params.skipDrop,
      params.dmatrixType,
      params.backend,
      params.gpuId,
      params.interactionConstraints,
      params.scalePosWeight,
      params.evalMetric,
      params.scoreEvalMetricOnly,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for XGBoost model.
   */
  public XGBoostV3 grid_search_xgboost_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeXgboost().execute().body();
  }
  public XGBoostV3 grid_search_xgboost_resume(XGBoostParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeXgboost(
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.minChildWeight,
      params.learnRate,
      params.eta,
      params.sampleRate,
      params.subsample,
      params.colSampleRate,
      params.colsampleBylevel,
      params.colSampleRatePerTree,
      params.colsampleBytree,
      params.colsampleBynode,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.maxDeltaStep,
      params.scoreTreeInterval,
      params.seed,
      params.minSplitImprovement,
      params.gamma,
      params.nthread,
      params.buildTreeOneNode,
      params.saveMatrixDirectory,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.maxBins,
      params.maxLeaves,
      params.treeMethod,
      params.growPolicy,
      params.booster,
      params.regLambda,
      params.regAlpha,
      params.quietMode,
      params.sampleType,
      params.normalizeType,
      params.rateDrop,
      params.oneDrop,
      params.skipDrop,
      params.dmatrixType,
      params.backend,
      params.gpuId,
      params.interactionConstraints,
      params.scalePosWeight,
      params.evalMetric,
      params.scoreEvalMetricOnly,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Remote XGBoost execution - init
   */
  public XGBoostExecRespV3 remote_xgb_init() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.init().execute().body();
  }
  public XGBoostExecRespV3 remote_xgb_init(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.init(keyToString(key), data).execute().body();
  }

  /**
   * Remote XGBoost execution - setup
   */
  public StreamingSchema remote_xgb_setup() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.setup().execute().body();
  }
  public StreamingSchema remote_xgb_setup(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.setup(keyToString(key), data).execute().body();
  }

  /**
   * Remote XGBoost execution - update
   */
  public XGBoostExecRespV3 remote_xgb_update() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.update().execute().body();
  }
  public XGBoostExecRespV3 remote_xgb_update(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.update(keyToString(key), data).execute().body();
  }

  /**
   * Remote XGBoost execution - getEvalMetric
   */
  public XGBoostExecRespV3 remote_xgb_metric() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.getEvalMetric().execute().body();
  }
  public XGBoostExecRespV3 remote_xgb_metric(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.getEvalMetric(keyToString(key), data).execute().body();
  }

  /**
   * Remote XGBoost execution - get booster
   */
  public StreamingSchema remote_xgb_booster() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.getBooster().execute().body();
  }
  public StreamingSchema remote_xgb_booster(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.getBooster(keyToString(key), data).execute().body();
  }

  /**
   * Remote XGBoost execution - cleanup
   */
  public XGBoostExecRespV3 remote_xgb_cleanup() throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.cleanup().execute().body();
  }
  public XGBoostExecRespV3 remote_xgb_cleanup(KeyV3 key, String data) throws IOException {
    XGBoostExecutor s = getService(XGBoostExecutor.class);
    return s.cleanup(keyToString(key), data).execute().body();
  }

  /**
   * Generate a MOJO 2 pipeline artifact from the Assembly
   */
  public StreamingSchema _assembly_fetch_mojo_pipeline(String assemblyId, String fileName) throws IOException {
    Assembly s = getService(Assembly.class);
    return s.fetchMojoPipeline(assemblyId, fileName).execute().body();
  }
  public StreamingSchema _assembly_fetch_mojo_pipeline(AssemblyV99 params) throws IOException {
    Assembly s = getService(Assembly.class);
    return s.fetchMojoPipeline(
      params.assemblyId,
      params.fileName,
      params.steps,
      keyToString(params.frame),
      params._excludeFields
    ).execute().body();
  }

  /**
   * Set Amazon S3 credentials (Secret Key ID, Secret Access Key)
   */
  public PersistS3CredentialsV3 set_s3_credentials(String secretKeyId, String secretAccessKey) throws IOException {
    PersistS3 s = getService(PersistS3.class);
    return s.setS3Credentials(secretKeyId, secretAccessKey).execute().body();
  }
  public PersistS3CredentialsV3 set_s3_credentials(String secretKeyId, String secretAccessKey, String sessionToken) throws IOException {
    PersistS3 s = getService(PersistS3.class);
    return s.setS3Credentials(secretKeyId, secretAccessKey, sessionToken).execute().body();
  }

  /**
   * Remove store Amazon S3 credentials
   */
  public PersistS3CredentialsV3 remove_s3_credentials(String secretKeyId, String secretAccessKey) throws IOException {
    PersistS3 s = getService(PersistS3.class);
    return s.removeS3Credentials(secretKeyId, secretAccessKey).execute().body();
  }
  public PersistS3CredentialsV3 remove_s3_credentials(String secretKeyId, String secretAccessKey, String sessionToken) throws IOException {
    PersistS3 s = getService(PersistS3.class);
    return s.removeS3Credentials(secretKeyId, secretAccessKey, sessionToken).execute().body();
  }

  /**
   * Return all the AutoML leaderboards.
   */
  public LeaderboardsV99 leaderboards() throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.list().execute().body();
  }
  public LeaderboardsV99 leaderboards(String projectName, String[] extensions) throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.list(projectName, extensions, "").execute().body();
  }
  public LeaderboardsV99 leaderboards(String projectName, String[] extensions, String _excludeFields) throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.list(projectName, extensions, _excludeFields).execute().body();
  }

  /**
   * Return the AutoML leaderboard for the given project.
   */
  public LeaderboardV99 leaderboard(String projectName) throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.fetch(projectName).execute().body();
  }
  public LeaderboardV99 leaderboard(String projectName, String[] extensions) throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.fetch(projectName, extensions, "").execute().body();
  }
  public LeaderboardV99 leaderboard(String projectName, String[] extensions, String _excludeFields) throws IOException {
    Leaderboards s = getService(Leaderboards.class);
    return s.fetch(projectName, extensions, _excludeFields).execute().body();
  }

  /**
   * Train a Infogram model.
   */
  public InfogramV3 train_infogram() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainInfogram().execute().body();
  }
  public InfogramV3 train_infogram(InfogramParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainInfogram(
      params.seed,
      params.standardize,
      keyToString(params.plugValues),
      params.maxIterations,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.algorithm,
      params.algorithmParams,
      params.protectedColumns,
      params.totalInformationThreshold,
      params.netInformationThreshold,
      params.relevanceIndexThreshold,
      params.safetyIndexThreshold,
      params.dataFraction,
      params.topNFeatures,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of Infogram model builder parameters.
   */
  public InfogramV3 validate_infogram() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersInfogram().execute().body();
  }
  public InfogramV3 validate_infogram(InfogramParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersInfogram(
      params.seed,
      params.standardize,
      keyToString(params.plugValues),
      params.maxIterations,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.algorithm,
      params.algorithmParams,
      params.protectedColumns,
      params.totalInformationThreshold,
      params.netInformationThreshold,
      params.relevanceIndexThreshold,
      params.safetyIndexThreshold,
      params.dataFraction,
      params.topNFeatures,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for Infogram model.
   */
  public InfogramV3 grid_search_infogram() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainInfogram().execute().body();
  }
  public InfogramV3 grid_search_infogram(InfogramParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainInfogram(
      params.seed,
      params.standardize,
      keyToString(params.plugValues),
      params.maxIterations,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.algorithm,
      params.algorithmParams,
      params.protectedColumns,
      params.totalInformationThreshold,
      params.netInformationThreshold,
      params.relevanceIndexThreshold,
      params.safetyIndexThreshold,
      params.dataFraction,
      params.topNFeatures,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for Infogram model.
   */
  public InfogramV3 grid_search_infogram_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeInfogram().execute().body();
  }
  public InfogramV3 grid_search_infogram_resume(InfogramParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeInfogram(
      params.seed,
      params.standardize,
      keyToString(params.plugValues),
      params.maxIterations,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.algorithm,
      params.algorithmParams,
      params.protectedColumns,
      params.totalInformationThreshold,
      params.netInformationThreshold,
      params.relevanceIndexThreshold,
      params.safetyIndexThreshold,
      params.dataFraction,
      params.topNFeatures,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a TargetEncoder model.
   */
  public TargetEncoderV3 train_targetencoder() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainTargetencoder().execute().body();
  }
  public TargetEncoderV3 train_targetencoder(TargetEncoderParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainTargetencoder(
      params.columnsToEncode,
      params.keepOriginalCategoricalColumns,
      params.blending,
      params.inflectionPoint,
      params.smoothing,
      params.dataLeakageHandling,
      params.noise,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of TargetEncoder model builder parameters.
   */
  public TargetEncoderV3 validate_targetencoder() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersTargetencoder().execute().body();
  }
  public TargetEncoderV3 validate_targetencoder(TargetEncoderParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersTargetencoder(
      params.columnsToEncode,
      params.keepOriginalCategoricalColumns,
      params.blending,
      params.inflectionPoint,
      params.smoothing,
      params.dataLeakageHandling,
      params.noise,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for TargetEncoder model.
   */
  public TargetEncoderV3 grid_search_targetencoder() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainTargetencoder().execute().body();
  }
  public TargetEncoderV3 grid_search_targetencoder(TargetEncoderParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainTargetencoder(
      params.columnsToEncode,
      params.keepOriginalCategoricalColumns,
      params.blending,
      params.inflectionPoint,
      params.smoothing,
      params.dataLeakageHandling,
      params.noise,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for TargetEncoder model.
   */
  public TargetEncoderV3 grid_search_targetencoder_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeTargetencoder().execute().body();
  }
  public TargetEncoderV3 grid_search_targetencoder_resume(TargetEncoderParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeTargetencoder(
      params.columnsToEncode,
      params.keepOriginalCategoricalColumns,
      params.blending,
      params.inflectionPoint,
      params.smoothing,
      params.dataLeakageHandling,
      params.noise,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Transform using give TargetEncoderModel
   */
  public FrameKeyV3 target_encoder_transform() throws IOException {
    TargetEncoderTransform s = getService(TargetEncoderTransform.class);
    return s.transform().execute().body();
  }
  public FrameKeyV3 target_encoder_transform(TargetEncoderTransformParametersV3 params) throws IOException {
    TargetEncoderTransform s = getService(TargetEncoderTransform.class);
    return s.transform(
      keyToString(params.model),
      keyToString(params.frame),
      params.asTraining,
      params.blending,
      params.inflectionPoint,
      params.smoothing,
      params.noise
    ).execute().body();
  }

  /**
   * Train a DeepLearning model.
   */
  public DeepLearningV3 train_deeplearning() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDeeplearning().execute().body();
  }
  public DeepLearningV3 train_deeplearning(DeepLearningParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDeeplearning(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.activation,
      params.hidden,
      params.epochs,
      params.trainSamplesPerIteration,
      params.targetRatioCommToComp,
      params.seed,
      params.adaptiveRate,
      params.rho,
      params.epsilon,
      params.rate,
      params.rateAnnealing,
      params.rateDecay,
      params.momentumStart,
      params.momentumRamp,
      params.momentumStable,
      params.nesterovAcceleratedGradient,
      params.inputDropoutRatio,
      params.hiddenDropoutRatios,
      params.l1,
      params.l2,
      params.maxW2,
      params.initialWeightDistribution,
      params.initialWeightScale,
      keyArrayToStringArray(params.initialWeights),
      keyArrayToStringArray(params.initialBiases),
      params.loss,
      params.scoreInterval,
      params.scoreTrainingSamples,
      params.scoreValidationSamples,
      params.scoreDutyCycle,
      params.classificationStop,
      params.regressionStop,
      params.quietMode,
      params.scoreValidationSampling,
      params.overwriteWithBestModel,
      params.autoencoder,
      params.useAllFactorLevels,
      params.standardize,
      params.diagnostics,
      params.variableImportances,
      params.fastMode,
      params.forceLoadBalance,
      params.replicateTrainingData,
      params.singleNodeMode,
      params.shuffleTrainingData,
      params.missingValuesHandling,
      params.sparse,
      params.colMajor,
      params.averageActivation,
      params.sparsityBeta,
      params.maxCategoricalFeatures,
      params.reproducible,
      params.exportWeightsAndBiases,
      params.miniBatchSize,
      params.elasticAveraging,
      params.elasticAveragingMovingRate,
      params.elasticAveragingRegularization,
      keyToString(params.pretrainedAutoencoder),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of DeepLearning model builder parameters.
   */
  public DeepLearningV3 validate_deeplearning() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDeeplearning().execute().body();
  }
  public DeepLearningV3 validate_deeplearning(DeepLearningParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDeeplearning(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.activation,
      params.hidden,
      params.epochs,
      params.trainSamplesPerIteration,
      params.targetRatioCommToComp,
      params.seed,
      params.adaptiveRate,
      params.rho,
      params.epsilon,
      params.rate,
      params.rateAnnealing,
      params.rateDecay,
      params.momentumStart,
      params.momentumRamp,
      params.momentumStable,
      params.nesterovAcceleratedGradient,
      params.inputDropoutRatio,
      params.hiddenDropoutRatios,
      params.l1,
      params.l2,
      params.maxW2,
      params.initialWeightDistribution,
      params.initialWeightScale,
      keyArrayToStringArray(params.initialWeights),
      keyArrayToStringArray(params.initialBiases),
      params.loss,
      params.scoreInterval,
      params.scoreTrainingSamples,
      params.scoreValidationSamples,
      params.scoreDutyCycle,
      params.classificationStop,
      params.regressionStop,
      params.quietMode,
      params.scoreValidationSampling,
      params.overwriteWithBestModel,
      params.autoencoder,
      params.useAllFactorLevels,
      params.standardize,
      params.diagnostics,
      params.variableImportances,
      params.fastMode,
      params.forceLoadBalance,
      params.replicateTrainingData,
      params.singleNodeMode,
      params.shuffleTrainingData,
      params.missingValuesHandling,
      params.sparse,
      params.colMajor,
      params.averageActivation,
      params.sparsityBeta,
      params.maxCategoricalFeatures,
      params.reproducible,
      params.exportWeightsAndBiases,
      params.miniBatchSize,
      params.elasticAveraging,
      params.elasticAveragingMovingRate,
      params.elasticAveragingRegularization,
      keyToString(params.pretrainedAutoencoder),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for DeepLearning model.
   */
  public DeepLearningV3 grid_search_deeplearning() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDeeplearning().execute().body();
  }
  public DeepLearningV3 grid_search_deeplearning(DeepLearningParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDeeplearning(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.activation,
      params.hidden,
      params.epochs,
      params.trainSamplesPerIteration,
      params.targetRatioCommToComp,
      params.seed,
      params.adaptiveRate,
      params.rho,
      params.epsilon,
      params.rate,
      params.rateAnnealing,
      params.rateDecay,
      params.momentumStart,
      params.momentumRamp,
      params.momentumStable,
      params.nesterovAcceleratedGradient,
      params.inputDropoutRatio,
      params.hiddenDropoutRatios,
      params.l1,
      params.l2,
      params.maxW2,
      params.initialWeightDistribution,
      params.initialWeightScale,
      keyArrayToStringArray(params.initialWeights),
      keyArrayToStringArray(params.initialBiases),
      params.loss,
      params.scoreInterval,
      params.scoreTrainingSamples,
      params.scoreValidationSamples,
      params.scoreDutyCycle,
      params.classificationStop,
      params.regressionStop,
      params.quietMode,
      params.scoreValidationSampling,
      params.overwriteWithBestModel,
      params.autoencoder,
      params.useAllFactorLevels,
      params.standardize,
      params.diagnostics,
      params.variableImportances,
      params.fastMode,
      params.forceLoadBalance,
      params.replicateTrainingData,
      params.singleNodeMode,
      params.shuffleTrainingData,
      params.missingValuesHandling,
      params.sparse,
      params.colMajor,
      params.averageActivation,
      params.sparsityBeta,
      params.maxCategoricalFeatures,
      params.reproducible,
      params.exportWeightsAndBiases,
      params.miniBatchSize,
      params.elasticAveraging,
      params.elasticAveragingMovingRate,
      params.elasticAveragingRegularization,
      keyToString(params.pretrainedAutoencoder),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for DeepLearning model.
   */
  public DeepLearningV3 grid_search_deeplearning_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDeeplearning().execute().body();
  }
  public DeepLearningV3 grid_search_deeplearning_resume(DeepLearningParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDeeplearning(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.activation,
      params.hidden,
      params.epochs,
      params.trainSamplesPerIteration,
      params.targetRatioCommToComp,
      params.seed,
      params.adaptiveRate,
      params.rho,
      params.epsilon,
      params.rate,
      params.rateAnnealing,
      params.rateDecay,
      params.momentumStart,
      params.momentumRamp,
      params.momentumStable,
      params.nesterovAcceleratedGradient,
      params.inputDropoutRatio,
      params.hiddenDropoutRatios,
      params.l1,
      params.l2,
      params.maxW2,
      params.initialWeightDistribution,
      params.initialWeightScale,
      keyArrayToStringArray(params.initialWeights),
      keyArrayToStringArray(params.initialBiases),
      params.loss,
      params.scoreInterval,
      params.scoreTrainingSamples,
      params.scoreValidationSamples,
      params.scoreDutyCycle,
      params.classificationStop,
      params.regressionStop,
      params.quietMode,
      params.scoreValidationSampling,
      params.overwriteWithBestModel,
      params.autoencoder,
      params.useAllFactorLevels,
      params.standardize,
      params.diagnostics,
      params.variableImportances,
      params.fastMode,
      params.forceLoadBalance,
      params.replicateTrainingData,
      params.singleNodeMode,
      params.shuffleTrainingData,
      params.missingValuesHandling,
      params.sparse,
      params.colMajor,
      params.averageActivation,
      params.sparsityBeta,
      params.maxCategoricalFeatures,
      params.reproducible,
      params.exportWeightsAndBiases,
      params.miniBatchSize,
      params.elasticAveraging,
      params.elasticAveragingMovingRate,
      params.elasticAveragingRegularization,
      keyToString(params.pretrainedAutoencoder),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a GLM model.
   */
  public GLMV3 train_glm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGlm().execute().body();
  }
  public GLMV3 train_glm(GLMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGlm(
      params.seed,
      params.family,
      params.randFamily,
      params.tweedieVariancePower,
      params.dispersionLearningRate,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      params.influence,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.dispersionParameterMethod,
      params.randLink,
      params.startval,
      params.randomColumns,
      params.calcLike,
      params.generateVariableInflationFactors,
      params.intercept,
      params.buildNullModel,
      params.fixDispersionParameter,
      params.initDispersionParameter,
      params.hglm,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.fixTweedieVariancePower,
      params.removeCollinearColumns,
      params.dispersionEpsilon,
      params.tweedieEpsilon,
      params.maxIterationsDispersion,
      params.generateScoringHistory,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of GLM model builder parameters.
   */
  public GLMV3 validate_glm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGlm().execute().body();
  }
  public GLMV3 validate_glm(GLMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGlm(
      params.seed,
      params.family,
      params.randFamily,
      params.tweedieVariancePower,
      params.dispersionLearningRate,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      params.influence,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.dispersionParameterMethod,
      params.randLink,
      params.startval,
      params.randomColumns,
      params.calcLike,
      params.generateVariableInflationFactors,
      params.intercept,
      params.buildNullModel,
      params.fixDispersionParameter,
      params.initDispersionParameter,
      params.hglm,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.fixTweedieVariancePower,
      params.removeCollinearColumns,
      params.dispersionEpsilon,
      params.tweedieEpsilon,
      params.maxIterationsDispersion,
      params.generateScoringHistory,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for GLM model.
   */
  public GLMV3 grid_search_glm() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGlm().execute().body();
  }
  public GLMV3 grid_search_glm(GLMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGlm(
      params.seed,
      params.family,
      params.randFamily,
      params.tweedieVariancePower,
      params.dispersionLearningRate,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      params.influence,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.dispersionParameterMethod,
      params.randLink,
      params.startval,
      params.randomColumns,
      params.calcLike,
      params.generateVariableInflationFactors,
      params.intercept,
      params.buildNullModel,
      params.fixDispersionParameter,
      params.initDispersionParameter,
      params.hglm,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.fixTweedieVariancePower,
      params.removeCollinearColumns,
      params.dispersionEpsilon,
      params.tweedieEpsilon,
      params.maxIterationsDispersion,
      params.generateScoringHistory,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for GLM model.
   */
  public GLMV3 grid_search_glm_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGlm().execute().body();
  }
  public GLMV3 grid_search_glm_resume(GLMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGlm(
      params.seed,
      params.family,
      params.randFamily,
      params.tweedieVariancePower,
      params.dispersionLearningRate,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      params.influence,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.dispersionParameterMethod,
      params.randLink,
      params.startval,
      params.randomColumns,
      params.calcLike,
      params.generateVariableInflationFactors,
      params.intercept,
      params.buildNullModel,
      params.fixDispersionParameter,
      params.initDispersionParameter,
      params.hglm,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.fixTweedieVariancePower,
      params.removeCollinearColumns,
      params.dispersionEpsilon,
      params.tweedieEpsilon,
      params.maxIterationsDispersion,
      params.generateScoringHistory,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a GLRM model.
   */
  public GLRMV3 train_glrm(int k) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGlrm(k).execute().body();
  }
  public GLRMV3 train_glrm(GLRMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGlrm(
      params.transform,
      params.k,
      params.loss,
      params.multiLoss,
      params.lossByCol,
      params.lossByColIdx,
      params.period,
      params.regularizationX,
      params.regularizationY,
      params.gammaX,
      params.gammaY,
      params.maxIterations,
      params.maxUpdates,
      params.initStepSize,
      params.minStepSize,
      params.seed,
      params.init,
      params.svdMethod,
      keyToString(params.userY),
      keyToString(params.userX),
      params.loadingName,
      params.representationName,
      params.expandUserY,
      params.imputeOriginal,
      params.recoverSvd,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of GLRM model builder parameters.
   */
  public GLRMV3 validate_glrm(int k) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGlrm(k).execute().body();
  }
  public GLRMV3 validate_glrm(GLRMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGlrm(
      params.transform,
      params.k,
      params.loss,
      params.multiLoss,
      params.lossByCol,
      params.lossByColIdx,
      params.period,
      params.regularizationX,
      params.regularizationY,
      params.gammaX,
      params.gammaY,
      params.maxIterations,
      params.maxUpdates,
      params.initStepSize,
      params.minStepSize,
      params.seed,
      params.init,
      params.svdMethod,
      keyToString(params.userY),
      keyToString(params.userX),
      params.loadingName,
      params.representationName,
      params.expandUserY,
      params.imputeOriginal,
      params.recoverSvd,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for GLRM model.
   */
  public GLRMV3 grid_search_glrm(int k) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGlrm(k).execute().body();
  }
  public GLRMV3 grid_search_glrm(GLRMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGlrm(
      params.transform,
      params.k,
      params.loss,
      params.multiLoss,
      params.lossByCol,
      params.lossByColIdx,
      params.period,
      params.regularizationX,
      params.regularizationY,
      params.gammaX,
      params.gammaY,
      params.maxIterations,
      params.maxUpdates,
      params.initStepSize,
      params.minStepSize,
      params.seed,
      params.init,
      params.svdMethod,
      keyToString(params.userY),
      keyToString(params.userX),
      params.loadingName,
      params.representationName,
      params.expandUserY,
      params.imputeOriginal,
      params.recoverSvd,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for GLRM model.
   */
  public GLRMV3 grid_search_glrm_resume(int k) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGlrm(k).execute().body();
  }
  public GLRMV3 grid_search_glrm_resume(GLRMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGlrm(
      params.transform,
      params.k,
      params.loss,
      params.multiLoss,
      params.lossByCol,
      params.lossByColIdx,
      params.period,
      params.regularizationX,
      params.regularizationY,
      params.gammaX,
      params.gammaY,
      params.maxIterations,
      params.maxUpdates,
      params.initStepSize,
      params.minStepSize,
      params.seed,
      params.init,
      params.svdMethod,
      keyToString(params.userY),
      keyToString(params.userX),
      params.loadingName,
      params.representationName,
      params.expandUserY,
      params.imputeOriginal,
      params.recoverSvd,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a KMeans model.
   */
  public KMeansV3 train_kmeans() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainKmeans().execute().body();
  }
  public KMeansV3 train_kmeans(KMeansParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainKmeans(
      keyToString(params.userPoints),
      params.maxIterations,
      params.standardize,
      params.seed,
      params.init,
      params.estimateK,
      params.clusterSizeConstraints,
      params.k,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of KMeans model builder parameters.
   */
  public KMeansV3 validate_kmeans() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersKmeans().execute().body();
  }
  public KMeansV3 validate_kmeans(KMeansParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersKmeans(
      keyToString(params.userPoints),
      params.maxIterations,
      params.standardize,
      params.seed,
      params.init,
      params.estimateK,
      params.clusterSizeConstraints,
      params.k,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for KMeans model.
   */
  public KMeansV3 grid_search_kmeans() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainKmeans().execute().body();
  }
  public KMeansV3 grid_search_kmeans(KMeansParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainKmeans(
      keyToString(params.userPoints),
      params.maxIterations,
      params.standardize,
      params.seed,
      params.init,
      params.estimateK,
      params.clusterSizeConstraints,
      params.k,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for KMeans model.
   */
  public KMeansV3 grid_search_kmeans_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeKmeans().execute().body();
  }
  public KMeansV3 grid_search_kmeans_resume(KMeansParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeKmeans(
      keyToString(params.userPoints),
      params.maxIterations,
      params.standardize,
      params.seed,
      params.init,
      params.estimateK,
      params.clusterSizeConstraints,
      params.k,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a NaiveBayes model.
   */
  public NaiveBayesV3 train_naivebayes() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainNaivebayes().execute().body();
  }
  public NaiveBayesV3 train_naivebayes(NaiveBayesParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainNaivebayes(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.laplace,
      params.minSdev,
      params.epsSdev,
      params.minProb,
      params.epsProb,
      params.computeMetrics,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of NaiveBayes model builder parameters.
   */
  public NaiveBayesV3 validate_naivebayes() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersNaivebayes().execute().body();
  }
  public NaiveBayesV3 validate_naivebayes(NaiveBayesParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersNaivebayes(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.laplace,
      params.minSdev,
      params.epsSdev,
      params.minProb,
      params.epsProb,
      params.computeMetrics,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for NaiveBayes model.
   */
  public NaiveBayesV3 grid_search_naivebayes() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainNaivebayes().execute().body();
  }
  public NaiveBayesV3 grid_search_naivebayes(NaiveBayesParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainNaivebayes(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.laplace,
      params.minSdev,
      params.epsSdev,
      params.minProb,
      params.epsProb,
      params.computeMetrics,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for NaiveBayes model.
   */
  public NaiveBayesV3 grid_search_naivebayes_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeNaivebayes().execute().body();
  }
  public NaiveBayesV3 grid_search_naivebayes_resume(NaiveBayesParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeNaivebayes(
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.laplace,
      params.minSdev,
      params.epsSdev,
      params.minProb,
      params.epsProb,
      params.computeMetrics,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a PCA model.
   */
  public PCAV3 train_pca(int k) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainPca(k).execute().body();
  }
  public PCAV3 train_pca(PCAParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainPca(
      params.transform,
      params.pcaMethod,
      params.pcaImpl,
      params.k,
      params.maxIterations,
      params.seed,
      params.useAllFactorLevels,
      params.computeMetrics,
      params.imputeMissing,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of PCA model builder parameters.
   */
  public PCAV3 validate_pca(int k) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersPca(k).execute().body();
  }
  public PCAV3 validate_pca(PCAParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersPca(
      params.transform,
      params.pcaMethod,
      params.pcaImpl,
      params.k,
      params.maxIterations,
      params.seed,
      params.useAllFactorLevels,
      params.computeMetrics,
      params.imputeMissing,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for PCA model.
   */
  public PCAV3 grid_search_pca(int k) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainPca(k).execute().body();
  }
  public PCAV3 grid_search_pca(PCAParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainPca(
      params.transform,
      params.pcaMethod,
      params.pcaImpl,
      params.k,
      params.maxIterations,
      params.seed,
      params.useAllFactorLevels,
      params.computeMetrics,
      params.imputeMissing,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for PCA model.
   */
  public PCAV3 grid_search_pca_resume(int k) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumePca(k).execute().body();
  }
  public PCAV3 grid_search_pca_resume(PCAParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumePca(
      params.transform,
      params.pcaMethod,
      params.pcaImpl,
      params.k,
      params.maxIterations,
      params.seed,
      params.useAllFactorLevels,
      params.computeMetrics,
      params.imputeMissing,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a SVD model.
   */
  public SVDV99 train_svd() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainSvd().execute().body();
  }
  public SVDV99 train_svd(SVDParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainSvd(
      params.transform,
      params.svdMethod,
      params.nv,
      params.maxIterations,
      params.seed,
      params.keepU,
      params.uName,
      params.useAllFactorLevels,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of SVD model builder parameters.
   */
  public SVDV99 validate_svd() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersSvd().execute().body();
  }
  public SVDV99 validate_svd(SVDParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersSvd(
      params.transform,
      params.svdMethod,
      params.nv,
      params.maxIterations,
      params.seed,
      params.keepU,
      params.uName,
      params.useAllFactorLevels,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for SVD model.
   */
  public SVDV99 grid_search_svd() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainSvd().execute().body();
  }
  public SVDV99 grid_search_svd(SVDParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainSvd(
      params.transform,
      params.svdMethod,
      params.nv,
      params.maxIterations,
      params.seed,
      params.keepU,
      params.uName,
      params.useAllFactorLevels,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for SVD model.
   */
  public SVDV99 grid_search_svd_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeSvd().execute().body();
  }
  public SVDV99 grid_search_svd_resume(SVDParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeSvd(
      params.transform,
      params.svdMethod,
      params.nv,
      params.maxIterations,
      params.seed,
      params.keepU,
      params.uName,
      params.useAllFactorLevels,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a DRF model.
   */
  public DRFV3 train_drf() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDrf().execute().body();
  }
  public DRFV3 train_drf(DRFParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDrf(
      params.mtries,
      params.binomialDoubleTrees,
      params.sampleRate,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of DRF model builder parameters.
   */
  public DRFV3 validate_drf() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDrf().execute().body();
  }
  public DRFV3 validate_drf(DRFParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDrf(
      params.mtries,
      params.binomialDoubleTrees,
      params.sampleRate,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for DRF model.
   */
  public DRFV3 grid_search_drf() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDrf().execute().body();
  }
  public DRFV3 grid_search_drf(DRFParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDrf(
      params.mtries,
      params.binomialDoubleTrees,
      params.sampleRate,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for DRF model.
   */
  public DRFV3 grid_search_drf_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDrf().execute().body();
  }
  public DRFV3 grid_search_drf_resume(DRFParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDrf(
      params.mtries,
      params.binomialDoubleTrees,
      params.sampleRate,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a GBM model.
   */
  public GBMV3 train_gbm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGbm().execute().body();
  }
  public GBMV3 train_gbm(GBMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGbm(
      params.learnRate,
      params.learnRateAnnealing,
      params.sampleRate,
      params.colSampleRate,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.predNoiseBandwidth,
      params.interactionConstraints,
      params.autoRebalance,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of GBM model builder parameters.
   */
  public GBMV3 validate_gbm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGbm().execute().body();
  }
  public GBMV3 validate_gbm(GBMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGbm(
      params.learnRate,
      params.learnRateAnnealing,
      params.sampleRate,
      params.colSampleRate,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.predNoiseBandwidth,
      params.interactionConstraints,
      params.autoRebalance,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for GBM model.
   */
  public GBMV3 grid_search_gbm() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGbm().execute().body();
  }
  public GBMV3 grid_search_gbm(GBMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGbm(
      params.learnRate,
      params.learnRateAnnealing,
      params.sampleRate,
      params.colSampleRate,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.predNoiseBandwidth,
      params.interactionConstraints,
      params.autoRebalance,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for GBM model.
   */
  public GBMV3 grid_search_gbm_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGbm().execute().body();
  }
  public GBMV3 grid_search_gbm_resume(GBMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGbm(
      params.learnRate,
      params.learnRateAnnealing,
      params.sampleRate,
      params.colSampleRate,
      params.monotoneConstraints,
      params.maxAbsLeafnodePred,
      params.predNoiseBandwidth,
      params.interactionConstraints,
      params.autoRebalance,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a IsolationForest model.
   */
  public IsolationForestV3 train_isolationforest() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainIsolationforest().execute().body();
  }
  public IsolationForestV3 train_isolationforest(IsolationForestParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainIsolationforest(
      params.sampleSize,
      params.sampleRate,
      params.mtries,
      params.contamination,
      colToString(params.validationResponseColumn),
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of IsolationForest model builder parameters.
   */
  public IsolationForestV3 validate_isolationforest() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersIsolationforest().execute().body();
  }
  public IsolationForestV3 validate_isolationforest(IsolationForestParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersIsolationforest(
      params.sampleSize,
      params.sampleRate,
      params.mtries,
      params.contamination,
      colToString(params.validationResponseColumn),
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for IsolationForest model.
   */
  public IsolationForestV3 grid_search_isolationforest() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainIsolationforest().execute().body();
  }
  public IsolationForestV3 grid_search_isolationforest(IsolationForestParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainIsolationforest(
      params.sampleSize,
      params.sampleRate,
      params.mtries,
      params.contamination,
      colToString(params.validationResponseColumn),
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for IsolationForest model.
   */
  public IsolationForestV3 grid_search_isolationforest_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeIsolationforest().execute().body();
  }
  public IsolationForestV3 grid_search_isolationforest_resume(IsolationForestParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeIsolationforest(
      params.sampleSize,
      params.sampleRate,
      params.mtries,
      params.contamination,
      colToString(params.validationResponseColumn),
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a ExtendedIsolationForest model.
   */
  public ExtendedIsolationForestV3 train_extendedisolationforest() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainExtendedisolationforest().execute().body();
  }
  public ExtendedIsolationForestV3 train_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainExtendedisolationforest(
      params.ntrees,
      params.sampleSize,
      params.extensionLevel,
      params.seed,
      params.scoreTreeInterval,
      params.disableTrainingMetrics,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of ExtendedIsolationForest model builder parameters.
   */
  public ExtendedIsolationForestV3 validate_extendedisolationforest() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersExtendedisolationforest().execute().body();
  }
  public ExtendedIsolationForestV3 validate_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersExtendedisolationforest(
      params.ntrees,
      params.sampleSize,
      params.extensionLevel,
      params.seed,
      params.scoreTreeInterval,
      params.disableTrainingMetrics,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for ExtendedIsolationForest model.
   */
  public ExtendedIsolationForestV3 grid_search_extendedisolationforest() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainExtendedisolationforest().execute().body();
  }
  public ExtendedIsolationForestV3 grid_search_extendedisolationforest(ExtendedIsolationForestParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainExtendedisolationforest(
      params.ntrees,
      params.sampleSize,
      params.extensionLevel,
      params.seed,
      params.scoreTreeInterval,
      params.disableTrainingMetrics,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for ExtendedIsolationForest model.
   */
  public ExtendedIsolationForestV3 grid_search_extendedisolationforest_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeExtendedisolationforest().execute().body();
  }
  public ExtendedIsolationForestV3 grid_search_extendedisolationforest_resume(ExtendedIsolationForestParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeExtendedisolationforest(
      params.ntrees,
      params.sampleSize,
      params.extensionLevel,
      params.seed,
      params.scoreTreeInterval,
      params.disableTrainingMetrics,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a Aggregator model.
   */
  public AggregatorV99 train_aggregator() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAggregator().execute().body();
  }
  public AggregatorV99 train_aggregator(AggregatorParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAggregator(
      params.transform,
      params.pcaMethod,
      params.k,
      params.maxIterations,
      params.targetNumExemplars,
      params.relTolNumExemplars,
      params.seed,
      params.useAllFactorLevels,
      params.saveMappingFrame,
      params.numIterationWithoutNewExemplar,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of Aggregator model builder parameters.
   */
  public AggregatorV99 validate_aggregator() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAggregator().execute().body();
  }
  public AggregatorV99 validate_aggregator(AggregatorParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAggregator(
      params.transform,
      params.pcaMethod,
      params.k,
      params.maxIterations,
      params.targetNumExemplars,
      params.relTolNumExemplars,
      params.seed,
      params.useAllFactorLevels,
      params.saveMappingFrame,
      params.numIterationWithoutNewExemplar,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for Aggregator model.
   */
  public AggregatorV99 grid_search_aggregator() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAggregator().execute().body();
  }
  public AggregatorV99 grid_search_aggregator(AggregatorParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAggregator(
      params.transform,
      params.pcaMethod,
      params.k,
      params.maxIterations,
      params.targetNumExemplars,
      params.relTolNumExemplars,
      params.seed,
      params.useAllFactorLevels,
      params.saveMappingFrame,
      params.numIterationWithoutNewExemplar,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for Aggregator model.
   */
  public AggregatorV99 grid_search_aggregator_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAggregator().execute().body();
  }
  public AggregatorV99 grid_search_aggregator_resume(AggregatorParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAggregator(
      params.transform,
      params.pcaMethod,
      params.k,
      params.maxIterations,
      params.targetNumExemplars,
      params.relTolNumExemplars,
      params.seed,
      params.useAllFactorLevels,
      params.saveMappingFrame,
      params.numIterationWithoutNewExemplar,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a Word2Vec model.
   */
  public Word2VecV3 train_word2vec() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainWord2vec().execute().body();
  }
  public Word2VecV3 train_word2vec(Word2VecParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainWord2vec(
      params.vecSize,
      params.windowSize,
      params.sentSampleRate,
      params.normModel,
      params.epochs,
      params.minWordFreq,
      params.initLearningRate,
      params.wordModel,
      keyToString(params.preTrained),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of Word2Vec model builder parameters.
   */
  public Word2VecV3 validate_word2vec() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersWord2vec().execute().body();
  }
  public Word2VecV3 validate_word2vec(Word2VecParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersWord2vec(
      params.vecSize,
      params.windowSize,
      params.sentSampleRate,
      params.normModel,
      params.epochs,
      params.minWordFreq,
      params.initLearningRate,
      params.wordModel,
      keyToString(params.preTrained),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for Word2Vec model.
   */
  public Word2VecV3 grid_search_word2vec() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainWord2vec().execute().body();
  }
  public Word2VecV3 grid_search_word2vec(Word2VecParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainWord2vec(
      params.vecSize,
      params.windowSize,
      params.sentSampleRate,
      params.normModel,
      params.epochs,
      params.minWordFreq,
      params.initLearningRate,
      params.wordModel,
      keyToString(params.preTrained),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for Word2Vec model.
   */
  public Word2VecV3 grid_search_word2vec_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeWord2vec().execute().body();
  }
  public Word2VecV3 grid_search_word2vec_resume(Word2VecParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeWord2vec(
      params.vecSize,
      params.windowSize,
      params.sentSampleRate,
      params.normModel,
      params.epochs,
      params.minWordFreq,
      params.initLearningRate,
      params.wordModel,
      keyToString(params.preTrained),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a StackedEnsemble model.
   */
  public StackedEnsembleV99 train_stackedensemble(KeyV3[] baseModels) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainStackedensemble(keyArrayToStringArray(baseModels)).execute().body();
  }
  public StackedEnsembleV99 train_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainStackedensemble(
      keyArrayToStringArray(params.baseModels),
      params.metalearnerAlgorithm,
      params.metalearnerNfolds,
      params.metalearnerFoldAssignment,
      colToString(params.metalearnerFoldColumn),
      params.metalearnerTransform,
      params.keepLeveloneFrame,
      params.metalearnerParams,
      keyToString(params.blendingFrame),
      params.seed,
      params.scoreTrainingSamples,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of StackedEnsemble model builder parameters.
   */
  public StackedEnsembleV99 validate_stackedensemble(KeyV3[] baseModels) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersStackedensemble(keyArrayToStringArray(baseModels)).execute().body();
  }
  public StackedEnsembleV99 validate_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersStackedensemble(
      keyArrayToStringArray(params.baseModels),
      params.metalearnerAlgorithm,
      params.metalearnerNfolds,
      params.metalearnerFoldAssignment,
      colToString(params.metalearnerFoldColumn),
      params.metalearnerTransform,
      params.keepLeveloneFrame,
      params.metalearnerParams,
      keyToString(params.blendingFrame),
      params.seed,
      params.scoreTrainingSamples,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for StackedEnsemble model.
   */
  public StackedEnsembleV99 grid_search_stackedensemble(KeyV3[] baseModels) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainStackedensemble(keyArrayToStringArray(baseModels)).execute().body();
  }
  public StackedEnsembleV99 grid_search_stackedensemble(StackedEnsembleParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainStackedensemble(
      keyArrayToStringArray(params.baseModels),
      params.metalearnerAlgorithm,
      params.metalearnerNfolds,
      params.metalearnerFoldAssignment,
      colToString(params.metalearnerFoldColumn),
      params.metalearnerTransform,
      params.keepLeveloneFrame,
      params.metalearnerParams,
      keyToString(params.blendingFrame),
      params.seed,
      params.scoreTrainingSamples,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for StackedEnsemble model.
   */
  public StackedEnsembleV99 grid_search_stackedensemble_resume(KeyV3[] baseModels) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeStackedensemble(keyArrayToStringArray(baseModels)).execute().body();
  }
  public StackedEnsembleV99 grid_search_stackedensemble_resume(StackedEnsembleParametersV99 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeStackedensemble(
      keyArrayToStringArray(params.baseModels),
      params.metalearnerAlgorithm,
      params.metalearnerNfolds,
      params.metalearnerFoldAssignment,
      colToString(params.metalearnerFoldColumn),
      params.metalearnerTransform,
      params.keepLeveloneFrame,
      params.metalearnerParams,
      keyToString(params.blendingFrame),
      params.seed,
      params.scoreTrainingSamples,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a CoxPH model.
   */
  public CoxPHV3 train_coxph() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainCoxph().execute().body();
  }
  public CoxPHV3 train_coxph(CoxPHParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainCoxph(
      colToString(params.startColumn),
      colToString(params.stopColumn),
      params.stratifyBy,
      params.ties,
      params.init,
      params.lreMin,
      params.maxIterations,
      params.interactionsOnly,
      params.interactions,
      params.interactionPairs,
      params.useAllFactorLevels,
      params.singleNodeMode,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of CoxPH model builder parameters.
   */
  public CoxPHV3 validate_coxph() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersCoxph().execute().body();
  }
  public CoxPHV3 validate_coxph(CoxPHParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersCoxph(
      colToString(params.startColumn),
      colToString(params.stopColumn),
      params.stratifyBy,
      params.ties,
      params.init,
      params.lreMin,
      params.maxIterations,
      params.interactionsOnly,
      params.interactions,
      params.interactionPairs,
      params.useAllFactorLevels,
      params.singleNodeMode,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for CoxPH model.
   */
  public CoxPHV3 grid_search_coxph() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainCoxph().execute().body();
  }
  public CoxPHV3 grid_search_coxph(CoxPHParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainCoxph(
      colToString(params.startColumn),
      colToString(params.stopColumn),
      params.stratifyBy,
      params.ties,
      params.init,
      params.lreMin,
      params.maxIterations,
      params.interactionsOnly,
      params.interactions,
      params.interactionPairs,
      params.useAllFactorLevels,
      params.singleNodeMode,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for CoxPH model.
   */
  public CoxPHV3 grid_search_coxph_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeCoxph().execute().body();
  }
  public CoxPHV3 grid_search_coxph_resume(CoxPHParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeCoxph(
      colToString(params.startColumn),
      colToString(params.stopColumn),
      params.stratifyBy,
      params.ties,
      params.init,
      params.lreMin,
      params.maxIterations,
      params.interactionsOnly,
      params.interactions,
      params.interactionPairs,
      params.useAllFactorLevels,
      params.singleNodeMode,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a Generic model.
   */
  public GenericV3 train_generic() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGeneric().execute().body();
  }
  public GenericV3 train_generic(GenericParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGeneric(
      params.path,
      keyToString(params.modelKey),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of Generic model builder parameters.
   */
  public GenericV3 validate_generic() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGeneric().execute().body();
  }
  public GenericV3 validate_generic(GenericParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGeneric(
      params.path,
      keyToString(params.modelKey),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for Generic model.
   */
  public GenericV3 grid_search_generic() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGeneric().execute().body();
  }
  public GenericV3 grid_search_generic(GenericParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGeneric(
      params.path,
      keyToString(params.modelKey),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for Generic model.
   */
  public GenericV3 grid_search_generic_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGeneric().execute().body();
  }
  public GenericV3 grid_search_generic_resume(GenericParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGeneric(
      params.path,
      keyToString(params.modelKey),
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a GAM model.
   */
  public GAMV3 train_gam(String[][] gamColumns) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGam(gamColumns).execute().body();
  }
  public GAMV3 train_gam(GAMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainGam(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.startval,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.standardize,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.intercept,
      params.prior,
      params.coldStart,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.storeKnotLocations,
      params.numKnots,
      params.splineOrders,
      params.splinesNonNegative,
      params.gamColumns,
      params.scale,
      params.bs,
      params.keepGamCols,
      params.standardizeTpGamCols,
      params.scaleTpPenaltyMat,
      params.knotIds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of GAM model builder parameters.
   */
  public GAMV3 validate_gam(String[][] gamColumns) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGam(gamColumns).execute().body();
  }
  public GAMV3 validate_gam(GAMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersGam(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.startval,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.standardize,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.intercept,
      params.prior,
      params.coldStart,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.storeKnotLocations,
      params.numKnots,
      params.splineOrders,
      params.splinesNonNegative,
      params.gamColumns,
      params.scale,
      params.bs,
      params.keepGamCols,
      params.standardizeTpGamCols,
      params.scaleTpPenaltyMat,
      params.knotIds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for GAM model.
   */
  public GAMV3 grid_search_gam(String[][] gamColumns) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGam(gamColumns).execute().body();
  }
  public GAMV3 grid_search_gam(GAMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainGam(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.startval,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.standardize,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.intercept,
      params.prior,
      params.coldStart,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.storeKnotLocations,
      params.numKnots,
      params.splineOrders,
      params.splinesNonNegative,
      params.gamColumns,
      params.scale,
      params.bs,
      params.keepGamCols,
      params.standardizeTpGamCols,
      params.scaleTpPenaltyMat,
      params.knotIds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for GAM model.
   */
  public GAMV3 grid_search_gam_resume(String[][] gamColumns) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGam(gamColumns).execute().body();
  }
  public GAMV3 grid_search_gam_resume(GAMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeGam(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.startval,
      params.lambdaSearch,
      params.earlyStopping,
      params.nlambdas,
      params.standardize,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.intercept,
      params.prior,
      params.coldStart,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.interactions,
      params.interactionPairs,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.storeKnotLocations,
      params.numKnots,
      params.splineOrders,
      params.splinesNonNegative,
      params.gamColumns,
      params.scale,
      params.bs,
      params.keepGamCols,
      params.standardizeTpGamCols,
      params.scaleTpPenaltyMat,
      params.knotIds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a ANOVAGLM model.
   */
  public ANOVAGLMV3 train_anovaglm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAnovaglm().execute().body();
  }
  public ANOVAGLMV3 train_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAnovaglm(
      params.seed,
      params.standardize,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.solver,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.computePValues,
      params.maxIterations,
      params.link,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.highestInteractionTerm,
      params.type,
      params.earlyStopping,
      params.saveTransformedFramekeys,
      params.nparallelism,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of ANOVAGLM model builder parameters.
   */
  public ANOVAGLMV3 validate_anovaglm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAnovaglm().execute().body();
  }
  public ANOVAGLMV3 validate_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAnovaglm(
      params.seed,
      params.standardize,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.solver,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.computePValues,
      params.maxIterations,
      params.link,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.highestInteractionTerm,
      params.type,
      params.earlyStopping,
      params.saveTransformedFramekeys,
      params.nparallelism,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for ANOVAGLM model.
   */
  public ANOVAGLMV3 grid_search_anovaglm() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAnovaglm().execute().body();
  }
  public ANOVAGLMV3 grid_search_anovaglm(ANOVAGLMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAnovaglm(
      params.seed,
      params.standardize,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.solver,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.computePValues,
      params.maxIterations,
      params.link,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.highestInteractionTerm,
      params.type,
      params.earlyStopping,
      params.saveTransformedFramekeys,
      params.nparallelism,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for ANOVAGLM model.
   */
  public ANOVAGLMV3 grid_search_anovaglm_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAnovaglm().execute().body();
  }
  public ANOVAGLMV3 grid_search_anovaglm_resume(ANOVAGLMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAnovaglm(
      params.seed,
      params.standardize,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.solver,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.computePValues,
      params.maxIterations,
      params.link,
      params.prior,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.highestInteractionTerm,
      params.type,
      params.earlyStopping,
      params.saveTransformedFramekeys,
      params.nparallelism,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a PSVM model.
   */
  public PSVMV3 train_psvm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainPsvm().execute().body();
  }
  public PSVMV3 train_psvm(PSVMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainPsvm(
      params.hyperParam,
      params.kernelType,
      params.gamma,
      params.rankRatio,
      params.positiveWeight,
      params.negativeWeight,
      params.disableTrainingMetrics,
      params.svThreshold,
      params.maxIterations,
      params.factThreshold,
      params.feasibleThreshold,
      params.surrogateGapThreshold,
      params.muFactor,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of PSVM model builder parameters.
   */
  public PSVMV3 validate_psvm() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersPsvm().execute().body();
  }
  public PSVMV3 validate_psvm(PSVMParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersPsvm(
      params.hyperParam,
      params.kernelType,
      params.gamma,
      params.rankRatio,
      params.positiveWeight,
      params.negativeWeight,
      params.disableTrainingMetrics,
      params.svThreshold,
      params.maxIterations,
      params.factThreshold,
      params.feasibleThreshold,
      params.surrogateGapThreshold,
      params.muFactor,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for PSVM model.
   */
  public PSVMV3 grid_search_psvm() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainPsvm().execute().body();
  }
  public PSVMV3 grid_search_psvm(PSVMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainPsvm(
      params.hyperParam,
      params.kernelType,
      params.gamma,
      params.rankRatio,
      params.positiveWeight,
      params.negativeWeight,
      params.disableTrainingMetrics,
      params.svThreshold,
      params.maxIterations,
      params.factThreshold,
      params.feasibleThreshold,
      params.surrogateGapThreshold,
      params.muFactor,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for PSVM model.
   */
  public PSVMV3 grid_search_psvm_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumePsvm().execute().body();
  }
  public PSVMV3 grid_search_psvm_resume(PSVMParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumePsvm(
      params.hyperParam,
      params.kernelType,
      params.gamma,
      params.rankRatio,
      params.positiveWeight,
      params.negativeWeight,
      params.disableTrainingMetrics,
      params.svThreshold,
      params.maxIterations,
      params.factThreshold,
      params.feasibleThreshold,
      params.surrogateGapThreshold,
      params.muFactor,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a RuleFit model.
   */
  public RuleFitV3 train_rulefit() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainRulefit().execute().body();
  }
  public RuleFitV3 train_rulefit(RuleFitParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainRulefit(
      params.seed,
      params.algorithm,
      params.minRuleLength,
      params.maxRuleLength,
      params.maxNumRules,
      params.modelType,
      params.ruleGenerationNtrees,
      params.removeDuplicates,
      params.lambda,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of RuleFit model builder parameters.
   */
  public RuleFitV3 validate_rulefit() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersRulefit().execute().body();
  }
  public RuleFitV3 validate_rulefit(RuleFitParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersRulefit(
      params.seed,
      params.algorithm,
      params.minRuleLength,
      params.maxRuleLength,
      params.maxNumRules,
      params.modelType,
      params.ruleGenerationNtrees,
      params.removeDuplicates,
      params.lambda,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for RuleFit model.
   */
  public RuleFitV3 grid_search_rulefit() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainRulefit().execute().body();
  }
  public RuleFitV3 grid_search_rulefit(RuleFitParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainRulefit(
      params.seed,
      params.algorithm,
      params.minRuleLength,
      params.maxRuleLength,
      params.maxNumRules,
      params.modelType,
      params.ruleGenerationNtrees,
      params.removeDuplicates,
      params.lambda,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for RuleFit model.
   */
  public RuleFitV3 grid_search_rulefit_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeRulefit().execute().body();
  }
  public RuleFitV3 grid_search_rulefit_resume(RuleFitParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeRulefit(
      params.seed,
      params.algorithm,
      params.minRuleLength,
      params.maxRuleLength,
      params.maxNumRules,
      params.modelType,
      params.ruleGenerationNtrees,
      params.removeDuplicates,
      params.lambda,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a UpliftDRF model.
   */
  public UpliftDRFV3 train_upliftdrf(String treatmentColumn) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainUpliftdrf(treatmentColumn).execute().body();
  }
  public UpliftDRFV3 train_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainUpliftdrf(
      params.mtries,
      params.sampleRate,
      params.treatmentColumn,
      params.upliftMetric,
      params.auucType,
      params.auucNbins,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of UpliftDRF model builder parameters.
   */
  public UpliftDRFV3 validate_upliftdrf(String treatmentColumn) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersUpliftdrf(treatmentColumn).execute().body();
  }
  public UpliftDRFV3 validate_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersUpliftdrf(
      params.mtries,
      params.sampleRate,
      params.treatmentColumn,
      params.upliftMetric,
      params.auucType,
      params.auucNbins,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for UpliftDRF model.
   */
  public UpliftDRFV3 grid_search_upliftdrf(String treatmentColumn) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainUpliftdrf(treatmentColumn).execute().body();
  }
  public UpliftDRFV3 grid_search_upliftdrf(UpliftDRFParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainUpliftdrf(
      params.mtries,
      params.sampleRate,
      params.treatmentColumn,
      params.upliftMetric,
      params.auucType,
      params.auucNbins,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for UpliftDRF model.
   */
  public UpliftDRFV3 grid_search_upliftdrf_resume(String treatmentColumn) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeUpliftdrf(treatmentColumn).execute().body();
  }
  public UpliftDRFV3 grid_search_upliftdrf_resume(UpliftDRFParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeUpliftdrf(
      params.mtries,
      params.sampleRate,
      params.treatmentColumn,
      params.upliftMetric,
      params.auucType,
      params.auucNbins,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.ntrees,
      params.maxDepth,
      params.minRows,
      params.nbins,
      params.nbinsTopLevel,
      params.nbinsCats,
      params.r2Stopping,
      params.seed,
      params.buildTreeOneNode,
      params.sampleRatePerClass,
      params.colSampleRatePerTree,
      params.colSampleRateChangePerLevel,
      params.scoreTreeInterval,
      params.minSplitImprovement,
      params.histogramType,
      params.calibrateModel,
      keyToString(params.calibrationFrame),
      params.calibrationMethod,
      params.checkConstantResponse,
      params.inTrainingCheckpointsDir,
      params.inTrainingCheckpointsTreeInterval,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a ModelSelection model.
   */
  public ModelSelectionV3 train_modelselection() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainModelselection().execute().body();
  }
  public ModelSelectionV3 train_modelselection(ModelSelectionParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainModelselection(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.multinodeMode,
      params.buildGlmModel,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.startval,
      params.calcLike,
      params.mode,
      params.intercept,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.maxPredictorNumber,
      params.minPredictorNumber,
      params.nparallelism,
      params.pValuesThreshold,
      params.influence,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of ModelSelection model builder parameters.
   */
  public ModelSelectionV3 validate_modelselection() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersModelselection().execute().body();
  }
  public ModelSelectionV3 validate_modelselection(ModelSelectionParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersModelselection(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.multinodeMode,
      params.buildGlmModel,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.startval,
      params.calcLike,
      params.mode,
      params.intercept,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.maxPredictorNumber,
      params.minPredictorNumber,
      params.nparallelism,
      params.pValuesThreshold,
      params.influence,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for ModelSelection model.
   */
  public ModelSelectionV3 grid_search_modelselection() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainModelselection().execute().body();
  }
  public ModelSelectionV3 grid_search_modelselection(ModelSelectionParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainModelselection(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.multinodeMode,
      params.buildGlmModel,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.startval,
      params.calcLike,
      params.mode,
      params.intercept,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.maxPredictorNumber,
      params.minPredictorNumber,
      params.nparallelism,
      params.pValuesThreshold,
      params.influence,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for ModelSelection model.
   */
  public ModelSelectionV3 grid_search_modelselection_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeModelselection().execute().body();
  }
  public ModelSelectionV3 grid_search_modelselection_resume(ModelSelectionParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeModelselection(
      params.seed,
      params.family,
      params.tweedieVariancePower,
      params.tweedieLinkPower,
      params.theta,
      params.solver,
      params.alpha,
      params.lambda,
      params.lambdaSearch,
      params.multinodeMode,
      params.buildGlmModel,
      params.earlyStopping,
      params.nlambdas,
      params.scoreIterationInterval,
      params.standardize,
      params.coldStart,
      params.missingValuesHandling,
      keyToString(params.plugValues),
      params.nonNegative,
      params.maxIterations,
      params.betaEpsilon,
      params.objectiveEpsilon,
      params.gradientEpsilon,
      params.objReg,
      params.link,
      params.startval,
      params.calcLike,
      params.mode,
      params.intercept,
      params.prior,
      params.lambdaMinRatio,
      keyToString(params.betaConstraints),
      params.maxActivePredictors,
      params.balanceClasses,
      params.classSamplingFactors,
      params.maxAfterBalanceSize,
      params.maxConfusionMatrixSize,
      params.computePValues,
      params.removeCollinearColumns,
      params.maxPredictorNumber,
      params.minPredictorNumber,
      params.nparallelism,
      params.pValuesThreshold,
      params.influence,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a IsotonicRegression model.
   */
  public IsotonicRegressionV3 train_isotonicregression() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainIsotonicregression().execute().body();
  }
  public IsotonicRegressionV3 train_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainIsotonicregression(
      params.outOfBounds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of IsotonicRegression model builder parameters.
   */
  public IsotonicRegressionV3 validate_isotonicregression() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersIsotonicregression().execute().body();
  }
  public IsotonicRegressionV3 validate_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersIsotonicregression(
      params.outOfBounds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for IsotonicRegression model.
   */
  public IsotonicRegressionV3 grid_search_isotonicregression() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainIsotonicregression().execute().body();
  }
  public IsotonicRegressionV3 grid_search_isotonicregression(IsotonicRegressionParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainIsotonicregression(
      params.outOfBounds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for IsotonicRegression model.
   */
  public IsotonicRegressionV3 grid_search_isotonicregression_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeIsotonicregression().execute().body();
  }
  public IsotonicRegressionV3 grid_search_isotonicregression_resume(IsotonicRegressionParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeIsotonicregression(
      params.outOfBounds,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a DT model.
   */
  public DTV3 train_dt() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDt().execute().body();
  }
  public DTV3 train_dt(DTParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainDt(
      params.seed,
      params.maxDepth,
      params.minRows,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of DT model builder parameters.
   */
  public DTV3 validate_dt() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDt().execute().body();
  }
  public DTV3 validate_dt(DTParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersDt(
      params.seed,
      params.maxDepth,
      params.minRows,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for DT model.
   */
  public DTV3 grid_search_dt() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDt().execute().body();
  }
  public DTV3 grid_search_dt(DTParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainDt(
      params.seed,
      params.maxDepth,
      params.minRows,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for DT model.
   */
  public DTV3 grid_search_dt_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDt().execute().body();
  }
  public DTV3 grid_search_dt_resume(DTParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeDt(
      params.seed,
      params.maxDepth,
      params.minRows,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Train a AdaBoost model.
   */
  public AdaBoostV3 train_adaboost() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAdaboost().execute().body();
  }
  public AdaBoostV3 train_adaboost(AdaBoostParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.trainAdaboost(
      params.nlearners,
      params.weakLearner,
      params.learnRate,
      params.weakLearnerParams,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Validate a set of AdaBoost model builder parameters.
   */
  public AdaBoostV3 validate_adaboost() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAdaboost().execute().body();
  }
  public AdaBoostV3 validate_adaboost(AdaBoostParametersV3 params) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.validate_parametersAdaboost(
      params.nlearners,
      params.weakLearner,
      params.learnRate,
      params.weakLearnerParams,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Run grid search for AdaBoost model.
   */
  public AdaBoostV3 grid_search_adaboost() throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAdaboost().execute().body();
  }
  public AdaBoostV3 grid_search_adaboost(AdaBoostParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.trainAdaboost(
      params.nlearners,
      params.weakLearner,
      params.learnRate,
      params.weakLearnerParams,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Resume grid search for AdaBoost model.
   */
  public AdaBoostV3 grid_search_adaboost_resume() throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAdaboost().execute().body();
  }
  public AdaBoostV3 grid_search_adaboost_resume(AdaBoostParametersV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.resumeAdaboost(
      params.nlearners,
      params.weakLearner,
      params.learnRate,
      params.weakLearnerParams,
      params.seed,
      keyToString(params.modelId),
      keyToString(params.trainingFrame),
      keyToString(params.validationFrame),
      params.nfolds,
      params.keepCrossValidationModels,
      params.keepCrossValidationPredictions,
      params.keepCrossValidationFoldAssignment,
      params.parallelizeCrossValidation,
      params.distribution,
      params.tweediePower,
      params.quantileAlpha,
      params.huberAlpha,
      colToString(params.responseColumn),
      colToString(params.weightsColumn),
      colToString(params.offsetColumn),
      colToString(params.foldColumn),
      params.foldAssignment,
      params.categoricalEncoding,
      params.maxCategoricalLevels,
      params.ignoredColumns,
      params.ignoreConstCols,
      params.scoreEachIteration,
      keyToString(params.checkpoint),
      params.stoppingRounds,
      params.maxRuntimeSecs,
      params.stoppingMetric,
      params.stoppingTolerance,
      params.gainsliftBins,
      params.customMetricFunc,
      params.customDistributionFunc,
      params.exportCheckpointsDir,
      params.aucType
    ).execute().body();
  }

  /**
   * Make a new GLM model based on existing one
   */
  public GLMModelV3 make_glm_model(ModelKeyV3 model, String[] names, double[] beta) throws IOException {
    MakeGLMModel s = getService(MakeGLMModel.class);
    return s.make_model(keyToString(model), names, beta).execute().body();
  }
  public GLMModelV3 make_glm_model(MakeGLMModelV3 params) throws IOException {
    MakeGLMModel s = getService(MakeGLMModel.class);
    return s.make_model(
      keyToString(params.model),
      keyToString(params.dest),
      params.names,
      params.beta,
      params.threshold
    ).execute().body();
  }

  /**
   * Get full regularization path
   */
  public GLMRegularizationPathV3 glm_regularization_path(ModelKeyV3 model) throws IOException {
    GetGLMRegPath s = getService(GetGLMRegPath.class);
    return s.extractRegularizationPath(keyToString(model)).execute().body();
  }
  public GLMRegularizationPathV3 glm_regularization_path(GLMRegularizationPathV3 params) throws IOException {
    GetGLMRegPath s = getService(GetGLMRegPath.class);
    return s.extractRegularizationPath(
      keyToString(params.model),
      params.lambdas,
      params.alphas,
      params.explainedDevianceTrain,
      params.explainedDevianceValid,
      params.coefficients,
      params.coefficientsStd,
      params.coefficientNames,
      params.zValues,
      params.pValues,
      params.stdErrs
    ).execute().body();
  }

  /**
   * Get weighted gram matrix
   */
  public GramV3 weighted_gram_matrix(FrameKeyV3 x) throws IOException {
    ComputeGram s = getService(ComputeGram.class);
    return s.computeGram(keyToString(x)).execute().body();
  }
  public GramV3 weighted_gram_matrix(GramV3 params) throws IOException {
    ComputeGram s = getService(ComputeGram.class);
    return s.computeGram(
      keyToString(params.x),
      colToString(params.w),
      params.useAllFactorLevels,
      params.standardize,
      params.skipMissing
    ).execute().body();
  }

  /**
   * Find synonyms using a word2vec model
   */
  public Word2VecSynonymsV3 word2vec_synonyms(ModelKeyV3 model, String word, int count) throws IOException {
    Word2VecSynonyms s = getService(Word2VecSynonyms.class);
    return s.findSynonyms(keyToString(model), word, count).execute().body();
  }
  public Word2VecSynonymsV3 word2vec_synonyms(Word2VecSynonymsV3 params) throws IOException {
    Word2VecSynonyms s = getService(Word2VecSynonyms.class);
    return s.findSynonyms(
      keyToString(params.model),
      params.word,
      params.count,
      params.synonyms,
      params.scores
    ).execute().body();
  }

  /**
   * Transform words to vectors using a word2vec model
   */
  public Word2VecTransformV3 word2vec_transform(ModelKeyV3 model, FrameKeyV3 wordsFrame) throws IOException {
    Word2VecTransform s = getService(Word2VecTransform.class);
    return s.transform(keyToString(model), keyToString(wordsFrame)).execute().body();
  }
  public Word2VecTransformV3 word2vec_transform(ModelKeyV3 model, FrameKeyV3 wordsFrame, Word2VecModelAggregateMethod aggregateMethod) throws IOException {
    Word2VecTransform s = getService(Word2VecTransform.class);
    return s.transform(keyToString(model), keyToString(wordsFrame), aggregateMethod).execute().body();
  }

  /**
   * Test only
   */
  public DataInfoFrameV3 glm_datainfo_frame() throws IOException {
    DataInfoFrame s = getService(DataInfoFrame.class);
    return s.getDataInfoFrame().execute().body();
  }
  public DataInfoFrameV3 glm_datainfo_frame(DataInfoFrameV3 params) throws IOException {
    DataInfoFrame s = getService(DataInfoFrame.class);
    return s.getDataInfoFrame(
      keyToString(params.frame),
      params.interactions,
      params.useAll,
      params.standardize,
      params.interactionsOnly
    ).execute().body();
  }

  /**
   * Obtain a traverseable representation of a specific tree
   */
  public TreeV3 get_tree(ModelKeyV3 model, int treeNumber) throws IOException {
    Tree s = getService(Tree.class);
    return s.getTree(keyToString(model), treeNumber).execute().body();
  }
  public TreeV3 get_tree(TreeV3 params) throws IOException {
    Tree s = getService(Tree.class);
    return s.getTree(
      keyToString(params.model),
      params.treeNumber,
      params.treeClass,
      params.plainLanguageRules
    ).execute().body();
  }

  /**
   * Create a synthetic H2O Frame with random data. You can specify the number of rows/columns, as well as column types:
   * integer, real, boolean, time, string, categorical. The frame may also have a dedicated "response" column, and some
   * of the entries in the dataset may be created as missing.
   */
  public JobV3 createFrame() throws IOException {
    CreateFrame s = getService(CreateFrame.class);
    return s.run().execute().body();
  }
  public JobV3 createFrame(CreateFrameV3 params) throws IOException {
    CreateFrame s = getService(CreateFrame.class);
    return s.run(
      keyToString(params.dest),
      params.rows,
      params.cols,
      params.seed,
      params.seedForColumnTypes,
      params.randomize,
      params.value,
      params.realRange,
      params.categoricalFraction,
      params.factors,
      params.integerFraction,
      params.integerRange,
      params.binaryFraction,
      params.binaryOnesFraction,
      params.timeFraction,
      params.stringFraction,
      params.missingFraction,
      params.hasResponse,
      params.responseFactors,
      params.positiveResponse,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Split an H2O Frame.
   */
  public SplitFrameV3 splitFrame() throws IOException {
    SplitFrame s = getService(SplitFrame.class);
    return s.run().execute().body();
  }
  public SplitFrameV3 splitFrame(SplitFrameV3 params) throws IOException {
    SplitFrame s = getService(SplitFrame.class);
    return s.run(
      keyToString(params.key),
      keyToString(params.dataset),
      params.ratios,
      keyArrayToStringArray(params.destinationFrames)
    ).execute().body();
  }

  /**
   * Create interactions between categorical columns.
   */
  public JobV3 generateInteractions(int maxFactors) throws IOException {
    Interaction s = getService(Interaction.class);
    return s.run(maxFactors).execute().body();
  }
  public JobV3 generateInteractions(InteractionV3 params) throws IOException {
    Interaction s = getService(Interaction.class);
    return s.run(
      keyToString(params.dest),
      keyToString(params.sourceFrame),
      params.factorColumns,
      params.pairwise,
      params.maxFactors,
      params.minOccurrence,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Insert missing values.
   */
  public JobV3 _missingInserter_run(FrameKeyV3 dataset, double fraction) throws IOException {
    MissingInserter s = getService(MissingInserter.class);
    return s.run(keyToString(dataset), fraction).execute().body();
  }
  public JobV3 _missingInserter_run(MissingInserterV3 params) throws IOException {
    MissingInserter s = getService(MissingInserter.class);
    return s.run(
      keyToString(params.dataset),
      params.fraction,
      params.seed,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Row-by-row discrete cosine transforms in 1D, 2D and 3D.
   */
  public JobV3 _dctTransformer_run(FrameKeyV3 dataset, int[] dimensions) throws IOException {
    DCTTransformer s = getService(DCTTransformer.class);
    return s.run(keyToString(dataset), dimensions).execute().body();
  }
  public JobV3 _dctTransformer_run(DCTTransformerV3 params) throws IOException {
    DCTTransformer s = getService(DCTTransformer.class);
    return s.run(
      keyToString(params.dataset),
      keyToString(params.destinationFrame),
      params.dimensions,
      params.inverse,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Tabulate one column vs another.
   */
  public TabulateV3 _tabulate_run(FrameKeyV3 dataset, ColSpecifierV3 predictor, ColSpecifierV3 response) throws IOException {
    Tabulate s = getService(Tabulate.class);
    return s.run(keyToString(dataset), colToString(predictor), colToString(response)).execute().body();
  }
  public TabulateV3 _tabulate_run(TabulateV3 params) throws IOException {
    Tabulate s = getService(Tabulate.class);
    return s.run(
      keyToString(params.dataset),
      colToString(params.predictor),
      colToString(params.response),
      colToString(params.weight),
      params.nbinsPredictor,
      params.nbinsResponse
    ).execute().body();
  }

  /**
   * Import raw data files into a single-column H2O Frame.
   */
  public ImportFilesV3 importFiles(String path) throws IOException {
    ImportFiles s = getService(ImportFiles.class);
    return s.importFiles(path).execute().body();
  }
  public ImportFilesV3 importFiles(String path, String pattern) throws IOException {
    ImportFiles s = getService(ImportFiles.class);
    return s.importFiles(path, pattern, "").execute().body();
  }
  public ImportFilesV3 importFiles(String path, String pattern, String _excludeFields) throws IOException {
    ImportFiles s = getService(ImportFiles.class);
    return s.importFiles(path, pattern, _excludeFields).execute().body();
  }

  /**
   * Import raw data files from multiple directories (or different data sources) into a single-column H2O Frame.
   */
  public ImportFilesMultiV3 importFilesMulti(String[] paths) throws IOException {
    ImportFilesMulti s = getService(ImportFilesMulti.class);
    return s.importFilesMulti(paths).execute().body();
  }
  public ImportFilesMultiV3 importFilesMulti(String[] paths, String pattern) throws IOException {
    ImportFilesMulti s = getService(ImportFilesMulti.class);
    return s.importFilesMulti(paths, pattern, "").execute().body();
  }
  public ImportFilesMultiV3 importFilesMulti(String[] paths, String pattern, String _excludeFields) throws IOException {
    ImportFilesMulti s = getService(ImportFilesMulti.class);
    return s.importFilesMulti(paths, pattern, _excludeFields).execute().body();
  }

  /**
   * Import SQL table into an H2O Frame.
   */
  public JobV3 importSqlTable(String connectionUrl, String username, String password) throws IOException {
    ImportSQLTable s = getService(ImportSQLTable.class);
    return s.importSQLTable(connectionUrl, username, password).execute().body();
  }
  public JobV3 importSqlTable(ImportSQLTableV99 params) throws IOException {
    ImportSQLTable s = getService(ImportSQLTable.class);
    return s.importSQLTable(
      params.connectionUrl,
      params.table,
      params.selectQuery,
      params.useTempTable,
      params.tempTableName,
      params.username,
      params.password,
      params.columns,
      params.fetchMode,
      params.numChunksHint,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Import Hive table into an H2O Frame.
   */
  public JobV3 importHiveTable(String table) throws IOException {
    ImportHiveTable s = getService(ImportHiveTable.class);
    return s.importHiveTable(table).execute().body();
  }
  public JobV3 importHiveTable(ImportHiveTableV3 params) throws IOException {
    ImportHiveTable s = getService(ImportHiveTable.class);
    return s.importHiveTable(
      params.database,
      params.table,
      params.partitions,
      params.allowMultiFormat,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Save an H2O Frame contents into a Hive table.
   */
  public SaveToHiveTableV3 saveToHiveTable(FrameKeyV3 frameId, String jdbcUrl, String tableName) throws IOException {
    SaveToHiveTable s = getService(SaveToHiveTable.class);
    return s.saveToHiveTable(keyToString(frameId), jdbcUrl, tableName).execute().body();
  }
  public SaveToHiveTableV3 saveToHiveTable(SaveToHiveTableV3 params) throws IOException {
    SaveToHiveTable s = getService(SaveToHiveTable.class);
    return s.saveToHiveTable(
      keyToString(params.frameId),
      params.jdbcUrl,
      params.tableName,
      params.tablePath,
      params.format,
      params.tmpPath,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Guess the parameters for parsing raw byte-oriented data into an H2O Frame.
   */
  public ParseSetupV3 guessParseSetup(FrameKeyV3[] sourceFrames) throws IOException {
    ParseSetup s = getService(ParseSetup.class);
    return s.guessSetup(keyArrayToStringArray(sourceFrames)).execute().body();
  }
  public ParseSetupV3 guessParseSetup(ParseSetupV3 params) throws IOException {
    ParseSetup s = getService(ParseSetup.class);
    return s.guessSetup(
      keyArrayToStringArray(params.sourceFrames),
      params.parseType,
      params.separator,
      params.singleQuotes,
      params.checkHeader,
      params.columnNames,
      params.skippedColumns,
      params.columnTypes,
      params.naStrings,
      params.columnNameFilter,
      params.columnOffset,
      params.columnCount,
      params.totalFilteredColumnCount,
      params.customNonDataLineMarkers,
      keyToString(params.decryptTool),
      params.partitionBy,
      params.escapechar,
      params.forceColTypes,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Parse a raw byte-oriented Frame into a useful columnar data Frame.
   */
  public ParseV3 parse(ParseV3 params) throws IOException {
    Parse s = getService(Parse.class);
    return s.parse(
      keyToString(params.destinationFrame),
      keyArrayToStringArray(params.sourceFrames),
      params.parseType,
      params.separator,
      params.singleQuotes,
      params.checkHeader,
      params.numberColumns,
      params.columnNames,
      params.columnTypes,
      params.skippedColumns,
      params.forceColTypes,
      params.domains,
      params.naStrings,
      params.chunkSize,
      params.deleteOnDone,
      params.blocking,
      keyToString(params.decryptTool),
      params.customNonDataLineMarkers,
      params.partitionBy,
      params.escapechar,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Install a decryption tool for parsing of encrypted data.
   */
  public DecryptionSetupV3 setupDecryption() throws IOException {
    DecryptionSetup s = getService(DecryptionSetup.class);
    return s.setupDecryption().execute().body();
  }
  public DecryptionSetupV3 setupDecryption(DecryptionSetupV3 params) throws IOException {
    DecryptionSetup s = getService(DecryptionSetup.class);
    return s.setupDecryption(
      keyToString(params.decryptToolId),
      params.decryptImpl,
      keyToString(params.keystoreId),
      params.keystoreType,
      params.keyAlias,
      params.password,
      params.cipherSpec,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Parse a raw byte-oriented Frame into a useful columnar data Frame.
   */
  public JobV3 parseSvmLight(FrameKeyV3[] sourceFrames) throws IOException {
    ParseSVMLight s = getService(ParseSVMLight.class);
    return s.parseSVMLight(keyArrayToStringArray(sourceFrames)).execute().body();
  }
  public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames) throws IOException {
    ParseSVMLight s = getService(ParseSVMLight.class);
    return s.parseSVMLight(keyToString(destinationFrame), keyArrayToStringArray(sourceFrames), "").execute().body();
  }
  public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames, String _excludeFields) throws IOException {
    ParseSVMLight s = getService(ParseSVMLight.class);
    return s.parseSVMLight(keyToString(destinationFrame), keyArrayToStringArray(sourceFrames), _excludeFields).execute().body();
  }

  /**
   * The endpoint used to let H2O know from external services that it should keep running.
   */
  public PingV3 ping() throws IOException {
    Ping s = getService(Ping.class);
    return s.ping().execute().body();
  }
  public PingV3 ping(String _excludeFields) throws IOException {
    Ping s = getService(Ping.class);
    return s.ping(_excludeFields).execute().body();
  }

  /**
   * Determine the status of the nodes in the H2O cloud.
   */
  public CloudV3 cloudStatus() throws IOException {
    Cloud s = getService(Cloud.class);
    return s.status().execute().body();
  }
  public CloudV3 cloudStatus(boolean skipTicks) throws IOException {
    Cloud s = getService(Cloud.class);
    return s.status(skipTicks, "").execute().body();
  }
  public CloudV3 cloudStatus(boolean skipTicks, String _excludeFields) throws IOException {
    Cloud s = getService(Cloud.class);
    return s.status(skipTicks, _excludeFields).execute().body();
  }

  /**
   * Determine the status of the nodes in the H2O cloud.
   */
  public CloudV3 cloudStatusMinimal() throws IOException {
    Cloud s = getService(Cloud.class);
    return s.head().execute().body();
  }
  public CloudV3 cloudStatusMinimal(boolean skipTicks) throws IOException {
    Cloud s = getService(Cloud.class);
    return s.head(skipTicks, "").execute().body();
  }
  public CloudV3 cloudStatusMinimal(boolean skipTicks, String _excludeFields) throws IOException {
    Cloud s = getService(Cloud.class);
    return s.head(skipTicks, _excludeFields).execute().body();
  }

  /**
   * Lock the cloud.
   */
  public CloudLockV3 cloudLock() throws IOException {
    CloudLock s = getService(CloudLock.class);
    return s.lock().execute().body();
  }
  public CloudLockV3 cloudLock(String reason) throws IOException {
    CloudLock s = getService(CloudLock.class);
    return s.lock(reason, "").execute().body();
  }
  public CloudLockV3 cloudLock(String reason, String _excludeFields) throws IOException {
    CloudLock s = getService(CloudLock.class);
    return s.lock(reason, _excludeFields).execute().body();
  }

  /**
   * Get a list of all the H2O Jobs (long-running actions).
   */
  public JobsV3 jobs() throws IOException {
    Jobs s = getService(Jobs.class);
    return s.list().execute().body();
  }
  public JobsV3 jobs(JobKeyV3 jobId) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.list(keyToString(jobId), "").execute().body();
  }
  public JobsV3 jobs(JobKeyV3 jobId, String _excludeFields) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.list(keyToString(jobId), _excludeFields).execute().body();
  }

  /**
   * Debugging tool that provides information on current communication between nodes.
   */
  public TimelineV3 timeline() throws IOException {
    Timeline s = getService(Timeline.class);
    return s.fetch().execute().body();
  }
  public TimelineV3 timeline(String _excludeFields) throws IOException {
    Timeline s = getService(Timeline.class);
    return s.fetch(_excludeFields).execute().body();
  }

  /**
   * Report real-time profiling information for all nodes (sorted, aggregated stack traces).
   */
  public ProfilerV3 profiler(int depth) throws IOException {
    Profiler s = getService(Profiler.class);
    return s.fetch(depth).execute().body();
  }
  public ProfilerV3 profiler(int depth, String _excludeFields) throws IOException {
    Profiler s = getService(Profiler.class);
    return s.fetch(depth, _excludeFields).execute().body();
  }

  /**
   * Report stack traces for all threads on all nodes.
   */
  public JStackV3 stacktraces() throws IOException {
    JStack s = getService(JStack.class);
    return s.fetch().execute().body();
  }
  public JStackV3 stacktraces(String _excludeFields) throws IOException {
    JStack s = getService(JStack.class);
    return s.fetch(_excludeFields).execute().body();
  }

  /**
   * Run a network test to measure the performance of the cluster interconnect.
   */
  public NetworkTestV3 testNetwork() throws IOException {
    NetworkTest s = getService(NetworkTest.class);
    return s.fetch().execute().body();
  }
  public NetworkTestV3 testNetwork(String _excludeFields) throws IOException {
    NetworkTest s = getService(NetworkTest.class);
    return s.fetch(_excludeFields).execute().body();
  }

  /**
   * Unlock all keys in the H2O distributed K/V store, to attempt to recover from a crash.
   */
  public UnlockKeysV3 unlockAllKeys() throws IOException {
    UnlockKeys s = getService(UnlockKeys.class);
    return s.unlock().execute().body();
  }
  public UnlockKeysV3 unlockAllKeys(String _excludeFields) throws IOException {
    UnlockKeys s = getService(UnlockKeys.class);
    return s.unlock(_excludeFields).execute().body();
  }

  /**
   * Shut down the cluster.
   */
  public ShutdownV3 shutdownCluster() throws IOException {
    Shutdown s = getService(Shutdown.class);
    return s.shutdown().execute().body();
  }
  public ShutdownV3 shutdownCluster(String _excludeFields) throws IOException {
    Shutdown s = getService(Shutdown.class);
    return s.shutdown(_excludeFields).execute().body();
  }

  /**
   * Return information about this H2O cluster.
   */
  public AboutV3 about() throws IOException {
    About s = getService(About.class);
    return s.get().execute().body();
  }
  public AboutV3 about(String _excludeFields) throws IOException {
    About s = getService(About.class);
    return s.get(_excludeFields).execute().body();
  }

  /**
   * Return the list of (almost) all REST API endpoints.
   */
  public MetadataV3 endpoints() throws IOException {
    Metadata s = getService(Metadata.class);
    return s.listRoutes().execute().body();
  }
  public MetadataV3 endpoints(MetadataV3 params) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.listRoutes(
      params.num,
      params.httpMethod,
      params.path,
      params.classname,
      params.schemaname,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the REST API endpoint metadata, including documentation, for the endpoint specified by path or index.
   */
  public MetadataV3 endpoint(String path) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchRoute(path).execute().body();
  }
  public MetadataV3 endpoint(MetadataV3 params) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchRoute(
      params.path,
      params.num,
      params.httpMethod,
      params.classname,
      params.schemaname,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the REST API schema metadata for specified schema class.
   */
  public MetadataV3 schemaForClass(String classname) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchSchemaMetadataByClass(classname).execute().body();
  }
  public MetadataV3 schemaForClass(MetadataV3 params) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchSchemaMetadataByClass(
      params.classname,
      params.num,
      params.httpMethod,
      params.path,
      params.schemaname,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the REST API schema metadata for specified schema.
   */
  public MetadataV3 schema(String schemaname) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchSchemaMetadata(schemaname).execute().body();
  }
  public MetadataV3 schema(MetadataV3 params) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.fetchSchemaMetadata(
      params.schemaname,
      params.num,
      params.httpMethod,
      params.path,
      params.classname,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return list of all REST API schemas.
   */
  public MetadataV3 schemas() throws IOException {
    Metadata s = getService(Metadata.class);
    return s.listSchemas().execute().body();
  }
  public MetadataV3 schemas(MetadataV3 params) throws IOException {
    Metadata s = getService(Metadata.class);
    return s.listSchemas(
      params.num,
      params.httpMethod,
      params.path,
      params.classname,
      params.schemaname,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Typeahead hander for filename completion.
   */
  public TypeaheadV3 typeaheadFileSuggestions(String src) throws IOException {
    Typeahead s = getService(Typeahead.class);
    return s.files(src).execute().body();
  }
  public TypeaheadV3 typeaheadFileSuggestions(String src, int limit) throws IOException {
    Typeahead s = getService(Typeahead.class);
    return s.files(src, limit, "").execute().body();
  }
  public TypeaheadV3 typeaheadFileSuggestions(String src, int limit, String _excludeFields) throws IOException {
    Typeahead s = getService(Typeahead.class);
    return s.files(src, limit, _excludeFields).execute().body();
  }

  /**
   * Get the status of the given H2O Job (long-running action).
   */
  public JobsV3 job(JobKeyV3 jobId) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.fetch(keyToString(jobId)).execute().body();
  }
  public JobsV3 job(JobKeyV3 jobId, String _excludeFields) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.fetch(keyToString(jobId), _excludeFields).execute().body();
  }

  /**
   * Cancel a running job.
   */
  public JobsV3 cancelJob(JobKeyV3 jobId) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.cancel(keyToString(jobId)).execute().body();
  }
  public JobsV3 cancelJob(JobKeyV3 jobId, String _excludeFields) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.cancel(keyToString(jobId), _excludeFields).execute().body();
  }

  /**
   * Find a value within a Frame.
   */
  public FindV3 findInFrame(FrameV3 key, long row) throws IOException {
    Find s = getService(Find.class);
    return s.find(key, row).execute().body();
  }
  public FindV3 findInFrame(FindV3 params) throws IOException {
    Find s = getService(Find.class);
    return s.find(
      params.key,
      params.column,
      params.row,
      params.match,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Export a Frame to the given path with optional overwrite.
   */
  public FramesV3 exportFrame(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.export(keyToString(frameId)).execute().body();
  }
  public FramesV3 exportFrame(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.export(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Save frame data to the given path.
   */
  public FrameSaveV3 saveFrame(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.save(keyToString(frameId)).execute().body();
  }
  public FrameSaveV3 saveFrame(FrameSaveV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.save(
      keyToString(params.frameId),
      params.dir,
      params.force,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Load a frame from data on given path.
   */
  public FrameLoadV3 loadFrame() throws IOException {
    Frames s = getService(Frames.class);
    return s.load().execute().body();
  }
  public FrameLoadV3 loadFrame(FrameLoadV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.load(
      keyToString(params.frameId),
      params.dir,
      params.force,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the summary metrics for a column, e.g. min, max, mean, sigma, percentiles, etc.
   */
  public FramesV3 frameColumnSummary(FrameKeyV3 frameId, String column) throws IOException {
    Frames s = getService(Frames.class);
    return s.columnSummary(keyToString(frameId), column).execute().body();
  }
  public FramesV3 frameColumnSummary(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.columnSummary(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the domains for the specified categorical column ("null" if the column is not a categorical).
   */
  public FramesV3 frameColumnDomain(FrameKeyV3 frameId, String column) throws IOException {
    Frames s = getService(Frames.class);
    return s.columnDomain(keyToString(frameId), column).execute().body();
  }
  public FramesV3 frameColumnDomain(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.columnDomain(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the specified column from a Frame.
   */
  public FramesV3 frameColumn(FrameKeyV3 frameId, String column) throws IOException {
    Frames s = getService(Frames.class);
    return s.column(keyToString(frameId), column).execute().body();
  }
  public FramesV3 frameColumn(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.column(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return all the columns from a Frame.
   */
  public FramesV3 frameColumns(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.columns(keyToString(frameId)).execute().body();
  }
  public FramesV3 frameColumns(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.columns(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return a Frame, including the histograms, after forcing computation of rollups.
   */
  public FramesV3 frameSummary(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.summary(keyToString(frameId)).execute().body();
  }
  public FramesV3 frameSummary(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.summary(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return a basic info about Frame to fill client Rapid expression cache.
   */
  public FramesV3 lightFrame(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.fetchLight(keyToString(frameId)).execute().body();
  }
  public FramesV3 lightFrame(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.fetchLight(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the specified Frame.
   */
  public FramesV3 frame(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.fetch(keyToString(frameId)).execute().body();
  }
  public FramesV3 frame(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.fetch(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return all Frames in the H2O distributed K/V store.
   */
  public FramesListV3 frames() throws IOException {
    Frames s = getService(Frames.class);
    return s.list().execute().body();
  }
  public FramesListV3 frames(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.list(keyToString(frameId), "").execute().body();
  }
  public FramesListV3 frames(FrameKeyV3 frameId, String _excludeFields) throws IOException {
    Frames s = getService(Frames.class);
    return s.list(keyToString(frameId), _excludeFields).execute().body();
  }

  /**
   * Delete the specified Frame from the H2O distributed K/V store.
   */
  public FramesV3 deleteFrame(FrameKeyV3 frameId) throws IOException {
    Frames s = getService(Frames.class);
    return s.delete(keyToString(frameId)).execute().body();
  }
  public FramesV3 deleteFrame(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.delete(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Delete all Frames from the H2O distributed K/V store.
   */
  public FramesV3 deleteAllFrames() throws IOException {
    Frames s = getService(Frames.class);
    return s.deleteAll().execute().body();
  }
  public FramesV3 deleteAllFrames(FramesV3 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.deleteAll(
      keyToString(params.frameId),
      params.column,
      params.rowOffset,
      params.rowCount,
      params.columnOffset,
      params.fullColumnCount,
      params.columnCount,
      params.findCompatibleModels,
      params.path,
      params.force,
      params.numParts,
      params.parallel,
      params.format,
      params.compression,
      params.writeChecksum,
      params.separator,
      params.header,
      params.quoteHeader,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return information about chunks for a given frame.
   */
  public FrameChunksV3 frameChunks(FrameKeyV3 frameId) throws IOException {
    FrameChunks s = getService(FrameChunks.class);
    return s.fetch(keyToString(frameId)).execute().body();
  }

  /**
   * Return the specified Model from the H2O distributed K/V store, optionally with the list of compatible Frames.
   */
  public ModelsV3 model(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.fetch(keyToString(modelId)).execute().body();
  }
  public ModelsV3 model(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.fetch(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return all Models from the H2O distributed K/V store.
   */
  public ModelsV3 models() throws IOException {
    Models s = getService(Models.class);
    return s.list().execute().body();
  }
  public ModelsV3 models(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.list(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Delete the specified Model from the H2O distributed K/V store.
   */
  public ModelsV3 deleteModel(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.delete(keyToString(modelId)).execute().body();
  }
  public ModelsV3 deleteModel(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.delete(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Delete all Models from the H2O distributed K/V store.
   */
  public ModelsV3 deleteAllModels() throws IOException {
    Models s = getService(Models.class);
    return s.deleteAll().execute().body();
  }
  public ModelsV3 deleteAllModels(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.deleteAll(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return potentially abridged model suitable for viewing in a browser (currently only used for java model code).
   */
  public StreamingSchema modelPreview(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.fetchPreview(keyToString(modelId)).execute().body();
  }
  public StreamingSchema modelPreview(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.fetchPreview(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * [DEPRECATED] Return the stream containing model implementation in Java code.
   */
  public StreamingSchema modelJavaCode(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.fetchJavaCode(keyToString(modelId)).execute().body();
  }
  public StreamingSchema modelJavaCode(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.fetchJavaCode(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the model in the MOJO format. This format can then be interpreted by gen_model.jar in order to perform
   * prediction / scoring. Currently works for GBM and DRF algos only.
   */
  public StreamingSchema modelMojo(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.fetchMojo(keyToString(modelId)).execute().body();
  }
  public StreamingSchema modelMojo(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.fetchMojo(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the model in the binary format.
   */
  public StreamingSchema modelBinary(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.fetchBinaryModel(keyToString(modelId)).execute().body();
  }
  public StreamingSchema modelBinary(ModelsV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.fetchBinaryModel(
      keyToString(params.modelId),
      params.preview,
      params.findCompatibleFrames,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Create data for partial dependence plot(s) for the specified model and frame.
   */
  public JobV3 makePDP() throws IOException {
    PartialDependence s = getService(PartialDependence.class);
    return s.makePartialDependence().execute().body();
  }
  public JobV3 makePDP(PartialDependenceV3 params) throws IOException {
    PartialDependence s = getService(PartialDependence.class);
    return s.makePartialDependence(
      keyToString(params.modelId),
      keyToString(params.frameId),
      params.rowIndex,
      params.cols,
      params.weightColumnIndex,
      params.addMissingNa,
      params.nbins,
      params.userSplits,
      params.userCols,
      params.numUserSplits,
      params.colPairs2dpdp,
      keyToString(params.destinationKey),
      params.targets
    ).execute().body();
  }

  /**
   * Fetch feature interaction data
   */
  public FeatureInteractionV3 makeFI(int maxInteractionDepth, int maxTreeDepth, int maxDeepening) throws IOException {
    FeatureInteraction s = getService(FeatureInteraction.class);
    return s.makeFeatureInteraction(maxInteractionDepth, maxTreeDepth, maxDeepening).execute().body();
  }
  public FeatureInteractionV3 makeFI(FeatureInteractionV3 params) throws IOException {
    FeatureInteraction s = getService(FeatureInteraction.class);
    return s.makeFeatureInteraction(
      keyToString(params.modelId),
      params.maxInteractionDepth,
      params.maxTreeDepth,
      params.maxDeepening,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Fetch Friedman Popescus H.
   */
  public FriedmanPopescusHV3 makeH(FrameV3 frame, String[] variables) throws IOException {
    FriedmansPopescusH s = getService(FriedmansPopescusH.class);
    return s.makeFriedmansPopescusH(frame, variables).execute().body();
  }
  public FriedmanPopescusHV3 makeH(FriedmanPopescusHV3 params) throws IOException {
    FriedmansPopescusH s = getService(FriedmansPopescusH.class);
    return s.makeFriedmansPopescusH(
      keyToString(params.modelId),
      params.frame,
      params.variables,
      params.h,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Fetch significant rules table.
   */
  public SignificantRulesV3 makeRules() throws IOException {
    SignificantRules s = getService(SignificantRules.class);
    return s.makeSignificantRulesTable().execute().body();
  }
  public SignificantRulesV3 makeRules(ModelKeyV3 modelId) throws IOException {
    SignificantRules s = getService(SignificantRules.class);
    return s.makeSignificantRulesTable(keyToString(modelId), "").execute().body();
  }
  public SignificantRulesV3 makeRules(ModelKeyV3 modelId, String _excludeFields) throws IOException {
    SignificantRules s = getService(SignificantRules.class);
    return s.makeSignificantRulesTable(keyToString(modelId), _excludeFields).execute().body();
  }

  /**
   * Fetch partial dependence data.
   */
  public PartialDependenceV3 fetchPDP(String name) throws IOException {
    PartialDependence s = getService(PartialDependence.class);
    return s.fetchPartialDependence(name).execute().body();
  }
  public PartialDependenceV3 fetchPDP(String name, String type, String url) throws IOException {
    PartialDependence s = getService(PartialDependence.class);
    return s.fetchPartialDependence(name, type, url).execute().body();
  }

  /**
   * Import given binary model into H2O.
   */
  public ModelsV3 importModel(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.importModel(keyToString(modelId)).execute().body();
  }
  public ModelsV3 importModel(ModelImportV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.importModel(
      keyToString(params.modelId),
      params.dir,
      params.force,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Export given model.
   */
  public ModelExportV3 exportModel(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.exportModel(keyToString(modelId)).execute().body();
  }
  public ModelExportV3 exportModel(ModelExportV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.exportModel(
      keyToString(params.modelId),
      params.dir,
      params.force,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Upload given binary model into H2O.
   */
  public ModelsV3 uploadModel(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.uploadModel(keyToString(modelId)).execute().body();
  }
  public ModelsV3 uploadModel(ModelImportV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.uploadModel(
      keyToString(params.modelId),
      params.dir,
      params.force,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Export given model as Mojo.
   */
  public ModelExportV3 exportMojo(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.exportMojo(keyToString(modelId)).execute().body();
  }
  public ModelExportV3 exportMojo(ModelExportV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.exportMojo(
      keyToString(params.modelId),
      params.dir,
      params.force,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Export given model details in json format.
   */
  public ModelExportV3 exportModelDetails(ModelKeyV3 modelId) throws IOException {
    Models s = getService(Models.class);
    return s.exportModelDetails(keyToString(modelId)).execute().body();
  }
  public ModelExportV3 exportModelDetails(ModelExportV3 params) throws IOException {
    Models s = getService(Models.class);
    return s.exportModelDetails(
      keyToString(params.modelId),
      params.dir,
      params.force,
      params.exportCrossValidationPredictions,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the specified grid search result.
   */
  public GridSchemaV99 grid(GridKeyV3 gridId) throws IOException {
    Grids s = getService(Grids.class);
    return s.fetch(keyToString(gridId)).execute().body();
  }
  public GridSchemaV99 grid(GridSchemaV99 params) throws IOException {
    Grids s = getService(Grids.class);
    return s.fetch(
      keyToString(params.gridId),
      params.sortBy,
      params.decreasing,
      keyArrayToStringArray(params.modelIds)
    ).execute().body();
  }

  /**
   * Return all grids from H2O distributed K/V store.
   */
  public GridsV99 grids() throws IOException {
    Grids s = getService(Grids.class);
    return s.list().execute().body();
  }

  /**
   * Return a new unique model_id for the specified algorithm.
   */
  public ModelIdV3 newModelId(String algo) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.calcModelId(algo).execute().body();
  }
  public ModelIdV3 newModelId(String algo, String _excludeFields) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.calcModelId(algo, _excludeFields).execute().body();
  }

  /**
   * Return the Model Builder metadata for the specified algorithm.
   */
  public ModelBuildersV3 modelBuilder(String algo) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.fetch(algo).execute().body();
  }
  public ModelBuildersV3 modelBuilder(String algo, String _excludeFields) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.fetch(algo, _excludeFields).execute().body();
  }

  /**
   * Return the Model Builder metadata for all available algorithms.
   */
  public ModelBuildersV3 modelBuilders() throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.list().execute().body();
  }
  public ModelBuildersV3 modelBuilders(String algo) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.list(algo, "").execute().body();
  }
  public ModelBuildersV3 modelBuilders(String algo, String _excludeFields) throws IOException {
    ModelBuilders s = getService(ModelBuilders.class);
    return s.list(algo, _excludeFields).execute().body();
  }

  /**
   * Return the saved scoring metrics for the specified Model and Frame.
   */
  public ModelMetricsListSchemaV3 _mmFetch1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.fetch(keyToString(model), keyToString(frame)).execute().body();
  }
  public ModelMetricsListSchemaV3 _mmFetch1(ModelMetricsListSchemaV3 params) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.fetch(
      keyToString(params.model),
      keyToString(params.frame),
      keyToString(params.predictionsFrame),
      keyToString(params.deviancesFrame),
      params.reconstructionError,
      params.reconstructionErrorPerFeature,
      params.deepFeaturesHiddenLayer,
      params.deepFeaturesHiddenLayerName,
      params.reconstructTrain,
      params.projectArchetypes,
      params.reverseTransform,
      params.leafNodeAssignment,
      params.leafNodeAssignmentType,
      params.predictStagedProba,
      params.predictContributions,
      params.rowToTreeAssignment,
      params.predictContributionsOutputFormat,
      params.topN,
      params.bottomN,
      params.compareAbs,
      params.featureFrequencies,
      params.exemplarIndex,
      params.deviances,
      params.customMetricFunc,
      params.aucType,
      params.auucType,
      params.customAuucThresholds,
      params.auucNbins,
      keyToString(params.backgroundFrame),
      params.outputSpace,
      params.outputPerReference,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the saved scoring metrics for the specified Model and Frame.
   */
  public ModelMetricsListSchemaV3 _mmDelete1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.delete(keyToString(model), keyToString(frame)).execute().body();
  }
  public ModelMetricsListSchemaV3 _mmDelete1(ModelMetricsListSchemaV3 params) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.delete(
      keyToString(params.model),
      keyToString(params.frame),
      keyToString(params.predictionsFrame),
      keyToString(params.deviancesFrame),
      params.reconstructionError,
      params.reconstructionErrorPerFeature,
      params.deepFeaturesHiddenLayer,
      params.deepFeaturesHiddenLayerName,
      params.reconstructTrain,
      params.projectArchetypes,
      params.reverseTransform,
      params.leafNodeAssignment,
      params.leafNodeAssignmentType,
      params.predictStagedProba,
      params.predictContributions,
      params.rowToTreeAssignment,
      params.predictContributionsOutputFormat,
      params.topN,
      params.bottomN,
      params.compareAbs,
      params.featureFrequencies,
      params.exemplarIndex,
      params.deviances,
      params.customMetricFunc,
      params.aucType,
      params.auucType,
      params.customAuucThresholds,
      params.auucNbins,
      keyToString(params.backgroundFrame),
      params.outputSpace,
      params.outputPerReference,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return the scoring metrics for the specified Frame with the specified Model.  If the Frame has already been scored
   * with the Model then cached results will be returned; otherwise predictions for all rows in the Frame will be
   * generated and the metrics will be returned.
   */
  public ModelMetricsListSchemaV3 score(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.score(keyToString(model), keyToString(frame)).execute().body();
  }
  public ModelMetricsListSchemaV3 score(ModelMetricsListSchemaV3 params) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.score(
      keyToString(params.model),
      keyToString(params.frame),
      keyToString(params.predictionsFrame),
      keyToString(params.deviancesFrame),
      params.reconstructionError,
      params.reconstructionErrorPerFeature,
      params.deepFeaturesHiddenLayer,
      params.deepFeaturesHiddenLayerName,
      params.reconstructTrain,
      params.projectArchetypes,
      params.reverseTransform,
      params.leafNodeAssignment,
      params.leafNodeAssignmentType,
      params.predictStagedProba,
      params.predictContributions,
      params.rowToTreeAssignment,
      params.predictContributionsOutputFormat,
      params.topN,
      params.bottomN,
      params.compareAbs,
      params.featureFrequencies,
      params.exemplarIndex,
      params.deviances,
      params.customMetricFunc,
      params.aucType,
      params.auucType,
      params.customAuucThresholds,
      params.auucNbins,
      keyToString(params.backgroundFrame),
      params.outputSpace,
      params.outputPerReference,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and
   * the metrics will be returned.
   */
  public ModelMetricsListSchemaV3 predict(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
    Predictions s = getService(Predictions.class);
    return s.predict(keyToString(model), keyToString(frame)).execute().body();
  }
  public ModelMetricsListSchemaV3 predict(ModelMetricsListSchemaV3 params) throws IOException {
    Predictions s = getService(Predictions.class);
    return s.predict(
      keyToString(params.model),
      keyToString(params.frame),
      keyToString(params.predictionsFrame),
      keyToString(params.deviancesFrame),
      params.reconstructionError,
      params.reconstructionErrorPerFeature,
      params.deepFeaturesHiddenLayer,
      params.deepFeaturesHiddenLayerName,
      params.reconstructTrain,
      params.projectArchetypes,
      params.reverseTransform,
      params.leafNodeAssignment,
      params.leafNodeAssignmentType,
      params.predictStagedProba,
      params.predictContributions,
      params.rowToTreeAssignment,
      params.predictContributionsOutputFormat,
      params.topN,
      params.bottomN,
      params.compareAbs,
      params.featureFrequencies,
      params.exemplarIndex,
      params.deviances,
      params.customMetricFunc,
      params.aucType,
      params.auucType,
      params.customAuucThresholds,
      params.auucNbins,
      keyToString(params.backgroundFrame),
      params.outputSpace,
      params.outputPerReference,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Score (generate predictions) for the specified Frame with the specified Model.  Both the Frame of predictions and
   * the metrics will be returned.
   */
  public JobV3 predict_async(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
    Predictions s = getService(Predictions.class);
    return s.predictAsync(keyToString(model), keyToString(frame)).execute().body();
  }
  public JobV3 predict_async(ModelMetricsListSchemaV3 params) throws IOException {
    Predictions s = getService(Predictions.class);
    return s.predictAsync(
      keyToString(params.model),
      keyToString(params.frame),
      keyToString(params.predictionsFrame),
      keyToString(params.deviancesFrame),
      params.reconstructionError,
      params.reconstructionErrorPerFeature,
      params.deepFeaturesHiddenLayer,
      params.deepFeaturesHiddenLayerName,
      params.reconstructTrain,
      params.projectArchetypes,
      params.reverseTransform,
      params.leafNodeAssignment,
      params.leafNodeAssignmentType,
      params.predictStagedProba,
      params.predictContributions,
      params.rowToTreeAssignment,
      params.predictContributionsOutputFormat,
      params.topN,
      params.bottomN,
      params.compareAbs,
      params.featureFrequencies,
      params.exemplarIndex,
      params.deviances,
      params.customMetricFunc,
      params.aucType,
      params.auucType,
      params.customAuucThresholds,
      params.auucNbins,
      keyToString(params.backgroundFrame),
      params.outputSpace,
      params.outputPerReference,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Create a ModelMetrics object from the predicted and actual values, and a domain for classification problems or a
   * distribution family for regression problems.
   */
  public ModelMetricsMakerSchemaV3 makeMetrics(String predictionsFrame, String actualsFrame) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.make(predictionsFrame, actualsFrame).execute().body();
  }
  public ModelMetricsMakerSchemaV3 makeMetrics(ModelMetricsMakerSchemaV3 params) throws IOException {
    ModelMetrics s = getService(ModelMetrics.class);
    return s.make(
      params.predictionsFrame,
      params.actualsFrame,
      params.weightsFrame,
      params.treatmentFrame,
      params.domain,
      params.distribution,
      params.aucType,
      params.auucType,
      params.auucNbins,
      params.customAuucThresholds
    ).execute().body();
  }

  /**
   * Return a CPU usage snapshot of all cores of all nodes in the H2O cluster.
   */
  public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx) throws IOException {
    WaterMeterCpuTicks s = getService(WaterMeterCpuTicks.class);
    return s.fetch(nodeidx).execute().body();
  }
  public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx, String _excludeFields) throws IOException {
    WaterMeterCpuTicks s = getService(WaterMeterCpuTicks.class);
    return s.fetch(nodeidx, _excludeFields).execute().body();
  }

  /**
   * Return IO usage snapshot of all nodes in the H2O cluster.
   */
  public WaterMeterIoV3 waterMeterIoForNode(int nodeidx) throws IOException {
    WaterMeterIo s = getService(WaterMeterIo.class);
    return s.fetch(nodeidx).execute().body();
  }
  public WaterMeterIoV3 waterMeterIoForNode(int nodeidx, String _excludeFields) throws IOException {
    WaterMeterIo s = getService(WaterMeterIo.class);
    return s.fetch(nodeidx, _excludeFields).execute().body();
  }

  /**
   * Return IO usage snapshot of all nodes in the H2O cluster.
   */
  public WaterMeterIoV3 waterMeterIoForCluster() throws IOException {
    WaterMeterIo s = getService(WaterMeterIo.class);
    return s.fetch_all().execute().body();
  }
  public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx) throws IOException {
    WaterMeterIo s = getService(WaterMeterIo.class);
    return s.fetch_all(nodeidx, "").execute().body();
  }
  public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx, String _excludeFields) throws IOException {
    WaterMeterIo s = getService(WaterMeterIo.class);
    return s.fetch_all(nodeidx, _excludeFields).execute().body();
  }

  /**
   * Return true or false.
   */
  public NodePersistentStorageV3 npsContains(String category, String name) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.exists(category, name).execute().body();
  }
  public NodePersistentStorageV3 npsContains(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.exists(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return true or false.
   */
  public NodePersistentStorageV3 npsEnabled() throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.configured().execute().body();
  }
  public NodePersistentStorageV3 npsEnabled(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.configured(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Store a named value.
   */
  public NodePersistentStorageV3 npsPut(String category, String name) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.put_with_name(category, name).execute().body();
  }
  public NodePersistentStorageV3 npsPut(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.put_with_name(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return value for a given name.
   */
  public NodePersistentStorageV3 npsGet(String category, String name) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.get_as_string(category, name).execute().body();
  }
  public NodePersistentStorageV3 npsGet(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.get_as_string(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Delete a key.
   */
  public NodePersistentStorageV3 npsRemove(String category, String name) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.delete(category, name).execute().body();
  }
  public NodePersistentStorageV3 npsRemove(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.delete(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Store a value.
   */
  public NodePersistentStorageV3 npsCreateCategory(String category) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.put(category).execute().body();
  }
  public NodePersistentStorageV3 npsCreateCategory(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.put(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Return all keys stored for a given category.
   */
  public NodePersistentStorageV3 npsKeys(String category) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.list(category).execute().body();
  }
  public NodePersistentStorageV3 npsKeys(NodePersistentStorageV3 params) throws IOException {
    NodePersistentStorage s = getService(NodePersistentStorage.class);
    return s.list(
      params.category,
      params.name,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Get named log file for a node.
   */
  public LogsV3 logs(String nodeidx, String name) throws IOException {
    Logs s = getService(Logs.class);
    return s.fetch(nodeidx, name).execute().body();
  }
  public LogsV3 logs(String nodeidx, String name, String _excludeFields) throws IOException {
    Logs s = getService(Logs.class);
    return s.fetch(nodeidx, name, _excludeFields).execute().body();
  }

  /**
   * Kill minus 3 on *this* node
   */
  public KillMinus3V3 logThreadDump() throws IOException {
    KillMinus3 s = getService(KillMinus3.class);
    return s.killm3().execute().body();
  }
  public KillMinus3V3 logThreadDump(String _excludeFields) throws IOException {
    KillMinus3 s = getService(KillMinus3.class);
    return s.killm3(_excludeFields).execute().body();
  }

  /**
   * Execute an Rapids AstRoot.
   */
  public RapidsSchemaV3 rapidsExec(String ast) throws IOException {
    Rapids s = getService(Rapids.class);
    return s.rapidsExec(ast).execute().body();
  }
  public RapidsSchemaV3 rapidsExec(RapidsSchemaV3 params) throws IOException {
    Rapids s = getService(Rapids.class);
    return s.rapidsExec(
      params.ast,
      params.sessionId,
      params.id,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Generate a Java POJO from the Assembly
   */
  public AssemblyV99 _assembly_toJava(String assemblyId, String fileName) throws IOException {
    Assembly s = getService(Assembly.class);
    return s.toJava(assemblyId, fileName).execute().body();
  }
  public AssemblyV99 _assembly_toJava(AssemblyV99 params) throws IOException {
    Assembly s = getService(Assembly.class);
    return s.toJava(
      params.assemblyId,
      params.fileName,
      params.steps,
      keyToString(params.frame),
      params._excludeFields
    ).execute().body();
  }

  /**
   * Fit an assembly to an input frame
   */
  public AssemblyV99 _assembly_fit() throws IOException {
    Assembly s = getService(Assembly.class);
    return s.fit().execute().body();
  }
  public AssemblyV99 _assembly_fit(AssemblyV99 params) throws IOException {
    Assembly s = getService(Assembly.class);
    return s.fit(
      params.steps,
      keyToString(params.frame),
      params.fileName,
      params.assemblyId,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Download dataset as a CSV.
   */
  public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetch(keyToString(frameId)).execute().body();
  }
  public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetch(keyToString(frameId), hexString, "").execute().body();
  }
  public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetch(keyToString(frameId), hexString, _excludeFields).execute().body();
  }

  /**
   * Download dataset as a CSV.
   */
  public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetchStreaming(keyToString(frameId)).execute().body();
  }
  public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetchStreaming(keyToString(frameId), hexString, "").execute().body();
  }
  public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
    DownloadDataset s = getService(DownloadDataset.class);
    return s.fetchStreaming(keyToString(frameId), hexString, _excludeFields).execute().body();
  }

  /**
   * Remove an arbitrary key from the H2O distributed K/V store.
   */
  public RemoveV3 deleteKey(KeyV3 key) throws IOException {
    DKV s = getService(DKV.class);
    return s.remove(keyToString(key)).execute().body();
  }
  public RemoveV3 deleteKey(KeyV3 key, boolean cascade) throws IOException {
    DKV s = getService(DKV.class);
    return s.remove(keyToString(key), cascade, "").execute().body();
  }
  public RemoveV3 deleteKey(KeyV3 key, boolean cascade, String _excludeFields) throws IOException {
    DKV s = getService(DKV.class);
    return s.remove(keyToString(key), cascade, _excludeFields).execute().body();
  }

  /**
   * Remove all keys from the H2O distributed K/V store.
   */
  public RemoveAllV3 deleteAllKeys() throws IOException {
    DKV s = getService(DKV.class);
    return s.removeAll().execute().body();
  }
  public RemoveAllV3 deleteAllKeys(KeyV3[] retainedKeys) throws IOException {
    DKV s = getService(DKV.class);
    return s.removeAll(keyArrayToStringArray(retainedKeys), "").execute().body();
  }
  public RemoveAllV3 deleteAllKeys(KeyV3[] retainedKeys, String _excludeFields) throws IOException {
    DKV s = getService(DKV.class);
    return s.removeAll(keyArrayToStringArray(retainedKeys), _excludeFields).execute().body();
  }

  /**
   * Save a message to the H2O logfile.
   */
  public LogAndEchoV3 logAndEcho() throws IOException {
    LogAndEcho s = getService(LogAndEcho.class);
    return s.echo().execute().body();
  }
  public LogAndEchoV3 logAndEcho(String message) throws IOException {
    LogAndEcho s = getService(LogAndEcho.class);
    return s.echo(message, "").execute().body();
  }
  public LogAndEchoV3 logAndEcho(String message, String _excludeFields) throws IOException {
    LogAndEcho s = getService(LogAndEcho.class);
    return s.echo(message, _excludeFields).execute().body();
  }

  /**
   * Issue a new session ID.
   */
  public InitIDV3 newSession() throws IOException {
    InitID s = getService(InitID.class);
    return s.startSession().execute().body();
  }
  public InitIDV3 newSession(String sessionKey) throws IOException {
    InitID s = getService(InitID.class);
    return s.startSession(sessionKey, "").execute().body();
  }
  public InitIDV3 newSession(String sessionKey, String _excludeFields) throws IOException {
    InitID s = getService(InitID.class);
    return s.startSession(sessionKey, _excludeFields).execute().body();
  }

  /**
   * End a session.
   */
  public InitIDV3 endSession() throws IOException {
    InitID s = getService(InitID.class);
    return s.endSession().execute().body();
  }
  public InitIDV3 endSession(String sessionKey) throws IOException {
    InitID s = getService(InitID.class);
    return s.endSession(sessionKey, "").execute().body();
  }
  public InitIDV3 endSession(String sessionKey, String _excludeFields) throws IOException {
    InitID s = getService(InitID.class);
    return s.endSession(sessionKey, _excludeFields).execute().body();
  }

  /**
   * Set session property.
   */
  public SessionPropertyV3 setSessionProperty() throws IOException {
    SessionProperties s = getService(SessionProperties.class);
    return s.setSessionProperty().execute().body();
  }
  public SessionPropertyV3 setSessionProperty(SessionPropertyV3 params) throws IOException {
    SessionProperties s = getService(SessionProperties.class);
    return s.setSessionProperty(
      params.sessionKey,
      params.key,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Get session property.
   */
  public SessionPropertyV3 getSessionProperty() throws IOException {
    SessionProperties s = getService(SessionProperties.class);
    return s.getSessionProperty().execute().body();
  }
  public SessionPropertyV3 getSessionProperty(SessionPropertyV3 params) throws IOException {
    SessionProperties s = getService(SessionProperties.class);
    return s.getSessionProperty(
      params.sessionKey,
      params.key,
      params.value,
      params._excludeFields
    ).execute().body();
  }

  /**
   * Explicitly call System.gc().
   */
  public GarbageCollectV3 garbageCollect() throws IOException {
    GarbageCollect s = getService(GarbageCollect.class);
    return s.gc().execute().body();
  }

  /**
   * Example of an experimental endpoint.  Call via /EXPERIMENTAL/Sample.  Experimental endpoints can change at any
   * moment.
   */
  public CloudV3 _sample_status() throws IOException {
    Sample s = getService(Sample.class);
    return s.status().execute().body();
  }
  public CloudV3 _sample_status(boolean skipTicks) throws IOException {
    Sample s = getService(Sample.class);
    return s.status(skipTicks, "").execute().body();
  }
  public CloudV3 _sample_status(boolean skipTicks, String _excludeFields) throws IOException {
    Sample s = getService(Sample.class);
    return s.status(skipTicks, _excludeFields).execute().body();
  }

  /**
   * Produce help for Rapids AstRoot language.
   */
  public RapidsHelpV3 rapids_help() throws IOException {
    Rapids s = getService(Rapids.class);
    return s.genHelp().execute().body();
  }

  /**
   * Get metrics for Steam from H2O.
   */
  public SteamMetricsV3 steamMetrics() throws IOException {
    SteamMetrics s = getService(SteamMetrics.class);
    return s.fetch().execute().body();
  }
  public SteamMetricsV3 steamMetrics(String _excludeFields) throws IOException {
    SteamMetrics s = getService(SteamMetrics.class);
    return s.fetch(_excludeFields).execute().body();
  }

  /**
   * List of all registered capabilities
   */
  public CapabilitiesV3 list_all_capabilities() throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listAll().execute().body();
  }
  public CapabilitiesV3 list_all_capabilities(String _excludeFields) throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listAll(_excludeFields).execute().body();
  }

  /**
   * List registered core capabilities
   */
  public CapabilitiesV3 list_core_capabilities() throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listCore().execute().body();
  }
  public CapabilitiesV3 list_core_capabilities(String _excludeFields) throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listCore(_excludeFields).execute().body();
  }

  /**
   * List of all registered Rest API capabilities
   */
  public CapabilitiesV3 list_rest_capabilities() throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listRest().execute().body();
  }
  public CapabilitiesV3 list_rest_capabilities(String _excludeFields) throws IOException {
    Capabilities s = getService(Capabilities.class);
    return s.listRest(_excludeFields).execute().body();
  }

  /**
   * Import previously saved grid model
   */
  public GridKeyV3 import_grid(String gridPath) throws IOException {
    Grid s = getService(Grid.class);
    return s.importGrid(gridPath).execute().body();
  }
  public GridKeyV3 import_grid(String gridPath, boolean loadParamsReferences) throws IOException {
    Grid s = getService(Grid.class);
    return s.importGrid(gridPath, loadParamsReferences).execute().body();
  }

  /**
   * Export a Grid and its models.
   */
  public GridKeyV3 export_grid(String gridId, String gridDirectory) throws IOException {
    Grid s = getService(Grid.class);
    return s.exportGrid(gridId, gridDirectory).execute().body();
  }
  public GridKeyV3 export_grid(GridExportV3 params) throws IOException {
    Grid s = getService(Grid.class);
    return s.exportGrid(
      params.gridId,
      params.gridDirectory,
      params.saveParamsReferences,
      params.exportCrossValidationPredictions
    ).execute().body();
  }

  /**
   * Recover stored state and resume interrupted job.
   */
  public ResumeV3 recovery_resume() throws IOException {
    Recovery s = getService(Recovery.class);
    return s.resume().execute().body();
  }
  public ResumeV3 recovery_resume(String recoveryDir) throws IOException {
    Recovery s = getService(Recovery.class);
    return s.resume(recoveryDir).execute().body();
  }

  /**
   * Returns the list of all REST API (v4) endpoints.
   */
  public EndpointsListV4 endpoints4() throws IOException {
    Endpoints s = getService(Endpoints.class);
    return s.listRoutes4().execute().body();
  }
  public EndpointsListV4 endpoints4(String __schema) throws IOException {
    Endpoints s = getService(Endpoints.class);
    return s.listRoutes4(__schema).execute().body();
  }

  /**
   * Start a new Rapids session, and return the session id.
   */
  public SessionIdV4 newSession4() throws IOException {
    Sessions s = getService(Sessions.class);
    return s.newSession4().execute().body();
  }
  public SessionIdV4 newSession4(String _fields) throws IOException {
    Sessions s = getService(Sessions.class);
    return s.newSession4(_fields).execute().body();
  }

  /**
   * Close the Rapids session.
   */
  public InitIDV3 endSession4(String sessionKey) throws IOException {
    Sessions s = getService(Sessions.class);
    return s.endSession(sessionKey).execute().body();
  }
  public InitIDV3 endSession4(String sessionKey, String _excludeFields) throws IOException {
    Sessions s = getService(Sessions.class);
    return s.endSession(sessionKey, _excludeFields).execute().body();
  }

  /**
   * Return basic information about all models available to train.
   */
  public ModelsInfoV4 modelsInfo() throws IOException {
    Modelsinfo s = getService(Modelsinfo.class);
    return s.modelsInfo().execute().body();
  }
  public ModelsInfoV4 modelsInfo(String __schema) throws IOException {
    Modelsinfo s = getService(Modelsinfo.class);
    return s.modelsInfo(__schema).execute().body();
  }

  /**
   * Create frame with random (uniformly distributed) data. You can specify how many columns of each type to make; and
   * what the desired range for each column type.
   */
  public JobV4 createSimpleFrame() throws IOException {
    Frames s = getService(Frames.class);
    return s.createSimpleFrame().execute().body();
  }
  public JobV4 createSimpleFrame(CreateFrameSimpleIV4 params) throws IOException {
    Frames s = getService(Frames.class);
    return s.createSimpleFrame(
      keyToString(params.dest),
      params.seed,
      params.nrows,
      params.ncolsReal,
      params.ncolsInt,
      params.ncolsEnum,
      params.ncolsBool,
      params.ncolsStr,
      params.ncolsTime,
      params.realLb,
      params.realUb,
      params.intLb,
      params.intUb,
      params.enumNlevels,
      params.boolP,
      params.timeLb,
      params.timeUb,
      params.strLength,
      params.missingFraction,
      params.responseType,
      params.responseLb,
      params.responseUb,
      params.responseP,
      params.responseNlevels,
      params._fields
    ).execute().body();
  }

  /**
   * Retrieve information about the current state of a job.
   */
  public JobV4 getJob4(String jobId) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.getJob4(jobId).execute().body();
  }
  public JobV4 getJob4(String jobId, String _fields) throws IOException {
    Jobs s = getService(Jobs.class);
    return s.getJob4(jobId, _fields).execute().body();
  }

  
  
  //--------- PRIVATE --------------------------------------------------------------------------------------------------
  
  private Retrofit retrofit;
  private String _url = DEFAULT_URL;
  private int timeout_s = 60;
  private int pollInterval_ms = 1000;
  
  private void initializeRetrofit() {
    Gson gson = new GsonBuilder()
      .registerTypeAdapterFactory(new ModelV3TypeAdapter())
      .registerTypeAdapter(KeyV3.class, new KeySerializer())
      .registerTypeAdapter(ColSpecifierV3.class, new ColSerializer())
      .registerTypeAdapter(ModelBuilderSchema.class, new ModelDeserializer())
      .registerTypeAdapter(ModelSchemaBaseV3.class, new ModelSchemaDeserializer())
      .registerTypeAdapter(ModelOutputSchemaV3.class, new ModelOutputDeserializer())
      .registerTypeAdapter(ModelParametersSchemaV3.class, new ModelParametersDeserializer())
      .create();
  
    OkHttpClient client = new OkHttpClient.Builder()
      .connectTimeout(timeout_s, TimeUnit.SECONDS)
      .writeTimeout(timeout_s, TimeUnit.SECONDS)
      .readTimeout(timeout_s, TimeUnit.SECONDS)
      .build();
  
    this.retrofit = new Retrofit.Builder()
      .client(client)
      .baseUrl(_url)
      .addConverterFactory(GsonConverterFactory.create(gson))
      .build();
  }
  
  private Retrofit getRetrofit() {
    if (retrofit == null) initializeRetrofit();
    return retrofit;
  }
  
  private <T> T getService(Class<T> clazz) {
    return getRetrofit().create(clazz);
  }
  
  
  /**
   * Keys get sent as Strings and returned as objects also containing the type and URL,
   * so they need a custom GSON serializer.
   */
  private static class KeySerializer implements JsonSerializer<KeyV3>, JsonDeserializer<KeyV3> {
    @Override
    public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
      return new JsonPrimitive(key.name);
    }
    @Override
    public KeyV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
      if (json.isJsonNull()) return null;
      JsonObject jobj = json.getAsJsonObject();
      String type = jobj.get("type").getAsString();
      switch (type) {
        // TODO: dynamically generate all possible cases
        case "Key<Model>": return context.deserialize(jobj, ModelKeyV3.class);
        case "Key<Job>":   return context.deserialize(jobj, JobKeyV3.class);
        case "Key<Grid>":  return context.deserialize(jobj, GridKeyV3.class);
        case "Key<Frame>": return context.deserialize(jobj, FrameKeyV3.class);
        default: throw new JsonParseException("Unable to deserialize key of type " + type);
      }
    }
  }
  
  private static class ColSerializer implements JsonSerializer<ColSpecifierV3> {
    @Override
    public JsonElement serialize(ColSpecifierV3 col, Type typeOfCol, JsonSerializationContext context) {
      return new JsonPrimitive(col.columnName);
    }
  }
  
  
  /**
   * Factory method for parsing a ModelBuilderSchema json object into an instance of the model-specific subclass.
   */
  private static class ModelDeserializer implements JsonDeserializer<ModelBuilderSchema> {
    @Override
    public ModelBuilderSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {
      if (json.isJsonNull()) return null;
      if (json.isJsonObject()) {
        JsonObject jobj = json.getAsJsonObject();
        if (jobj.has("algo")) {
          String algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
          switch (algo) {
            case "xgboost": return context.deserialize(json, XGBoostV3.class);
            case "infogram": return context.deserialize(json, InfogramV3.class);
            case "targetencoder": return context.deserialize(json, TargetEncoderV3.class);
            case "deeplearning": return context.deserialize(json, DeepLearningV3.class);
            case "glm": return context.deserialize(json, GLMV3.class);
            case "glrm": return context.deserialize(json, GLRMV3.class);
            case "kmeans": return context.deserialize(json, KMeansV3.class);
            case "naivebayes": return context.deserialize(json, NaiveBayesV3.class);
            case "pca": return context.deserialize(json, PCAV3.class);
            case "svd": return context.deserialize(json, SVDV99.class);
            case "drf": return context.deserialize(json, DRFV3.class);
            case "gbm": return context.deserialize(json, GBMV3.class);
            case "isolationforest": return context.deserialize(json, IsolationForestV3.class);
            case "extendedisolationforest": return context.deserialize(json, ExtendedIsolationForestV3.class);
            case "aggregator": return context.deserialize(json, AggregatorV99.class);
            case "word2vec": return context.deserialize(json, Word2VecV3.class);
            case "stackedensemble": return context.deserialize(json, StackedEnsembleV99.class);
            case "coxph": return context.deserialize(json, CoxPHV3.class);
            case "generic": return context.deserialize(json, GenericV3.class);
            case "gam": return context.deserialize(json, GAMV3.class);
            case "anovaglm": return context.deserialize(json, ANOVAGLMV3.class);
            case "psvm": return context.deserialize(json, PSVMV3.class);
            case "rulefit": return context.deserialize(json, RuleFitV3.class);
            case "upliftdrf": return context.deserialize(json, UpliftDRFV3.class);
            case "modelselection": return context.deserialize(json, ModelSelectionV3.class);
            case "isotonicregression": return context.deserialize(json, IsotonicRegressionV3.class);
            case "dt": return context.deserialize(json, DTV3.class);
            case "adaboost": return context.deserialize(json, AdaBoostV3.class);
            default:
              throw new JsonParseException("Unable to deserialize model of type " + algo);
          }
        }
      }
      throw new JsonParseException("Invalid ModelBuilderSchema element " + json.toString());
    }
  }

  /**
   * Factory method for parsing a ModelSchemaBaseV3 json object into an instance of the model-specific subclass.
   */
  private static class ModelSchemaDeserializer implements JsonDeserializer<ModelSchemaBaseV3> {
    @Override
    public ModelSchemaBaseV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {
      if (json.isJsonNull()) return null;
      if (json.isJsonObject()) {
        JsonObject jobj = json.getAsJsonObject();
        if (jobj.has("algo")) {
          String algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
          switch (algo) {
            case "xgboost": return context.deserialize(json, XGBoostModelV3.class);
            case "infogram": return context.deserialize(json, InfogramModelV3.class);
            case "targetencoder": return context.deserialize(json, TargetEncoderModelV3.class);
            case "deeplearning": return context.deserialize(json, DeepLearningModelV3.class);
            case "glm": return context.deserialize(json, GLMModelV3.class);
            case "glrm": return context.deserialize(json, GLRMModelV3.class);
            case "kmeans": return context.deserialize(json, KMeansModelV3.class);
            case "naivebayes": return context.deserialize(json, NaiveBayesModelV3.class);
            case "pca": return context.deserialize(json, PCAModelV3.class);
            case "svd": return context.deserialize(json, SVDModelV99.class);
            case "drf": return context.deserialize(json, DRFModelV3.class);
            case "gbm": return context.deserialize(json, GBMModelV3.class);
            case "isolationforest": return context.deserialize(json, IsolationForestModelV3.class);
            case "extendedisolationforest": return context.deserialize(json, ExtendedIsolationForestModelV3.class);
            case "aggregator": return context.deserialize(json, AggregatorModelV99.class);
            case "word2vec": return context.deserialize(json, Word2VecModelV3.class);
            case "stackedensemble": return context.deserialize(json, StackedEnsembleModelV99.class);
            case "coxph": return context.deserialize(json, CoxPHModelV3.class);
            case "generic": return context.deserialize(json, GenericModelV3.class);
            case "gam": return context.deserialize(json, GAMModelV3.class);
            case "anovaglm": return context.deserialize(json, ANOVAGLMModelV3.class);
            case "psvm": return context.deserialize(json, PSVMModelV3.class);
            case "rulefit": return context.deserialize(json, RuleFitModelV3.class);
            case "upliftdrf": return context.deserialize(json, UpliftDRFModelV3.class);
            case "modelselection": return context.deserialize(json, ModelSelectionModelV3.class);
            case "isotonicregression": return context.deserialize(json, IsotonicRegressionModelV3.class);
            case "dt": return context.deserialize(json, DTModelV3.class);
            case "adaboost": return context.deserialize(json, AdaBoostModelV3.class);
            default:
              throw new JsonParseException("Unable to deserialize model of type " + algo);
          }
        }
      }
      throw new JsonParseException("Invalid ModelSchemaBaseV3 element " + json.toString());
    }
  }

  /**
   * Factory method for parsing a ModelOutputSchemaV3 json object into an instance of the model-specific subclass.
   */
  private static class ModelOutputDeserializer implements JsonDeserializer<ModelOutputSchemaV3> {
    @Override
    public ModelOutputSchemaV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {
      if (json.isJsonNull()) return null;
      if (json.isJsonObject()) {
        JsonObject jobj = json.getAsJsonObject();
        if (jobj.has("algo")) {
          String algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
          switch (algo) {
            case "xgboost": return context.deserialize(json, XGBoostModelOutputV3.class);
            case "infogram": return context.deserialize(json, InfogramModelOutputV3.class);
            case "targetencoder": return context.deserialize(json, TargetEncoderModelOutputV3.class);
            case "deeplearning": return context.deserialize(json, DeepLearningModelOutputV3.class);
            case "glm": return context.deserialize(json, GLMModelOutputV3.class);
            case "glrm": return context.deserialize(json, GLRMModelOutputV3.class);
            case "kmeans": return context.deserialize(json, KMeansModelOutputV3.class);
            case "naivebayes": return context.deserialize(json, NaiveBayesModelOutputV3.class);
            case "pca": return context.deserialize(json, PCAModelOutputV3.class);
            case "svd": return context.deserialize(json, SVDModelOutputV99.class);
            case "drf": return context.deserialize(json, DRFModelOutputV3.class);
            case "gbm": return context.deserialize(json, GBMModelOutputV3.class);
            case "isolationforest": return context.deserialize(json, IsolationForestModelOutputV3.class);
            case "extendedisolationforest": return context.deserialize(json, ExtendedIsolationForestModelOutputV3.class);
            case "aggregator": return context.deserialize(json, AggregatorModelOutputV99.class);
            case "word2vec": return context.deserialize(json, Word2VecModelOutputV3.class);
            case "stackedensemble": return context.deserialize(json, StackedEnsembleModelOutputV99.class);
            case "coxph": return context.deserialize(json, CoxPHModelOutputV3.class);
            case "generic": return context.deserialize(json, GenericModelOutputV3.class);
            case "gam": return context.deserialize(json, GAMModelOutputV3.class);
            case "anovaglm": return context.deserialize(json, ANOVAGLMModelOutputV3.class);
            case "psvm": return context.deserialize(json, PSVMModelOutputV3.class);
            case "rulefit": return context.deserialize(json, RuleFitModelOutputV3.class);
            case "upliftdrf": return context.deserialize(json, UpliftDRFModelOutputV3.class);
            case "modelselection": return context.deserialize(json, ModelSelectionModelOutputV3.class);
            case "isotonicregression": return context.deserialize(json, IsotonicRegressionModelOutputV3.class);
            case "dt": return context.deserialize(json, DTModelOutputV3.class);
            case "adaboost": return context.deserialize(json, AdaBoostModelOutputV3.class);
            default:
              throw new JsonParseException("Unable to deserialize model of type " + algo);
          }
        }
      }
      throw new JsonParseException("Invalid ModelOutputSchemaV3 element " + json.toString());
    }
  }

  /**
   * Factory method for parsing a ModelParametersSchemaV3 json object into an instance of the model-specific subclass.
   */
  private static class ModelParametersDeserializer implements JsonDeserializer<ModelParametersSchemaV3> {
    @Override
    public ModelParametersSchemaV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context)
      throws JsonParseException {
      if (json.isJsonNull()) return null;
      if (json.isJsonObject()) {
        JsonObject jobj = json.getAsJsonObject();
        if (jobj.has("algo")) {
          String algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
          switch (algo) {
            case "xgboost": return context.deserialize(json, XGBoostParametersV3.class);
            case "infogram": return context.deserialize(json, InfogramParametersV3.class);
            case "targetencoder": return context.deserialize(json, TargetEncoderParametersV3.class);
            case "deeplearning": return context.deserialize(json, DeepLearningParametersV3.class);
            case "glm": return context.deserialize(json, GLMParametersV3.class);
            case "glrm": return context.deserialize(json, GLRMParametersV3.class);
            case "kmeans": return context.deserialize(json, KMeansParametersV3.class);
            case "naivebayes": return context.deserialize(json, NaiveBayesParametersV3.class);
            case "pca": return context.deserialize(json, PCAParametersV3.class);
            case "svd": return context.deserialize(json, SVDParametersV99.class);
            case "drf": return context.deserialize(json, DRFParametersV3.class);
            case "gbm": return context.deserialize(json, GBMParametersV3.class);
            case "isolationforest": return context.deserialize(json, IsolationForestParametersV3.class);
            case "extendedisolationforest": return context.deserialize(json, ExtendedIsolationForestParametersV3.class);
            case "aggregator": return context.deserialize(json, AggregatorParametersV99.class);
            case "word2vec": return context.deserialize(json, Word2VecParametersV3.class);
            case "stackedensemble": return context.deserialize(json, StackedEnsembleParametersV99.class);
            case "coxph": return context.deserialize(json, CoxPHParametersV3.class);
            case "generic": return context.deserialize(json, GenericParametersV3.class);
            case "gam": return context.deserialize(json, GAMParametersV3.class);
            case "anovaglm": return context.deserialize(json, ANOVAGLMParametersV3.class);
            case "psvm": return context.deserialize(json, PSVMParametersV3.class);
            case "rulefit": return context.deserialize(json, RuleFitParametersV3.class);
            case "upliftdrf": return context.deserialize(json, UpliftDRFParametersV3.class);
            case "modelselection": return context.deserialize(json, ModelSelectionParametersV3.class);
            case "isotonicregression": return context.deserialize(json, IsotonicRegressionParametersV3.class);
            case "dt": return context.deserialize(json, DTParametersV3.class);
            case "adaboost": return context.deserialize(json, AdaBoostParametersV3.class);
            default:
              throw new JsonParseException("Unable to deserialize model of type " + algo);
          }
        }
      }
      throw new JsonParseException("Invalid ModelParametersSchemaV3 element " + json.toString());
    }
  }

  
    private static class ModelV3TypeAdapter implements TypeAdapterFactory {
      @Override
      public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final Class<? super T> rawType = type.getRawType();
        if (!ModelBuilderSchema.class.isAssignableFrom(rawType) &&
            !ModelSchemaBaseV3.class.isAssignableFrom(rawType)) return null;
        final TypeAdapter<T> delegate = gson.getDelegateAdapter(this, type);
        return new TypeAdapter<T>() {
          @Override
          public void write(JsonWriter out, T value) throws IOException {
            delegate.write(out, value);
          }
          @Override
          public T read(JsonReader in) throws IOException {
            JsonObject jobj = new JsonParser().parse(in).getAsJsonObject();
            if (jobj.has("parameters") && jobj.get("parameters").isJsonArray()) {
              JsonArray jarr = jobj.get("parameters").getAsJsonArray();
              JsonObject paramsNew = new JsonObject();
              for (JsonElement item : jarr) {
                JsonObject itemObj = item.getAsJsonObject();
                paramsNew.add(itemObj.get("name").getAsString(), itemObj.get("actual_value"));
              }
              jobj.add("parameters", paramsNew);
            }
            // noinspection unchecked
            return (T) new Gson().fromJson(jobj, rawType);
          }
        };
      }
    }
  
  
    /**
     * Return an array of Strings for an array of keys.
     */
    public static String[] keyArrayToStringArray(KeyV3[] keys) {
      if (keys == null) return null;
      String[] ids = new String[keys.length];
      int i = 0;
      for (KeyV3 key : keys) ids[i++] = key.name;
      return ids;
    }
  
    /**
     * Return an array of keys from an array of Strings.
     * @param ids array of string ids to convert to KeyV3's
     * @param clz class of key objects to create. Since we have JobKeyV3, FrameKeyV3, ModelKeyV3, etc -- this
     *            method needs to know which of these keys you want to create
     */
    public static <T extends KeyV3> T[] stringArrayToKeyArray(String[] ids, Class<T> clz) {
      if (ids == null) return null;
      // noinspection unchecked
      T[] keys = (T[]) Array.newInstance(clz, ids.length);
      String keyType = clz.getSimpleName();
      if (keyType.endsWith("KeyV3")) keyType = keyType.substring(0, keyType.length()-5);
      try {
        int i = 0;
        for (String id: ids) {
          keys[i] = clz.getConstructor().newInstance();
          keys[i].name = id;
          keys[i].type = keyType;
          i++;
        }
      }
      catch (Exception e) {
        e.printStackTrace();
      }
      return keys;
    }
  
    /**
     *
     */
    public static String keyToString(KeyV3 key) {
      return key == null? null : key.name;
    }
  
    /**
     *
     */
    public static FrameKeyV3 stringToFrameKey(String key) {
      if (key == null) return null;
      FrameKeyV3 k = new FrameKeyV3();
      k.name = key;
      return k;
    }
  
    /**
     *
     */
    private static String colToString(ColSpecifierV3 col) {
      return col == null? null : col.columnName;
    }
  
    /**
     *
     */
    public static String stringToCol(String col) {
      if (col == null) return null;
      ColSpecifierV3 c = new ColSpecifierV3();
      c.columnName = col;
      return col;
    }
  
  
    public static void copyFields(Object to, Object from) {
      Field[] fromFields = from.getClass().getDeclaredFields();
      Field[] toFields   = to.getClass().getDeclaredFields();
  
      for (Field fromField : fromFields){
        Field toField;
        try {
          toField = to.getClass().getDeclaredField(fromField.getName());
          fromField.setAccessible(true);
          toField.setAccessible(true);
          toField.set(to, fromField.get(from));
        }
        catch (Exception ignored) {
          // NoSuchField is the normal case
        }
      }
    }
  }
  
