/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;


public class GLMParametersV3 extends ModelParametersSchemaV3 {

    /**
     * Seed for pseudo random number generator (if applicable)
     */
    public long seed;

    /**
     * Family. Use binomial for classification with logistic regression, others are for regression problems.
     */
    public GLMFamily family;

    /**
     * Tweedie variance power
     */
    @SerializedName("tweedie_variance_power")
    public double tweedieVariancePower;

    /**
     * Tweedie link power
     */
    @SerializedName("tweedie_link_power")
    public double tweedieLinkPower;

    /**
     * AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small
     * number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many columns.
     * Coordinate descent is experimental (beta).
     */
    public GLMSolver solver;

    /**
     * distribution of regularization between L1 and L2.
     */
    public double[] alpha;

    /**
     * regularization strength
     */
    public double[] lambda;

    /**
     * use lambda search starting at lambda max, given lambda is then interpreted as lambda min
     */
    @SerializedName("lambda_search")
    public boolean lambdaSearch;

    /**
     * stop early when there is no more relative improvement on train or validation (if provided)
     */
    @SerializedName("early_stopping")
    public boolean earlyStopping;

    /**
     * number of lambdas to be used in a search
     */
    public int nlambdas;

    /**
     * Standardize numeric columns to have zero mean and unit variance
     */
    public boolean standardize;

    /**
     * Handling of missing values. Either Skip or MeanImputation.
     */
    @SerializedName("missing_values_handling")
    public DeepLearningMissingValuesHandling missingValuesHandling;

    /**
     * Restrict coefficients (not intercept) to be non-negative
     */
    @SerializedName("non_negative")
    public boolean nonNegative;

    /**
     * Maximum number of iterations
     */
    @SerializedName("max_iterations")
    public int maxIterations;

    /**
     * converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver
     */
    @SerializedName("beta_epsilon")
    public double betaEpsilon;

    /**
     * converge if  objective value changes less than this
     */
    @SerializedName("objective_epsilon")
    public double objectiveEpsilon;

    /**
     * converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver
     */
    @SerializedName("gradient_epsilon")
    public double gradientEpsilon;

    /**
     * likelihood divider in objective value computation, default is 1/nobs
     */
    @SerializedName("obj_reg")
    public double objReg;

    /**

     */
    public GLMLink link;

    /**
     * include constant term in the model
     */
    public boolean intercept;

    /**
     * prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean of
     * response does not reflect reality.
     */
    public double prior;

    /**
     * min lambda used in lambda search, specified as a ratio of lambda_max
     */
    @SerializedName("lambda_min_ratio")
    public double lambdaMinRatio;

    /**
     * beta constraints
     */
    @SerializedName("beta_constraints")
    public FrameKeyV3 betaConstraints;

    /**
     * Maximum number of active predictors during computation. Use as a stopping criterium to prevent expensive model
     * building with many predictors.
     */
    @SerializedName("max_active_predictors")
    public int maxActivePredictors;

    /**
     * A list of predictor column indices to interact. All pairwise combinations will be computed for the list.
     */
    public String[] interactions;

    /**
     * Balance training data class counts via over/under-sampling (for imbalanced data).
     */
    @SerializedName("balance_classes")
    public boolean balanceClasses;

    /**
     * Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will be
     * automatically computed to obtain class balance during training. Requires balance_classes.
     */
    @SerializedName("class_sampling_factors")
    public float[] classSamplingFactors;

    /**
     * Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
     * balance_classes.
     */
    @SerializedName("max_after_balance_size")
    public float maxAfterBalanceSize;

    /**
     * Maximum size (# classes) for confusion matrices to be printed in the Logs
     */
    @SerializedName("max_confusion_matrix_size")
    public int maxConfusionMatrixSize;

    /**
     * Max. number (top K) of predictions to use for hit ratio computation (for multi-class only, 0 to disable)
     */
    @SerializedName("max_hit_ratio_k")
    public int maxHitRatioK;

    /**
     * request p-values computation, p-values work only with IRLSM solver and no regularization
     */
    @SerializedName("compute_p_values")
    public boolean computePValues;

    /**
     * in case of linearly dependent columns remove some of the dependent columns
     */
    @SerializedName("remove_collinear_columns")
    public boolean removeCollinearColumns;


    /*------------------------------------------------------------------------------------------------------------------
    //                                                  INHERITED
    //------------------------------------------------------------------------------------------------------------------

    // Destination id for this model; auto-generated if not specified.
    public ModelKeyV3 modelId;

    // Id of the training data frame (Not required, to allow initial validation of model parameters).
    public FrameKeyV3 trainingFrame;

    // Id of the validation data frame.
    public FrameKeyV3 validationFrame;

    // Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
    public int nfolds;

    // Whether to keep the predictions of the cross-validation models.
    public boolean keepCrossValidationPredictions;

    // Whether to keep the cross-validation fold assignment.
    public boolean keepCrossValidationFoldAssignment;

    // Allow parallel training of cross-validation models
    public boolean parallelizeCrossValidation;

    // Response variable column.
    public ColSpecifierV3 responseColumn;

    // Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from the
    // dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative weights
    // are not allowed.
    public ColSpecifierV3 weightsColumn;

    // Offset column. This will be added to the combination of columns before applying the link function.
    public ColSpecifierV3 offsetColumn;

    // Column with cross-validation fold index assignment per observation.
    public ColSpecifierV3 foldColumn;

    // Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will stratify
    // the folds based on the response variable, for classification problems.
    public ModelParametersFoldAssignmentScheme foldAssignment;

    // Names of columns to ignore for training.
    public String[] ignoredColumns;

    // Ignore constant columns.
    public boolean ignoreConstCols;

    // Whether to score during each iteration of model training.
    public boolean scoreEachIteration;

    // Model checkpoint to resume training with.
    public ModelKeyV3 checkpoint;

    // Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
    // stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)
    public int stoppingRounds;

    // Maximum allowed runtime in seconds for model training. Use 0 to disable.
    public double maxRuntimeSecs;

    // Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)
    public ScoreKeeperStoppingMetric stoppingMetric;

    // Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)
    public double stoppingTolerance;

    // Comma-separated list of JSON field paths to exclude from the result, used like:
    // "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
    public String _excludeFields;

    */

    /**
     * Public constructor
     */
    public GLMParametersV3() {
        seed = -1L;
        family = GLMFamily.gaussian;
        tweedieVariancePower = 0.0;
        tweedieLinkPower = 1.0;
        solver = GLMSolver.AUTO;
        lambdaSearch = false;
        earlyStopping = true;
        nlambdas = -1;
        standardize = true;
        missingValuesHandling = DeepLearningMissingValuesHandling.MeanImputation;
        nonNegative = false;
        maxIterations = -1;
        betaEpsilon = 0.0001;
        objectiveEpsilon = -1.0;
        gradientEpsilon = -1.0;
        objReg = -1.0;
        link = GLMLink.family_default;
        intercept = true;
        prior = -1.0;
        lambdaMinRatio = -1.0;
        maxActivePredictors = -1;
        balanceClasses = false;
        maxAfterBalanceSize = 5.0f;
        maxConfusionMatrixSize = 20;
        maxHitRatioK = 0;
        computePValues = false;
        removeCollinearColumns = false;
        nfolds = 0;
        keepCrossValidationPredictions = false;
        keepCrossValidationFoldAssignment = false;
        parallelizeCrossValidation = true;
        foldAssignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignoreConstCols = true;
        scoreEachIteration = false;
        stoppingRounds = 3;
        maxRuntimeSecs = 0.0;
        stoppingMetric = ScoreKeeperStoppingMetric.deviance;
        stoppingTolerance = 0.0001;
        _excludeFields = "";
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
