/*
 * Decompiled with CFR 0.152.
 */
package water.bindings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import water.bindings.pojos.AboutV3;
import water.bindings.pojos.AggregatorModelV99;
import water.bindings.pojos.AggregatorParametersV99;
import water.bindings.pojos.AggregatorV99;
import water.bindings.pojos.AssemblyV99;
import water.bindings.pojos.CloudV3;
import water.bindings.pojos.ColSpecifierV3;
import water.bindings.pojos.CreateFrameV3;
import water.bindings.pojos.DCTTransformerV3;
import water.bindings.pojos.DRFModelV3;
import water.bindings.pojos.DRFParametersV3;
import water.bindings.pojos.DRFV3;
import water.bindings.pojos.DataInfoFrameV3;
import water.bindings.pojos.DeepLearningModelV3;
import water.bindings.pojos.DeepLearningParametersV3;
import water.bindings.pojos.DeepLearningV3;
import water.bindings.pojos.DownloadDataV3;
import water.bindings.pojos.EndpointsListV4;
import water.bindings.pojos.FindV3;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.FrameV3;
import water.bindings.pojos.FramesV3;
import water.bindings.pojos.GBMModelV3;
import water.bindings.pojos.GBMParametersV3;
import water.bindings.pojos.GBMV3;
import water.bindings.pojos.GLMModelV3;
import water.bindings.pojos.GLMParametersV3;
import water.bindings.pojos.GLMRegularizationPathV3;
import water.bindings.pojos.GLMV3;
import water.bindings.pojos.GLRMModelV3;
import water.bindings.pojos.GLRMParametersV3;
import water.bindings.pojos.GLRMV3;
import water.bindings.pojos.GarbageCollectV3;
import water.bindings.pojos.GridKeyV3;
import water.bindings.pojos.GridSchemaV99;
import water.bindings.pojos.GridsV99;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.ImportSQLTableV99;
import water.bindings.pojos.InitIDV3;
import water.bindings.pojos.InteractionV3;
import water.bindings.pojos.JStackV3;
import water.bindings.pojos.JobKeyV3;
import water.bindings.pojos.JobV3;
import water.bindings.pojos.JobsV3;
import water.bindings.pojos.KMeansModelV3;
import water.bindings.pojos.KMeansParametersV3;
import water.bindings.pojos.KMeansV3;
import water.bindings.pojos.KeyV3;
import water.bindings.pojos.KillMinus3V3;
import water.bindings.pojos.LogAndEchoV3;
import water.bindings.pojos.LogsV3;
import water.bindings.pojos.MakeGLMModelV3;
import water.bindings.pojos.MetadataV3;
import water.bindings.pojos.MissingInserterV3;
import water.bindings.pojos.ModelBuilderSchema;
import water.bindings.pojos.ModelBuildersV3;
import water.bindings.pojos.ModelExportV3;
import water.bindings.pojos.ModelIdV3;
import water.bindings.pojos.ModelImportV3;
import water.bindings.pojos.ModelKeyV3;
import water.bindings.pojos.ModelMetricsListSchemaV3;
import water.bindings.pojos.ModelSchemaBaseV3;
import water.bindings.pojos.ModelsV3;
import water.bindings.pojos.NaiveBayesModelV3;
import water.bindings.pojos.NaiveBayesParametersV3;
import water.bindings.pojos.NaiveBayesV3;
import water.bindings.pojos.NetworkTestV3;
import water.bindings.pojos.NodePersistentStorageV3;
import water.bindings.pojos.PCAModelV3;
import water.bindings.pojos.PCAParametersV3;
import water.bindings.pojos.PCAV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;
import water.bindings.pojos.ProfilerV3;
import water.bindings.pojos.RapidsHelpV3;
import water.bindings.pojos.RapidsSchemaV3;
import water.bindings.pojos.RemoveAllV3;
import water.bindings.pojos.RemoveV3;
import water.bindings.pojos.SVDModelV99;
import water.bindings.pojos.SVDParametersV99;
import water.bindings.pojos.SVDV99;
import water.bindings.pojos.ShutdownV3;
import water.bindings.pojos.SplitFrameV3;
import water.bindings.pojos.StreamingSchema;
import water.bindings.pojos.TabulateV3;
import water.bindings.pojos.TimelineV3;
import water.bindings.pojos.TypeaheadV3;
import water.bindings.pojos.UnlockKeysV3;
import water.bindings.pojos.WaterMeterCpuTicksV3;
import water.bindings.pojos.WaterMeterIoV3;
import water.bindings.proxies.retrofit.About;
import water.bindings.proxies.retrofit.Assembly;
import water.bindings.proxies.retrofit.Cloud;
import water.bindings.proxies.retrofit.CreateFrame;
import water.bindings.proxies.retrofit.DCTTransformer;
import water.bindings.proxies.retrofit.DKV;
import water.bindings.proxies.retrofit.DataInfoFrame;
import water.bindings.proxies.retrofit.DownloadDataset;
import water.bindings.proxies.retrofit.Find;
import water.bindings.proxies.retrofit.Frames;
import water.bindings.proxies.retrofit.GarbageCollect;
import water.bindings.proxies.retrofit.GetGLMRegPath;
import water.bindings.proxies.retrofit.Grid;
import water.bindings.proxies.retrofit.Grids;
import water.bindings.proxies.retrofit.ImportFiles;
import water.bindings.proxies.retrofit.ImportSQLTable;
import water.bindings.proxies.retrofit.InitID;
import water.bindings.proxies.retrofit.Interaction;
import water.bindings.proxies.retrofit.JStack;
import water.bindings.proxies.retrofit.Jobs;
import water.bindings.proxies.retrofit.KillMinus3;
import water.bindings.proxies.retrofit.LogAndEcho;
import water.bindings.proxies.retrofit.Logs;
import water.bindings.proxies.retrofit.MakeGLMModel;
import water.bindings.proxies.retrofit.Metadata;
import water.bindings.proxies.retrofit.MissingInserter;
import water.bindings.proxies.retrofit.ModelBuilders;
import water.bindings.proxies.retrofit.ModelMetrics;
import water.bindings.proxies.retrofit.Models;
import water.bindings.proxies.retrofit.NetworkTest;
import water.bindings.proxies.retrofit.NodePersistentStorage;
import water.bindings.proxies.retrofit.Parse;
import water.bindings.proxies.retrofit.ParseSVMLight;
import water.bindings.proxies.retrofit.ParseSetup;
import water.bindings.proxies.retrofit.Predictions;
import water.bindings.proxies.retrofit.Profiler;
import water.bindings.proxies.retrofit.Rapids;
import water.bindings.proxies.retrofit.Sample;
import water.bindings.proxies.retrofit.Shutdown;
import water.bindings.proxies.retrofit.SplitFrame;
import water.bindings.proxies.retrofit.Tabulate;
import water.bindings.proxies.retrofit.Timeline;
import water.bindings.proxies.retrofit.Typeahead;
import water.bindings.proxies.retrofit.UnlockKeys;
import water.bindings.proxies.retrofit.WaterMeterCpuTicks;
import water.bindings.proxies.retrofit.WaterMeterIo;
import water.bindings.proxies.retrofit.endpoints;

public class H2oApi {
    private Retrofit retrofit;
    private String url = "http://localhost:54321/";
    private int timeout_s = 60;
    private int pollInterval_ms = 1000;

    public H2oApi() {
    }

    public H2oApi(String url) {
        this.url = url;
    }

    public H2oApi setUrl(String s) {
        this.url = s;
        this.retrofit = null;
        return this;
    }

    public H2oApi setTimeout(int t) {
        this.timeout_s = t;
        this.retrofit = null;
        return this;
    }

    public H2oApi setJobPollInterval(int millis) {
        this.pollInterval_ms = millis;
        return this;
    }

    public JobV3 waitForJobCompletion(JobKeyV3 jobKey) {
        return this.waitForJobCompletion(H2oApi.keyToString(jobKey));
    }

    public JobV3 waitForJobCompletion(String jobId) {
        Jobs jobService = this.getService(Jobs.class);
        Response jobsResponse = null;
        int retries = 3;
        JobsV3 jobs = null;
        do {
            try {
                Thread.sleep(this.pollInterval_ms);
                jobsResponse = jobService.fetch(jobId).execute();
            }
            catch (IOException e) {
                System.err.println("Caught exception: " + e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (jobsResponse == null || !jobsResponse.isSuccessful()) {
                if (retries-- > 0) continue;
                throw new RuntimeException("/3/Jobs/" + jobId + " failed 3 times.");
            }
            jobs = (JobsV3)jobsResponse.body();
            if (jobs.jobs != null && jobs.jobs.length == 1) continue;
            throw new RuntimeException("Failed to find Job: " + jobId);
        } while (jobs != null && jobs.jobs[0].status.equals("RUNNING"));
        return jobs == null ? null : jobs.jobs[0];
    }

    public EndpointsListV4 endpoints4() throws IOException {
        endpoints s = this.getService(endpoints.class);
        return (EndpointsListV4)s.listRoutes4().execute().body();
    }

    public EndpointsListV4 endpoints4(String __schema) throws IOException {
        endpoints s = this.getService(endpoints.class);
        return (EndpointsListV4)s.listRoutes4(__schema).execute().body();
    }

    public JobV3 createFrame() throws IOException {
        CreateFrame s = this.getService(CreateFrame.class);
        return (JobV3)s.run().execute().body();
    }

    public JobV3 createFrame(CreateFrameV3 params) throws IOException {
        CreateFrame s = this.getService(CreateFrame.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dest), params.rows, params.cols, params.seed, params.seedForColumnTypes, params.randomize, params.value, params.realRange, params.categoricalFraction, params.factors, params.integerFraction, params.integerRange, params.binaryFraction, params.binaryOnesFraction, params.timeFraction, params.stringFraction, params.missingFraction, params.responseFactors, params.hasResponse, params._excludeFields).execute().body();
    }

    public SplitFrameV3 splitFrame() throws IOException {
        SplitFrame s = this.getService(SplitFrame.class);
        return (SplitFrameV3)s.run().execute().body();
    }

    public SplitFrameV3 splitFrame(SplitFrameV3 params) throws IOException {
        SplitFrame s = this.getService(SplitFrame.class);
        return (SplitFrameV3)s.run(H2oApi.keyToString(params.key), H2oApi.keyToString(params.dataset), params.ratios, H2oApi.keyArrayToStringArray(params.destinationFrames), params._excludeFields).execute().body();
    }

    public JobV3 generateInteractions(int maxFactors) throws IOException {
        Interaction s = this.getService(Interaction.class);
        return (JobV3)s.run(maxFactors).execute().body();
    }

    public JobV3 generateInteractions(InteractionV3 params) throws IOException {
        Interaction s = this.getService(Interaction.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dest), H2oApi.keyToString(params.sourceFrame), params.factorColumns, params.pairwise, params.maxFactors, params.minOccurrence, params._excludeFields).execute().body();
    }

    public JobV3 _missingInserter_run(FrameKeyV3 dataset, double fraction) throws IOException {
        MissingInserter s = this.getService(MissingInserter.class);
        return (JobV3)s.run(H2oApi.keyToString(dataset), fraction).execute().body();
    }

    public JobV3 _missingInserter_run(MissingInserterV3 params) throws IOException {
        MissingInserter s = this.getService(MissingInserter.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dataset), params.fraction, params.seed, params._excludeFields).execute().body();
    }

    public JobV3 _dctTransformer_run(FrameKeyV3 dataset, int[] dimensions) throws IOException {
        DCTTransformer s = this.getService(DCTTransformer.class);
        return (JobV3)s.run(H2oApi.keyToString(dataset), dimensions).execute().body();
    }

    public JobV3 _dctTransformer_run(DCTTransformerV3 params) throws IOException {
        DCTTransformer s = this.getService(DCTTransformer.class);
        return (JobV3)s.run(H2oApi.keyToString(params.dataset), H2oApi.keyToString(params.destinationFrame), params.dimensions, params.inverse, params._excludeFields).execute().body();
    }

    public TabulateV3 _tabulate_run(FrameKeyV3 dataset, ColSpecifierV3 predictor, ColSpecifierV3 response) throws IOException {
        Tabulate s = this.getService(Tabulate.class);
        return (TabulateV3)s.run(H2oApi.keyToString(dataset), H2oApi.colToString(predictor), H2oApi.colToString(response)).execute().body();
    }

    public TabulateV3 _tabulate_run(TabulateV3 params) throws IOException {
        Tabulate s = this.getService(Tabulate.class);
        return (TabulateV3)s.run(H2oApi.keyToString(params.dataset), H2oApi.colToString(params.predictor), H2oApi.colToString(params.response), H2oApi.colToString(params.weight), params.nbinsPredictor, params.nbinsResponse, params._excludeFields).execute().body();
    }

    public ImportFilesV3 importFiles(String path) throws IOException {
        ImportFiles s = this.getService(ImportFiles.class);
        return (ImportFilesV3)s.importFiles(path).execute().body();
    }

    public ImportFilesV3 importFiles(String path, String _excludeFields) throws IOException {
        ImportFiles s = this.getService(ImportFiles.class);
        return (ImportFilesV3)s.importFiles(path, _excludeFields).execute().body();
    }

    public JobV3 importSqlTable(String connectionUrl, String username, String password) throws IOException {
        ImportSQLTable s = this.getService(ImportSQLTable.class);
        return (JobV3)s.importSQLTable(connectionUrl, username, password).execute().body();
    }

    public JobV3 importSqlTable(ImportSQLTableV99 params) throws IOException {
        ImportSQLTable s = this.getService(ImportSQLTable.class);
        return (JobV3)s.importSQLTable(params.connectionUrl, params.table, params.selectQuery, params.username, params.password, params.columns, params.optimize, params._excludeFields).execute().body();
    }

    public ParseSetupV3 guessParseSetup(FrameKeyV3[] sourceFrames) throws IOException {
        ParseSetup s = this.getService(ParseSetup.class);
        return (ParseSetupV3)s.guessSetup(H2oApi.keyArrayToStringArray(sourceFrames)).execute().body();
    }

    public ParseSetupV3 guessParseSetup(ParseSetupV3 params) throws IOException {
        ParseSetup s = this.getService(ParseSetup.class);
        return (ParseSetupV3)s.guessSetup(H2oApi.keyArrayToStringArray(params.sourceFrames), params.parseType, params.separator, params.singleQuotes, params.checkHeader, params.columnNames, params.columnTypes, params.naStrings, params.columnNameFilter, params.columnOffset, params.columnCount, params.totalFilteredColumnCount, params._excludeFields).execute().body();
    }

    public ParseV3 parse(ParseV3 params) throws IOException {
        Parse s = this.getService(Parse.class);
        return (ParseV3)s.parse(H2oApi.keyToString(params.destinationFrame), H2oApi.keyArrayToStringArray(params.sourceFrames), params.parseType, params.separator, params.singleQuotes, params.checkHeader, params.numberColumns, params.columnNames, params.columnTypes, params.domains, params.naStrings, params.chunkSize, params.deleteOnDone, params.blocking, params._excludeFields).execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3[] sourceFrames) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyArrayToStringArray(sourceFrames)).execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyToString(destinationFrame), H2oApi.keyArrayToStringArray(sourceFrames), "").execute().body();
    }

    public JobV3 parseSvmLight(FrameKeyV3 destinationFrame, FrameKeyV3[] sourceFrames, String _excludeFields) throws IOException {
        ParseSVMLight s = this.getService(ParseSVMLight.class);
        return (JobV3)s.parseSVMLight(H2oApi.keyToString(destinationFrame), H2oApi.keyArrayToStringArray(sourceFrames), _excludeFields).execute().body();
    }

    public CloudV3 cloudStatus() throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status().execute().body();
    }

    public CloudV3 cloudStatus(boolean skipTicks) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status(skipTicks, "").execute().body();
    }

    public CloudV3 cloudStatus(boolean skipTicks, String _excludeFields) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.status(skipTicks, _excludeFields).execute().body();
    }

    public CloudV3 cloudStatusMinimal() throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head().execute().body();
    }

    public CloudV3 cloudStatusMinimal(boolean skipTicks) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head(skipTicks, "").execute().body();
    }

    public CloudV3 cloudStatusMinimal(boolean skipTicks, String _excludeFields) throws IOException {
        Cloud s = this.getService(Cloud.class);
        return (CloudV3)s.head(skipTicks, _excludeFields).execute().body();
    }

    public JobsV3 jobs() throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list().execute().body();
    }

    public JobsV3 jobs(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list(H2oApi.keyToString(jobId), "").execute().body();
    }

    public JobsV3 jobs(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.list(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public TimelineV3 timeline() throws IOException {
        Timeline s = this.getService(Timeline.class);
        return (TimelineV3)s.fetch().execute().body();
    }

    public TimelineV3 timeline(String _excludeFields) throws IOException {
        Timeline s = this.getService(Timeline.class);
        return (TimelineV3)s.fetch(_excludeFields).execute().body();
    }

    public ProfilerV3 profiler(int depth) throws IOException {
        Profiler s = this.getService(Profiler.class);
        return (ProfilerV3)s.fetch(depth).execute().body();
    }

    public ProfilerV3 profiler(int depth, String _excludeFields) throws IOException {
        Profiler s = this.getService(Profiler.class);
        return (ProfilerV3)s.fetch(depth, _excludeFields).execute().body();
    }

    public JStackV3 stacktraces() throws IOException {
        JStack s = this.getService(JStack.class);
        return (JStackV3)s.fetch().execute().body();
    }

    public JStackV3 stacktraces(String _excludeFields) throws IOException {
        JStack s = this.getService(JStack.class);
        return (JStackV3)s.fetch(_excludeFields).execute().body();
    }

    public NetworkTestV3 testNetwork() throws IOException {
        NetworkTest s = this.getService(NetworkTest.class);
        return (NetworkTestV3)s.fetch().execute().body();
    }

    public NetworkTestV3 testNetwork(String _excludeFields) throws IOException {
        NetworkTest s = this.getService(NetworkTest.class);
        return (NetworkTestV3)s.fetch(_excludeFields).execute().body();
    }

    public UnlockKeysV3 unlockAllKeys() throws IOException {
        UnlockKeys s = this.getService(UnlockKeys.class);
        return (UnlockKeysV3)s.unlock().execute().body();
    }

    public UnlockKeysV3 unlockAllKeys(String _excludeFields) throws IOException {
        UnlockKeys s = this.getService(UnlockKeys.class);
        return (UnlockKeysV3)s.unlock(_excludeFields).execute().body();
    }

    public ShutdownV3 shutdownCluster() throws IOException {
        Shutdown s = this.getService(Shutdown.class);
        return (ShutdownV3)s.shutdown().execute().body();
    }

    public ShutdownV3 shutdownCluster(String _excludeFields) throws IOException {
        Shutdown s = this.getService(Shutdown.class);
        return (ShutdownV3)s.shutdown(_excludeFields).execute().body();
    }

    public AboutV3 about() throws IOException {
        About s = this.getService(About.class);
        return (AboutV3)s.get().execute().body();
    }

    public AboutV3 about(String _excludeFields) throws IOException {
        About s = this.getService(About.class);
        return (AboutV3)s.get(_excludeFields).execute().body();
    }

    public MetadataV3 endpoints() throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listRoutes().execute().body();
    }

    public MetadataV3 endpoints(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listRoutes(params.num, params.httpMethod, params.path, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 endpoint(String path) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchRoute(path).execute().body();
    }

    public MetadataV3 endpoint(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchRoute(params.path, params.num, params.httpMethod, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 schemaForClass(String classname) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadataByClass(classname).execute().body();
    }

    public MetadataV3 schemaForClass(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadataByClass(params.classname, params.num, params.httpMethod, params.path, params.schemaname, params._excludeFields).execute().body();
    }

    public MetadataV3 schema(String schemaname) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadata(schemaname).execute().body();
    }

    public MetadataV3 schema(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.fetchSchemaMetadata(params.schemaname, params.num, params.httpMethod, params.path, params.classname, params._excludeFields).execute().body();
    }

    public MetadataV3 schemas() throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listSchemas().execute().body();
    }

    public MetadataV3 schemas(MetadataV3 params) throws IOException {
        Metadata s = this.getService(Metadata.class);
        return (MetadataV3)s.listSchemas(params.num, params.httpMethod, params.path, params.classname, params.schemaname, params._excludeFields).execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src).execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src, int limit) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src, limit, "").execute().body();
    }

    public TypeaheadV3 typeaheadFileSuggestions(String src, int limit, String _excludeFields) throws IOException {
        Typeahead s = this.getService(Typeahead.class);
        return (TypeaheadV3)s.files(src, limit, _excludeFields).execute().body();
    }

    public JobsV3 job(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.fetch(H2oApi.keyToString(jobId)).execute().body();
    }

    public JobsV3 job(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.fetch(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public JobsV3 cancelJob(JobKeyV3 jobId) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.cancel(H2oApi.keyToString(jobId)).execute().body();
    }

    public JobsV3 cancelJob(JobKeyV3 jobId, String _excludeFields) throws IOException {
        Jobs s = this.getService(Jobs.class);
        return (JobsV3)s.cancel(H2oApi.keyToString(jobId), _excludeFields).execute().body();
    }

    public FindV3 findInFrame(FrameV3 key, long row) throws IOException {
        Find s = this.getService(Find.class);
        return (FindV3)s.find(key, row).execute().body();
    }

    public FindV3 findInFrame(FindV3 params) throws IOException {
        Find s = this.getService(Find.class);
        return (FindV3)s.find(params.key, params.column, params.row, params.match, params._excludeFields).execute().body();
    }

    public FramesV3 exportFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.export(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 exportFrame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.export(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumnSummary(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnSummary(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumnSummary(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnSummary(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumnDomain(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnDomain(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumnDomain(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columnDomain(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumn(FrameKeyV3 frameId, String column) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.column(H2oApi.keyToString(frameId), column).execute().body();
    }

    public FramesV3 frameColumn(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.column(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameColumns(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columns(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frameColumns(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.columns(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frameSummary(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.summary(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frameSummary(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.summary(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetch(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 frame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.fetch(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 frames() throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.list().execute().body();
    }

    public FramesV3 frames(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.list(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 deleteFrame(FrameKeyV3 frameId) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.delete(H2oApi.keyToString(frameId)).execute().body();
    }

    public FramesV3 deleteFrame(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.delete(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public FramesV3 deleteAllFrames() throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.deleteAll().execute().body();
    }

    public FramesV3 deleteAllFrames(FramesV3 params) throws IOException {
        Frames s = this.getService(Frames.class);
        return (FramesV3)s.deleteAll(H2oApi.keyToString(params.frameId), params.column, params.rowOffset, params.rowCount, params.columnOffset, params.columnCount, params.findCompatibleModels, params.path, params.force, params._excludeFields).execute().body();
    }

    public ModelsV3 model(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.fetch(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 model(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.fetch(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public ModelsV3 models() throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.list().execute().body();
    }

    public ModelsV3 models(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.list(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public ModelsV3 deleteModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.delete(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 deleteModel(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.delete(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public ModelsV3 deleteAllModels() throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.deleteAll().execute().body();
    }

    public ModelsV3 deleteAllModels(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.deleteAll(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public StreamingSchema modelPreview(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchPreview(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelPreview(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchPreview(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public StreamingSchema modelJavaCode(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchJavaCode(H2oApi.keyToString(modelId)).execute().body();
    }

    public StreamingSchema modelJavaCode(ModelsV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (StreamingSchema)s.fetchJavaCode(H2oApi.keyToString(params.modelId), params.preview, params.findCompatibleFrames, params._excludeFields).execute().body();
    }

    public ModelsV3 importModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.importModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelsV3 importModel(ModelImportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelsV3)s.importModel(H2oApi.keyToString(params.modelId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public ModelExportV3 exportModel(ModelKeyV3 modelId) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModel(H2oApi.keyToString(modelId)).execute().body();
    }

    public ModelExportV3 exportModel(ModelExportV3 params) throws IOException {
        Models s = this.getService(Models.class);
        return (ModelExportV3)s.exportModel(H2oApi.keyToString(params.modelId), params.dir, params.force, params._excludeFields).execute().body();
    }

    public GridSchemaV99 grid(GridKeyV3 gridId) throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridSchemaV99)s.fetch(H2oApi.keyToString(gridId)).execute().body();
    }

    public GridSchemaV99 grid(GridSchemaV99 params) throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridSchemaV99)s.fetch(H2oApi.keyToString(params.gridId), params.sortBy, params.decreasing, H2oApi.keyArrayToStringArray(params.modelIds), params._excludeFields).execute().body();
    }

    public GridsV99 grids() throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridsV99)s.list().execute().body();
    }

    public GridsV99 grids(String _excludeFields) throws IOException {
        Grids s = this.getService(Grids.class);
        return (GridsV99)s.list(_excludeFields).execute().body();
    }

    public ModelIdV3 newModelId(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelIdV3)s.calcModelId(algo).execute().body();
    }

    public ModelIdV3 newModelId(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelIdV3)s.calcModelId(algo, _excludeFields).execute().body();
    }

    public ModelBuildersV3 modelBuilder(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.fetch(algo).execute().body();
    }

    public ModelBuildersV3 modelBuilder(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.fetch(algo, _excludeFields).execute().body();
    }

    public ModelBuildersV3 modelBuilders() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list().execute().body();
    }

    public ModelBuildersV3 modelBuilders(String algo) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list(algo, "").execute().body();
    }

    public ModelBuildersV3 modelBuilders(String algo, String _excludeFields) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (ModelBuildersV3)s.list(algo, _excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmFetch1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.fetch(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmFetch1(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.fetch(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.exemplarIndex, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmDelete1(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.delete(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 _mmDelete1(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.delete(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.exemplarIndex, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 score(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.score(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 score(ModelMetricsListSchemaV3 params) throws IOException {
        ModelMetrics s = this.getService(ModelMetrics.class);
        return (ModelMetricsListSchemaV3)s.score(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.exemplarIndex, params._excludeFields).execute().body();
    }

    public ModelMetricsListSchemaV3 predict(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (ModelMetricsListSchemaV3)s.predict(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public ModelMetricsListSchemaV3 predict(ModelMetricsListSchemaV3 params) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (ModelMetricsListSchemaV3)s.predict(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.exemplarIndex, params._excludeFields).execute().body();
    }

    public JobV3 predict_async(ModelKeyV3 model, FrameKeyV3 frame) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (JobV3)s.predictAsync(H2oApi.keyToString(model), H2oApi.keyToString(frame)).execute().body();
    }

    public JobV3 predict_async(ModelMetricsListSchemaV3 params) throws IOException {
        Predictions s = this.getService(Predictions.class);
        return (JobV3)s.predictAsync(H2oApi.keyToString(params.model), H2oApi.keyToString(params.frame), H2oApi.keyToString(params.predictionsFrame), params.reconstructionError, params.reconstructionErrorPerFeature, params.deepFeaturesHiddenLayer, params.reconstructTrain, params.projectArchetypes, params.reverseTransform, params.leafNodeAssignment, params.exemplarIndex, params._excludeFields).execute().body();
    }

    public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx) throws IOException {
        WaterMeterCpuTicks s = this.getService(WaterMeterCpuTicks.class);
        return (WaterMeterCpuTicksV3)s.fetch(nodeidx).execute().body();
    }

    public WaterMeterCpuTicksV3 waterMeterCpuTicks(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterCpuTicks s = this.getService(WaterMeterCpuTicks.class);
        return (WaterMeterCpuTicksV3)s.fetch(nodeidx, _excludeFields).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForNode(int nodeidx) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch(nodeidx).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForNode(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch(nodeidx, _excludeFields).execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster() throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all().execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all(nodeidx, "").execute().body();
    }

    public WaterMeterIoV3 waterMeterIoForCluster(int nodeidx, String _excludeFields) throws IOException {
        WaterMeterIo s = this.getService(WaterMeterIo.class);
        return (WaterMeterIoV3)s.fetch_all(nodeidx, _excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsContains(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.exists(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsContains(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.exists(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsEnabled() throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.configured().execute().body();
    }

    public NodePersistentStorageV3 npsEnabled(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.configured(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsPut(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put_with_name(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsPut(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put_with_name(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsGet(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.get_as_string(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsGet(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.get_as_string(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsRemove(String category, String name) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.delete(category, name).execute().body();
    }

    public NodePersistentStorageV3 npsRemove(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.delete(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsCreateCategory(String category) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put(category).execute().body();
    }

    public NodePersistentStorageV3 npsCreateCategory(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.put(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public NodePersistentStorageV3 npsKeys(String category) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.list(category).execute().body();
    }

    public NodePersistentStorageV3 npsKeys(NodePersistentStorageV3 params) throws IOException {
        NodePersistentStorage s = this.getService(NodePersistentStorage.class);
        return (NodePersistentStorageV3)s.list(params.category, params.name, params.value, params._excludeFields).execute().body();
    }

    public LogsV3 logs(int nodeidx, String name) throws IOException {
        Logs s = this.getService(Logs.class);
        return (LogsV3)s.fetch(nodeidx, name).execute().body();
    }

    public LogsV3 logs(int nodeidx, String name, String _excludeFields) throws IOException {
        Logs s = this.getService(Logs.class);
        return (LogsV3)s.fetch(nodeidx, name, _excludeFields).execute().body();
    }

    public KillMinus3V3 logThreadDump() throws IOException {
        KillMinus3 s = this.getService(KillMinus3.class);
        return (KillMinus3V3)s.killm3().execute().body();
    }

    public KillMinus3V3 logThreadDump(String _excludeFields) throws IOException {
        KillMinus3 s = this.getService(KillMinus3.class);
        return (KillMinus3V3)s.killm3(_excludeFields).execute().body();
    }

    public RapidsSchemaV3 rapidsExec(String ast) throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsSchemaV3)s.exec(ast).execute().body();
    }

    public RapidsSchemaV3 rapidsExec(RapidsSchemaV3 params) throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsSchemaV3)s.exec(params.ast, params.sessionId, params.id, params._excludeFields).execute().body();
    }

    public AssemblyV99 _assembly_toJava(String assemblyId, String pojoName) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.toJava(assemblyId, pojoName).execute().body();
    }

    public AssemblyV99 _assembly_toJava(AssemblyV99 params) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.toJava(params.assemblyId, params.pojoName, params.steps, H2oApi.keyToString(params.frame), params._excludeFields).execute().body();
    }

    public AssemblyV99 _assembly_fit() throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.fit().execute().body();
    }

    public AssemblyV99 _assembly_fit(AssemblyV99 params) throws IOException {
        Assembly s = this.getService(Assembly.class);
        return (AssemblyV99)s.fit(params.steps, H2oApi.keyToString(params.frame), params.pojoName, params.assemblyId, params._excludeFields).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId)).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId), hexString, "").execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetch(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetch(H2oApi.keyToString(frameId), hexString, _excludeFields).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId)).execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId), hexString, "").execute().body();
    }

    public DownloadDataV3 _downloadDataset_fetchStreaming(FrameKeyV3 frameId, boolean hexString, String _excludeFields) throws IOException {
        DownloadDataset s = this.getService(DownloadDataset.class);
        return (DownloadDataV3)s.fetchStreaming(H2oApi.keyToString(frameId), hexString, _excludeFields).execute().body();
    }

    public RemoveV3 deleteKey(KeyV3 key) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveV3)s.remove(H2oApi.keyToString(key)).execute().body();
    }

    public RemoveV3 deleteKey(KeyV3 key, String _excludeFields) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveV3)s.remove(H2oApi.keyToString(key), _excludeFields).execute().body();
    }

    public RemoveAllV3 deleteAllKeys() throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveAllV3)s.removeAll().execute().body();
    }

    public RemoveAllV3 deleteAllKeys(String _excludeFields) throws IOException {
        DKV s = this.getService(DKV.class);
        return (RemoveAllV3)s.removeAll(_excludeFields).execute().body();
    }

    public LogAndEchoV3 logAndEcho() throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo().execute().body();
    }

    public LogAndEchoV3 logAndEcho(String message) throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo(message, "").execute().body();
    }

    public LogAndEchoV3 logAndEcho(String message, String _excludeFields) throws IOException {
        LogAndEcho s = this.getService(LogAndEcho.class);
        return (LogAndEchoV3)s.echo(message, _excludeFields).execute().body();
    }

    public InitIDV3 newSession() throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.issue().execute().body();
    }

    public InitIDV3 newSession(String _excludeFields) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.issue(_excludeFields).execute().body();
    }

    public InitIDV3 endSession() throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.endSession().execute().body();
    }

    public InitIDV3 endSession(String _excludeFields) throws IOException {
        InitID s = this.getService(InitID.class);
        return (InitIDV3)s.endSession(_excludeFields).execute().body();
    }

    public GarbageCollectV3 garbageCollect() throws IOException {
        GarbageCollect s = this.getService(GarbageCollect.class);
        return (GarbageCollectV3)s.gc().execute().body();
    }

    public GarbageCollectV3 garbageCollect(String _excludeFields) throws IOException {
        GarbageCollect s = this.getService(GarbageCollect.class);
        return (GarbageCollectV3)s.gc(_excludeFields).execute().body();
    }

    public CloudV3 _sample_status() throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status().execute().body();
    }

    public CloudV3 _sample_status(boolean skipTicks) throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status(skipTicks, "").execute().body();
    }

    public CloudV3 _sample_status(boolean skipTicks, String _excludeFields) throws IOException {
        Sample s = this.getService(Sample.class);
        return (CloudV3)s.status(skipTicks, _excludeFields).execute().body();
    }

    public RapidsHelpV3 rapids_help() throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsHelpV3)s.genHelp().execute().body();
    }

    public RapidsHelpV3 rapids_help(String _excludeFields) throws IOException {
        Rapids s = this.getService(Rapids.class);
        return (RapidsHelpV3)s.genHelp(_excludeFields).execute().body();
    }

    public DeepLearningV3 train_deeplearning() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.trainDeeplearning().execute().body();
    }

    public DeepLearningV3 train_deeplearning(DeepLearningParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.trainDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.distribution, params.tweediePower, params.quantileAlpha, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public DeepLearningV3 validate_deeplearning() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.validate_parametersDeeplearning().execute().body();
    }

    public DeepLearningV3 validate_deeplearning(DeepLearningParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DeepLearningV3)s.validate_parametersDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.distribution, params.tweediePower, params.quantileAlpha, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.trainDeeplearning().execute().body();
    }

    public DeepLearningV3 grid_search_deeplearning(DeepLearningParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DeepLearningV3)s.trainDeeplearning(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.activation, params.hidden, params.epochs, params.trainSamplesPerIteration, params.targetRatioCommToComp, params.seed, params.adaptiveRate, params.rho, params.epsilon, params.rate, params.rateAnnealing, params.rateDecay, params.momentumStart, params.momentumRamp, params.momentumStable, params.nesterovAcceleratedGradient, params.inputDropoutRatio, params.hiddenDropoutRatios, params.l1, params.l2, params.maxW2, params.initialWeightDistribution, params.initialWeightScale, H2oApi.keyArrayToStringArray(params.initialWeights), H2oApi.keyArrayToStringArray(params.initialBiases), params.loss, params.distribution, params.tweediePower, params.quantileAlpha, params.scoreInterval, params.scoreTrainingSamples, params.scoreValidationSamples, params.scoreDutyCycle, params.classificationStop, params.regressionStop, params.quietMode, params.scoreValidationSampling, params.overwriteWithBestModel, params.autoencoder, params.useAllFactorLevels, params.standardize, params.diagnostics, params.variableImportances, params.fastMode, params.forceLoadBalance, params.replicateTrainingData, params.singleNodeMode, params.shuffleTrainingData, params.missingValuesHandling, params.sparse, params.colMajor, params.averageActivation, params.sparsityBeta, params.maxCategoricalFeatures, params.reproducible, params.exportWeightsAndBiases, params.miniBatchSize, params.elasticAveraging, params.elasticAveragingMovingRate, params.elasticAveragingRegularization, H2oApi.keyToString(params.pretrainedAutoencoder), H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLMV3 train_glm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.trainGlm().execute().body();
    }

    public GLMV3 train_glm(GLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.trainGlm(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.computePValues, params.removeCollinearColumns, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLMV3 validate_glm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.validate_parametersGlm().execute().body();
    }

    public GLMV3 validate_glm(GLMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLMV3)s.validate_parametersGlm(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.computePValues, params.removeCollinearColumns, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLMV3 grid_search_glm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.trainGlm().execute().body();
    }

    public GLMV3 grid_search_glm(GLMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLMV3)s.trainGlm(params.seed, params.family, params.tweedieVariancePower, params.tweedieLinkPower, params.solver, params.alpha, params.lambda, params.lambdaSearch, params.earlyStopping, params.nlambdas, params.standardize, params.missingValuesHandling, params.nonNegative, params.maxIterations, params.betaEpsilon, params.objectiveEpsilon, params.gradientEpsilon, params.objReg, params.link, params.intercept, params.prior, params.lambdaMinRatio, H2oApi.keyToString(params.betaConstraints), params.maxActivePredictors, params.interactions, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.computePValues, params.removeCollinearColumns, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLRMV3 train_glrm(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.trainGlrm(k).execute().body();
    }

    public GLRMV3 train_glrm(GLRMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.trainGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLRMV3 validate_glrm(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.validate_parametersGlrm(k).execute().body();
    }

    public GLRMV3 validate_glrm(GLRMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GLRMV3)s.validate_parametersGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLRMV3 grid_search_glrm(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.trainGlrm(k).execute().body();
    }

    public GLRMV3 grid_search_glrm(GLRMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GLRMV3)s.trainGlrm(params.transform, params.k, params.loss, params.multiLoss, params.lossByCol, params.lossByColIdx, params.period, params.regularizationX, params.regularizationY, params.gammaX, params.gammaY, params.maxIterations, params.maxUpdates, params.initStepSize, params.minStepSize, params.seed, params.init, params.svdMethod, H2oApi.keyToString(params.userY), H2oApi.keyToString(params.userX), params.loadingName, params.expandUserY, params.imputeOriginal, params.recoverSvd, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public KMeansV3 train_kmeans(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.trainKmeans(k).execute().body();
    }

    public KMeansV3 train_kmeans(KMeansParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.trainKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public KMeansV3 validate_kmeans(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.validate_parametersKmeans(k).execute().body();
    }

    public KMeansV3 validate_kmeans(KMeansParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (KMeansV3)s.validate_parametersKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public KMeansV3 grid_search_kmeans(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.trainKmeans(k).execute().body();
    }

    public KMeansV3 grid_search_kmeans(KMeansParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (KMeansV3)s.trainKmeans(H2oApi.keyToString(params.userPoints), params.maxIterations, params.standardize, params.seed, params.init, params.k, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public NaiveBayesV3 train_naivebayes() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.trainNaivebayes().execute().body();
    }

    public NaiveBayesV3 train_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.trainNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public NaiveBayesV3 validate_naivebayes() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.validate_parametersNaivebayes().execute().body();
    }

    public NaiveBayesV3 validate_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (NaiveBayesV3)s.validate_parametersNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes() throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.trainNaivebayes().execute().body();
    }

    public NaiveBayesV3 grid_search_naivebayes(NaiveBayesParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (NaiveBayesV3)s.trainNaivebayes(params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.laplace, params.minSdev, params.epsSdev, params.minProb, params.epsProb, params.computeMetrics, params.seed, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public PCAV3 train_pca(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.trainPca(k).execute().body();
    }

    public PCAV3 train_pca(PCAParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.trainPca(params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public PCAV3 validate_pca(int k) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.validate_parametersPca(k).execute().body();
    }

    public PCAV3 validate_pca(PCAParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (PCAV3)s.validate_parametersPca(params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public PCAV3 grid_search_pca(int k) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.trainPca(k).execute().body();
    }

    public PCAV3 grid_search_pca(PCAParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (PCAV3)s.trainPca(params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, params.computeMetrics, params.imputeMissing, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public SVDV99 train_svd() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.trainSvd().execute().body();
    }

    public SVDV99 train_svd(SVDParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.trainSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public SVDV99 validate_svd() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.validate_parametersSvd().execute().body();
    }

    public SVDV99 validate_svd(SVDParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (SVDV99)s.validate_parametersSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public SVDV99 grid_search_svd() throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.trainSvd().execute().body();
    }

    public SVDV99 grid_search_svd(SVDParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (SVDV99)s.trainSvd(params.transform, params.svdMethod, params.nv, params.maxIterations, params.seed, params.keepU, params.uName, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public DRFV3 train_drf() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.trainDrf().execute().body();
    }

    public DRFV3 train_drf(DRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.trainDrf(params.mtries, params.binomialDoubleTrees, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public DRFV3 validate_drf() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.validate_parametersDrf().execute().body();
    }

    public DRFV3 validate_drf(DRFParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (DRFV3)s.validate_parametersDrf(params.mtries, params.binomialDoubleTrees, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public DRFV3 grid_search_drf() throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.trainDrf().execute().body();
    }

    public DRFV3 grid_search_drf(DRFParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (DRFV3)s.trainDrf(params.mtries, params.binomialDoubleTrees, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GBMV3 train_gbm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.trainGbm().execute().body();
    }

    public GBMV3 train_gbm(GBMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.trainGbm(params.learnRate, params.learnRateAnnealing, params.distribution, params.quantileAlpha, params.tweediePower, params.colSampleRate, params.maxAbsLeafnodePred, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GBMV3 validate_gbm() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.validate_parametersGbm().execute().body();
    }

    public GBMV3 validate_gbm(GBMParametersV3 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (GBMV3)s.validate_parametersGbm(params.learnRate, params.learnRateAnnealing, params.distribution, params.quantileAlpha, params.tweediePower, params.colSampleRate, params.maxAbsLeafnodePred, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GBMV3 grid_search_gbm() throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.trainGbm().execute().body();
    }

    public GBMV3 grid_search_gbm(GBMParametersV3 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (GBMV3)s.trainGbm(params.learnRate, params.learnRateAnnealing, params.distribution, params.quantileAlpha, params.tweediePower, params.colSampleRate, params.maxAbsLeafnodePred, params.balanceClasses, params.classSamplingFactors, params.maxAfterBalanceSize, params.maxConfusionMatrixSize, params.maxHitRatioK, params.ntrees, params.maxDepth, params.minRows, params.nbins, params.nbinsTopLevel, params.nbinsCats, params.r2Stopping, params.seed, params.buildTreeOneNode, params.sampleRate, params.sampleRatePerClass, params.colSampleRatePerTree, params.colSampleRateChangePerLevel, params.scoreTreeInterval, params.minSplitImprovement, params.histogramType, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public AggregatorV99 train_aggregator() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.trainAggregator().execute().body();
    }

    public AggregatorV99 train_aggregator(AggregatorParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.trainAggregator(params.radiusScale, params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public AggregatorV99 validate_aggregator() throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.validate_parametersAggregator().execute().body();
    }

    public AggregatorV99 validate_aggregator(AggregatorParametersV99 params) throws IOException {
        ModelBuilders s = this.getService(ModelBuilders.class);
        return (AggregatorV99)s.validate_parametersAggregator(params.radiusScale, params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public AggregatorV99 grid_search_aggregator() throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.trainAggregator().execute().body();
    }

    public AggregatorV99 grid_search_aggregator(AggregatorParametersV99 params) throws IOException {
        Grid s = this.getService(Grid.class);
        return (AggregatorV99)s.trainAggregator(params.radiusScale, params.transform, params.pcaMethod, params.k, params.maxIterations, params.seed, params.useAllFactorLevels, H2oApi.keyToString(params.modelId), H2oApi.keyToString(params.trainingFrame), H2oApi.keyToString(params.validationFrame), params.nfolds, params.keepCrossValidationPredictions, params.keepCrossValidationFoldAssignment, params.parallelizeCrossValidation, H2oApi.colToString(params.responseColumn), H2oApi.colToString(params.weightsColumn), H2oApi.colToString(params.offsetColumn), H2oApi.colToString(params.foldColumn), params.foldAssignment, params.ignoredColumns, params.ignoreConstCols, params.scoreEachIteration, H2oApi.keyToString(params.checkpoint), params.stoppingRounds, params.maxRuntimeSecs, params.stoppingMetric, params.stoppingTolerance, params._excludeFields).execute().body();
    }

    public GLMModelV3 make_glm_model(ModelKeyV3 model, String[] names, double[] beta) throws IOException {
        MakeGLMModel s = this.getService(MakeGLMModel.class);
        return (GLMModelV3)s.make_model(H2oApi.keyToString(model), names, beta).execute().body();
    }

    public GLMModelV3 make_glm_model(MakeGLMModelV3 params) throws IOException {
        MakeGLMModel s = this.getService(MakeGLMModel.class);
        return (GLMModelV3)s.make_model(H2oApi.keyToString(params.model), H2oApi.keyToString(params.dest), params.names, params.beta, params.threshold, params._excludeFields).execute().body();
    }

    public GLMRegularizationPathV3 glm_regularization_path(ModelKeyV3 model) throws IOException {
        GetGLMRegPath s = this.getService(GetGLMRegPath.class);
        return (GLMRegularizationPathV3)s.extractRegularizationPath(H2oApi.keyToString(model)).execute().body();
    }

    public GLMRegularizationPathV3 glm_regularization_path(GLMRegularizationPathV3 params) throws IOException {
        GetGLMRegPath s = this.getService(GetGLMRegPath.class);
        return (GLMRegularizationPathV3)s.extractRegularizationPath(H2oApi.keyToString(params.model), params.lambdas, params.explainedDevianceTrain, params.explainedDevianceValid, params.coefficients, params.coefficientsStd, params.coefficientNames, params._excludeFields).execute().body();
    }

    public DataInfoFrameV3 glm_datainfo_frame() throws IOException {
        DataInfoFrame s = this.getService(DataInfoFrame.class);
        return (DataInfoFrameV3)s.getDataInfoFrame().execute().body();
    }

    public DataInfoFrameV3 glm_datainfo_frame(DataInfoFrameV3 params) throws IOException {
        DataInfoFrame s = this.getService(DataInfoFrame.class);
        return (DataInfoFrameV3)s.getDataInfoFrame(H2oApi.keyToString(params.frame), params.interactions, params.useAll, params.standardize, params.interactionsOnly, params._excludeFields).execute().body();
    }

    private void initializeRetrofit() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new ModelV3TypeAdapter()).registerTypeAdapter(KeyV3.class, (Object)new KeySerializer()).registerTypeAdapter(ColSpecifierV3.class, (Object)new ColSerializer()).registerTypeAdapter(ModelBuilderSchema.class, (Object)new ModelDeserializer()).registerTypeAdapter(ModelSchemaBaseV3.class, (Object)new ModelSchemaDeserializer()).create();
        OkHttpClient client = new OkHttpClient.Builder().connectTimeout((long)this.timeout_s, TimeUnit.SECONDS).writeTimeout((long)this.timeout_s, TimeUnit.SECONDS).readTimeout((long)this.timeout_s, TimeUnit.SECONDS).build();
        this.retrofit = new Retrofit.Builder().client(client).baseUrl(this.url).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
    }

    private Retrofit getRetrofit() {
        if (this.retrofit == null) {
            this.initializeRetrofit();
        }
        return this.retrofit;
    }

    private <T> T getService(Class<T> clazz) {
        return (T)this.getRetrofit().create(clazz);
    }

    public static String[] keyArrayToStringArray(KeyV3[] keys) {
        if (keys == null) {
            return null;
        }
        String[] ids = new String[keys.length];
        int i = 0;
        for (KeyV3 key : keys) {
            ids[i++] = key.name;
        }
        return ids;
    }

    public static <T extends KeyV3> T[] stringArrayToKeyArray(String[] ids, Class<T> clz) {
        if (ids == null) {
            return null;
        }
        KeyV3[] keys = (KeyV3[])Array.newInstance(clz, ids.length);
        String keyType = clz.getSimpleName();
        if (keyType.endsWith("KeyV3")) {
            keyType = keyType.substring(0, keyType.length() - 5);
        }
        try {
            int i = 0;
            for (String id : ids) {
                keys[i] = (KeyV3)clz.newInstance();
                keys[i].name = id;
                keys[i].type = keyType;
                ++i;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            // empty catch block
        }
        return keys;
    }

    public static String keyToString(KeyV3 key) {
        return key == null ? null : key.name;
    }

    public static FrameKeyV3 stringToFrameKey(String key) {
        if (key == null) {
            return null;
        }
        FrameKeyV3 k = new FrameKeyV3();
        k.name = key;
        return k;
    }

    private static String colToString(ColSpecifierV3 col) {
        return col == null ? null : col.columnName;
    }

    public static String stringToCol(String col) {
        if (col == null) {
            return null;
        }
        ColSpecifierV3 c = new ColSpecifierV3();
        c.columnName = col;
        return col;
    }

    public static void copyFields(Object to, Object from) {
        Field[] fromFields = from.getClass().getDeclaredFields();
        Field[] toFields = to.getClass().getDeclaredFields();
        for (Field fromField : fromFields) {
            Field toField = null;
            try {
                toField = to.getClass().getDeclaredField(fromField.getName());
                fromField.setAccessible(true);
                toField.setAccessible(true);
                toField.set(to, fromField.get(from));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static class ModelV3TypeAdapter
    implements TypeAdapterFactory {
        private ModelV3TypeAdapter() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final Class rawType = type.getRawType();
            if (!ModelBuilderSchema.class.isAssignableFrom(rawType) && !ModelSchemaBaseV3.class.isAssignableFrom(rawType)) {
                return null;
            }
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    JsonObject jobj = new JsonParser().parse(in).getAsJsonObject();
                    if (jobj.has("parameters") && jobj.get("parameters").isJsonArray()) {
                        JsonArray jarr = jobj.get("parameters").getAsJsonArray();
                        JsonObject paramsNew = new JsonObject();
                        for (JsonElement item : jarr) {
                            JsonObject itemObj = item.getAsJsonObject();
                            paramsNew.add(itemObj.get("name").getAsString(), itemObj.get("actual_value"));
                        }
                        jobj.add("parameters", (JsonElement)paramsNew);
                    }
                    return new Gson().fromJson((JsonElement)jobj, rawType);
                }
            };
        }
    }

    private static class ModelSchemaDeserializer
    implements JsonDeserializer<ModelSchemaBaseV3> {
        private ModelSchemaDeserializer() {
        }

        public ModelSchemaBaseV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                String string = algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
                int n = -1;
                switch (string.hashCode()) {
                    case 1549648906: {
                        if (!string.equals("deeplearning")) break;
                        n = 0;
                        break;
                    }
                    case 102440: {
                        if (!string.equals("glm")) break;
                        n = 1;
                        break;
                    }
                    case 3175904: {
                        if (!string.equals("glrm")) break;
                        n = 2;
                        break;
                    }
                    case -1127878717: {
                        if (!string.equals("kmeans")) break;
                        n = 3;
                        break;
                    }
                    case -723270877: {
                        if (!string.equals("naivebayes")) break;
                        n = 4;
                        break;
                    }
                    case 110798: {
                        if (!string.equals("pca")) break;
                        n = 5;
                        break;
                    }
                    case 114273: {
                        if (!string.equals("svd")) break;
                        n = 6;
                        break;
                    }
                    case 99736: {
                        if (!string.equals("drf")) break;
                        n = 7;
                        break;
                    }
                    case 102130: {
                        if (!string.equals("gbm")) break;
                        n = 8;
                        break;
                    }
                    case 1135524809: {
                        if (!string.equals("aggregator")) break;
                        n = 9;
                    }
                }
                switch (n) {
                    case 0: {
                        return (ModelSchemaBaseV3)context.deserialize(json, DeepLearningModelV3.class);
                    }
                    case 1: {
                        return (ModelSchemaBaseV3)context.deserialize(json, GLMModelV3.class);
                    }
                    case 2: {
                        return (ModelSchemaBaseV3)context.deserialize(json, GLRMModelV3.class);
                    }
                    case 3: {
                        return (ModelSchemaBaseV3)context.deserialize(json, KMeansModelV3.class);
                    }
                    case 4: {
                        return (ModelSchemaBaseV3)context.deserialize(json, NaiveBayesModelV3.class);
                    }
                    case 5: {
                        return (ModelSchemaBaseV3)context.deserialize(json, PCAModelV3.class);
                    }
                    case 6: {
                        return (ModelSchemaBaseV3)context.deserialize(json, SVDModelV99.class);
                    }
                    case 7: {
                        return (ModelSchemaBaseV3)context.deserialize(json, DRFModelV3.class);
                    }
                    case 8: {
                        return (ModelSchemaBaseV3)context.deserialize(json, GBMModelV3.class);
                    }
                    case 9: {
                        return (ModelSchemaBaseV3)context.deserialize(json, AggregatorModelV99.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelSchemaBaseV3 element " + json.toString());
        }
    }

    private static class ModelDeserializer
    implements JsonDeserializer<ModelBuilderSchema> {
        private ModelDeserializer() {
        }

        public ModelBuilderSchema deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jobj;
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonObject() && (jobj = json.getAsJsonObject()).has("algo")) {
                String algo;
                String string = algo = jobj.get("algo").getAsJsonPrimitive().getAsString().toLowerCase();
                int n = -1;
                switch (string.hashCode()) {
                    case 1549648906: {
                        if (!string.equals("deeplearning")) break;
                        n = 0;
                        break;
                    }
                    case 102440: {
                        if (!string.equals("glm")) break;
                        n = 1;
                        break;
                    }
                    case 3175904: {
                        if (!string.equals("glrm")) break;
                        n = 2;
                        break;
                    }
                    case -1127878717: {
                        if (!string.equals("kmeans")) break;
                        n = 3;
                        break;
                    }
                    case -723270877: {
                        if (!string.equals("naivebayes")) break;
                        n = 4;
                        break;
                    }
                    case 110798: {
                        if (!string.equals("pca")) break;
                        n = 5;
                        break;
                    }
                    case 114273: {
                        if (!string.equals("svd")) break;
                        n = 6;
                        break;
                    }
                    case 99736: {
                        if (!string.equals("drf")) break;
                        n = 7;
                        break;
                    }
                    case 102130: {
                        if (!string.equals("gbm")) break;
                        n = 8;
                        break;
                    }
                    case 1135524809: {
                        if (!string.equals("aggregator")) break;
                        n = 9;
                    }
                }
                switch (n) {
                    case 0: {
                        return (ModelBuilderSchema)context.deserialize(json, DeepLearningV3.class);
                    }
                    case 1: {
                        return (ModelBuilderSchema)context.deserialize(json, GLMV3.class);
                    }
                    case 2: {
                        return (ModelBuilderSchema)context.deserialize(json, GLRMV3.class);
                    }
                    case 3: {
                        return (ModelBuilderSchema)context.deserialize(json, KMeansV3.class);
                    }
                    case 4: {
                        return (ModelBuilderSchema)context.deserialize(json, NaiveBayesV3.class);
                    }
                    case 5: {
                        return (ModelBuilderSchema)context.deserialize(json, PCAV3.class);
                    }
                    case 6: {
                        return (ModelBuilderSchema)context.deserialize(json, SVDV99.class);
                    }
                    case 7: {
                        return (ModelBuilderSchema)context.deserialize(json, DRFV3.class);
                    }
                    case 8: {
                        return (ModelBuilderSchema)context.deserialize(json, GBMV3.class);
                    }
                    case 9: {
                        return (ModelBuilderSchema)context.deserialize(json, AggregatorV99.class);
                    }
                }
                throw new JsonParseException("Unable to deserialize model of type " + algo);
            }
            throw new JsonParseException("Invalid ModelBuilderSchema element " + json.toString());
        }
    }

    private static class ColSerializer
    implements JsonSerializer<ColSpecifierV3> {
        private ColSerializer() {
        }

        public JsonElement serialize(ColSpecifierV3 col, Type typeOfCol, JsonSerializationContext context) {
            return new JsonPrimitive(col.columnName);
        }
    }

    private static class KeySerializer
    implements JsonSerializer<KeyV3>,
    JsonDeserializer<KeyV3> {
        private KeySerializer() {
        }

        public JsonElement serialize(KeyV3 key, Type typeOfKey, JsonSerializationContext context) {
            return new JsonPrimitive(key.name);
        }

        public KeyV3 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            String type;
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject jobj = json.getAsJsonObject();
            String string = type = jobj.get("type").getAsString();
            int n = -1;
            switch (string.hashCode()) {
                case 429416050: {
                    if (!string.equals("Key<Model>")) break;
                    n = 0;
                    break;
                }
                case 532200350: {
                    if (!string.equals("Key<Job>")) break;
                    n = 1;
                    break;
                }
                case -684331557: {
                    if (!string.equals("Key<Grid>")) break;
                    n = 2;
                    break;
                }
                case 231700654: {
                    if (!string.equals("Key<Frame>")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, ModelKeyV3.class);
                }
                case 1: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, JobKeyV3.class);
                }
                case 2: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, GridKeyV3.class);
                }
                case 3: {
                    return (KeyV3)context.deserialize((JsonElement)jobj, FrameKeyV3.class);
                }
            }
            throw new JsonParseException("Unable to deserialize key of type " + type);
        }
    }
}

