/*
 * Decompiled with CFR 0.152.
 */
package water.bindings.examples.retrofit;

import java.io.IOException;
import water.bindings.H2oApi;
import water.bindings.pojos.FrameKeyV3;
import water.bindings.pojos.ImportFilesV3;
import water.bindings.pojos.ParseSetupV3;
import water.bindings.pojos.ParseV3;
import water.bindings.pojos.RapidsSchemaV3;

public class Merge_Example {
    public static void mergeExample() {
        H2oApi h2o = new H2oApi();
        try {
            Object job = null;
            String sessionId = h2o.newSession().sessionKey;
            ImportFilesV3 importBody = h2o.importFiles("smalldata/merge/tourism.csv");
            ParseSetupV3 parseSetupParams = new ParseSetupV3();
            parseSetupParams.sourceFrames = (FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class);
            parseSetupParams.checkHeader = 1;
            ParseSetupV3 parseSetupBody = h2o.guessParseSetup(parseSetupParams);
            ParseV3 parseParms = new ParseV3();
            H2oApi.copyFields(parseParms, parseSetupBody);
            parseParms.destinationFrame = H2oApi.stringToFrameKey("tourism");
            parseParms.blocking = true;
            ParseV3 parseBody = h2o.parse(parseParms);
            importBody = h2o.importFiles("smalldata/merge/heart.csv");
            parseSetupParams = new ParseSetupV3();
            parseSetupParams.sourceFrames = (FrameKeyV3[])H2oApi.stringArrayToKeyArray((String[])importBody.destinationFrames, FrameKeyV3.class);
            parseSetupParams.checkHeader = 1;
            parseSetupBody = h2o.guessParseSetup(parseSetupParams);
            parseParms = new ParseV3();
            H2oApi.copyFields(parseParms, parseSetupBody);
            parseParms.destinationFrame = H2oApi.stringToFrameKey("heart");
            parseParms.checkHeader = 1;
            parseParms.blocking = true;
            parseBody = h2o.parse(parseParms);
            RapidsSchemaV3 rapidsParms = new RapidsSchemaV3();
            rapidsParms.sessionId = sessionId;
            rapidsParms.ast = "(assign heart (:= heart (as.factor (cols heart 1)) 1 [0:263]))";
            h2o.rapidsExec(rapidsParms);
            rapidsParms.ast = String.format("(assign mergedframe (merge %s %s TRUE FALSE [] [] \"auto\") )", "tourism", "heart");
            h2o.rapidsExec(rapidsParms);
            h2o.endSession();
        }
        catch (IOException e) {
            System.err.println("Caught exception: " + e);
        }
    }

    public static void main(String[] args) {
        Merge_Example.mergeExample();
    }
}

