/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.pojos;

import com.google.gson.Gson;
import com.google.gson.annotations.*;


public class Word2VecParametersV3 extends ModelParametersSchemaV3 {

    /**
     * Set size of word vectors
     */
    @SerializedName("vecSize")
    public int vecsize;

    /**
     * Set max skip length between words
     */
    @SerializedName("windowSize")
    public int windowsize;

    /**
     * Set threshold for occurrence of words. Those that appear with higher frequency in the training data
     * will be randomly down-sampled; useful range is (0, 1e-5)
     */
    @SerializedName("sentSampleRate")
    public float sentsamplerate;

    /**
     * Use Hierarchical Softmax or Negative Sampling
     */
    @SerializedName("normModel")
    public Word2VecNormModel normmodel;

    /**
     * Number of negative examples, common values are 3 - 10 (0 = not used)
     */
    @SerializedName("negSampleCnt")
    public int negsamplecnt;

    /**
     * Number of training iterations to run
     */
    public int epochs;

    /**
     * This will discard words that appear less than <int> times
     */
    @SerializedName("minWordFreq")
    public int minwordfreq;

    /**
     * Set the starting learning rate
     */
    @SerializedName("initLearningRate")
    public float initlearningrate;

    /**
     * Use the continuous bag of words model or the Skip-Gram model
     */
    @SerializedName("wordModel")
    public Word2VecWordModel wordmodel;


    /*------------------------------------------------------------------------------------------------------------------
    //                                                  INHERITED
    //------------------------------------------------------------------------------------------------------------------

    // Destination id for this model; auto-generated if not specified.
    public ModelKeyV3 modelId;

    // Id of the training data frame (Not required, to allow initial validation of model parameters).
    public FrameKeyV3 trainingFrame;

    // Id of the validation data frame.
    public FrameKeyV3 validationFrame;

    // Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
    public int nfolds;

    // Whether to keep the predictions of the cross-validation models.
    public boolean keepCrossValidationPredictions;

    // Whether to keep the cross-validation fold assignment.
    public boolean keepCrossValidationFoldAssignment;

    // Allow parallel training of cross-validation models
    public boolean parallelizeCrossValidation;

    // Response variable column.
    public ColSpecifierV3 responseColumn;

    // Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from the
    // dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative weights
    // are not allowed.
    public ColSpecifierV3 weightsColumn;

    // Offset column. This will be added to the combination of columns before applying the link function.
    public ColSpecifierV3 offsetColumn;

    // Column with cross-validation fold index assignment per observation.
    public ColSpecifierV3 foldColumn;

    // Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will stratify
    // the folds based on the response variable, for classification problems.
    public ModelParametersFoldAssignmentScheme foldAssignment;

    // Names of columns to ignore for training.
    public String[] ignoredColumns;

    // Ignore constant columns.
    public boolean ignoreConstCols;

    // Whether to score during each iteration of model training.
    public boolean scoreEachIteration;

    // Model checkpoint to resume training with.
    public ModelKeyV3 checkpoint;

    // Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
    // stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)
    public int stoppingRounds;

    // Maximum allowed runtime in seconds for model training. Use 0 to disable.
    public double maxRuntimeSecs;

    // Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)
    public ScoreKeeperStoppingMetric stoppingMetric;

    // Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)
    public double stoppingTolerance;

    // Comma-separated list of JSON field paths to exclude from the result, used like:
    // "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
    public String _excludeFields;

    */

    /**
     * Public constructor
     */
    public Word2VecParametersV3() {
        vecsize = 100;
        windowsize = 5;
        sentsamplerate = 0.001f;
        normmodel = Word2VecNormModel.HSM;
        negsamplecnt = 5;
        epochs = 5;
        minwordfreq = 5;
        initlearningrate = 0.05f;
        wordmodel = Word2VecWordModel.SkipGram;
        nfolds = 0;
        keepCrossValidationPredictions = false;
        keepCrossValidationFoldAssignment = false;
        parallelizeCrossValidation = true;
        foldAssignment = ModelParametersFoldAssignmentScheme.AUTO;
        ignoreConstCols = true;
        scoreEachIteration = false;
        stoppingRounds = 0;
        maxRuntimeSecs = 0.0;
        stoppingMetric = ScoreKeeperStoppingMetric.AUTO;
        stoppingTolerance = 0.001;
        _excludeFields = "";
    }

    /**
     * Return the contents of this object as a JSON String.
     */
    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

}
