/**
 * This file is auto-generated by h2o-3/h2o-bindings/bin/gen_java.py
 * Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details)
 */
package water.bindings.proxies.retrofit;

import water.bindings.pojos.*;
import retrofit2.*;
import retrofit2.http.*;

public interface ModelBuilders {

  /** 
   * Return a new unique model_id for the specified algorithm.
   *   @param algo Algo of ModelBuilder of interest
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/{algo}/model_id")
  Call<ModelIdV3> calcModelId(
    @Path("algo") String algo,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/{algo}/model_id")
  Call<ModelIdV3> calcModelId(@Path("algo") String algo);

  /** 
   * Return the Model Builder metadata for the specified algorithm.
   *   @param algo Algo of ModelBuilder of interest
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/ModelBuilders/{algo}")
  Call<ModelBuildersV3> fetch(
    @Path("algo") String algo,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/ModelBuilders/{algo}")
  Call<ModelBuildersV3> fetch(@Path("algo") String algo);

  /** 
   * Return the Model Builder metadata for all available algorithms.
   *   @param algo Algo of ModelBuilder of interest
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @GET("/3/ModelBuilders")
  Call<ModelBuildersV3> list(
    @Field("algo") String algo,
    @Field("_exclude_fields") String _exclude_fields
  );

  @GET("/3/ModelBuilders")
  Call<ModelBuildersV3> list();

  /** 
   * Train a DeepLearning model.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs.
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable).
   *   @param activation Activation function.
   *   @param hidden Hidden layer sizes (e.g. [100, 100]).
   *   @param epochs How many times the dataset should be iterated (streamed), can be fractional.
   *   @param train_samples_per_iteration Number of training samples (globally) per MapReduce iteration. Special values
   *                                      are 0: one epoch, -1: all available data (e.g., replicated training data), -2:
   *                                      automatic.
   *   @param target_ratio_comm_to_comp Target ratio of communication overhead to computation. Only for multi-node
   *                                    operation and train_samples_per_iteration = -2 (auto-tuning).
   *   @param seed Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded.
   *   @param adaptive_rate Adaptive learning rate.
   *   @param rho Adaptive learning rate time decay factor (similarity to prior updates).
   *   @param epsilon Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress).
   *   @param rate Learning rate (higher => less stable, lower => slower convergence).
   *   @param rate_annealing Learning rate annealing: rate / (1 + rate_annealing * samples).
   *   @param rate_decay Learning rate decay factor between layers (N-th layer: rate·rate_decayᴺ⁻¹).
   *   @param momentum_start Initial momentum at the beginning of training (try 0.5).
   *   @param momentum_ramp Number of training samples for which momentum increases.
   *   @param momentum_stable Final momentum after the ramp is over (try 0.99).
   *   @param nesterov_accelerated_gradient Use Nesterov accelerated gradient (recommended).
   *   @param input_dropout_ratio Input layer dropout ratio (can improve generalization, try 0.1 or 0.2).
   *   @param hidden_dropout_ratios Hidden layer dropout ratios (can improve generalization), specify one value per
   *                                hidden layer, defaults to 0.5.
   *   @param l1 L1 regularization (can add stability and improve generalization, causes many weights to become 0).
   *   @param l2 L2 regularization (can add stability and improve generalization, causes many weights to be small.
   *   @param max_w2 Constraint for squared sum of incoming weights per unit (e.g. for Rectifier).
   *   @param initial_weight_distribution Initial weight distribution.
   *   @param initial_weight_scale Uniform: -value...value, Normal: stddev.
   *   @param initial_weights A list of H2OFrame ids to initialize the weight matrices of this model with.
   *   @param initial_biases A list of H2OFrame ids to initialize the bias vectors of this model with.
   *   @param loss Loss function.
   *   @param distribution Distribution function.
   *   @param tweedie_power Tweedie power.
   *   @param quantile_alpha Desired quantile for quantile regression (from 0.0 to 1.0).
   *   @param score_interval Shortest time interval (in seconds) between model scoring.
   *   @param score_training_samples Number of training set samples for scoring (0 for all).
   *   @param score_validation_samples Number of validation set samples for scoring (0 for all).
   *   @param score_duty_cycle Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).
   *   @param classification_stop Stopping criterion for classification error fraction on training data (-1 to disable).
   *   @param regression_stop Stopping criterion for regression error (MSE) on training data (-1 to disable).
   *   @param quiet_mode Enable quiet mode for less output to standard output.
   *   @param score_validation_sampling Method used to sample validation dataset for scoring.
   *   @param overwrite_with_best_model If enabled, override the final model with the best model found during training.
   *   @param autoencoder Auto-Encoder.
   *   @param use_all_factor_levels Use all factor levels of categorical variables. Otherwise, the first factor level is
   *                                omitted (without loss of accuracy). Useful for variable importances and auto-enabled
   *                                for autoencoder.
   *   @param standardize If enabled, automatically standardize the data. If disabled, the user must provide properly
   *                      scaled input data.
   *   @param diagnostics Enable diagnostics for hidden layers.
   *   @param variable_importances Compute variable importances for input features (Gedeon method) - can be slow for
   *                               large networks.
   *   @param fast_mode Enable fast mode (minor approximation in back-propagation).
   *   @param force_load_balance Force extra load balancing to increase training speed for small datasets (to keep all
   *                             cores busy).
   *   @param replicate_training_data Replicate the entire training dataset onto every node for faster training on small
   *                                  datasets.
   *   @param single_node_mode Run on a single node for fine-tuning of model parameters.
   *   @param shuffle_training_data Enable shuffling of training data (recommended if training data is replicated and
   *                                train_samples_per_iteration is close to #nodes x #rows, of if using
   *                                balance_classes).
   *   @param missing_values_handling Handling of missing values. Either Skip or MeanImputation.
   *   @param sparse Sparse data handling (more efficient for data with lots of 0 values).
   *   @param col_major #DEPRECATED Use a column major weight matrix for input layer. Can speed up forward propagation,
   *                    but might slow down backpropagation.
   *   @param average_activation Average activation for sparse auto-encoder. #Experimental
   *   @param sparsity_beta Sparsity regularization. #Experimental
   *   @param max_categorical_features Max. number of categorical features, enforced via hashing. #Experimental
   *   @param reproducible Force reproducibility on small data (will be slow - only uses 1 thread).
   *   @param export_weights_and_biases Whether to export Neural Network weights and biases to H₂O Frames.
   *   @param mini_batch_size Mini-batch size (smaller leads to better fit, larger can speed up and generalize better).
   *   @param elastic_averaging Elastic averaging between compute nodes can improve distributed model convergence.
   *                            #Experimental
   *   @param elastic_averaging_moving_rate Elastic averaging moving rate (only if elastic averaging is enabled).
   *   @param elastic_averaging_regularization Elastic averaging regularization strength (only if elastic averaging is
   *                                           enabled).
   *   @param pretrained_autoencoder Pretrained autoencoder model to initialize this model with.
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/deeplearning")
  Call<DeepLearningV3> trainDeeplearning(
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("activation") DeepLearningActivation activation,
    @Field("hidden") int[] hidden,
    @Field("epochs") double epochs,
    @Field("train_samples_per_iteration") long train_samples_per_iteration,
    @Field("target_ratio_comm_to_comp") double target_ratio_comm_to_comp,
    @Field("seed") long seed,
    @Field("adaptive_rate") boolean adaptive_rate,
    @Field("rho") double rho,
    @Field("epsilon") double epsilon,
    @Field("rate") double rate,
    @Field("rate_annealing") double rate_annealing,
    @Field("rate_decay") double rate_decay,
    @Field("momentum_start") double momentum_start,
    @Field("momentum_ramp") double momentum_ramp,
    @Field("momentum_stable") double momentum_stable,
    @Field("nesterov_accelerated_gradient") boolean nesterov_accelerated_gradient,
    @Field("input_dropout_ratio") double input_dropout_ratio,
    @Field("hidden_dropout_ratios") double[] hidden_dropout_ratios,
    @Field("l1") double l1,
    @Field("l2") double l2,
    @Field("max_w2") float max_w2,
    @Field("initial_weight_distribution") DeepLearningInitialWeightDistribution initial_weight_distribution,
    @Field("initial_weight_scale") double initial_weight_scale,
    @Field("initial_weights") String[] initial_weights,
    @Field("initial_biases") String[] initial_biases,
    @Field("loss") DeepLearningLoss loss,
    @Field("distribution") DistributionFamily distribution,
    @Field("tweedie_power") double tweedie_power,
    @Field("quantile_alpha") double quantile_alpha,
    @Field("score_interval") double score_interval,
    @Field("score_training_samples") long score_training_samples,
    @Field("score_validation_samples") long score_validation_samples,
    @Field("score_duty_cycle") double score_duty_cycle,
    @Field("classification_stop") double classification_stop,
    @Field("regression_stop") double regression_stop,
    @Field("quiet_mode") boolean quiet_mode,
    @Field("score_validation_sampling") DeepLearningClassSamplingMethod score_validation_sampling,
    @Field("overwrite_with_best_model") boolean overwrite_with_best_model,
    @Field("autoencoder") boolean autoencoder,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("standardize") boolean standardize,
    @Field("diagnostics") boolean diagnostics,
    @Field("variable_importances") boolean variable_importances,
    @Field("fast_mode") boolean fast_mode,
    @Field("force_load_balance") boolean force_load_balance,
    @Field("replicate_training_data") boolean replicate_training_data,
    @Field("single_node_mode") boolean single_node_mode,
    @Field("shuffle_training_data") boolean shuffle_training_data,
    @Field("missing_values_handling") DeepLearningMissingValuesHandling missing_values_handling,
    @Field("sparse") boolean sparse,
    @Field("col_major") boolean col_major,
    @Field("average_activation") double average_activation,
    @Field("sparsity_beta") double sparsity_beta,
    @Field("max_categorical_features") int max_categorical_features,
    @Field("reproducible") boolean reproducible,
    @Field("export_weights_and_biases") boolean export_weights_and_biases,
    @Field("mini_batch_size") int mini_batch_size,
    @Field("elastic_averaging") boolean elastic_averaging,
    @Field("elastic_averaging_moving_rate") double elastic_averaging_moving_rate,
    @Field("elastic_averaging_regularization") double elastic_averaging_regularization,
    @Field("pretrained_autoencoder") String pretrained_autoencoder,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/deeplearning")
  Call<DeepLearningV3> trainDeeplearning();

  /** 
   * Validate a set of DeepLearning model builder parameters.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs.
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable).
   *   @param activation Activation function.
   *   @param hidden Hidden layer sizes (e.g. [100, 100]).
   *   @param epochs How many times the dataset should be iterated (streamed), can be fractional.
   *   @param train_samples_per_iteration Number of training samples (globally) per MapReduce iteration. Special values
   *                                      are 0: one epoch, -1: all available data (e.g., replicated training data), -2:
   *                                      automatic.
   *   @param target_ratio_comm_to_comp Target ratio of communication overhead to computation. Only for multi-node
   *                                    operation and train_samples_per_iteration = -2 (auto-tuning).
   *   @param seed Seed for random numbers (affects sampling) - Note: only reproducible when running single threaded.
   *   @param adaptive_rate Adaptive learning rate.
   *   @param rho Adaptive learning rate time decay factor (similarity to prior updates).
   *   @param epsilon Adaptive learning rate smoothing factor (to avoid divisions by zero and allow progress).
   *   @param rate Learning rate (higher => less stable, lower => slower convergence).
   *   @param rate_annealing Learning rate annealing: rate / (1 + rate_annealing * samples).
   *   @param rate_decay Learning rate decay factor between layers (N-th layer: rate·rate_decayᴺ⁻¹).
   *   @param momentum_start Initial momentum at the beginning of training (try 0.5).
   *   @param momentum_ramp Number of training samples for which momentum increases.
   *   @param momentum_stable Final momentum after the ramp is over (try 0.99).
   *   @param nesterov_accelerated_gradient Use Nesterov accelerated gradient (recommended).
   *   @param input_dropout_ratio Input layer dropout ratio (can improve generalization, try 0.1 or 0.2).
   *   @param hidden_dropout_ratios Hidden layer dropout ratios (can improve generalization), specify one value per
   *                                hidden layer, defaults to 0.5.
   *   @param l1 L1 regularization (can add stability and improve generalization, causes many weights to become 0).
   *   @param l2 L2 regularization (can add stability and improve generalization, causes many weights to be small.
   *   @param max_w2 Constraint for squared sum of incoming weights per unit (e.g. for Rectifier).
   *   @param initial_weight_distribution Initial weight distribution.
   *   @param initial_weight_scale Uniform: -value...value, Normal: stddev.
   *   @param initial_weights A list of H2OFrame ids to initialize the weight matrices of this model with.
   *   @param initial_biases A list of H2OFrame ids to initialize the bias vectors of this model with.
   *   @param loss Loss function.
   *   @param distribution Distribution function.
   *   @param tweedie_power Tweedie power.
   *   @param quantile_alpha Desired quantile for quantile regression (from 0.0 to 1.0).
   *   @param score_interval Shortest time interval (in seconds) between model scoring.
   *   @param score_training_samples Number of training set samples for scoring (0 for all).
   *   @param score_validation_samples Number of validation set samples for scoring (0 for all).
   *   @param score_duty_cycle Maximum duty cycle fraction for scoring (lower: more training, higher: more scoring).
   *   @param classification_stop Stopping criterion for classification error fraction on training data (-1 to disable).
   *   @param regression_stop Stopping criterion for regression error (MSE) on training data (-1 to disable).
   *   @param quiet_mode Enable quiet mode for less output to standard output.
   *   @param score_validation_sampling Method used to sample validation dataset for scoring.
   *   @param overwrite_with_best_model If enabled, override the final model with the best model found during training.
   *   @param autoencoder Auto-Encoder.
   *   @param use_all_factor_levels Use all factor levels of categorical variables. Otherwise, the first factor level is
   *                                omitted (without loss of accuracy). Useful for variable importances and auto-enabled
   *                                for autoencoder.
   *   @param standardize If enabled, automatically standardize the data. If disabled, the user must provide properly
   *                      scaled input data.
   *   @param diagnostics Enable diagnostics for hidden layers.
   *   @param variable_importances Compute variable importances for input features (Gedeon method) - can be slow for
   *                               large networks.
   *   @param fast_mode Enable fast mode (minor approximation in back-propagation).
   *   @param force_load_balance Force extra load balancing to increase training speed for small datasets (to keep all
   *                             cores busy).
   *   @param replicate_training_data Replicate the entire training dataset onto every node for faster training on small
   *                                  datasets.
   *   @param single_node_mode Run on a single node for fine-tuning of model parameters.
   *   @param shuffle_training_data Enable shuffling of training data (recommended if training data is replicated and
   *                                train_samples_per_iteration is close to #nodes x #rows, of if using
   *                                balance_classes).
   *   @param missing_values_handling Handling of missing values. Either Skip or MeanImputation.
   *   @param sparse Sparse data handling (more efficient for data with lots of 0 values).
   *   @param col_major #DEPRECATED Use a column major weight matrix for input layer. Can speed up forward propagation,
   *                    but might slow down backpropagation.
   *   @param average_activation Average activation for sparse auto-encoder. #Experimental
   *   @param sparsity_beta Sparsity regularization. #Experimental
   *   @param max_categorical_features Max. number of categorical features, enforced via hashing. #Experimental
   *   @param reproducible Force reproducibility on small data (will be slow - only uses 1 thread).
   *   @param export_weights_and_biases Whether to export Neural Network weights and biases to H₂O Frames.
   *   @param mini_batch_size Mini-batch size (smaller leads to better fit, larger can speed up and generalize better).
   *   @param elastic_averaging Elastic averaging between compute nodes can improve distributed model convergence.
   *                            #Experimental
   *   @param elastic_averaging_moving_rate Elastic averaging moving rate (only if elastic averaging is enabled).
   *   @param elastic_averaging_regularization Elastic averaging regularization strength (only if elastic averaging is
   *                                           enabled).
   *   @param pretrained_autoencoder Pretrained autoencoder model to initialize this model with.
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/deeplearning/parameters")
  Call<DeepLearningV3> validate_parametersDeeplearning(
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("activation") DeepLearningActivation activation,
    @Field("hidden") int[] hidden,
    @Field("epochs") double epochs,
    @Field("train_samples_per_iteration") long train_samples_per_iteration,
    @Field("target_ratio_comm_to_comp") double target_ratio_comm_to_comp,
    @Field("seed") long seed,
    @Field("adaptive_rate") boolean adaptive_rate,
    @Field("rho") double rho,
    @Field("epsilon") double epsilon,
    @Field("rate") double rate,
    @Field("rate_annealing") double rate_annealing,
    @Field("rate_decay") double rate_decay,
    @Field("momentum_start") double momentum_start,
    @Field("momentum_ramp") double momentum_ramp,
    @Field("momentum_stable") double momentum_stable,
    @Field("nesterov_accelerated_gradient") boolean nesterov_accelerated_gradient,
    @Field("input_dropout_ratio") double input_dropout_ratio,
    @Field("hidden_dropout_ratios") double[] hidden_dropout_ratios,
    @Field("l1") double l1,
    @Field("l2") double l2,
    @Field("max_w2") float max_w2,
    @Field("initial_weight_distribution") DeepLearningInitialWeightDistribution initial_weight_distribution,
    @Field("initial_weight_scale") double initial_weight_scale,
    @Field("initial_weights") String[] initial_weights,
    @Field("initial_biases") String[] initial_biases,
    @Field("loss") DeepLearningLoss loss,
    @Field("distribution") DistributionFamily distribution,
    @Field("tweedie_power") double tweedie_power,
    @Field("quantile_alpha") double quantile_alpha,
    @Field("score_interval") double score_interval,
    @Field("score_training_samples") long score_training_samples,
    @Field("score_validation_samples") long score_validation_samples,
    @Field("score_duty_cycle") double score_duty_cycle,
    @Field("classification_stop") double classification_stop,
    @Field("regression_stop") double regression_stop,
    @Field("quiet_mode") boolean quiet_mode,
    @Field("score_validation_sampling") DeepLearningClassSamplingMethod score_validation_sampling,
    @Field("overwrite_with_best_model") boolean overwrite_with_best_model,
    @Field("autoencoder") boolean autoencoder,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("standardize") boolean standardize,
    @Field("diagnostics") boolean diagnostics,
    @Field("variable_importances") boolean variable_importances,
    @Field("fast_mode") boolean fast_mode,
    @Field("force_load_balance") boolean force_load_balance,
    @Field("replicate_training_data") boolean replicate_training_data,
    @Field("single_node_mode") boolean single_node_mode,
    @Field("shuffle_training_data") boolean shuffle_training_data,
    @Field("missing_values_handling") DeepLearningMissingValuesHandling missing_values_handling,
    @Field("sparse") boolean sparse,
    @Field("col_major") boolean col_major,
    @Field("average_activation") double average_activation,
    @Field("sparsity_beta") double sparsity_beta,
    @Field("max_categorical_features") int max_categorical_features,
    @Field("reproducible") boolean reproducible,
    @Field("export_weights_and_biases") boolean export_weights_and_biases,
    @Field("mini_batch_size") int mini_batch_size,
    @Field("elastic_averaging") boolean elastic_averaging,
    @Field("elastic_averaging_moving_rate") double elastic_averaging_moving_rate,
    @Field("elastic_averaging_regularization") double elastic_averaging_regularization,
    @Field("pretrained_autoencoder") String pretrained_autoencoder,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/deeplearning/parameters")
  Call<DeepLearningV3> validate_parametersDeeplearning();

  /** 
   * Train a GLM model.
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param family Family. Use binomial for classification with logistic regression, others are for regression
   *                 problems.
   *   @param tweedie_variance_power Tweedie variance power
   *   @param tweedie_link_power Tweedie link power
   *   @param solver AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems
   *                 with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for
   *                 datasets with many columns. Coordinate descent is experimental (beta).
   *   @param alpha distribution of regularization between L1 and L2.
   *   @param lambda regularization strength
   *   @param lambda_search use lambda search starting at lambda max, given lambda is then interpreted as lambda min
   *   @param early_stopping stop early when there is no more relative improvement on train or validation (if provided)
   *   @param nlambdas number of lambdas to be used in a search
   *   @param standardize Standardize numeric columns to have zero mean and unit variance
   *   @param missing_values_handling Handling of missing values. Either Skip or MeanImputation.
   *   @param non_negative Restrict coefficients (not intercept) to be non-negative
   *   @param max_iterations Maximum number of iterations
   *   @param beta_epsilon converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to
   *                       IRLSM solver
   *   @param objective_epsilon converge if  objective value changes less than this
   *   @param gradient_epsilon converge if  objective changes less (using L-infinity norm) than this, ONLY applies to
   *                           L-BFGS solver
   *   @param obj_reg likelihood divider in objective value computation, default is 1/nobs
   *   @param link 
   *   @param intercept include constant term in the model
   *   @param prior prior probability for y==1. To be used only for logistic regression iff the data has been sampled
   *                and the mean of response does not reflect reality.
   *   @param lambda_min_ratio min lambda used in lambda search, specified as a ratio of lambda_max
   *   @param beta_constraints beta constraints
   *   @param max_active_predictors Maximum number of active predictors during computation. Use as a stopping criterium
   *                                to prevent expensive model building with many predictors.
   *   @param interactions A list of predictor column indices to interact. All pairwise combinations will be computed
   *                       for the list.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param compute_p_values request p-values computation, p-values work only with IRLSM solver and no regularization
   *   @param remove_collinear_columns in case of linearly dependent columns remove some of the dependent columns
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/glm")
  Call<GLMV3> trainGlm(
    @Field("seed") long seed,
    @Field("family") GLMFamily family,
    @Field("tweedie_variance_power") double tweedie_variance_power,
    @Field("tweedie_link_power") double tweedie_link_power,
    @Field("solver") GLMSolver solver,
    @Field("alpha") double[] alpha,
    @Field("lambda") double[] lambda,
    @Field("lambda_search") boolean lambda_search,
    @Field("early_stopping") boolean early_stopping,
    @Field("nlambdas") int nlambdas,
    @Field("standardize") boolean standardize,
    @Field("missing_values_handling") DeepLearningMissingValuesHandling missing_values_handling,
    @Field("non_negative") boolean non_negative,
    @Field("max_iterations") int max_iterations,
    @Field("beta_epsilon") double beta_epsilon,
    @Field("objective_epsilon") double objective_epsilon,
    @Field("gradient_epsilon") double gradient_epsilon,
    @Field("obj_reg") double obj_reg,
    @Field("link") GLMLink link,
    @Field("intercept") boolean intercept,
    @Field("prior") double prior,
    @Field("lambda_min_ratio") double lambda_min_ratio,
    @Field("beta_constraints") String beta_constraints,
    @Field("max_active_predictors") int max_active_predictors,
    @Field("interactions") String[] interactions,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("compute_p_values") boolean compute_p_values,
    @Field("remove_collinear_columns") boolean remove_collinear_columns,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/glm")
  Call<GLMV3> trainGlm();

  /** 
   * Validate a set of GLM model builder parameters.
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param family Family. Use binomial for classification with logistic regression, others are for regression
   *                 problems.
   *   @param tweedie_variance_power Tweedie variance power
   *   @param tweedie_link_power Tweedie link power
   *   @param solver AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems
   *                 with small number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for
   *                 datasets with many columns. Coordinate descent is experimental (beta).
   *   @param alpha distribution of regularization between L1 and L2.
   *   @param lambda regularization strength
   *   @param lambda_search use lambda search starting at lambda max, given lambda is then interpreted as lambda min
   *   @param early_stopping stop early when there is no more relative improvement on train or validation (if provided)
   *   @param nlambdas number of lambdas to be used in a search
   *   @param standardize Standardize numeric columns to have zero mean and unit variance
   *   @param missing_values_handling Handling of missing values. Either Skip or MeanImputation.
   *   @param non_negative Restrict coefficients (not intercept) to be non-negative
   *   @param max_iterations Maximum number of iterations
   *   @param beta_epsilon converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to
   *                       IRLSM solver
   *   @param objective_epsilon converge if  objective value changes less than this
   *   @param gradient_epsilon converge if  objective changes less (using L-infinity norm) than this, ONLY applies to
   *                           L-BFGS solver
   *   @param obj_reg likelihood divider in objective value computation, default is 1/nobs
   *   @param link 
   *   @param intercept include constant term in the model
   *   @param prior prior probability for y==1. To be used only for logistic regression iff the data has been sampled
   *                and the mean of response does not reflect reality.
   *   @param lambda_min_ratio min lambda used in lambda search, specified as a ratio of lambda_max
   *   @param beta_constraints beta constraints
   *   @param max_active_predictors Maximum number of active predictors during computation. Use as a stopping criterium
   *                                to prevent expensive model building with many predictors.
   *   @param interactions A list of predictor column indices to interact. All pairwise combinations will be computed
   *                       for the list.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param compute_p_values request p-values computation, p-values work only with IRLSM solver and no regularization
   *   @param remove_collinear_columns in case of linearly dependent columns remove some of the dependent columns
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/glm/parameters")
  Call<GLMV3> validate_parametersGlm(
    @Field("seed") long seed,
    @Field("family") GLMFamily family,
    @Field("tweedie_variance_power") double tweedie_variance_power,
    @Field("tweedie_link_power") double tweedie_link_power,
    @Field("solver") GLMSolver solver,
    @Field("alpha") double[] alpha,
    @Field("lambda") double[] lambda,
    @Field("lambda_search") boolean lambda_search,
    @Field("early_stopping") boolean early_stopping,
    @Field("nlambdas") int nlambdas,
    @Field("standardize") boolean standardize,
    @Field("missing_values_handling") DeepLearningMissingValuesHandling missing_values_handling,
    @Field("non_negative") boolean non_negative,
    @Field("max_iterations") int max_iterations,
    @Field("beta_epsilon") double beta_epsilon,
    @Field("objective_epsilon") double objective_epsilon,
    @Field("gradient_epsilon") double gradient_epsilon,
    @Field("obj_reg") double obj_reg,
    @Field("link") GLMLink link,
    @Field("intercept") boolean intercept,
    @Field("prior") double prior,
    @Field("lambda_min_ratio") double lambda_min_ratio,
    @Field("beta_constraints") String beta_constraints,
    @Field("max_active_predictors") int max_active_predictors,
    @Field("interactions") String[] interactions,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("compute_p_values") boolean compute_p_values,
    @Field("remove_collinear_columns") boolean remove_collinear_columns,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/glm/parameters")
  Call<GLMV3> validate_parametersGlm();

  /** 
   * Train a GLRM model.
   *   @param transform Transformation of training data
   *   @param k Rank of matrix approximation
   *   @param loss Numeric loss function
   *   @param multi_loss Categorical loss function
   *   @param loss_by_col Loss function by column (override)
   *   @param loss_by_col_idx Loss function by column index (override)
   *   @param period Length of period (only used with periodic loss function)
   *   @param regularization_x Regularization function for X matrix
   *   @param regularization_y Regularization function for Y matrix
   *   @param gamma_x Regularization weight on X matrix
   *   @param gamma_y Regularization weight on Y matrix
   *   @param max_iterations Maximum number of iterations
   *   @param max_updates Maximum number of updates
   *   @param init_step_size Initial step size
   *   @param min_step_size Minimum step size
   *   @param seed RNG seed for initialization
   *   @param init Initialization mode
   *   @param svd_method Method for computing SVD during initialization (Caution: Power and Randomized are currently
   *                     experimental and unstable)
   *   @param user_y User-specified initial Y
   *   @param user_x User-specified initial X
   *   @param loading_name Frame key to save resulting X
   *   @param expand_user_y Expand categorical columns in user-specified initial Y
   *   @param impute_original Reconstruct original training data by reversing transform
   *   @param recover_svd Recover singular values and eigenvectors of XY
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/glrm")
  Call<GLRMV3> trainGlrm(
    @Field("transform") DataInfoTransformType transform,
    @Field("k") int k,
    @Field("loss") GLRMLoss loss,
    @Field("multi_loss") GLRMLoss multi_loss,
    @Field("loss_by_col") GLRMLoss[] loss_by_col,
    @Field("loss_by_col_idx") int[] loss_by_col_idx,
    @Field("period") int period,
    @Field("regularization_x") GLRMRegularizer regularization_x,
    @Field("regularization_y") GLRMRegularizer regularization_y,
    @Field("gamma_x") double gamma_x,
    @Field("gamma_y") double gamma_y,
    @Field("max_iterations") int max_iterations,
    @Field("max_updates") int max_updates,
    @Field("init_step_size") double init_step_size,
    @Field("min_step_size") double min_step_size,
    @Field("seed") long seed,
    @Field("init") GLRMInitialization init,
    @Field("svd_method") SVDMethod svd_method,
    @Field("user_y") String user_y,
    @Field("user_x") String user_x,
    @Field("loading_name") String loading_name,
    @Field("expand_user_y") boolean expand_user_y,
    @Field("impute_original") boolean impute_original,
    @Field("recover_svd") boolean recover_svd,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/glrm")
  Call<GLRMV3> trainGlrm(@Field("k") int k);

  /** 
   * Validate a set of GLRM model builder parameters.
   *   @param transform Transformation of training data
   *   @param k Rank of matrix approximation
   *   @param loss Numeric loss function
   *   @param multi_loss Categorical loss function
   *   @param loss_by_col Loss function by column (override)
   *   @param loss_by_col_idx Loss function by column index (override)
   *   @param period Length of period (only used with periodic loss function)
   *   @param regularization_x Regularization function for X matrix
   *   @param regularization_y Regularization function for Y matrix
   *   @param gamma_x Regularization weight on X matrix
   *   @param gamma_y Regularization weight on Y matrix
   *   @param max_iterations Maximum number of iterations
   *   @param max_updates Maximum number of updates
   *   @param init_step_size Initial step size
   *   @param min_step_size Minimum step size
   *   @param seed RNG seed for initialization
   *   @param init Initialization mode
   *   @param svd_method Method for computing SVD during initialization (Caution: Power and Randomized are currently
   *                     experimental and unstable)
   *   @param user_y User-specified initial Y
   *   @param user_x User-specified initial X
   *   @param loading_name Frame key to save resulting X
   *   @param expand_user_y Expand categorical columns in user-specified initial Y
   *   @param impute_original Reconstruct original training data by reversing transform
   *   @param recover_svd Recover singular values and eigenvectors of XY
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/glrm/parameters")
  Call<GLRMV3> validate_parametersGlrm(
    @Field("transform") DataInfoTransformType transform,
    @Field("k") int k,
    @Field("loss") GLRMLoss loss,
    @Field("multi_loss") GLRMLoss multi_loss,
    @Field("loss_by_col") GLRMLoss[] loss_by_col,
    @Field("loss_by_col_idx") int[] loss_by_col_idx,
    @Field("period") int period,
    @Field("regularization_x") GLRMRegularizer regularization_x,
    @Field("regularization_y") GLRMRegularizer regularization_y,
    @Field("gamma_x") double gamma_x,
    @Field("gamma_y") double gamma_y,
    @Field("max_iterations") int max_iterations,
    @Field("max_updates") int max_updates,
    @Field("init_step_size") double init_step_size,
    @Field("min_step_size") double min_step_size,
    @Field("seed") long seed,
    @Field("init") GLRMInitialization init,
    @Field("svd_method") SVDMethod svd_method,
    @Field("user_y") String user_y,
    @Field("user_x") String user_x,
    @Field("loading_name") String loading_name,
    @Field("expand_user_y") boolean expand_user_y,
    @Field("impute_original") boolean impute_original,
    @Field("recover_svd") boolean recover_svd,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/glrm/parameters")
  Call<GLRMV3> validate_parametersGlrm(@Field("k") int k);

  /** 
   * Train a KMeans model.
   *   @param user_points User-specified points
   *   @param max_iterations Maximum training iterations
   *   @param standardize Standardize columns
   *   @param seed RNG Seed
   *   @param init Initialization mode
   *   @param k Number of clusters
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/kmeans")
  Call<KMeansV3> trainKmeans(
    @Field("user_points") String user_points,
    @Field("max_iterations") int max_iterations,
    @Field("standardize") boolean standardize,
    @Field("seed") long seed,
    @Field("init") KMeansInitialization init,
    @Field("k") int k,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/kmeans")
  Call<KMeansV3> trainKmeans(@Field("k") int k);

  /** 
   * Validate a set of KMeans model builder parameters.
   *   @param user_points User-specified points
   *   @param max_iterations Maximum training iterations
   *   @param standardize Standardize columns
   *   @param seed RNG Seed
   *   @param init Initialization mode
   *   @param k Number of clusters
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/kmeans/parameters")
  Call<KMeansV3> validate_parametersKmeans(
    @Field("user_points") String user_points,
    @Field("max_iterations") int max_iterations,
    @Field("standardize") boolean standardize,
    @Field("seed") long seed,
    @Field("init") KMeansInitialization init,
    @Field("k") int k,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/kmeans/parameters")
  Call<KMeansV3> validate_parametersKmeans(@Field("k") int k);

  /** 
   * Train a NaiveBayes model.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param laplace Laplace smoothing parameter
   *   @param min_sdev Min. standard deviation to use for observations with not enough data
   *   @param eps_sdev Cutoff below which standard deviation is replaced with min_sdev
   *   @param min_prob Min. probability to use for observations with not enough data
   *   @param eps_prob Cutoff below which probability is replaced with min_prob
   *   @param compute_metrics Compute metrics on training data
   *   @param seed Seed for pseudo random number generator (only used for cross-validation and fold_assignment="Random"
   *               or "AUTO")
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/naivebayes")
  Call<NaiveBayesV3> trainNaivebayes(
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("laplace") double laplace,
    @Field("min_sdev") double min_sdev,
    @Field("eps_sdev") double eps_sdev,
    @Field("min_prob") double min_prob,
    @Field("eps_prob") double eps_prob,
    @Field("compute_metrics") boolean compute_metrics,
    @Field("seed") long seed,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/naivebayes")
  Call<NaiveBayesV3> trainNaivebayes();

  /** 
   * Validate a set of NaiveBayes model builder parameters.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param laplace Laplace smoothing parameter
   *   @param min_sdev Min. standard deviation to use for observations with not enough data
   *   @param eps_sdev Cutoff below which standard deviation is replaced with min_sdev
   *   @param min_prob Min. probability to use for observations with not enough data
   *   @param eps_prob Cutoff below which probability is replaced with min_prob
   *   @param compute_metrics Compute metrics on training data
   *   @param seed Seed for pseudo random number generator (only used for cross-validation and fold_assignment="Random"
   *               or "AUTO")
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/naivebayes/parameters")
  Call<NaiveBayesV3> validate_parametersNaivebayes(
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("laplace") double laplace,
    @Field("min_sdev") double min_sdev,
    @Field("eps_sdev") double eps_sdev,
    @Field("min_prob") double min_prob,
    @Field("eps_prob") double eps_prob,
    @Field("compute_metrics") boolean compute_metrics,
    @Field("seed") long seed,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/naivebayes/parameters")
  Call<NaiveBayesV3> validate_parametersNaivebayes();

  /** 
   * Train a PCA model.
   *   @param transform Transformation of training data
   *   @param pca_method Method for computing PCA (Caution: Power and GLRM are currently experimental and unstable)
   *   @param k Rank of matrix approximation
   *   @param max_iterations Maximum training iterations
   *   @param seed RNG seed for initialization
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param compute_metrics Whether to compute metrics on the training data
   *   @param impute_missing Whether to impute missing entries with the column mean
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/pca")
  Call<PCAV3> trainPca(
    @Field("transform") DataInfoTransformType transform,
    @Field("pca_method") PCAMethod pca_method,
    @Field("k") int k,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("compute_metrics") boolean compute_metrics,
    @Field("impute_missing") boolean impute_missing,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/pca")
  Call<PCAV3> trainPca(@Field("k") int k);

  /** 
   * Validate a set of PCA model builder parameters.
   *   @param transform Transformation of training data
   *   @param pca_method Method for computing PCA (Caution: Power and GLRM are currently experimental and unstable)
   *   @param k Rank of matrix approximation
   *   @param max_iterations Maximum training iterations
   *   @param seed RNG seed for initialization
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param compute_metrics Whether to compute metrics on the training data
   *   @param impute_missing Whether to impute missing entries with the column mean
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/pca/parameters")
  Call<PCAV3> validate_parametersPca(
    @Field("transform") DataInfoTransformType transform,
    @Field("pca_method") PCAMethod pca_method,
    @Field("k") int k,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("compute_metrics") boolean compute_metrics,
    @Field("impute_missing") boolean impute_missing,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/pca/parameters")
  Call<PCAV3> validate_parametersPca(@Field("k") int k);

  /** 
   * Train a SVD model.
   *   @param transform Transformation of training data
   *   @param svd_method Method for computing SVD (Caution: Power and Randomized are currently experimental and
   *                     unstable)
   *   @param nv Number of right singular vectors
   *   @param max_iterations Maximum iterations
   *   @param seed RNG seed for k-means++ initialization
   *   @param keep_u Save left singular vectors?
   *   @param u_name Frame key to save left singular vectors
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/99/ModelBuilders/svd")
  Call<SVDV99> trainSvd(
    @Field("transform") DataInfoTransformType transform,
    @Field("svd_method") SVDMethod svd_method,
    @Field("nv") int nv,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("keep_u") boolean keep_u,
    @Field("u_name") String u_name,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/99/ModelBuilders/svd")
  Call<SVDV99> trainSvd();

  /** 
   * Validate a set of SVD model builder parameters.
   *   @param transform Transformation of training data
   *   @param svd_method Method for computing SVD (Caution: Power and Randomized are currently experimental and
   *                     unstable)
   *   @param nv Number of right singular vectors
   *   @param max_iterations Maximum iterations
   *   @param seed RNG seed for k-means++ initialization
   *   @param keep_u Save left singular vectors?
   *   @param u_name Frame key to save left singular vectors
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/99/ModelBuilders/svd/parameters")
  Call<SVDV99> validate_parametersSvd(
    @Field("transform") DataInfoTransformType transform,
    @Field("svd_method") SVDMethod svd_method,
    @Field("nv") int nv,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("keep_u") boolean keep_u,
    @Field("u_name") String u_name,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/99/ModelBuilders/svd/parameters")
  Call<SVDV99> validate_parametersSvd();

  /** 
   * Train a DRF model.
   *   @param mtries Number of variables randomly sampled as candidates at each split. If set to -1, defaults to sqrt{p}
   *                 for classification and p/3 for regression (where p is the # of predictors
   *   @param binomial_double_trees For binary classification: Build 2x as many trees (one per class) - can lead to
   *                                higher accuracy.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param ntrees Number of trees.
   *   @param max_depth Maximum tree depth.
   *   @param min_rows Fewest allowed (weighted) observations in a leaf (in R called 'nodesize').
   *   @param nbins For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the
   *                best point
   *   @param nbins_top_level For numerical columns (real/int), build a histogram of (at most) this many bins at the
   *                          root level, then decrease by factor of two per level
   *   @param nbins_cats For categorical columns (factors), build a histogram of this many bins, then split at the best
   *                     point. Higher values can lead to more overfitting.
   *   @param r2_stopping Stop making trees when the R^2 metric equals or exceeds this
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param build_tree_one_node Run on one node only; no network overhead but fewer cpus used.  Suitable for small
   *                              datasets.
   *   @param sample_rate Row sample rate per tree (from 0.0 to 1.0)
   *   @param sample_rate_per_class Row sample rate per tree per class (from 0.0 to 1.0)
   *   @param col_sample_rate_per_tree Column sample rate per tree (from 0.0 to 1.0)
   *   @param col_sample_rate_change_per_level Relative change of the column sampling rate for every level (from 0.0 to
   *                                           2.0)
   *   @param score_tree_interval Score the model after every so many trees. Disabled if set to 0.
   *   @param min_split_improvement Minimum relative improvement in squared error reduction for a split to happen
   *   @param histogram_type What type of histogram to use for finding optimal split points
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/drf")
  Call<DRFV3> trainDrf(
    @Field("mtries") int mtries,
    @Field("binomial_double_trees") boolean binomial_double_trees,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("ntrees") int ntrees,
    @Field("max_depth") int max_depth,
    @Field("min_rows") double min_rows,
    @Field("nbins") int nbins,
    @Field("nbins_top_level") int nbins_top_level,
    @Field("nbins_cats") int nbins_cats,
    @Field("r2_stopping") double r2_stopping,
    @Field("seed") long seed,
    @Field("build_tree_one_node") boolean build_tree_one_node,
    @Field("sample_rate") double sample_rate,
    @Field("sample_rate_per_class") double[] sample_rate_per_class,
    @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
    @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
    @Field("score_tree_interval") int score_tree_interval,
    @Field("min_split_improvement") double min_split_improvement,
    @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/drf")
  Call<DRFV3> trainDrf();

  /** 
   * Validate a set of DRF model builder parameters.
   *   @param mtries Number of variables randomly sampled as candidates at each split. If set to -1, defaults to sqrt{p}
   *                 for classification and p/3 for regression (where p is the # of predictors
   *   @param binomial_double_trees For binary classification: Build 2x as many trees (one per class) - can lead to
   *                                higher accuracy.
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param ntrees Number of trees.
   *   @param max_depth Maximum tree depth.
   *   @param min_rows Fewest allowed (weighted) observations in a leaf (in R called 'nodesize').
   *   @param nbins For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the
   *                best point
   *   @param nbins_top_level For numerical columns (real/int), build a histogram of (at most) this many bins at the
   *                          root level, then decrease by factor of two per level
   *   @param nbins_cats For categorical columns (factors), build a histogram of this many bins, then split at the best
   *                     point. Higher values can lead to more overfitting.
   *   @param r2_stopping Stop making trees when the R^2 metric equals or exceeds this
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param build_tree_one_node Run on one node only; no network overhead but fewer cpus used.  Suitable for small
   *                              datasets.
   *   @param sample_rate Row sample rate per tree (from 0.0 to 1.0)
   *   @param sample_rate_per_class Row sample rate per tree per class (from 0.0 to 1.0)
   *   @param col_sample_rate_per_tree Column sample rate per tree (from 0.0 to 1.0)
   *   @param col_sample_rate_change_per_level Relative change of the column sampling rate for every level (from 0.0 to
   *                                           2.0)
   *   @param score_tree_interval Score the model after every so many trees. Disabled if set to 0.
   *   @param min_split_improvement Minimum relative improvement in squared error reduction for a split to happen
   *   @param histogram_type What type of histogram to use for finding optimal split points
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/drf/parameters")
  Call<DRFV3> validate_parametersDrf(
    @Field("mtries") int mtries,
    @Field("binomial_double_trees") boolean binomial_double_trees,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("ntrees") int ntrees,
    @Field("max_depth") int max_depth,
    @Field("min_rows") double min_rows,
    @Field("nbins") int nbins,
    @Field("nbins_top_level") int nbins_top_level,
    @Field("nbins_cats") int nbins_cats,
    @Field("r2_stopping") double r2_stopping,
    @Field("seed") long seed,
    @Field("build_tree_one_node") boolean build_tree_one_node,
    @Field("sample_rate") double sample_rate,
    @Field("sample_rate_per_class") double[] sample_rate_per_class,
    @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
    @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
    @Field("score_tree_interval") int score_tree_interval,
    @Field("min_split_improvement") double min_split_improvement,
    @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/drf/parameters")
  Call<DRFV3> validate_parametersDrf();

  /** 
   * Train a GBM model.
   *   @param learn_rate Learning rate (from 0.0 to 1.0)
   *   @param learn_rate_annealing Scale the learning rate by this factor after each tree (e.g., 0.99 or 0.999)
   *   @param distribution Distribution function
   *   @param quantile_alpha Desired quantile for quantile regression (from 0.0 to 1.0)
   *   @param tweedie_power Tweedie Power (between 1 and 2)
   *   @param col_sample_rate Column sample rate (from 0.0 to 1.0)
   *   @param max_abs_leafnode_pred Maximum absolute value of a leaf node prediction
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param ntrees Number of trees.
   *   @param max_depth Maximum tree depth.
   *   @param min_rows Fewest allowed (weighted) observations in a leaf (in R called 'nodesize').
   *   @param nbins For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the
   *                best point
   *   @param nbins_top_level For numerical columns (real/int), build a histogram of (at most) this many bins at the
   *                          root level, then decrease by factor of two per level
   *   @param nbins_cats For categorical columns (factors), build a histogram of this many bins, then split at the best
   *                     point. Higher values can lead to more overfitting.
   *   @param r2_stopping Stop making trees when the R^2 metric equals or exceeds this
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param build_tree_one_node Run on one node only; no network overhead but fewer cpus used.  Suitable for small
   *                              datasets.
   *   @param sample_rate Row sample rate per tree (from 0.0 to 1.0)
   *   @param sample_rate_per_class Row sample rate per tree per class (from 0.0 to 1.0)
   *   @param col_sample_rate_per_tree Column sample rate per tree (from 0.0 to 1.0)
   *   @param col_sample_rate_change_per_level Relative change of the column sampling rate for every level (from 0.0 to
   *                                           2.0)
   *   @param score_tree_interval Score the model after every so many trees. Disabled if set to 0.
   *   @param min_split_improvement Minimum relative improvement in squared error reduction for a split to happen
   *   @param histogram_type What type of histogram to use for finding optimal split points
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/gbm")
  Call<GBMV3> trainGbm(
    @Field("learn_rate") double learn_rate,
    @Field("learn_rate_annealing") double learn_rate_annealing,
    @Field("distribution") DistributionFamily distribution,
    @Field("quantile_alpha") double quantile_alpha,
    @Field("tweedie_power") double tweedie_power,
    @Field("col_sample_rate") double col_sample_rate,
    @Field("max_abs_leafnode_pred") double max_abs_leafnode_pred,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("ntrees") int ntrees,
    @Field("max_depth") int max_depth,
    @Field("min_rows") double min_rows,
    @Field("nbins") int nbins,
    @Field("nbins_top_level") int nbins_top_level,
    @Field("nbins_cats") int nbins_cats,
    @Field("r2_stopping") double r2_stopping,
    @Field("seed") long seed,
    @Field("build_tree_one_node") boolean build_tree_one_node,
    @Field("sample_rate") double sample_rate,
    @Field("sample_rate_per_class") double[] sample_rate_per_class,
    @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
    @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
    @Field("score_tree_interval") int score_tree_interval,
    @Field("min_split_improvement") double min_split_improvement,
    @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/gbm")
  Call<GBMV3> trainGbm();

  /** 
   * Validate a set of GBM model builder parameters.
   *   @param learn_rate Learning rate (from 0.0 to 1.0)
   *   @param learn_rate_annealing Scale the learning rate by this factor after each tree (e.g., 0.99 or 0.999)
   *   @param distribution Distribution function
   *   @param quantile_alpha Desired quantile for quantile regression (from 0.0 to 1.0)
   *   @param tweedie_power Tweedie Power (between 1 and 2)
   *   @param col_sample_rate Column sample rate (from 0.0 to 1.0)
   *   @param max_abs_leafnode_pred Maximum absolute value of a leaf node prediction
   *   @param balance_classes Balance training data class counts via over/under-sampling (for imbalanced data).
   *   @param class_sampling_factors Desired over/under-sampling ratios per class (in lexicographic order). If not
   *                                 specified, sampling factors will be automatically computed to obtain class balance
   *                                 during training. Requires balance_classes.
   *   @param max_after_balance_size Maximum relative size of the training data after balancing class counts (can be
   *                                 less than 1.0). Requires balance_classes.
   *   @param max_confusion_matrix_size Maximum size (# classes) for confusion matrices to be printed in the Logs
   *   @param max_hit_ratio_k Max. number (top K) of predictions to use for hit ratio computation (for multi-class only,
   *                          0 to disable)
   *   @param ntrees Number of trees.
   *   @param max_depth Maximum tree depth.
   *   @param min_rows Fewest allowed (weighted) observations in a leaf (in R called 'nodesize').
   *   @param nbins For numerical columns (real/int), build a histogram of (at least) this many bins, then split at the
   *                best point
   *   @param nbins_top_level For numerical columns (real/int), build a histogram of (at most) this many bins at the
   *                          root level, then decrease by factor of two per level
   *   @param nbins_cats For categorical columns (factors), build a histogram of this many bins, then split at the best
   *                     point. Higher values can lead to more overfitting.
   *   @param r2_stopping Stop making trees when the R^2 metric equals or exceeds this
   *   @param seed Seed for pseudo random number generator (if applicable)
   *   @param build_tree_one_node Run on one node only; no network overhead but fewer cpus used.  Suitable for small
   *                              datasets.
   *   @param sample_rate Row sample rate per tree (from 0.0 to 1.0)
   *   @param sample_rate_per_class Row sample rate per tree per class (from 0.0 to 1.0)
   *   @param col_sample_rate_per_tree Column sample rate per tree (from 0.0 to 1.0)
   *   @param col_sample_rate_change_per_level Relative change of the column sampling rate for every level (from 0.0 to
   *                                           2.0)
   *   @param score_tree_interval Score the model after every so many trees. Disabled if set to 0.
   *   @param min_split_improvement Minimum relative improvement in squared error reduction for a split to happen
   *   @param histogram_type What type of histogram to use for finding optimal split points
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/3/ModelBuilders/gbm/parameters")
  Call<GBMV3> validate_parametersGbm(
    @Field("learn_rate") double learn_rate,
    @Field("learn_rate_annealing") double learn_rate_annealing,
    @Field("distribution") DistributionFamily distribution,
    @Field("quantile_alpha") double quantile_alpha,
    @Field("tweedie_power") double tweedie_power,
    @Field("col_sample_rate") double col_sample_rate,
    @Field("max_abs_leafnode_pred") double max_abs_leafnode_pred,
    @Field("balance_classes") boolean balance_classes,
    @Field("class_sampling_factors") float[] class_sampling_factors,
    @Field("max_after_balance_size") float max_after_balance_size,
    @Field("max_confusion_matrix_size") int max_confusion_matrix_size,
    @Field("max_hit_ratio_k") int max_hit_ratio_k,
    @Field("ntrees") int ntrees,
    @Field("max_depth") int max_depth,
    @Field("min_rows") double min_rows,
    @Field("nbins") int nbins,
    @Field("nbins_top_level") int nbins_top_level,
    @Field("nbins_cats") int nbins_cats,
    @Field("r2_stopping") double r2_stopping,
    @Field("seed") long seed,
    @Field("build_tree_one_node") boolean build_tree_one_node,
    @Field("sample_rate") double sample_rate,
    @Field("sample_rate_per_class") double[] sample_rate_per_class,
    @Field("col_sample_rate_per_tree") double col_sample_rate_per_tree,
    @Field("col_sample_rate_change_per_level") double col_sample_rate_change_per_level,
    @Field("score_tree_interval") int score_tree_interval,
    @Field("min_split_improvement") double min_split_improvement,
    @Field("histogram_type") TreeSharedTreeModelSharedTreeParametersHistogramType histogram_type,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/3/ModelBuilders/gbm/parameters")
  Call<GBMV3> validate_parametersGbm();

  /** 
   * Train a Aggregator model.
   *   @param radius_scale Radius scaling
   *   @param transform Transformation of training data
   *   @param pca_method Method for computing PCA (Caution: Power and GLRM are currently experimental and unstable)
   *   @param k Rank of matrix approximation
   *   @param max_iterations Maximum number of iterations for PCA
   *   @param seed RNG seed for initialization
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/99/ModelBuilders/aggregator")
  Call<AggregatorV99> trainAggregator(
    @Field("radius_scale") double radius_scale,
    @Field("transform") DataInfoTransformType transform,
    @Field("pca_method") PCAMethod pca_method,
    @Field("k") int k,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/99/ModelBuilders/aggregator")
  Call<AggregatorV99> trainAggregator();

  /** 
   * Validate a set of Aggregator model builder parameters.
   *   @param radius_scale Radius scaling
   *   @param transform Transformation of training data
   *   @param pca_method Method for computing PCA (Caution: Power and GLRM are currently experimental and unstable)
   *   @param k Rank of matrix approximation
   *   @param max_iterations Maximum number of iterations for PCA
   *   @param seed RNG seed for initialization
   *   @param use_all_factor_levels Whether first factor level is included in each categorical expansion
   *   @param model_id Destination id for this model; auto-generated if not specified.
   *   @param training_frame Id of the training data frame (Not required, to allow initial validation of model
   *                         parameters).
   *   @param validation_frame Id of the validation data frame.
   *   @param nfolds Number of folds for N-fold cross-validation (0 to disable or ≥ 2).
   *   @param keep_cross_validation_predictions Whether to keep the predictions of the cross-validation models.
   *   @param keep_cross_validation_fold_assignment Whether to keep the cross-validation fold assignment.
   *   @param parallelize_cross_validation Allow parallel training of cross-validation models
   *   @param response_column Response variable column.
   *   @param weights_column Column with observation weights. Giving some observation a weight of zero is equivalent to
   *                         excluding it from the dataset; giving an observation a relative weight of 2 is equivalent
   *                         to repeating that row twice. Negative weights are not allowed.
   *   @param offset_column Offset column. This will be added to the combination of columns before applying the link
   *                        function.
   *   @param fold_column Column with cross-validation fold index assignment per observation.
   *   @param fold_assignment Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified'
   *                          option will stratify the folds based on the response variable, for classification
   *                          problems.
   *   @param ignored_columns Names of columns to ignore for training.
   *   @param ignore_const_cols Ignore constant columns.
   *   @param score_each_iteration Whether to score during each iteration of model training.
   *   @param checkpoint Model checkpoint to resume training with.
   *   @param stopping_rounds Early stopping based on convergence of stopping_metric. Stop if simple moving average of
   *                          length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0
   *                          to disable)
   *   @param max_runtime_secs Maximum allowed runtime in seconds for model training. Use 0 to disable.
   *   @param stopping_metric Metric to use for early stopping (AUTO: logloss for classification, deviance for
   *                          regression)
   *   @param stopping_tolerance Relative tolerance for metric-based stopping criterion (stop if relative improvement is
   *                             not at least this much)
   *   @param _exclude_fields Comma-separated list of JSON field paths to exclude from the result, used like:
   *                          "/3/Frames?_exclude_fields=frames/frame_id/URL,__meta"
   */
  @FormUrlEncoded
  @POST("/99/ModelBuilders/aggregator/parameters")
  Call<AggregatorV99> validate_parametersAggregator(
    @Field("radius_scale") double radius_scale,
    @Field("transform") DataInfoTransformType transform,
    @Field("pca_method") PCAMethod pca_method,
    @Field("k") int k,
    @Field("max_iterations") int max_iterations,
    @Field("seed") long seed,
    @Field("use_all_factor_levels") boolean use_all_factor_levels,
    @Field("model_id") String model_id,
    @Field("training_frame") String training_frame,
    @Field("validation_frame") String validation_frame,
    @Field("nfolds") int nfolds,
    @Field("keep_cross_validation_predictions") boolean keep_cross_validation_predictions,
    @Field("keep_cross_validation_fold_assignment") boolean keep_cross_validation_fold_assignment,
    @Field("parallelize_cross_validation") boolean parallelize_cross_validation,
    @Field("response_column") String response_column,
    @Field("weights_column") String weights_column,
    @Field("offset_column") String offset_column,
    @Field("fold_column") String fold_column,
    @Field("fold_assignment") ModelParametersFoldAssignmentScheme fold_assignment,
    @Field("ignored_columns") String[] ignored_columns,
    @Field("ignore_const_cols") boolean ignore_const_cols,
    @Field("score_each_iteration") boolean score_each_iteration,
    @Field("checkpoint") String checkpoint,
    @Field("stopping_rounds") int stopping_rounds,
    @Field("max_runtime_secs") double max_runtime_secs,
    @Field("stopping_metric") ScoreKeeperStoppingMetric stopping_metric,
    @Field("stopping_tolerance") double stopping_tolerance,
    @Field("_exclude_fields") String _exclude_fields
  );

  @FormUrlEncoded
  @POST("/99/ModelBuilders/aggregator/parameters")
  Call<AggregatorV99> validate_parametersAggregator();


  class Helper {
    /**
     * Train a DeepLearning model.
     */
    public static Call<DeepLearningV3> trainDeeplearning(ModelBuilders z, DeepLearningParametersV3 p) {
      return z.trainDeeplearning(
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.activation,
        p.hidden,
        p.epochs,
        p.trainSamplesPerIteration,
        p.targetRatioCommToComp,
        p.seed,
        p.adaptiveRate,
        p.rho,
        p.epsilon,
        p.rate,
        p.rateAnnealing,
        p.rateDecay,
        p.momentumStart,
        p.momentumRamp,
        p.momentumStable,
        p.nesterovAcceleratedGradient,
        p.inputDropoutRatio,
        p.hiddenDropoutRatios,
        p.l1,
        p.l2,
        p.maxW2,
        p.initialWeightDistribution,
        p.initialWeightScale,
        (p.initialWeights == null? null : keyArrayToStringArray(p.initialWeights)),
        (p.initialBiases == null? null : keyArrayToStringArray(p.initialBiases)),
        p.loss,
        p.distribution,
        p.tweediePower,
        p.quantileAlpha,
        p.scoreInterval,
        p.scoreTrainingSamples,
        p.scoreValidationSamples,
        p.scoreDutyCycle,
        p.classificationStop,
        p.regressionStop,
        p.quietMode,
        p.scoreValidationSampling,
        p.overwriteWithBestModel,
        p.autoencoder,
        p.useAllFactorLevels,
        p.standardize,
        p.diagnostics,
        p.variableImportances,
        p.fastMode,
        p.forceLoadBalance,
        p.replicateTrainingData,
        p.singleNodeMode,
        p.shuffleTrainingData,
        p.missingValuesHandling,
        p.sparse,
        p.colMajor,
        p.averageActivation,
        p.sparsityBeta,
        p.maxCategoricalFeatures,
        p.reproducible,
        p.exportWeightsAndBiases,
        p.miniBatchSize,
        p.elasticAveraging,
        p.elasticAveragingMovingRate,
        p.elasticAveragingRegularization,
        (p.pretrainedAutoencoder == null? null : p.pretrainedAutoencoder.name),
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of DeepLearning model builder parameters.
     */
    public static Call<DeepLearningV3> validate_parametersDeeplearning(ModelBuilders z, DeepLearningParametersV3 p) {
      return z.validate_parametersDeeplearning(
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.activation,
        p.hidden,
        p.epochs,
        p.trainSamplesPerIteration,
        p.targetRatioCommToComp,
        p.seed,
        p.adaptiveRate,
        p.rho,
        p.epsilon,
        p.rate,
        p.rateAnnealing,
        p.rateDecay,
        p.momentumStart,
        p.momentumRamp,
        p.momentumStable,
        p.nesterovAcceleratedGradient,
        p.inputDropoutRatio,
        p.hiddenDropoutRatios,
        p.l1,
        p.l2,
        p.maxW2,
        p.initialWeightDistribution,
        p.initialWeightScale,
        (p.initialWeights == null? null : keyArrayToStringArray(p.initialWeights)),
        (p.initialBiases == null? null : keyArrayToStringArray(p.initialBiases)),
        p.loss,
        p.distribution,
        p.tweediePower,
        p.quantileAlpha,
        p.scoreInterval,
        p.scoreTrainingSamples,
        p.scoreValidationSamples,
        p.scoreDutyCycle,
        p.classificationStop,
        p.regressionStop,
        p.quietMode,
        p.scoreValidationSampling,
        p.overwriteWithBestModel,
        p.autoencoder,
        p.useAllFactorLevels,
        p.standardize,
        p.diagnostics,
        p.variableImportances,
        p.fastMode,
        p.forceLoadBalance,
        p.replicateTrainingData,
        p.singleNodeMode,
        p.shuffleTrainingData,
        p.missingValuesHandling,
        p.sparse,
        p.colMajor,
        p.averageActivation,
        p.sparsityBeta,
        p.maxCategoricalFeatures,
        p.reproducible,
        p.exportWeightsAndBiases,
        p.miniBatchSize,
        p.elasticAveraging,
        p.elasticAveragingMovingRate,
        p.elasticAveragingRegularization,
        (p.pretrainedAutoencoder == null? null : p.pretrainedAutoencoder.name),
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a GLM model.
     */
    public static Call<GLMV3> trainGlm(ModelBuilders z, GLMParametersV3 p) {
      return z.trainGlm(
        p.seed,
        p.family,
        p.tweedieVariancePower,
        p.tweedieLinkPower,
        p.solver,
        p.alpha,
        p.lambda,
        p.lambdaSearch,
        p.earlyStopping,
        p.nlambdas,
        p.standardize,
        p.missingValuesHandling,
        p.nonNegative,
        p.maxIterations,
        p.betaEpsilon,
        p.objectiveEpsilon,
        p.gradientEpsilon,
        p.objReg,
        p.link,
        p.intercept,
        p.prior,
        p.lambdaMinRatio,
        (p.betaConstraints == null? null : p.betaConstraints.name),
        p.maxActivePredictors,
        p.interactions,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.computePValues,
        p.removeCollinearColumns,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of GLM model builder parameters.
     */
    public static Call<GLMV3> validate_parametersGlm(ModelBuilders z, GLMParametersV3 p) {
      return z.validate_parametersGlm(
        p.seed,
        p.family,
        p.tweedieVariancePower,
        p.tweedieLinkPower,
        p.solver,
        p.alpha,
        p.lambda,
        p.lambdaSearch,
        p.earlyStopping,
        p.nlambdas,
        p.standardize,
        p.missingValuesHandling,
        p.nonNegative,
        p.maxIterations,
        p.betaEpsilon,
        p.objectiveEpsilon,
        p.gradientEpsilon,
        p.objReg,
        p.link,
        p.intercept,
        p.prior,
        p.lambdaMinRatio,
        (p.betaConstraints == null? null : p.betaConstraints.name),
        p.maxActivePredictors,
        p.interactions,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.computePValues,
        p.removeCollinearColumns,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a GLRM model.
     */
    public static Call<GLRMV3> trainGlrm(ModelBuilders z, GLRMParametersV3 p) {
      return z.trainGlrm(
        p.transform,
        p.k,
        p.loss,
        p.multiLoss,
        p.lossByCol,
        p.lossByColIdx,
        p.period,
        p.regularizationX,
        p.regularizationY,
        p.gammaX,
        p.gammaY,
        p.maxIterations,
        p.maxUpdates,
        p.initStepSize,
        p.minStepSize,
        p.seed,
        p.init,
        p.svdMethod,
        (p.userY == null? null : p.userY.name),
        (p.userX == null? null : p.userX.name),
        p.loadingName,
        p.expandUserY,
        p.imputeOriginal,
        p.recoverSvd,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of GLRM model builder parameters.
     */
    public static Call<GLRMV3> validate_parametersGlrm(ModelBuilders z, GLRMParametersV3 p) {
      return z.validate_parametersGlrm(
        p.transform,
        p.k,
        p.loss,
        p.multiLoss,
        p.lossByCol,
        p.lossByColIdx,
        p.period,
        p.regularizationX,
        p.regularizationY,
        p.gammaX,
        p.gammaY,
        p.maxIterations,
        p.maxUpdates,
        p.initStepSize,
        p.minStepSize,
        p.seed,
        p.init,
        p.svdMethod,
        (p.userY == null? null : p.userY.name),
        (p.userX == null? null : p.userX.name),
        p.loadingName,
        p.expandUserY,
        p.imputeOriginal,
        p.recoverSvd,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a KMeans model.
     */
    public static Call<KMeansV3> trainKmeans(ModelBuilders z, KMeansParametersV3 p) {
      return z.trainKmeans(
        (p.userPoints == null? null : p.userPoints.name),
        p.maxIterations,
        p.standardize,
        p.seed,
        p.init,
        p.k,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of KMeans model builder parameters.
     */
    public static Call<KMeansV3> validate_parametersKmeans(ModelBuilders z, KMeansParametersV3 p) {
      return z.validate_parametersKmeans(
        (p.userPoints == null? null : p.userPoints.name),
        p.maxIterations,
        p.standardize,
        p.seed,
        p.init,
        p.k,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a NaiveBayes model.
     */
    public static Call<NaiveBayesV3> trainNaivebayes(ModelBuilders z, NaiveBayesParametersV3 p) {
      return z.trainNaivebayes(
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.laplace,
        p.minSdev,
        p.epsSdev,
        p.minProb,
        p.epsProb,
        p.computeMetrics,
        p.seed,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of NaiveBayes model builder parameters.
     */
    public static Call<NaiveBayesV3> validate_parametersNaivebayes(ModelBuilders z, NaiveBayesParametersV3 p) {
      return z.validate_parametersNaivebayes(
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.laplace,
        p.minSdev,
        p.epsSdev,
        p.minProb,
        p.epsProb,
        p.computeMetrics,
        p.seed,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a PCA model.
     */
    public static Call<PCAV3> trainPca(ModelBuilders z, PCAParametersV3 p) {
      return z.trainPca(
        p.transform,
        p.pcaMethod,
        p.k,
        p.maxIterations,
        p.seed,
        p.useAllFactorLevels,
        p.computeMetrics,
        p.imputeMissing,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of PCA model builder parameters.
     */
    public static Call<PCAV3> validate_parametersPca(ModelBuilders z, PCAParametersV3 p) {
      return z.validate_parametersPca(
        p.transform,
        p.pcaMethod,
        p.k,
        p.maxIterations,
        p.seed,
        p.useAllFactorLevels,
        p.computeMetrics,
        p.imputeMissing,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a SVD model.
     */
    public static Call<SVDV99> trainSvd(ModelBuilders z, SVDParametersV99 p) {
      return z.trainSvd(
        p.transform,
        p.svdMethod,
        p.nv,
        p.maxIterations,
        p.seed,
        p.keepU,
        p.uName,
        p.useAllFactorLevels,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of SVD model builder parameters.
     */
    public static Call<SVDV99> validate_parametersSvd(ModelBuilders z, SVDParametersV99 p) {
      return z.validate_parametersSvd(
        p.transform,
        p.svdMethod,
        p.nv,
        p.maxIterations,
        p.seed,
        p.keepU,
        p.uName,
        p.useAllFactorLevels,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a DRF model.
     */
    public static Call<DRFV3> trainDrf(ModelBuilders z, DRFParametersV3 p) {
      return z.trainDrf(
        p.mtries,
        p.binomialDoubleTrees,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.ntrees,
        p.maxDepth,
        p.minRows,
        p.nbins,
        p.nbinsTopLevel,
        p.nbinsCats,
        p.r2Stopping,
        p.seed,
        p.buildTreeOneNode,
        p.sampleRate,
        p.sampleRatePerClass,
        p.colSampleRatePerTree,
        p.colSampleRateChangePerLevel,
        p.scoreTreeInterval,
        p.minSplitImprovement,
        p.histogramType,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of DRF model builder parameters.
     */
    public static Call<DRFV3> validate_parametersDrf(ModelBuilders z, DRFParametersV3 p) {
      return z.validate_parametersDrf(
        p.mtries,
        p.binomialDoubleTrees,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.ntrees,
        p.maxDepth,
        p.minRows,
        p.nbins,
        p.nbinsTopLevel,
        p.nbinsCats,
        p.r2Stopping,
        p.seed,
        p.buildTreeOneNode,
        p.sampleRate,
        p.sampleRatePerClass,
        p.colSampleRatePerTree,
        p.colSampleRateChangePerLevel,
        p.scoreTreeInterval,
        p.minSplitImprovement,
        p.histogramType,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a GBM model.
     */
    public static Call<GBMV3> trainGbm(ModelBuilders z, GBMParametersV3 p) {
      return z.trainGbm(
        p.learnRate,
        p.learnRateAnnealing,
        p.distribution,
        p.quantileAlpha,
        p.tweediePower,
        p.colSampleRate,
        p.maxAbsLeafnodePred,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.ntrees,
        p.maxDepth,
        p.minRows,
        p.nbins,
        p.nbinsTopLevel,
        p.nbinsCats,
        p.r2Stopping,
        p.seed,
        p.buildTreeOneNode,
        p.sampleRate,
        p.sampleRatePerClass,
        p.colSampleRatePerTree,
        p.colSampleRateChangePerLevel,
        p.scoreTreeInterval,
        p.minSplitImprovement,
        p.histogramType,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of GBM model builder parameters.
     */
    public static Call<GBMV3> validate_parametersGbm(ModelBuilders z, GBMParametersV3 p) {
      return z.validate_parametersGbm(
        p.learnRate,
        p.learnRateAnnealing,
        p.distribution,
        p.quantileAlpha,
        p.tweediePower,
        p.colSampleRate,
        p.maxAbsLeafnodePred,
        p.balanceClasses,
        p.classSamplingFactors,
        p.maxAfterBalanceSize,
        p.maxConfusionMatrixSize,
        p.maxHitRatioK,
        p.ntrees,
        p.maxDepth,
        p.minRows,
        p.nbins,
        p.nbinsTopLevel,
        p.nbinsCats,
        p.r2Stopping,
        p.seed,
        p.buildTreeOneNode,
        p.sampleRate,
        p.sampleRatePerClass,
        p.colSampleRatePerTree,
        p.colSampleRateChangePerLevel,
        p.scoreTreeInterval,
        p.minSplitImprovement,
        p.histogramType,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Train a Aggregator model.
     */
    public static Call<AggregatorV99> trainAggregator(ModelBuilders z, AggregatorParametersV99 p) {
      return z.trainAggregator(
        p.radiusScale,
        p.transform,
        p.pcaMethod,
        p.k,
        p.maxIterations,
        p.seed,
        p.useAllFactorLevels,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Validate a set of Aggregator model builder parameters.
     */
    public static Call<AggregatorV99> validate_parametersAggregator(ModelBuilders z, AggregatorParametersV99 p) {
      return z.validate_parametersAggregator(
        p.radiusScale,
        p.transform,
        p.pcaMethod,
        p.k,
        p.maxIterations,
        p.seed,
        p.useAllFactorLevels,
        (p.modelId == null? null : p.modelId.name),
        (p.trainingFrame == null? null : p.trainingFrame.name),
        (p.validationFrame == null? null : p.validationFrame.name),
        p.nfolds,
        p.keepCrossValidationPredictions,
        p.keepCrossValidationFoldAssignment,
        p.parallelizeCrossValidation,
        (p.responseColumn == null? null : p.responseColumn.columnName),
        (p.weightsColumn == null? null : p.weightsColumn.columnName),
        (p.offsetColumn == null? null : p.offsetColumn.columnName),
        (p.foldColumn == null? null : p.foldColumn.columnName),
        p.foldAssignment,
        p.ignoredColumns,
        p.ignoreConstCols,
        p.scoreEachIteration,
        (p.checkpoint == null? null : p.checkpoint.name),
        p.stoppingRounds,
        p.maxRuntimeSecs,
        p.stoppingMetric,
        p.stoppingTolerance,
        p._excludeFields
      );
    }

    /**
     * Return an array of Strings for an array of keys.
     */
    public static String[] keyArrayToStringArray(KeyV3[] keys) {
      if (keys == null) return null;
      String[] ids = new String[keys.length];
      int i = 0;
      for (KeyV3 key : keys) ids[i++] = key.name;
      return ids;
    }
  }

}
