/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import water.H2O;
import water.H2ONode;

public class H2OClusterStatusEndpoint
extends RouterNanoHTTPD.DefaultHandler {
    @Override
    public String getText() {
        throw new IllegalStateException(String.format("Method getText should not be called on '%s'", this.getClass().getName()));
    }

    @Override
    public String getMimeType() {
        return "application/json";
    }

    @Override
    public NanoHTTPD.Response.IStatus getStatus() {
        throw new IllegalStateException(String.format("Method getMimeType should not be called on '%s'", this.getClass().getName()));
    }

    @Override
    public NanoHTTPD.Response get(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        boolean clustered;
        if (!H2O.isFlatfileEnabled()) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NO_CONTENT, this.getMimeType(), null);
        }
        Set flatFile = H2O.getFlatfile();
        H2ONode[] cloudMembers = H2O.CLOUD.members();
        boolean bl = clustered = flatFile != null && cloudMembers != null && cloudMembers.length == flatFile.size() && flatFile.containsAll(Arrays.asList(cloudMembers));
        if (!clustered) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NO_CONTENT, this.getMimeType(), null);
        }
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, this.getMimeType(), this.nodesListJson());
    }

    private String nodesListJson() {
        H2ONode[] cloudMembers = H2O.CLOUD.members();
        StringBuilder healthyNodesStringArray = new StringBuilder();
        StringBuilder unhealthyNodesStringArray = new StringBuilder();
        int healthyNodeCount = 0;
        int unhealthyNodeCount = 0;
        for (H2ONode node : cloudMembers) {
            if (node.isHealthy()) {
                healthyNodesStringArray.append('\"');
                healthyNodesStringArray.append(node.getIpPortString());
                healthyNodesStringArray.append("\",");
                ++healthyNodeCount;
                continue;
            }
            unhealthyNodesStringArray.append('\"');
            unhealthyNodesStringArray.append(node.getIpPortString());
            unhealthyNodesStringArray.append('\"');
            unhealthyNodesStringArray.append("\",");
            ++unhealthyNodeCount;
        }
        if (healthyNodeCount > 0) {
            healthyNodesStringArray.deleteCharAt(healthyNodesStringArray.length() - 1);
        }
        if (unhealthyNodeCount > 0) {
            unhealthyNodesStringArray.deleteCharAt(unhealthyNodesStringArray.length() - 1);
        }
        return String.format("{\n\"leader_node\": \"%s\",\n\"healthy_nodes\": [%s],\n\"unhealthy_nodes\": [%s]\n}", H2O.CLOUD.leader().getIpPortString(), healthyNodesStringArray.toString(), unhealthyNodesStringArray.toString());
    }
}

