/*
 * Decompiled with CFR 0.152.
 */
package water.clustering.api;

import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class AssistedClusteringEndpoint
extends RouterNanoHTTPD.DefaultHandler {
    private static final Logger LOG = Logger.getLogger(AssistedClusteringEndpoint.class);
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final AtomicBoolean flatFileReceived;
    private final ExecutorService flatFileConsumerCallbackExecutor = Executors.newSingleThreadExecutor();
    public static final String RESPONSE_MIME_TYPE = "text/plain";

    public AssistedClusteringEndpoint() {
        this.flatFileReceived = new AtomicBoolean(false);
    }

    @Override
    public String getText() {
        throw new IllegalStateException(String.format("Method getText should not be called on '%s'", this.getClass().getName()));
    }

    @Override
    public String getMimeType() {
        return RESPONSE_MIME_TYPE;
    }

    @Override
    public NanoHTTPD.Response.IStatus getStatus() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NanoHTTPD.Response post(RouterNanoHTTPD.UriResource uriResource, Map<String, String> urlParams, NanoHTTPD.IHTTPSession session) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            session.parseBody(map);
        }
        catch (NanoHTTPD.ResponseException | IOException e) {
            LOG.error((Object)"Received incorrect flatfile request.", (Throwable)e);
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, RESPONSE_MIME_TYPE, null);
        }
        String postBody = (String)map.get("postData");
        if (postBody != null) {
            Lock writeLock = this.lock.writeLock();
            try {
                writeLock.lock();
                if (this.flatFileReceived.get()) {
                    NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, RESPONSE_MIME_TYPE, "Flatfile already provided.");
                    return response;
                }
                Consumer flatFileConsumer = uriResource.initParameter(Consumer.class);
                this.flatFileConsumerCallbackExecutor.submit(() -> flatFileConsumer.accept(postBody));
                this.flatFileReceived.set(true);
            }
            finally {
                writeLock.unlock();
            }
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, RESPONSE_MIME_TYPE, null);
        }
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, RESPONSE_MIME_TYPE, "Unable to parse IP addresses in body. Only one IPv4/IPv6 address per line is accepted.");
    }
}

