/*
 * Decompiled with CFR 0.152.
 */
package no.priv.garshol.duke.cleaners;

import no.priv.garshol.duke.cleaners.AbstractRuleBasedCleaner;
import no.priv.garshol.duke.cleaners.LowerCaseNormalizeCleaner;
import no.priv.garshol.duke.utils.StringUtils;

public class NorwegianCompanyNameCleaner
extends AbstractRuleBasedCleaner {
    private LowerCaseNormalizeCleaner sub = new LowerCaseNormalizeCleaner();

    public NorwegianCompanyNameCleaner() {
        this.add("\\s(a/s)(\\s|$)", "as");
        this.add("\\s(a\\\\s)(\\s|$)", "as");
        this.add("^(a/s)\\s", "as");
        this.add("^(a\\\\s)\\s", "as");
        this.add("\\s(a/l)(\\s|$)", "al");
        this.add("^(a/l)\\s", "al");
    }

    @Override
    public String clean(String value) {
        value = StringUtils.replaceAnyOf(value, ",().-_", ' ');
        if ((value = this.sub.clean(value)) == null || value.equals("")) {
            return "";
        }
        value = super.clean(value);
        if ((value = StringUtils.normalizeWS(value)).startsWith("as ") || value.startsWith("al ")) {
            value = value.substring(3) + ' ' + value.substring(0, 2);
        }
        return value;
    }
}

